/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Element;

public class XmlUtils {
    protected static final String LIST_PREFIX = "Li";
    protected static final String[] COMMON_UNWANTED_BEAN_PROPERTIES = new String[]{"class"};

    public static Element constrcutXmlElement(Object bean, String beanName) throws IllegalArgumentException {
        Element root = new Element("beans");
        return XmlUtils.constrcutXmlElement(bean, beanName, root, null, true);
    }

    public static Element constrcutXmlElement(Object bean, String beanName, String[] skipProperties) throws IllegalArgumentException {
        Element root = new Element("beans");
        return XmlUtils.constrcutXmlElement(bean, beanName, root, skipProperties, true);
    }

    public static Element constrcutXmlElement(Object bean, String beanName, Element root) throws IllegalArgumentException {
        return XmlUtils.constrcutXmlElement(bean, beanName, root, null, true);
    }

    public static Element constrcutXmlElement(Object bean, String beanName, Element root, String[] skipProperties, boolean ignoreCommonBeanProperties) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)beanName)) {
            throw new IllegalArgumentException("Bean Name can not be empty or null!");
        }
        if (root == null) {
            throw new IllegalArgumentException("Root Element cannot be null!");
        }
        if (bean != null) {
            int refCount = 0;
            Element newBean = new Element("bean");
            newBean = new Element("bean");
            newBean.setAttribute("id", beanName);
            newBean.setAttribute("class", bean.getClass().getName());
            BeanMap data = new BeanMap(bean);
            Element element = null;
            Object value = null;
            for (Object key : data.keySet()) {
                if (ParsingUtils.equalsIgnoreCase(String.valueOf(key), skipProperties) || (value = data.get(key)) == null) continue;
                if (value instanceof CharSequence || value instanceof Number || value instanceof Boolean || value instanceof Date) {
                    if (!StringUtils.isNotEmpty((String)String.valueOf(data.get(key)))) continue;
                    element = new Element("property");
                    element.setAttribute("name", String.valueOf(key));
                    element.setAttribute("value", String.valueOf(data.get(key)));
                    newBean.addContent((Content)element);
                    continue;
                }
                if (value instanceof Enum) {
                    element = new Element("property");
                    element.setAttribute("name", String.valueOf(key));
                    element.setAttribute("value", String.valueOf(data.get(key)));
                    newBean.addContent((Content)element);
                    continue;
                }
                if (value.getClass().isArray() || value instanceof Collection) {
                    element = new Element("property");
                    element.setAttribute("name", String.valueOf(key));
                    Element list = new Element("list");
                    XmlUtils.addListElements(root, list, value, beanName + refCount, skipProperties, ignoreCommonBeanProperties);
                    ++refCount;
                    element.addContent((Content)list);
                    newBean.addContent((Content)element);
                    continue;
                }
                if (ignoreCommonBeanProperties && ParsingUtils.equalsIgnoreCase(String.valueOf(key), COMMON_UNWANTED_BEAN_PROPERTIES)) continue;
                String refName = beanName + refCount;
                ++refCount;
                element = new Element("property");
                element.setAttribute("name", String.valueOf(key));
                element.setAttribute("ref", refName);
                newBean.addContent((Content)element);
                XmlUtils.constrcutXmlElement(value, refName, root, skipProperties, ignoreCommonBeanProperties);
            }
            if (newBean != null) {
                root.addContent((Content)newBean);
            }
        }
        return root;
    }

    protected static void addListElements(Element root, Element list, Object listValues, String beanName, String[] skipProperties, boolean ignoreCommonBeanProperties) {
        if (listValues instanceof Collection) {
            listValues = ((Collection)listValues).toArray();
        }
        if (listValues.getClass().isArray()) {
            Object[] values = listValues;
            Element listItem = null;
            int refCount = 0;
            for (Object value : values) {
                if (value == null) continue;
                if (value instanceof CharSequence || value instanceof Number || value instanceof Boolean || value instanceof Date) {
                    listItem = new Element("value");
                    listItem.addContent(String.valueOf(value));
                    list.addContent((Content)listItem);
                    continue;
                }
                if (value instanceof Enum) continue;
                String refName = LIST_PREFIX + beanName + refCount;
                ++refCount;
                listItem = new Element("ref");
                listItem.setAttribute("bean", refName);
                list.addContent((Content)listItem);
                XmlUtils.constrcutXmlElement(value, refName, root, skipProperties, ignoreCommonBeanProperties);
            }
        }
    }
}

