/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.lunaimaging.insight.core.utils.FileUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebUtils {
    public static final Log log = LogFactory.getLog(WebUtils.class);

    public static List constructObjectsFromRequest(Class c, String prefix, HttpServletRequest request) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> objects = new ArrayList<Object>();
        Object obj = null;
        for (int index = 0; index == 0 || obj != null; ++index) {
            obj = WebUtils.constrcutAndPopulate(c, prefix, index, request);
            if (obj == null) continue;
            objects.add(obj);
        }
        return objects;
    }

    public static Object constrcutAndPopulate(Class c, String prefix, int index, HttpServletRequest request) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object toReturn = null;
        HashMap<Object, String> map = new HashMap<Object, String>();
        Enumeration enumeration = request.getParameterNames();
        String param = null;
        while (enumeration.hasMoreElements()) {
            Object[] split;
            param = (String)enumeration.nextElement();
            if (!ParsingUtils.startsWithIgnoreCaseTrim(param, prefix + index) || (split = ParsingUtils.splitPostDigits(param, prefix, 0)) == null || (Integer)split[0] != index) continue;
            map.put(split[1], request.getParameter(param));
        }
        if (!map.isEmpty()) {
            toReturn = c.newInstance();
            BeanUtils.populate(toReturn, map);
        }
        return toReturn;
    }

    public static File[] saveUrlToDirectory(String[] urls, File directory, String baseName, String suffix) throws IOException {
        File[] files = new File[urls.length];
        int index = 0;
        for (String url : urls) {
            files[index] = new File(directory, baseName + index + suffix).getAbsoluteFile();
            WebUtils.saveUrlToFile(url, files[index]);
            ++index;
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long saveUrlToFile(String urlString, File saveFile) throws MalformedURLException, IOException {
        log.debug((Object)("urlString: " + urlString));
        log.debug((Object)("saveFile: " + saveFile.getAbsolutePath()));
        long fileSize = 0L;
        URL url = new URL(urlString);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        log.debug((Object)"before connect()");
        con.connect();
        log.debug((Object)"after connect()");
        if (con.getResponseCode() == 200) {
            log.debug((Object)("Response code: " + con.getResponseCode()));
            InputStream is = con.getInputStream();
            File outFile = saveFile;
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(outFile);
            try {
                FileUtils.sendInputToOutputStream(is, fos);
            }
            finally {
                is.close();
                fos.flush();
                fos.close();
                con.disconnect();
                fileSize = outFile.length();
            }
        }
        log.debug((Object)"end saveUrlToFile()");
        return fileSize;
    }

    public static String getUrlAddressFromAnchorTag(String anchor) {
        int pos;
        String toReturn = "";
        if (StringUtils.isNotEmpty((String)anchor) && (pos = StringUtils.indexOf((String)anchor, (String)"http:")) > 0) {
            toReturn = StringUtils.substring((String)anchor, (int)pos, (int)anchor.length());
            pos = StringUtils.indexOf((String)toReturn, (String)"\"");
            toReturn = StringUtils.substring((String)toReturn, (int)0, (int)pos);
        }
        return toReturn;
    }
}

