/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.owasp.esapi.ESAPI;

public class UrlUtils {
    public static final String FORWARD_SLASH_ESCAPE_STRING = "____";
    private static Log logger = LogFactory.getLog(UrlUtils.class);

    public static String removeParameter(String url, String paramName) {
        String toReturn = "";
        if (url != null) {
            if (StringUtils.contains((CharSequence)url, (CharSequence)"/")) {
                toReturn = url;
            } else {
                try {
                    toReturn = URLDecoder.decode(url, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return url;
                }
            }
            paramName = paramName + "=";
            if (toReturn.contains(paramName)) {
                String[] split = toReturn.split("&|\\?");
                toReturn = split[0];
                for (int i = 1; i < split.length; ++i) {
                    String part = split[i];
                    if (ParsingUtils.startsWithIgnoreCaseTrim(part, paramName)) continue;
                    String[] nameValue = part.split("=");
                    toReturn = UrlUtils.appendParameter(toReturn, nameValue[0], nameValue[1]);
                }
            }
        }
        return toReturn;
    }

    public static String appendParameter(String url, String paramName, int paramValue) {
        return UrlUtils.appendParameter(url, paramName, String.valueOf(paramValue));
    }

    public static String appendParameter(String url, String paramName, boolean paramValue) {
        return UrlUtils.appendParameter(url, paramName, String.valueOf(paramValue));
    }

    public static String appendParameter(String url, String paramName, String paramValue) {
        if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)paramName) && StringUtils.isNotEmpty((CharSequence)paramValue)) {
            url = (url = UrlUtils.stripParameter(url, paramName)).contains("?") ? url + "&" : url + "?";
            try {
                paramValue = UrlUtils.decodeSanitizeForHtml(paramValue);
                url = url + URLEncoder.encode(paramName, "UTF-8") + "=" + URLEncoder.encode(paramValue, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                url = "UNABLE_TO_URLEncoder.encode";
            }
        }
        return url;
    }

    public static String appendParameters(String url, HttpServletRequest request) {
        return UrlUtils.appendParameters(url, request, new String[0]);
    }

    public static String appendParameters(String url, HttpServletRequest request, String[] skipKeys) {
        if (StringUtils.isNotEmpty((CharSequence)url) && request != null) {
            Iterator it = request.getParameterMap().keySet().iterator();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                if (ParsingUtils.equalsIgnoreCase(key, skipKeys)) continue;
                String value = request.getParameter(key);
                if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) continue;
                try {
                    key = URLDecoder.decode(key, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                    key = UrlUtils.sanitize(key);
                    value = UrlUtils.sanitize(value);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException ire) {
                    key = UrlUtils.sanitize(key);
                    value = UrlUtils.sanitize(value);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                url = UrlUtils.appendParameter(url, key, value);
            }
        }
        return url;
    }

    public static String appendParameters(String url, HttpServletRequest request, List<String> skipKeys) {
        String toReturn = url;
        String[] skip = new String[]{};
        if (skipKeys != null) {
            skip = skipKeys.toArray(skip);
        }
        url = UrlUtils.appendParameters(url, request, skip);
        return url;
    }

    public static String stripParameters(String url, String[] paramNames) {
        for (int i = 0; i < paramNames.length; ++i) {
            url = UrlUtils.stripParameter(url, paramNames[i]);
        }
        return url;
    }

    public static String stripParameter(String url, String paramName) {
        if (url.contains("?" + paramName + "=") || url.contains("&" + paramName + "=")) {
            String delim = url.contains("?" + paramName + "=") ? "?" : "&";
            String s1 = url.substring(0, url.indexOf(delim + paramName + "=") + 1);
            String s2 = url.substring(url.indexOf(delim + paramName + "=") + 1);
            if (s2.indexOf("&") > -1) {
                return s1 + s2.substring(s2.indexOf("&") + 1);
            }
            return s1.substring(0, s1.length() - 1);
        }
        return url;
    }

    public static String getParameter(String url, String paramName) {
        if (url.contains("?" + paramName + "=") || url.contains("&" + paramName + "=")) {
            String delim = url.contains("?" + paramName + "=") ? "?" : "&";
            String s1 = url.substring(url.indexOf(delim + paramName + "=") + delim.length() + paramName.length() + 1);
            if (s1.contains("&")) {
                s1 = s1.substring(0, s1.indexOf("&"));
            }
            return s1;
        }
        return "";
    }

    public static String parseLastValue(String url) {
        Object[] uriParts;
        Object toReturn = null;
        if (url != null && !ArrayUtils.isEmpty((Object[])(uriParts = url.split("/")))) {
            toReturn = uriParts[uriParts.length - 1];
        }
        return toReturn;
    }

    public static int parseLastValueAsInt(String url, int defaultValue) {
        return NumberUtils.toInt((String)UrlUtils.parseLastValue(url), (int)defaultValue);
    }

    public static final ArrayList<String> getWhoListFromURL(String url_) {
        ArrayList<String> who = new ArrayList<String>();
        String url = url_;
        try {
            url = UrlUtils.getUrlWithoutParameters(url);
        }
        catch (URISyntaxException e1) {
            logger.error((Object)("Invalid URI: " + url), (Throwable)e1);
        }
        if (url.contains("who/")) {
            String s;
            String[] theRest = url.substring(url.indexOf("who/") + 4).split("/");
            theRest = UrlUtils.removeSessionParam(theRest);
            try {
                for (int i = 0; i < theRest.length; ++i) {
                    theRest[i] = URLDecoder.decode(theRest[i], "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                url = "UNABLE_TO_URLDecoder.decode";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String[] stringArray = theRest;
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (s = stringArray[i]).equalsIgnoreCase("what") || s.equalsIgnoreCase("where") || s.equalsIgnoreCase("when")); ++i) {
                if (s.equalsIgnoreCase("who") || s.length() == 0 || s.equalsIgnoreCase("showAll")) continue;
                who.add(s);
            }
        }
        return who;
    }

    public static final ArrayList<String> getWhatListFromURL(String url_) {
        ArrayList<String> what = new ArrayList<String>();
        String url = url_;
        try {
            url = UrlUtils.getUrlWithoutParameters(url);
        }
        catch (URISyntaxException e1) {
            logger.error((Object)("Invalid URI: " + url), (Throwable)e1);
        }
        if (url.contains("what/")) {
            String s;
            String[] theRest = url.substring(url.indexOf("what/") + 5).split("/");
            theRest = UrlUtils.removeSessionParam(theRest);
            try {
                for (int i = 0; i < theRest.length; ++i) {
                    theRest[i] = URLDecoder.decode(theRest[i], "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                url = "UNABLE_TO_URLDecoder.decode";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String[] stringArray = theRest;
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (s = stringArray[i]).equalsIgnoreCase("who") || s.equalsIgnoreCase("where") || s.equalsIgnoreCase("when")); ++i) {
                if (s.equalsIgnoreCase("what") || s.length() == 0 || s.equalsIgnoreCase("showAll")) continue;
                what.add(s);
            }
        }
        return what;
    }

    public static final ArrayList<String> getWhenListFromURL(String url_) {
        ArrayList<String> when = new ArrayList<String>();
        String url = url_;
        try {
            url = UrlUtils.getUrlWithoutParameters(url);
        }
        catch (URISyntaxException e1) {
            logger.error((Object)("Invalid URI: " + url), (Throwable)e1);
        }
        if (url.contains("when/")) {
            String s;
            String[] theRest = url.substring(url.indexOf("when/") + 5).split("/");
            theRest = UrlUtils.removeSessionParam(theRest);
            try {
                for (int i = 0; i < theRest.length; ++i) {
                    theRest[i] = URLDecoder.decode(theRest[i], "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                url = "UNABLE_TO_URLDecoder.decode";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String[] stringArray = theRest;
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (s = stringArray[i]).equalsIgnoreCase("who") || s.equalsIgnoreCase("where") || s.equalsIgnoreCase("what")); ++i) {
                if (s.equalsIgnoreCase("when") || s.length() == 0 || s.equalsIgnoreCase("showAll")) continue;
                when.add(s);
            }
        }
        return when;
    }

    public static final ArrayList<String> getWhereListFromURL(String url_) {
        ArrayList<String> where = new ArrayList<String>();
        String url = url_;
        try {
            url = UrlUtils.getUrlWithoutParameters(url);
        }
        catch (URISyntaxException e1) {
            logger.error((Object)("Invalid URI: " + url), (Throwable)e1);
        }
        if (url.contains("where/")) {
            String s;
            String[] theRest = url.substring(url.indexOf("where/") + 6).split("/");
            theRest = UrlUtils.removeSessionParam(theRest);
            try {
                for (int i = 0; i < theRest.length; ++i) {
                    theRest[i] = URLDecoder.decode(theRest[i], "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                url = "UNABLE_TO_URLDecoder.decode";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String[] stringArray = theRest;
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (s = stringArray[i]).equalsIgnoreCase("who") || s.equalsIgnoreCase("when") || s.equalsIgnoreCase("what")); ++i) {
                if (s.equalsIgnoreCase("where") || s.length() == 0 || s.equalsIgnoreCase("showAll")) continue;
                where.add(s);
            }
        }
        return where;
    }

    public static String getCollectionFromURL(String url) {
        return UrlUtils.getCollectionFromURL(url, null);
    }

    public static String getCollectionFromURL(String url, String prefix) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            url = "UNABLE_TO_URLDecoder.decode";
        }
        if (prefix == null) {
            prefix = "collection/";
        }
        String collection = null;
        if (url.contains(prefix)) {
            String[] theRest = url.substring(url.lastIndexOf(prefix) + prefix.length()).split("/");
            collection = theRest[0];
        }
        return collection;
    }

    public static final String getSearchFriendlyURL(String url, String context, String page) throws UnsupportedEncodingException {
        url = URLDecoder.decode(url, "UTF-8");
        ArrayList<String> who = UrlUtils.getWhoListFromURL(url);
        ArrayList<String> what = UrlUtils.getWhatListFromURL(url);
        ArrayList<String> where = UrlUtils.getWhereListFromURL(url);
        ArrayList<String> when = UrlUtils.getWhenListFromURL(url);
        String collection = UrlUtils.getCollectionFromURL(url);
        collection = collection == null ? "" : collection + "/";
        String output = context + page + "/" + collection;
        output = output + UrlUtils.createSlashedW4String(who, what, where, when) + UrlUtils.getParams(url);
        output = URLEncoder.encode(output, "UTF-8");
        return output;
    }

    public static final String getParams(String url) {
        if (url.contains("?")) {
            return url.substring(url.indexOf("?"), url.length());
        }
        return "";
    }

    public static final String createSlashedW4String(ArrayList<String> who, ArrayList<String> what, ArrayList<String> where, ArrayList<String> when) throws UnsupportedEncodingException {
        String output = "";
        if (who.size() > 0) {
            output = output + "who/";
        }
        for (String s : who) {
            s = URLEncoder.encode(s, "UTF-8");
            output = output + s;
            output = output + "/";
        }
        if (what.size() > 0) {
            output = output + "what/";
        }
        for (String s : what) {
            s = URLEncoder.encode(s, "UTF-8");
            output = output + s;
            output = output + "/";
        }
        if (where.size() > 0) {
            output = output + "where/";
        }
        for (String s : where) {
            s = URLEncoder.encode(s, "UTF-8");
            output = output + s;
            output = output + "/";
        }
        if (when.size() > 0) {
            output = output + "when/";
        }
        for (String s : when) {
            s = URLEncoder.encode(s, "UTF-8");
            output = output + s;
            output = output + "/";
        }
        return output;
    }

    public static final String getSlashedUrl(String url) {
        String paramWhen;
        String paramWhere;
        String paramWhat;
        String paramWho;
        url = UrlUtils.removeJsessionParameter(url);
        Object[] w4params = new String[]{"who", "what", "where", "when"};
        Map<String, List<String>> params = UrlUtils.getQueryParams(url);
        if (params != null && params.keySet() != null) {
            for (String pn : params.keySet()) {
                if (ArrayUtils.contains((Object[])w4params, (Object)pn)) continue;
                url = UrlUtils.stripParameter(url, pn);
            }
        }
        if (StringUtils.contains((CharSequence)(paramWho = UrlUtils.getParameter(url, "who")), (CharSequence)"/")) {
            url = UrlUtils.stripParameter(url, "who");
            url = UrlUtils.appendParameter(url, "who", StringUtils.replace((String)paramWho, (String)"/", (String)FORWARD_SLASH_ESCAPE_STRING));
        }
        if (StringUtils.contains((CharSequence)(paramWhat = UrlUtils.getParameter(url, "what")), (CharSequence)"/")) {
            url = UrlUtils.stripParameter(url, "what");
            url = UrlUtils.appendParameter(url, "what", StringUtils.replace((String)paramWhat, (String)"/", (String)FORWARD_SLASH_ESCAPE_STRING));
        }
        if (StringUtils.contains((CharSequence)(paramWhere = UrlUtils.getParameter(url, "where")), (CharSequence)"/")) {
            url = UrlUtils.stripParameter(url, "where");
            url = UrlUtils.appendParameter(url, "where", StringUtils.replace((String)paramWhere, (String)"/", (String)FORWARD_SLASH_ESCAPE_STRING));
        }
        if (StringUtils.contains((CharSequence)(paramWhen = UrlUtils.getParameter(url, "when")), (CharSequence)"/")) {
            url = UrlUtils.stripParameter(url, "when");
            url = UrlUtils.appendParameter(url, "when", StringUtils.replace((String)paramWhen, (String)"/", (String)FORWARD_SLASH_ESCAPE_STRING));
        }
        if (!(url = url.replace("=", "/").replace(" ", "+").replace(",", "%2c").replace(":", "%3a").replace("&who", "/who").replace("&what", "/what").replace("&where", "/where").replace("&when", "/when").replace("?who", "/who").replace("?what", "/what").replace("?where", "/where").replace("?when", "/when").replace("%2f", FORWARD_SLASH_ESCAPE_STRING).replace("%2F", FORWARD_SLASH_ESCAPE_STRING)).endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static final String stripAllParameters(String url) {
        if (url.contains("&")) {
            return url.substring(0, url.indexOf("&"));
        }
        return url;
    }

    public static Map<String, List<String>> getQueryParams(String url) {
        try {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            String[] urlParts = url.split("\\?");
            if (urlParts.length > 1) {
                String query = urlParts[1];
                for (String param : query.split("&")) {
                    ArrayList<String> values;
                    String[] pair = param.split("=");
                    String key = URLDecoder.decode(pair[0], "UTF-8");
                    String value = "";
                    if (pair.length > 1) {
                        value = URLDecoder.decode(pair[1], "UTF-8");
                    }
                    if ((values = (ArrayList<String>)params.get(key)) == null) {
                        values = new ArrayList<String>();
                        params.put(key, values);
                    }
                    values.add(value);
                }
            }
            return params;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static final String createSlashedURLForGroup(String url) {
        return url.replaceFirst("\\?", "/").replaceFirst("=", "/");
    }

    public static final String revertURLForGroup(String url) {
        return url.replaceFirst("group/", "group\\?").replaceFirst("mediaGroupId/", "mediaGroupId=");
    }

    public static final ArrayList<String> setupWho(String URI2) {
        URI2 = UrlUtils.cleanupUrl(URI2);
        return UrlUtils.getWhoListFromURL(URI2);
    }

    public static final ArrayList<String> setupWhat(String URI2) {
        URI2 = UrlUtils.cleanupUrl(URI2);
        return UrlUtils.getWhatListFromURL(URI2);
    }

    public static final ArrayList<String> setupWhere(String URI2) {
        URI2 = UrlUtils.cleanupUrl(URI2);
        return UrlUtils.getWhereListFromURL(URI2);
    }

    public static final ArrayList<String> setupWhen(String URI2) {
        URI2 = UrlUtils.cleanupUrl(URI2);
        return UrlUtils.getWhenListFromURL(URI2);
    }

    public static String removeJsessionParameter(String url) {
        String toReturn = RegExUtils.removeFirst((String)url, (String)"JSESSIONID=[A-Za-z0-9\\-]+");
        if (!StringUtils.equals((CharSequence)(toReturn = RegExUtils.removeFirst((String)toReturn, (String)("JSESSIONID".toLowerCase() + "=[A-Za-z0-9\\-]+"))), (CharSequence)url)) {
            toReturn = StringUtils.replaceOnce((String)toReturn, (String)";?", (String)"?");
        }
        return toReturn;
    }

    public static String forceHttp(String url) {
        if (url != null && url.startsWith("https:")) {
            return url.replaceFirst("https", "http");
        }
        return url;
    }

    public static String forceHttps(String url) {
        if (url != null && url.startsWith("http:")) {
            return url.replaceFirst("http", "https");
        }
        return url;
    }

    public static String encodeReservedChar(String s) {
        return s.replace("%", "%25").replace("/", "%2F").replace("?", "%3F");
    }

    public static String encodeForJavascript(String s) {
        return ESAPI.encoder().encodeForJavaScript(s);
    }

    public static String sanitize(String unsafe) {
        String[] blacklist = new String[]{"javascript:", "background:url", "<%00script>", "onload=", "onunload=", "onclick=", "ondblclick=", "onmousedown=", "onmousemove=", "onmouseout=", "onmouseover=", "onmouseup=", "onerror="};
        ArrayList<String> jsregex = new ArrayList<String>();
        jsregex.add("alert(.*)");
        jsregex.add("<iframe.*>");
        jsregex.add("<frame.*>");
        String toReturn = null;
        List<Object> params = new ArrayList();
        String safe = "";
        boolean isRelativePath = false;
        try {
            if (unsafe.startsWith("/")) {
                isRelativePath = true;
            }
            URL url = new URL(unsafe);
            if (isRelativePath) {
                if (unsafe.indexOf(63) < 0) {
                    return unsafe;
                }
                toReturn = unsafe.substring(16, unsafe.indexOf(63));
            } else {
                toReturn = url.getProtocol() + "://" + url.getAuthority() + url.getPath();
            }
            toReturn = toReturn.replaceAll("[\"|']+\\s*\\+[^\\+]+\\+\\s*[\"|']+", "");
            toReturn = toReturn.replaceAll("(%3C|%3c|<)(\\s|%20)*\\/?\\s*((?i)script)(\\s|%20)*((%3E|%3e|>))", "");
            toReturn = toReturn.replaceAll("onload=|onunload=|onerror=|javascript:", "");
            unsafe = url.getQuery();
            if (unsafe == null || unsafe.length() == 0) {
                return toReturn;
            }
            String[] t = unsafe.split("&(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            params = Arrays.asList(t);
            for (String string : params) {
                String cleanedParam = Jsoup.clean((String)string, (Whitelist)Whitelist.basic());
                String[] keyValue = cleanedParam.split("=(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
                if (keyValue.length == 2) {
                    keyValue[1] = StringEscapeUtils.unescapeHtml((String)keyValue[1]);
                    safe = safe + (safe.length() == 0 ? "" : "&") + keyValue[0] + "=" + keyValue[1];
                    continue;
                }
                safe = safe + (safe.length() == 0 ? "" : "&") + cleanedParam;
            }
        }
        catch (MalformedURLException e) {
            toReturn = "";
            safe = safe + (safe.length() == 0 ? "" : "&") + Jsoup.clean((String)unsafe, (Whitelist)Whitelist.basic());
        }
        safe = ParsingUtils.replace(blacklist, safe, "");
        safe = ParsingUtils.regxReplaceWith(safe, jsregex, "");
        return toReturn.isEmpty() ? safe : toReturn + "?" + safe;
    }

    public static String decodeAndSanitize(String unsafe) {
        String decodedString = "";
        try {
            if (unsafe != null && unsafe.length() > 0) {
                decodedString = URLDecoder.decode(unsafe, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return UrlUtils.sanitize(decodedString);
    }

    public static String decodeSanitizeForHtml(String unsafe) {
        if (unsafe == null || unsafe.isEmpty()) {
            return unsafe;
        }
        String decodedString = "";
        unsafe = StringEscapeUtils.unescapeHtml((String)unsafe);
        decodedString = UrlUtils.decodeAndSanitize(unsafe);
        decodedString = StringEscapeUtils.unescapeHtml((String)decodedString);
        decodedString = StringUtils.replace((String)decodedString, (String)FORWARD_SLASH_ESCAPE_STRING, (String)"/");
        return decodedString;
    }

    public static String sanitizeAndUrlEncode(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        s = UrlUtils.getDecodedString(s);
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String toReturn = UrlUtils.sanitize(s);
        return toReturn;
    }

    public static String urlDoubleEncode(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        try {
            s = URLEncoder.encode(URLEncoder.encode(s, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String toReturn = UrlUtils.sanitize(s);
        return toReturn;
    }

    public static String cleanupUrl(String s) {
        if (s == null) {
            return null;
        }
        if (!s.startsWith("/") && s.startsWith("%2F")) {
            try {
                s = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    public static String getDecodedString(String s) {
        String saved = "";
        while (!(saved = s).equals(s = StringEscapeUtils.unescapeHtml((String)s))) {
        }
        try {
            while (!(saved = s).equals(s = URLDecoder.decode(s, "UTF-8"))) {
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }

    public static String renderAsAnchor(String href, String displayText, int maxWordLength, String suffix) {
        StringBuilder toReturn = new StringBuilder();
        if (href != null) {
            toReturn.append("<a target=\"_blank\"");
            toReturn.append(" href=\"");
            toReturn.append(StringUtils.trim((String)href));
            toReturn.append("\"");
            if (displayText.length() > maxWordLength && maxWordLength != -1) {
                toReturn.append(" title=\"");
                toReturn.append(displayText);
                toReturn.append("\">");
                toReturn.append(displayText.substring(0, maxWordLength - 1));
                toReturn.append(suffix);
            } else {
                toReturn.append(">");
                toReturn.append(displayText);
            }
            toReturn.append("</a>");
        }
        return toReturn.toString();
    }

    public static String getExtensionLowercase(String url) {
        String extension = FilenameUtils.getExtension((String)url);
        if (extension != null) {
            return extension.toLowerCase();
        }
        return "";
    }

    public static String removeScheme(String url) {
        try {
            URI uri = new URI(url);
            return uri.getSchemeSpecificPart();
        }
        catch (Exception e) {
            return url;
        }
    }

    public static String[] removeSessionParam(String[] parts) {
        if (parts == null || parts.length == 0) {
            return parts;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(parts));
        ListIterator<String> iter = list.listIterator();
        while (iter.hasNext()) {
            String str = iter.next();
            if (str != null && str.startsWith(";JSESSIONID")) {
                iter.remove();
                continue;
            }
            if (str == null || !str.contains(";JSESSIONID")) continue;
            iter.set(StringUtils.substringBefore((String)str, (String)";JSESSIONID"));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String removeHtmlTags(String text) {
        return Jsoup.parse((String)text).text();
    }

    public static String getUrlWithoutParameters(String url) throws URISyntaxException {
        if ((url = StringUtils.replace((String)url, (String)"/?", (String)"?")).endsWith("/")) {
            return url;
        }
        URI uri = new URI(url);
        return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment()).toString();
    }

    public static boolean isEncoded(String uri) {
        uri = uri == null ? "" : uri;
        try {
            return uri != URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public static String getLastPath(String urlString) {
        urlString = urlString.replaceAll("/+$", "");
        int pathStartIndex = urlString.indexOf("://") + 3;
        int pathEndIndex = urlString.indexOf(63);
        if (pathEndIndex == -1) {
            pathEndIndex = urlString.length();
        }
        String path = urlString.substring(pathStartIndex, pathEndIndex);
        String[] segments = path.split("/");
        for (int i = segments.length - 1; i >= 0; --i) {
            String segment = segments[i];
            if (segment.isEmpty()) continue;
            return segment;
        }
        return segments[segments.length - 1];
    }
}

