/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.ExternalMedia;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.Presentation;
import com.lunaimaging.insight.core.domain.SlideImage;
import com.lunaimaging.insight.core.domain.SlideImageState;
import com.lunaimaging.insight.core.domain.SlideMedia;
import com.lunaimaging.insight.core.domain.SlideVideo;
import com.lunaimaging.insight.core.domain.logic.InsightFacade;
import com.lunaimaging.insight.core.utils.FileUtils;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.WebUtils;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlideUtils {
    public static final Log log = LogFactory.getLog(SlideUtils.class);
    public static final int EXTERNAL_MEDIA_STARTING_LEVEL = 2;
    public static final int EXTERNAL_ADDITIONAL_LEVELS = 2;

    public static List<SlideMedia> constrcutSlideFromRequest(HttpServletRequest request, String prefix, String lunaLibraryUrl, InsightFacade insight, Authenticable authenticable) {
        ArrayList<SlideMedia> toReturn = new ArrayList<SlideMedia>();
        SlideMedia si = new SlideImage();
        Media media = null;
        int index = 0;
        while (si != null) {
            si = null;
            if (request.getParameter(prefix + index) == null) continue;
            String[] values = request.getParameter(prefix + index).split(",");
            ++index;
            int slideId = NumberUtils.toInt((String)values[0]);
            String mediaId = values[1];
            media = "DEFAULT~0~0".equals(InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId)) ? insight.getExternalMediaDetails(String.valueOf(InsightCoreUtils.getMediaIdFromLunaMediaId(mediaId)), authenticable.getId(), lunaLibraryUrl, true) : insight.getMedia(authenticable.getCredentials(), mediaId, false, false);
            if (media != null) {
                if (media.isVideo() || media.isAudio()) {
                    if (values.length < 9) continue;
                    si = new SlideVideo();
                    si.setSlideId(slideId);
                    si.setMediaId(mediaId);
                    si.setPositionX(NumberUtils.toInt((String)values[2]));
                    si.setPositionY(NumberUtils.toInt((String)values[3]));
                    si.setPanelWidth(NumberUtils.toInt((String)values[4]));
                    si.setPanelHeight(NumberUtils.toInt((String)values[5]));
                    si.setWorkspaceWidth(NumberUtils.toInt((String)values[6]));
                    si.setWorkspaceHeight(NumberUtils.toInt((String)values[7]));
                    ((SlideVideo)si).setStartTime(NumberUtils.toDouble((String)values[8]));
                    if (values.length == 10) {
                        si.setStackOrder(NumberUtils.toInt((String)values[9]));
                    }
                    if (media instanceof ExternalMedia) {
                        si.setMedia(media);
                    }
                    toReturn.add(si);
                    continue;
                }
                if (!media.isImage() || values.length < 12) continue;
                si = new SlideImage();
                si.setSlideId(NumberUtils.toInt((String)values[0]));
                si.setMediaId(values[1]);
                si.setPositionX(NumberUtils.toInt((String)values[2]));
                si.setPositionY(NumberUtils.toInt((String)values[3]));
                si.setPanelWidth(NumberUtils.toInt((String)values[4]));
                si.setPanelHeight(NumberUtils.toInt((String)values[5]));
                si.setWorkspaceWidth(NumberUtils.toInt((String)values[6]));
                si.setWorkspaceHeight(NumberUtils.toInt((String)values[7]));
                ((SlideImage)si).setCenterPointX(NumberUtils.toInt((String)values[8]));
                ((SlideImage)si).setCenterPointY(NumberUtils.toInt((String)values[9]));
                ((SlideImage)si).setActualImageSizeWidth(NumberUtils.toInt((String)values[10]));
                ((SlideImage)si).setActualImageSizeHeight(NumberUtils.toInt((String)values[11]));
                if (values.length > 12) {
                    si.setStackOrder(NumberUtils.toInt((String)values[12]));
                }
                if (media instanceof ExternalMedia) {
                    si.setMedia(media);
                }
                toReturn.add(si);
                continue;
            }
            log.debug((Object)("PublisherMedia was null: [" + mediaId + "]"));
        }
        return toReturn;
    }

    public static File processImage(SlideImageState derivedState, File workingDirectory) throws IOException {
        return SlideUtils.processImage(derivedState, workingDirectory, null);
    }

    public static File processImage(SlideImageState derivedState, File workingDirectory, String fileName) throws IOException {
        File toReturn = null;
        if (StringUtils.isEmpty((String)fileName)) {
            String fileExtension = "jpg";
            fileName = SlideUtils.constructImageFileName(derivedState.getSlideImage()) + "." + fileExtension;
        }
        if (derivedState != null && derivedState.getSlideImage() != null && derivedState.getSlideImage().getMedia() != null) {
            Media media = derivedState.getSlideImage().getMedia();
            if (media instanceof LunaMedia && StringUtils.isNotEmpty((String)((LunaMedia)media).getUrlSource())) {
                toReturn = SlideUtils.fetchImage((LunaMedia)media, derivedState, workingDirectory, fileName);
            }
            if (toReturn == null) {
                String url = media.getUrlSize4();
                if (StringUtils.isEmpty((String)url)) {
                    url = media.getLargestUrlAvailable();
                }
                toReturn = SlideUtils.fetchImage(url, derivedState, workingDirectory, fileName);
            }
            if (toReturn == null) {
                toReturn = SlideUtils.createPlaceHolerImage(derivedState, workingDirectory, fileName);
            }
        }
        return toReturn;
    }

    protected static File createPlaceHolerImage(SlideImageState derivedState, File workingDirectory, String fileName) {
        File toReturn = null;
        try {
            toReturn = new File(workingDirectory, fileName);
            BufferedImage bufferedImage = new BufferedImage(derivedState.getPanelDimensions().width, derivedState.getPanelDimensions().height, 1);
            bufferedImage.flush();
            Graphics2D g = bufferedImage.createGraphics();
            g.setColor(Color.BLACK);
            g.setBackground(Color.BLACK);
            g.fillRect(0, 0, derivedState.getPanelDimensions().width, derivedState.getPanelDimensions().height);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", toReturn);
        }
        catch (IOException e) {
            toReturn = null;
        }
        return toReturn;
    }

    protected static File fetchImage(LunaMedia media, SlideImageState derivedState, File workingDirectory, String fileName) {
        File toReturn = null;
        String url = null;
        try {
            url = InsightCoreUtils.constructLunaImageSourceUrl(derivedState);
            toReturn = new File(workingDirectory, fileName);
            WebUtils.saveUrlToFile(url, toReturn);
            BufferedImage bufferedImage = ImageIO.read(toReturn);
            bufferedImage = SlideUtils.frameImage(bufferedImage, derivedState);
            if (bufferedImage != null) {
                bufferedImage.flush();
            }
            ImageIO.write((RenderedImage)bufferedImage, "jpg", toReturn);
        }
        catch (Exception e) {
            log.error((Object)("fetchImage: " + media + " ; " + url + " : "), (Throwable)e);
            toReturn = null;
        }
        return toReturn;
    }

    protected static File fetchImage(String url, SlideImageState derivedState, File workingDirectory, String fileName) {
        File toReturn = null;
        try {
            String fileExtension = SlideUtils.getFileExtensionFromUrl(url);
            if (fileExtension.equalsIgnoreCase("jp2")) {
                fileExtension = "jpg";
            }
            BufferedImage bufferedImage = ImageIO.read(new URL(url));
            bufferedImage = SlideUtils.resize(bufferedImage, derivedState.getActualImageSize());
            bufferedImage = SlideUtils.subimage(bufferedImage, derivedState);
            bufferedImage.flush();
            toReturn = new File(workingDirectory, fileName);
            ImageIO.write((RenderedImage)bufferedImage, fileExtension, toReturn);
        }
        catch (Exception e) {
            log.error((Object)("fetchImage: " + url + ": "), (Throwable)e);
            toReturn = null;
        }
        return toReturn;
    }

    protected static String getFileExtensionFromUrl(String url) {
        String ext = FileUtils.getFileExtension(url);
        if (StringUtils.isNotEmpty((String)ext)) {
            if (ext.indexOf("?") > 0) {
                ext = ext.substring(0, ext.indexOf("?"));
            }
            if (ext.indexOf("&") > 0) {
                ext = ext.substring(0, ext.indexOf("&"));
            }
        }
        return ext;
    }

    public static Dimension calculateSlideDimensions(Presentation p, int targetCanvasWidth, int targetCanvasHeight) {
        Dimension toReturn = new Dimension();
        int[] canvas = new int[]{targetCanvasWidth, targetCanvasHeight};
        int[] aspectRatio = new int[]{p.getWidth(), p.getHeight()};
        int[] newSize = new int[2];
        int largeSide = canvas[0] > canvas[1] ? 0 : 1;
        int smallSide = largeSide == 0 ? 1 : 0;
        double ratio = (double)aspectRatio[smallSide] / (double)aspectRatio[largeSide];
        newSize[largeSide] = canvas[largeSide];
        newSize[smallSide] = (int)Math.round((double)newSize[largeSide] * ratio);
        if (newSize[smallSide] > canvas[smallSide]) {
            ratio = newSize[largeSide] / newSize[smallSide];
            newSize[smallSide] = canvas[smallSide];
            newSize[largeSide] = (int)Math.round((double)newSize[smallSide] * ratio);
        }
        toReturn.setSize(newSize[0], newSize[1]);
        return toReturn;
    }

    protected static BufferedImage scale(BufferedImage bufferedImage, double scaleX, double scaleY) {
        AffineTransform tx = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(bufferedImage, null);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Dimension newDimension) {
        BufferedImage toReturn = null;
        ImagePlus source = new ImagePlus(null, (Image)bufferedImage);
        ImageProcessor ip = source.getProcessor();
        ImageProcessor ip2 = ip.resize(newDimension.width, newDimension.height);
        toReturn = ip2.getBufferedImage();
        return toReturn;
    }

    protected static BufferedImage frameImage(BufferedImage image, SlideImageState derivedState) {
        BufferedImage toReturn = null;
        Dimension boxSize = derivedState.getPanelDimensions();
        if (boxSize.width > image.getWidth() || boxSize.height > image.getHeight()) {
            toReturn = new BufferedImage(boxSize.width, boxSize.height, image.getType());
            Graphics2D g = toReturn.createGraphics();
            g.setColor(Color.BLACK);
            g.setBackground(Color.BLACK);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.fillRect(0, 0, derivedState.getPanelDimensions().width, derivedState.getPanelDimensions().height);
            int destinationX = 0;
            int destinationY = 0;
            int sourceWidth = boxSize.width;
            int sourceHeight = boxSize.height;
            int sourceX = 0;
            int sourceY = 0;
            if (boxSize.width > image.getWidth()) {
                destinationX = (int)((double)boxSize.width / 2.0 - (double)Math.round((double)image.getWidth() / 2.0));
                sourceWidth = image.getWidth();
                sourceX = 0;
            }
            if (boxSize.height > image.getHeight()) {
                destinationY = (int)((double)boxSize.height / 2.0 - (double)Math.round((double)image.getHeight() / 2.0));
                sourceHeight = image.getHeight();
                sourceY = 0;
            }
            g.drawImage(image, destinationX, destinationY, destinationX + sourceWidth, destinationY + sourceHeight, sourceX, sourceY, sourceX + sourceWidth, sourceY + sourceHeight, null);
            g.dispose();
        } else {
            toReturn = image;
        }
        return toReturn;
    }

    protected static BufferedImage subimage(BufferedImage image, SlideImageState derivedState) {
        BufferedImage toReturn = null;
        if (image != null) {
            Dimension boxSize = derivedState.getPanelDimensions();
            toReturn = new BufferedImage(boxSize.width, boxSize.height, image.getType());
            Graphics2D g = toReturn.createGraphics();
            g.setColor(Color.BLACK);
            g.setBackground(Color.BLACK);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.fillRect(0, 0, derivedState.getPanelDimensions().width, derivedState.getPanelDimensions().height);
            int sourceX = (int)((long)derivedState.getCenterPoint().x - Math.round((double)boxSize.width / 2.0));
            int sourceY = (int)((long)derivedState.getCenterPoint().y - Math.round((double)boxSize.height / 2.0));
            int sourceWidth = boxSize.width;
            int sourceHeight = boxSize.height;
            int destinationX = 0;
            int destinationY = 0;
            if (boxSize.width > image.getWidth()) {
                destinationX = (int)((double)boxSize.width / 2.0 - (double)Math.round((double)image.getWidth() / 2.0));
                sourceWidth = image.getWidth();
                sourceX = 0;
            }
            if (boxSize.height > image.getHeight()) {
                destinationY = (int)((double)boxSize.height / 2.0 - (double)Math.round((double)image.getHeight() / 2.0));
                sourceHeight = image.getHeight();
                sourceY = 0;
            }
            g.drawImage(image, destinationX, destinationY, destinationX + sourceWidth, destinationY + sourceHeight, sourceX, sourceY, sourceX + sourceWidth, sourceY + sourceHeight, null);
            g.dispose();
        }
        return toReturn;
    }

    protected static String constructImageFileName(SlideMedia si) {
        String imageFileName = si.getId() + "-" + si.getMediaId();
        imageFileName = FileUtils.makeValidFilename(imageFileName);
        return imageFileName;
    }

    protected static Dimension calculateSlideDimensions(Presentation p, Dimension targetCanvasSize) {
        if (targetCanvasSize != null) {
            return SlideUtils.calculateSlideDimensions(p, targetCanvasSize.width, targetCanvasSize.height);
        }
        return SlideUtils.calculateSlideDimensions(p, 1, 1);
    }

    public static Dimension calculateExternalMediaBaseRatio(int width, int height) {
        Dimension toReturn = new Dimension();
        if (width > 0 && height > 0) {
            toReturn.width = (int)Math.round((double)width * Math.pow(2.0, 2.0));
            toReturn.height = (int)Math.round((double)height * Math.pow(2.0, 2.0));
        }
        return toReturn;
    }
}

