/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import de.schlichtherle.io.FileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SigFileHelper {
    protected static final Log logger = LogFactory.getLog(SigFileHelper.class);
    public static final String DIGEST = "digest";
    public static final String MODTIME = "modtime";

    public static long parseSigFile(StringBuffer contents, String newDigest) {
        String digest = "";
        long modTime = -1L;
        logger.debug((Object)("SigFile: parsing:" + contents));
        String[] lines = contents.toString().split("\r\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains(":")) continue;
            String key = line.substring(0, line.indexOf(":"));
            String val = line.substring(line.indexOf(":") + 1);
            if (key.equals(DIGEST)) {
                digest = val;
            }
            if (!key.equals(MODTIME)) continue;
            try {
                modTime = Long.parseLong(val);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1L;
            }
        }
        logger.debug((Object)("digest:" + digest + "; newDigest:" + newDigest + "(" + digest.trim().equals(newDigest.trim()) + ") ; modTime:" + modTime));
        if (digest.trim().equals(newDigest.trim())) {
            return modTime;
        }
        return -1L;
    }

    public static String createSigFile(String digest, long modTime) {
        String ret = "digest:" + digest + "\r\n";
        ret = ret + "modtime:" + modTime + "\r\n";
        return ret;
    }

    public static synchronized String encrypt(String plaintext) throws NoSuchAlgorithmException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            md.update(plaintext.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] raw = md.digest();
        return new String(Base64.getMimeEncoder().encode(raw), StandardCharsets.UTF_8);
    }

    public static synchronized String encrypt(File mfile) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        int read;
        FileInputStream is = null;
        String hash = null;
        is = new FileInputStream(mfile);
        byte[] buffer = new byte[8192];
        MessageDigest digest = null;
        digest = MessageDigest.getInstance("SHA");
        while ((read = is.read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        byte[] raw = digest.digest();
        hash = new String(Base64.getMimeEncoder().encode(raw), StandardCharsets.UTF_8);
        return hash;
    }
}

