/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class PolygonUtils {
    public static List<List<double[]>> simplify(List<List<double[]>> polygons, double tolerance) {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<List<double[]>> simplifiedPolygons = new ArrayList<List<double[]>>();
        for (List<double[]> polygon : polygons) {
            double[] point;
            int type;
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(polygon.get(0)[0], polygon.get(0)[1]);
            for (int i = 1; i < polygon.size(); ++i) {
                ((Path2D)path).lineTo(polygon.get(i)[0], polygon.get(i)[1]);
            }
            path.closePath();
            PathIterator iterator = path.getPathIterator(null);
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
            while (!iterator.isDone() && (type = iterator.currentSegment(point = new double[2])) != 4) {
                coordinates.add(new Coordinate(point[0], point[1]));
                iterator.next();
            }
            Polygon poly = gf.createPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
            Geometry simplified = TopologyPreservingSimplifier.simplify((Geometry)poly, (double)tolerance);
            Coordinate[] simplifiedCoords = simplified.getCoordinates();
            ArrayList<double[]> simplifiedPolygon = new ArrayList<double[]>();
            for (Coordinate coord : simplifiedCoords) {
                double[] point2 = new double[]{coord.x, coord.y};
                simplifiedPolygon.add(point2);
            }
            simplifiedPolygons.add(simplifiedPolygon);
        }
        return simplifiedPolygons;
    }

    public static Coordinate calculateCentroid(List<Coordinate> coordinates) {
        if (coordinates == null) {
            return null;
        }
        if (coordinates.size() == 1) {
            return coordinates.get(0);
        }
        if (coordinates.get(0) == coordinates.get(coordinates.size() - 1)) {
            coordinates.remove(coordinates.size() - 1);
        }
        ArrayList<Double> coordX = new ArrayList<Double>();
        ArrayList<Double> coordY = new ArrayList<Double>();
        for (Coordinate c : coordinates) {
            coordX.add(c.getX());
            coordY.add(PolygonUtils.positiveLon(c.getY()));
        }
        double centroidX = PolygonUtils.calculateCentroid(coordX.toArray());
        double centroidY = PolygonUtils.calculateCentroid(coordY.toArray());
        if (centroidY > 180.0) {
            double diff = centroidY - 180.0;
            centroidY = -180.0 + diff;
        } else if (centroidY < -180.0) {
            double diff = Math.abs(centroidY + 180.0);
            centroidY = 180.0 - diff;
        }
        return new Coordinate(centroidX, centroidY);
    }

    public static double positiveLon(double lon) {
        if (lon > 0.0) {
            return lon;
        }
        double dist = Math.abs(-180.0 - lon);
        return 180.0 + dist;
    }

    private static double calculateCentroid(Object[] coordinates) {
        double sum = 0.0;
        int n = coordinates.length;
        for (Object coord : coordinates) {
            sum += ((Double)coord).doubleValue();
        }
        return sum / (double)n;
    }

    public static Coordinate midPoint(Coordinate p1, Coordinate p2) {
        return new Coordinate((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
    }

    public static Coordinate getMidpoint(List<Coordinate> coordinates) {
        if (coordinates == null || coordinates.size() == 0) {
            return null;
        }
        if (coordinates.size() == 1) {
            return coordinates.get(0);
        }
        if (coordinates.size() == 2) {
            return PolygonUtils.midPoint(coordinates.get(0), coordinates.get(1));
        }
        return PolygonUtils.calculateCentroid(coordinates);
    }

    public static void main(String[] args) {
        String coordinatesString = "[-98.722405, 29.534705], [-98.723379, 29.478152], [-98.70586, 29.454416], [-98.648967, 29.440186], [-98.592107, 29.430102], [-98.541998, 29.417559], [-98.48007, 29.408863], [-98.42283, 29.393544], [-98.34922, 29.38483], [-98.334861, 29.411752], [-98.329294, 29.465618], [-98.398129, 29.498721], [-98.462956, 29.511874], [-98.53567, 29.51826], [-98.612035, 29.526823], [-98.678508, 29.53797], [-98.722405, 29.534705]";
        coordinatesString = "[1.5326602265923697, -178.75440111747548], [-0.46271434098247255, -172.52423005129188], [0.8572277416337784, -176.1164814384032], [1.1680807875277992, -177.0758995885384], [1.4490387225620225, -177.95558629722524], [1.7264899279906132, -178.82338487715984], [1.99515853634297, -179.6661826318521], [2.2866297884835376, 179.42277361905766], [2.8777950539291197, 177.58796583254224], [1.5326602265923697, -178.75440111747548]";
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>();
        coordinatesString = StringUtils.removeEnd((String)StringUtils.removeStart((String)coordinatesString, (String)"["), (String)"]");
        String[] coordinateStrings = coordinatesString.split("\\], \\[");
        for (String coordinateString : coordinateStrings) {
            String[] values = coordinateString.split(", ");
            double x = Double.parseDouble(values[0]);
            double y = Double.parseDouble(values[1]);
            Coordinate coordinate = new Coordinate(x, y);
            coordinateList.add(coordinate);
        }
        for (Coordinate coordinate : coordinateList) {
            System.out.println(coordinate);
        }
        System.out.println("center: " + PolygonUtils.calculateCentroid(coordinateList));
    }
}

