/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasypt.digest.StandardStringDigester;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimplePBEConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

public class PasswordEncryptUtils {
    protected static final Log logger = LogFactory.getLog(PasswordEncryptUtils.class);
    public static final String DEFAULT_DIGEST_ALGORITHM = "SHA-1";
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "PBEWithMD5AndDES";
    public static final int ITERATIONS = 10000;
    public static final String DEFAULT_SALT = "lunaimaginginc";
    public static final String DEFAULT_PRIVATE_KEY = "lunaimaginginc";

    public static synchronized String digest() throws EncryptionOperationNotPossibleException, EncryptionInitializationException {
        return PasswordEncryptUtils.digest("lunaimaginginc");
    }

    public static synchronized String digest(String plaintext) throws EncryptionOperationNotPossibleException, EncryptionInitializationException {
        if (plaintext == null || plaintext.length() == 0) {
            return "";
        }
        StandardStringDigester digester = new StandardStringDigester();
        digester.setAlgorithm(DEFAULT_DIGEST_ALGORITHM);
        digester.setIterations(10000);
        String digest = digester.digest(plaintext);
        return digest;
    }

    public static synchronized boolean matches(String digest) throws EncryptionOperationNotPossibleException, EncryptionInitializationException {
        return PasswordEncryptUtils.matches("lunaimaginginc", digest);
    }

    public static synchronized boolean matches(String password, String digest) throws EncryptionOperationNotPossibleException, EncryptionInitializationException {
        StandardStringDigester digester = new StandardStringDigester();
        digester.setAlgorithm(DEFAULT_DIGEST_ALGORITHM);
        digester.setIterations(10000);
        return digester.matches(password, digest);
    }

    public static synchronized String encrypt(String plaintext, String privateKey, String algorithm) throws EncryptionOperationNotPossibleException, EncryptionInitializationException {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        if (plaintext == null || plaintext.length() == 0) {
            return "";
        }
        SimplePBEConfig simplePBEConfig = new SimplePBEConfig();
        if (algorithm == null) {
            algorithm = DEFAULT_ENCRYPTION_ALGORITHM;
        }
        simplePBEConfig.setAlgorithm(algorithm);
        if (privateKey == null) {
            privateKey = "lunaimaginginc";
        }
        if (!StringUtils.isEmpty((String)privateKey)) {
            simplePBEConfig.setPassword(privateKey);
        }
        encryptor.setConfig((PBEConfig)simplePBEConfig);
        return encryptor.encrypt(plaintext);
    }

    public static synchronized String decrypt(String encrypted, String privateKey, String algorithm) throws EncryptionOperationNotPossibleException, EncryptionInitializationException {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        if (encrypted == null || encrypted.length() == 0) {
            return "";
        }
        SimplePBEConfig simplePBEConfig = new SimplePBEConfig();
        if (algorithm == null) {
            algorithm = DEFAULT_ENCRYPTION_ALGORITHM;
        }
        simplePBEConfig.setAlgorithm(algorithm);
        if (privateKey == null) {
            privateKey = "lunaimaginginc";
        }
        if (!StringUtils.isEmpty((String)privateKey)) {
            simplePBEConfig.setPassword(privateKey);
        }
        encryptor.setConfig((PBEConfig)simplePBEConfig);
        return encryptor.decrypt(encrypted);
    }
}

