/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ParsingUtils {
    public static String[] splitIgnoreCaseTrim(String str, String delimeter) {
        String[] toReturn = null;
        if (str != null) {
            toReturn = str.split("(?i)" + delimeter);
            toReturn = StringUtils.stripAll((String[])toReturn);
        }
        return toReturn;
    }

    public static String[] splitIgnoreCaseTrim(String str, List<String> delimeters) {
        String[] values = new String[]{};
        String delimeter = "";
        if (CollectionUtils.isNotEmpty(delimeters)) {
            for (int i = 0; i < delimeters.size(); ++i) {
                delimeter = delimeter + delimeters.get(i);
                if (i >= delimeters.size() - 1) continue;
                delimeter = delimeter + "|";
            }
        }
        if (StringUtils.isNotEmpty((String)delimeter)) {
            values = ParsingUtils.splitIgnoreCaseTrim(str, delimeter);
        }
        return values;
    }

    public static String[] splitIgnoreCaseTrim(String str, String[] delimeters) {
        String[] values = new String[]{};
        String delimeter = "";
        if (!ArrayUtils.isEmpty((Object[])delimeters)) {
            for (int i = 0; i < delimeters.length; ++i) {
                delimeter = delimeter + delimeters[i];
                if (i >= delimeters.length - 1) continue;
                delimeter = delimeter + "|";
            }
        }
        if (StringUtils.isNotEmpty((String)delimeter)) {
            values = ParsingUtils.splitIgnoreCaseTrim(str, delimeter);
        }
        return values;
    }

    public static Object[] splitPostDigits(String s) {
        return ParsingUtils.splitPostDigits(s, null, -1);
    }

    public static Object[] splitPostDigits(String s, String prefix, int defaultInt) {
        Object[] toReturn = null;
        if (s != null) {
            toReturn = new Object[2];
            if (ParsingUtils.startsWithIgnoreCaseTrim(s, prefix)) {
                s = s.substring(prefix.length());
            }
            if (StringUtils.isNotEmpty((String)s)) {
                String[] split = s.split("\\d+", 2);
                if (split != null && split.length > 1 && StringUtils.isNotEmpty((String)split[1])) {
                    toReturn[1] = split[1];
                    toReturn[0] = NumberUtils.toInt((String)s.substring(0, s.length() - split[1].length()), (int)defaultInt);
                } else {
                    toReturn[1] = null;
                    toReturn[0] = defaultInt;
                }
            }
        }
        return toReturn;
    }

    public static String removeSuffixIgnoreCaseTrim(String str, String suffix) {
        String toReturn = null;
        if (str != null) {
            toReturn = new String(str);
            if ((str = str.toLowerCase().trim()).endsWith(suffix = suffix.toLowerCase().trim())) {
                toReturn = toReturn.substring(0, str.lastIndexOf(suffix)).trim();
            }
        }
        return toReturn;
    }

    public static String removeSuffixIgnoreCase(String str, String suffix) {
        String toReturn = null;
        if (str != null && suffix != null) {
            toReturn = new String(str);
            if (str.toLowerCase().endsWith(suffix.toLowerCase())) {
                toReturn = toReturn.substring(0, str.length() - suffix.length());
            }
        }
        return toReturn;
    }

    public static String removePrefixIgnoreCaseTrim(String str, String prefix) {
        String toReturn = null;
        if (str != null) {
            toReturn = new String(str);
            if (prefix != null && (str = str.toLowerCase()).startsWith(prefix = prefix.toLowerCase())) {
                toReturn = toReturn.substring(prefix.length()).trim();
            }
        }
        return toReturn;
    }

    public static String removePrefixIgnoreCase(String str, String prefix) {
        String toReturn = null;
        if (str != null) {
            toReturn = new String(str);
            if (prefix != null && (str = str.toLowerCase()).startsWith(prefix = prefix.toLowerCase())) {
                toReturn = toReturn.substring(prefix.length());
            }
        }
        return toReturn;
    }

    public static boolean endsWithIgnoreCaseTrim(String str, String suffix) {
        if (str != null && suffix != null) {
            return str.toLowerCase().trim().endsWith(suffix.toLowerCase());
        }
        return false;
    }

    public static boolean endsWithIgnoreCaseTrim(String str, String[] suffixes) {
        if (str != null && suffixes != null) {
            for (String suffix : suffixes) {
                if (!ParsingUtils.endsWithIgnoreCaseTrim(str, suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIgnoreCaseTrim(String str, String suffix) {
        if (str != null && suffix != null) {
            return StringUtils.containsIgnoreCase((String)str, (String)suffix);
        }
        return false;
    }

    public static boolean containsIgnoreCaseTrim(String str, String[] suffixes) {
        if (str != null && suffixes != null) {
            for (String suffix : suffixes) {
                if (!ParsingUtils.containsIgnoreCaseTrim(str, suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startsWithIgnoreCaseTrim(String str, String prefix) {
        if (str != null && prefix != null) {
            return str.toLowerCase().trim().startsWith(prefix.toLowerCase());
        }
        return false;
    }

    public static boolean startsWithIgnoreCaseTrim(String str, String[] prefixes) {
        if (str != null && prefixes != null) {
            for (String prefix : prefixes) {
                if (!ParsingUtils.startsWithIgnoreCaseTrim(str, prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static String toDelimitedString(List<String> values, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            String s = values.get(i);
            if (s == null) continue;
            if (StringUtils.isNotEmpty((String)prefix)) {
                sb.append(prefix);
            }
            sb.append(s);
            if (!StringUtils.isNotEmpty((String)suffix) || i == values.size() - 1) continue;
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static void setValueOnLinkedArrays(ArrayList keys, ArrayList values, Object key, Object value) {
        int arraySize = keys.size();
        for (int i = 0; i < arraySize; ++i) {
            if (!keys.get(i).equals(key)) continue;
            try {
                values.remove(i);
                values.add(i, value);
            }
            catch (IndexOutOfBoundsException iobe) {
                values.add(value);
            }
            return;
        }
        keys.add(key);
        values.add(value);
    }

    public static Object getValueFromLinkedArrays(ArrayList keys, ArrayList values, Object key) {
        int arraySize = keys.size();
        for (int i = 0; i < arraySize; ++i) {
            if (!keys.get(i).equals(key)) continue;
            return values.get(i);
        }
        return null;
    }

    public static boolean equalsIgnoreCase(String s1, String[] s2) {
        if (s1 != null && !ArrayUtils.isEmpty((Object[])s2)) {
            for (String string : s2) {
                if (!StringUtils.equalsIgnoreCase((String)s1, (String)string)) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList splitToArrayList(String source, String delimiter) {
        if (source == null) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(source.split(delimiter)));
    }

    public static String regexReplace(String regex, String input, String newText) {
        String toReturn = input;
        Pattern.compile(regex).matcher(toReturn).replaceAll(newText);
        return toReturn;
    }

    public static String replace(String[] lookFor, String input, String with) {
        String toReturn = input;
        for (String replace : lookFor) {
            toReturn = StringUtils.replace((String)toReturn, (String)replace, (String)with);
        }
        return toReturn;
    }

    public static String repaceSuffix(String[] suffixes, String input, String with) {
        String toReturn = input;
        if (suffixes != null && input != null && with != null) {
            for (String suffix : suffixes) {
                if (!input.endsWith(suffix)) continue;
                toReturn = input.substring(0, input.length() - suffix.length());
                toReturn = toReturn + with;
            }
        }
        return toReturn;
    }

    public static String repacePrefix(String[] prefixes, String input, String with) {
        String toReturn = input;
        if (prefixes != null && input != null && with != null) {
            for (String prefix : prefixes) {
                if (!input.startsWith(prefix)) continue;
                toReturn = input.substring(prefix.length(), input.length());
                toReturn = toReturn + with;
            }
        }
        return toReturn;
    }

    public static Object getIgnoreCase(Map map, String key) {
        Object toReturn = null;
        if (map != null) {
            for (Object obj : map.keySet()) {
                if (!(obj instanceof String) || !StringUtils.equalsIgnoreCase((String)key, (String)((String)obj))) continue;
                toReturn = map.get(obj);
                break;
            }
        }
        return toReturn;
    }

    public static Object getIgnoreCase(Map map, Collection<String> keys) {
        Object toReturn;
        block1: {
            String key;
            toReturn = null;
            if (keys == null) break block1;
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext() && (toReturn = ParsingUtils.getIgnoreCase(map, key = iterator.next())) == null) {
            }
        }
        return toReturn;
    }

    public static List<String> unalteredSplit(String regx, String s) {
        Pattern p = Pattern.compile(regx);
        return ParsingUtils.unalteredSplit(p, s);
    }

    public static List<String> unalteredSplit(Pattern regx, String s) {
        ArrayList<String> terms = new ArrayList<String>();
        if (s != null) {
            String currentMatch;
            Matcher matcher = regx.matcher(s);
            int lastEnd = 0;
            while (matcher.find()) {
                if (lastEnd < matcher.end()) {
                    currentMatch = s.substring(lastEnd, matcher.end());
                    terms.add(currentMatch);
                }
                lastEnd = matcher.end();
            }
            currentMatch = s.substring(lastEnd, s.length());
            terms.add(currentMatch);
        }
        return terms;
    }

    public static boolean contains(int[] source, int[] valuesToFind) {
        boolean toReturn = false;
        if (!ArrayUtils.isEmpty((int[])source) && !ArrayUtils.isEmpty((int[])valuesToFind)) {
            for (int toFind : valuesToFind) {
                if (!ArrayUtils.contains((int[])source, (int)toFind)) continue;
                toReturn = true;
                break;
            }
        }
        return toReturn;
    }

    public static boolean contains(int[] source, List<Integer> valuesToFind) {
        boolean toReturn = false;
        if (!ArrayUtils.isEmpty((int[])source) && !CollectionUtils.isEmpty(valuesToFind)) {
            for (int toFind : valuesToFind) {
                if (!ArrayUtils.contains((int[])source, (int)toFind)) continue;
                toReturn = true;
                break;
            }
        }
        return toReturn;
    }

    public static boolean containsAll(String[] source, List<String> valuesToFind) {
        if (!ArrayUtils.isEmpty((Object[])source) && !CollectionUtils.isEmpty(valuesToFind)) {
            for (String toFind : valuesToFind) {
                if (ArrayUtils.contains((Object[])source, (Object)toFind)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean containsAny(int[] source, List<Integer> valuesToFind) {
        if (!ArrayUtils.isEmpty((int[])source) && !CollectionUtils.isEmpty(valuesToFind)) {
            for (int toFind : valuesToFind) {
                if (!ArrayUtils.contains((int[])source, (int)toFind)) continue;
                return true;
            }
        }
        return false;
    }

    public static List removeDuplicateItems(List<?> list) {
        List toReturn = null;
        if (list != null) {
            try {
                toReturn = (List)list.getClass().newInstance();
                for (Object obj : list) {
                    if (list == null || toReturn.contains(obj)) continue;
                    toReturn.add(obj);
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    public static String setStringIndex(String stringValue, boolean boolValue, int index) {
        String value = "";
        if (stringValue.length() < index + 1 || index < 0) {
            return "";
        }
        String returnString = "";
        value = boolValue ? "1" : "0";
        returnString = index == 0 ? value + stringValue.substring(index + 1) : stringValue.substring(0, index) + value + stringValue.substring(index + 1);
        return returnString;
    }

    public static boolean isStringIndex(String stringValue, int index) {
        if (stringValue.length() - 1 < index || index < 0) {
            return false;
        }
        return stringValue.charAt(index) != '0';
    }

    public static String replaceWith(String text, Collection<String> values, String with) {
        String toReturn = "";
        if (text != null && values != null) {
            toReturn = text;
            for (String value : values) {
                toReturn = StringUtils.replace((String)toReturn, (String)value, (String)with);
            }
        }
        return toReturn;
    }

    public static String regxReplaceWith(String text, Collection<String> regx, String with) {
        String toReturn = "";
        if (text != null && regx != null) {
            toReturn = text;
            for (String reg : regx) {
                toReturn = toReturn.replaceAll(reg, with);
            }
        }
        return toReturn;
    }

    public static boolean containsAny(Collection<String> partialMatches, String source) {
        if (source != null && partialMatches != null) {
            for (String partialMatch : partialMatches) {
                if (source == null || source.indexOf(partialMatch) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || c == '/') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

