/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchStringValue;
import com.lunaimaging.insight.core.domain.search.W4SearchFieldValue;
import com.lunaimaging.insight.core.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MediaSearchUtils {
    public static boolean containsOperation(List<W4SearchFieldValue> searchFieldValues, SearchFieldValue.Operator op) {
        if (searchFieldValues != null && op != null) {
            for (W4SearchFieldValue sfv : searchFieldValues) {
                if (sfv == null || !op.equals((Object)sfv.getOperator())) continue;
                return true;
            }
        }
        return false;
    }

    public static void addSortFieldsToSeachCriteria(String fieldNames, MediaSearchCriteria searchCriteria, Collection<MediaField> mediaFields) {
        if (fieldNames != null) {
            String[] split;
            for (String fieldName : split = StringUtils.split((String)fieldNames, (String)",")) {
                MediaField mf;
                if (!StringUtils.isNotEmpty((String)fieldName) || (mf = MediaSearchUtils.findMediaField(fieldName, mediaFields)) == null) continue;
                searchCriteria.addSortField(mf);
            }
        }
    }

    protected static MediaField findMediaField(String fieldName, Collection<MediaField> mediaFields) {
        if (mediaFields != null) {
            for (MediaField mf : mediaFields) {
                if (!StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName)) continue;
                return mf;
            }
        }
        return null;
    }

    public static void addFacetsToSeachCriteria(HttpServletRequest request, MediaSearchCriteria searchCriteria) {
        String url = request.getRequestURI();
        MediaSearchUtils.addFacetsToSeachCriteria(url, searchCriteria);
    }

    public static void addFacetsToSeachCriteria(String url, MediaSearchCriteria searchCriteria) {
        SearchStringValue ssv;
        ArrayList<String> who = MediaSearchUtils.decode(UrlUtils.getWhoListFromURL(url));
        ArrayList<String> what = MediaSearchUtils.decode(UrlUtils.getWhatListFromURL(url));
        ArrayList<String> where = MediaSearchUtils.decode(UrlUtils.getWhereListFromURL(url));
        ArrayList<String> when = MediaSearchUtils.decode(UrlUtils.getWhenListFromURL(url));
        if (CollectionUtils.isNotEmpty(who) || CollectionUtils.isNotEmpty(what) || CollectionUtils.isNotEmpty(where) || CollectionUtils.isNotEmpty(when)) {
            searchCriteria.setW4FilteredSearch(true);
        } else {
            searchCriteria.setW4FilteredSearch(false);
        }
        for (String s : who) {
            ssv = new SearchStringValue(MediaSearchUtils.unescapeForwardSlashes(s));
            if (!ssv.parse(true)) continue;
            searchCriteria.add(new W4SearchFieldValue(MediaField.W4Type.WHO, ssv, SearchFieldValue.Operator.EQUALS, SearchFieldValue.Condition.AND));
        }
        for (String s : what) {
            ssv = new SearchStringValue(MediaSearchUtils.unescapeForwardSlashes(s));
            if (!ssv.parse(true)) continue;
            searchCriteria.add(new W4SearchFieldValue(MediaField.W4Type.WHAT, ssv, SearchFieldValue.Operator.EQUALS, SearchFieldValue.Condition.AND));
        }
        for (String s : where) {
            ssv = new SearchStringValue(MediaSearchUtils.unescapeForwardSlashes(s));
            if (!ssv.parse(true)) continue;
            searchCriteria.add(new W4SearchFieldValue(MediaField.W4Type.WHERE, ssv, SearchFieldValue.Operator.EQUALS, SearchFieldValue.Condition.AND));
        }
        for (String s : when) {
            ssv = new SearchStringValue(MediaSearchUtils.unescapeForwardSlashes(s));
            if (!ssv.parse(true)) continue;
            searchCriteria.add(new W4SearchFieldValue(MediaField.W4Type.WHEN, ssv, SearchFieldValue.Operator.EQUALS, SearchFieldValue.Condition.AND));
        }
    }

    private static String unescapeForwardSlashes(String value) {
        return StringUtils.replace((String)value, (String)"____", (String)"/");
    }

    public static ArrayList<String> decode(ArrayList<String> list) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String value : list) {
            try {
                returnList.add(URLDecoder.decode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IllegalArgumentException iae) {
                returnList.add(value);
            }
        }
        return returnList;
    }
}

