/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldValue;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class MediaFieldUtils {
    private static final boolean allowUnknowMediaFields = false;

    public static List<MediaFieldValue> getOrderedMediaFieldValues(PublisherMedia pm, MediaCollection mc) {
        ArrayList<MediaFieldValue> toReturn = new ArrayList<MediaFieldValue>();
        if (mc != null) {
            Set fieldNameSet = pm.getFieldNames();
            MediaFieldValue mediaFieldValue = null;
            HashMap entityFieldValues = new HashMap();
            for (String fieldName : fieldNameSet) {
                MediaField mediaField;
                if (fieldName == null || (mediaField = MediaFieldUtils.constructMediaField(mc, fieldName, pm)) == null || mediaField.getDisplayOrder() < 0) continue;
                String fieldValue = null;
                if (mediaField.getParentName() != null && !fieldName.startsWith("_luna_media_") && !fieldName.startsWith("_luna_display_entity_")) {
                    for (String thisFieldName : fieldNameSet) {
                        if (!thisFieldName.startsWith("_luna_display_entity_" + fieldName + "_#")) continue;
                        List fieldValueList = pm.getFieldValueList(thisFieldName);
                        if (fieldValueList != null && fieldValueList.size() > 1) {
                            for (int j = 0; j < fieldValueList.size(); ++j) {
                                String value = (String)fieldValueList.get(j);
                                mediaFieldValue = new MediaFieldValue(mediaField, value);
                                String hierarchyStr = thisFieldName.substring(thisFieldName.indexOf("_luna_display_entity_") + "_luna_display_entity_".length() + fieldName.length() + 1);
                                MediaFieldUtils.constructEntityFieldValues(hierarchyStr, mediaFieldValue, entityFieldValues);
                            }
                            continue;
                        }
                        fieldValue = pm.getFieldValue(thisFieldName);
                        mediaFieldValue = new MediaFieldValue(mediaField, fieldValue);
                        String hierarchyStr = thisFieldName.substring(thisFieldName.indexOf("_luna_display_entity_") + "_luna_display_entity_".length() + fieldName.length() + 1);
                        MediaFieldUtils.constructEntityFieldValues(hierarchyStr, mediaFieldValue, entityFieldValues);
                    }
                    continue;
                }
                List fieldValueList = pm.getFieldValueList(fieldName);
                if (fieldValueList != null && fieldValueList.size() > 1) {
                    for (int j = fieldValueList.size() - 1; j >= 0; --j) {
                        String value = (String)fieldValueList.get(j);
                        mediaFieldValue = new MediaFieldValue(mediaField, value);
                        toReturn.add(0, mediaFieldValue);
                    }
                    continue;
                }
                fieldValue = pm.getFieldValue(fieldName);
                if (fieldName.startsWith("_luna_collection")) {
                    mediaField.setDisplayOrder(1);
                }
                if (fieldValue != null) {
                    mediaFieldValue = new MediaFieldValue(mediaField, fieldValue);
                }
                toReturn.add(0, mediaFieldValue);
            }
            Collections.sort(toReturn);
            MediaFieldUtils.addEntityFields(toReturn, MediaFieldUtils.getEntityFields(entityFieldValues));
        }
        return toReturn;
    }

    public static void constructEntityFieldValues(String hierarchyStr, MediaFieldValue mediaFieldValue, Map<String, List<?>> entityFieldValues) {
        int indexOfNextLevel = hierarchyStr.indexOf("#", 1);
        int level = -1;
        level = indexOfNextLevel > 0 ? Integer.parseInt(hierarchyStr.substring(1, indexOfNextLevel)) : Integer.parseInt(hierarchyStr.substring(1));
        List<?> currentLevelValues = entityFieldValues.get(String.valueOf(level));
        if (currentLevelValues == null) {
            currentLevelValues = new ArrayList();
            entityFieldValues.put(String.valueOf(level), currentLevelValues);
        }
        if (indexOfNextLevel < 0) {
            currentLevelValues.add(mediaFieldValue);
        } else {
            int i;
            Map<String, List<Object>> subFields = null;
            for (i = 0; i < currentLevelValues.size() && currentLevelValues.get(i) instanceof MediaFieldValue; ++i) {
            }
            if (i < currentLevelValues.size() && currentLevelValues.get(i) instanceof Map) {
                subFields = (Map)currentLevelValues.get(i);
            }
            if (subFields == null) {
                subFields = new HashMap();
                currentLevelValues.add(subFields);
            }
            MediaFieldUtils.constructEntityFieldValues(hierarchyStr.substring(indexOfNextLevel), mediaFieldValue, subFields);
        }
    }

    public static List<MediaFieldValue> getEntityFields(Map<String, List<?>> entityFieldValues) {
        ArrayList<MediaFieldValue> entityFields = new ArrayList<MediaFieldValue>();
        int levelSize = entityFieldValues.size();
        int numberOfLevelsParsedThru = 0;
        int totalEntityFields = 0;
        int i = 0;
        while (numberOfLevelsParsedThru < levelSize) {
            List<?> subFields = entityFieldValues.get(String.valueOf(i + 1));
            int insertIndex = totalEntityFields;
            int lastLevelsMaxIndex = totalEntityFields;
            if (subFields != null) {
                Object obj;
                int j;
                int n = subFields.size();
                for (j = 0; j < n; ++j) {
                    obj = subFields.get(j);
                    if (obj == null || !(obj instanceof Map)) continue;
                    List<MediaFieldValue> thisEntitySubFields = MediaFieldUtils.getEntityFields((Map)obj);
                    boolean positionFound = false;
                    if (totalEntityFields == 0) {
                        positionFound = true;
                    }
                    int displayOrder = thisEntitySubFields.get(0).getField().getDisplayOrder();
                    while (!positionFound && insertIndex < totalEntityFields && displayOrder >= ((MediaFieldValue)entityFields.get(insertIndex)).getField().getDisplayOrder()) {
                        ++insertIndex;
                    }
                    if (insertIndex >= totalEntityFields) {
                        entityFields.addAll(thisEntitySubFields);
                    } else {
                        entityFields.addAll(insertIndex, thisEntitySubFields);
                    }
                    totalEntityFields += thisEntitySubFields.size();
                }
                n = subFields.size();
                for (j = 0; j < n; ++j) {
                    obj = subFields.get(j);
                    if (obj == null || !(obj instanceof MediaFieldValue)) continue;
                    boolean positionFound = false;
                    if (totalEntityFields == 0) {
                        positionFound = true;
                    }
                    int displayOrder = ((MediaFieldValue)obj).getField().getDisplayOrder();
                    boolean alreadyIncremented = false;
                    while (!positionFound && insertIndex < totalEntityFields) {
                        if (displayOrder >= ((MediaFieldValue)entityFields.get(insertIndex)).getField().getDisplayOrder()) {
                            ++insertIndex;
                            alreadyIncremented = true;
                            continue;
                        }
                        int lastDisplayOrder = ((MediaFieldValue)entityFields.get(insertIndex)).getField().getDisplayOrder();
                        if (insertIndex > 0 && !alreadyIncremented) {
                            --insertIndex;
                        }
                        while (insertIndex >= 0 && insertIndex >= lastLevelsMaxIndex && ((MediaFieldValue)entityFields.get(insertIndex)).getField().getDisplayOrder() <= lastDisplayOrder && displayOrder < ((MediaFieldValue)entityFields.get(insertIndex)).getField().getDisplayOrder()) {
                            lastDisplayOrder = ((MediaFieldValue)entityFields.get(insertIndex)).getField().getDisplayOrder();
                            --insertIndex;
                        }
                        ++insertIndex;
                        positionFound = true;
                    }
                    if (insertIndex >= totalEntityFields) {
                        entityFields.add((MediaFieldValue)obj);
                    } else {
                        entityFields.add(insertIndex, (MediaFieldValue)obj);
                    }
                    ++totalEntityFields;
                }
                ++numberOfLevelsParsedThru;
            }
            ++i;
        }
        return entityFields;
    }

    public static void addEntityFields(List<MediaFieldValue> mediaFieldList, List<MediaFieldValue> entityFields) {
        if (mediaFieldList == null) {
            mediaFieldList = entityFields;
        } else if (entityFields != null && !entityFields.isEmpty()) {
            int i = 0;
            int entityIndex = entityFields.get(0).getField().getDisplayOrder();
            int nextHigherMediaFieldsDisplayOrder = 0;
            Iterator<MediaFieldValue> entityFieldsIter = entityFields.iterator();
            boolean positionFound = false;
            int totalSimpleFields = mediaFieldList.size();
            while (entityFieldsIter.hasNext()) {
                while (!positionFound && i < totalSimpleFields && mediaFieldList.get(i).getField().getFieldGrp() == MediaField.fieldGroupType.DEFAULT) {
                    if (mediaFieldList.get(i).getField().getDisplayOrder() <= entityIndex) {
                        ++i;
                        continue;
                    }
                    positionFound = true;
                    nextHigherMediaFieldsDisplayOrder = mediaFieldList.get(i).getField().getDisplayOrder();
                }
                if (positionFound) {
                    MediaFieldValue thisField = null;
                    while (entityFieldsIter.hasNext() && entityIndex < nextHigherMediaFieldsDisplayOrder) {
                        thisField = entityFieldsIter.next();
                        if (thisField.getField().getDisplayOrder() > nextHigherMediaFieldsDisplayOrder) {
                            entityFieldsIter = entityFields.iterator();
                            break;
                        }
                        mediaFieldList.add(i++, thisField);
                        ++totalSimpleFields;
                        entityFieldsIter.remove();
                    }
                    i = 0;
                    entityIndex = thisField.getField().getDisplayOrder();
                    positionFound = false;
                    continue;
                }
                while (entityFieldsIter.hasNext()) {
                    mediaFieldList.add(i++, entityFieldsIter.next());
                    ++totalSimpleFields;
                    entityFieldsIter.remove();
                }
            }
        }
    }

    public static MediaField constructMediaField(MediaCollection mc, String fieldName, PublisherMedia pm) {
        MediaField toReturn = null;
        StringBuilder sb = new StringBuilder();
        if (pm != null) {
            if (fieldName.startsWith("_luna_media_")) {
                String fieldValue = pm.getFieldValue(fieldName);
                if (fieldValue == null) {
                    return null;
                }
                MediaField mf = null;
                String displayName = null;
                MediaField.fieldGroupType mediaFieldGrp = null;
                if (fieldName.startsWith("_luna_media_exif_")) {
                    displayName = pm.getFieldValue("_luna_display_media_exif_" + fieldName.substring("_luna_media_exif_".length()));
                    mf = MediaFieldUtils.getMediaField(mc.getMediaFields(), "MEDIA_EXIF", mc);
                    mediaFieldGrp = MediaField.fieldGroupType.MEDIA_EXIF;
                } else if (fieldName.startsWith("_luna_media_iptc_")) {
                    displayName = pm.getFieldValue("_luna_display_media_iptc_" + fieldName.substring("_luna_media_iptc_".length()));
                    mf = MediaFieldUtils.getMediaField(mc.getMediaFields(), "MEDIA_IPTC", mc);
                    mediaFieldGrp = MediaField.fieldGroupType.MEDIA_IPTC;
                } else if (fieldName.startsWith("_luna_media_xmp_")) {
                    displayName = pm.getFieldValue("_luna_display_media_xmp_" + fieldName.substring("_luna_media_xmp_".length()));
                    mf = MediaFieldUtils.getMediaField(mc.getMediaFields(), "MEDIA_XMP", mc);
                    mediaFieldGrp = MediaField.fieldGroupType.MEDIA_XMP;
                } else if (fieldName.startsWith("_luna_media_custom_caption_label_") || fieldName.startsWith("_luna_media_custom_caption_src_")) {
                    displayName = pm.getFieldValue("_luna_display_media_custom_" + fieldName.substring("_luna_media_custom_".length()));
                    mf = MediaFieldUtils.getMediaField(mc.getMediaFields(), "MEDIA_CUSTOM", mc);
                    mediaFieldGrp = MediaField.fieldGroupType.MEDIA_CUSTOM;
                } else if (fieldName.startsWith("_luna_media_custom_")) {
                    displayName = pm.getFieldValue("_luna_display_media_custom_" + fieldName.substring("_luna_media_custom_".length()));
                    mf = MediaFieldUtils.getMediaField(mc.getMediaFields(), "MEDIA_CUSTOM", mc);
                    mediaFieldGrp = MediaField.fieldGroupType.MEDIA_CUSTOM;
                }
                if (mf != null) {
                    toReturn = new MediaField();
                    toReturn.setFieldName(fieldName);
                    toReturn.setFieldId(mf.getFieldId());
                    toReturn.setDisplayName(displayName);
                    sb.append("fieldName = " + fieldName + "\n");
                    toReturn.setFieldGrp(mediaFieldGrp);
                    toReturn.setParentName(mf.getParentName());
                    toReturn.setDisplayOrder(mf.getDisplayOrder());
                    toReturn.setSearchable(mf.isSearchable());
                    toReturn.setInstitutionId(mc.getInstitutionId());
                    sb.append("institutionId = " + mc.getInstitutionId() + "\n");
                    toReturn.setCollectionId(NumberUtils.toInt((String)mc.getCollectionId(), (int)-1));
                    sb.append("collectionId = " + NumberUtils.toInt((String)mc.getCollectionId(), (int)-1) + "\n");
                    toReturn.setUniqueCollectionId(mc.getUniqueCollectionId());
                    sb.append("uniqueCollectionId = " + mc.getUniqueCollectionId());
                }
            } else {
                toReturn = MediaFieldUtils.getMediaField(mc.getMediaFields(), fieldName, mc);
                if (toReturn == null) {
                    // empty if block
                }
            }
        }
        return toReturn;
    }

    public static MediaField constructMediaField(MediaCollection mc, FieldMapping fieldMapping) {
        MediaField toReturn = null;
        StringBuilder sb = new StringBuilder();
        if (fieldMapping == null || (toReturn = MediaFieldUtils.getMediaField(mc.getMediaFields(), fieldMapping.getFieldName(), mc)) == null) {
            // empty if block
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MediaField constructMediaField(MediaCollection mc, FieldValue fieldValue) {
        String fname;
        MediaField toReturn = null;
        if (fieldValue == null) return toReturn;
        if (fieldValue.getField() != null) {
            fname = "";
            fname = !fieldValue.isFieldGroupName ? fieldValue.getField().getFieldName() : fieldValue.getField().getFieldDisplayName();
            assert (!fieldValue.isFieldGroupName) : " THERE is a field that uses fieldDisplay name because isFieldGroupName is true, fiele display name = " + fname + ", collection name = " + mc.getCollectionName();
        } else {
            if (fieldValue.getFieldMapping() == null) return toReturn;
            return MediaFieldUtils.constructMediaField(mc, fieldValue.getFieldMapping());
        }
        toReturn = MediaFieldUtils.getMediaField(mc.getMediaFields(), fname, mc);
        if (toReturn != null) return toReturn;
        return toReturn;
    }

    public static MediaField getMediaField(List<MediaField> mediaFields, String fieldName, MediaCollection mc) {
        MediaField toReturn = null;
        if (mediaFields != null && fieldName != null) {
            for (MediaField mf : mediaFields) {
                if (mf == null || !mf.getInstitutionId().equals(mc.getInstitutionId()) || mf.getUniqueCollectionId() != mc.getUniqueCollectionId() || !StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName)) continue;
                toReturn = mf;
                break;
            }
        }
        return toReturn;
    }
}

