/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.google.common.net.InternetDomainName;
import com.luna.insight.server.TrinityCollectionInfo;
import com.lunaimaging.insight.core.domain.ExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.SharedExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.SharedMediaField;
import com.lunaimaging.insight.core.domain.iiif.ChangeCollection;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.orion.editor.support.CollectionTools;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaCollectionUtils {
    private static Log logger = LogFactory.getLog(MediaCollectionUtils.class);

    public static void removeNonExistingInsightCollections(List<MediaCollection> mediaCollections, Vector insightCollections) {
        if (mediaCollections != null) {
            int m;
            ArrayList<String> mediaCollectionIds = new ArrayList<String>();
            for (m = 0; m < mediaCollections.size(); ++m) {
                mediaCollectionIds.add(mediaCollections.get(m).getInstitutionId() + "~" + mediaCollections.get(m).getCollectionId());
            }
            for (m = 0; m < insightCollections.size(); ++m) {
                String insightCollectionId = ((TrinityCollectionInfo)insightCollections.get(m)).getInstitutionID() + "~" + ((TrinityCollectionInfo)insightCollections.get(m)).getCollectionID();
                if (ParsingUtils.containsAny(mediaCollectionIds, insightCollectionId)) continue;
                insightCollections.remove(m);
                --m;
            }
        }
    }

    public static List<MediaCollection> getSelectedCollections(List<MediaCollection> mcs, String identities) {
        ArrayList<MediaCollection> toReturn = new ArrayList<MediaCollection>();
        if (mcs != null && identities != null) {
            String[] ids = ParsingUtils.splitIgnoreCaseTrim(identities, ",");
            for (MediaCollection mc : mcs) {
                for (int i = 0; i < ids.length; ++i) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)ids[i], (CharSequence)mc.getId()) && !StringUtils.equalsIgnoreCase((CharSequence)ids[i], (CharSequence)mc.getAbbreviatedName())) continue;
                    toReturn.add(mc);
                }
            }
        }
        return toReturn;
    }

    public static List<MediaField> getSortableFields(List<MediaCollection> mcs) {
        ArrayList<MediaField> sortableFields = new ArrayList<MediaField>();
        ArrayList<MediaField> mfs = new ArrayList<MediaField>();
        for (MediaCollection mc : mcs) {
            mfs.addAll(mc.getMediaFields());
        }
        for (MediaField mf : mfs) {
            if (!mf.isSortable()) continue;
            sortableFields.add(mf);
        }
        return sortableFields;
    }

    public static String getServerAddressFromList(List<MediaCollection> mcs, String identity) {
        List<MediaCollection> mediaCollection = MediaCollectionUtils.getSelectedCollections(mcs, identity);
        if (!mediaCollection.isEmpty()) {
            return mediaCollection.get(0).getServerAddress();
        }
        return "";
    }

    public static SharedMediaCollection constructSharedMediaCollection(MediaCollection mc) throws IOException, IllegalAccessException, InvocationTargetException {
        SharedMediaCollection smc = null;
        if (mc != null) {
            SharedMediaField smf;
            ArrayList<MediaField> mfs;
            smc = new SharedMediaCollection();
            BeanUtils.copyProperties((Object)smc, (Object)mc);
            if (mc.getExtendedCollectionProperties() != null) {
                ExtendedCollectionProperties props = mc.getExtendedCollectionProperties();
                SharedExtendedCollectionProperties secp = new SharedExtendedCollectionProperties();
                if (!(props instanceof SharedExtendedCollectionProperties)) {
                    BeanUtils.copyProperties((Object)secp, (Object)props);
                }
                secp.setCollectionId(mc.getId());
                secp.setDefaultGroupId(0);
                if (StringUtils.isNotBlank((CharSequence)props.getTheme())) {
                    String srcTheme = props.getTheme();
                    if (StringUtils.equalsIgnoreCase((CharSequence)srcTheme, (CharSequence)"default")) {
                        srcTheme = "earth";
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)srcTheme, (CharSequence)"white")) {
                        srcTheme = "modern";
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)srcTheme, (CharSequence)"blue")) {
                        srcTheme = "deepsea";
                    }
                    secp.setTheme(srcTheme);
                }
                smc.setExtendedCollectionProperties(secp);
            }
            if (mc.getPreviewMediaFields() != null) {
                mfs = new ArrayList<MediaField>();
                for (MediaField mf : mc.getPreviewMediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setPreviewMediaFields(mfs);
            }
            if (mc.getSummaryDescriptionMediaFields() != null) {
                mfs = new ArrayList();
                for (MediaField mf : mc.getSummaryDescriptionMediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setSummaryDescriptionMediaFields(mfs);
            }
            if (mc.getW4MediaFields() != null) {
                mfs = new ArrayList();
                for (MediaField mf : mc.getW4MediaFields()) {
                    smf = new SharedMediaField();
                    BeanUtils.copyProperties((Object)smf, (Object)mf);
                    mfs.add(smf);
                }
                smc.setW4MediaFields(mfs);
            }
        }
        return smc;
    }

    public static List<SharedMediaCollection> constructSharedMediaCollections(List<MediaCollection> mcs) throws IOException, IllegalAccessException, InvocationTargetException {
        ArrayList<SharedMediaCollection> smcs = new ArrayList<SharedMediaCollection>();
        for (MediaCollection mc : mcs) {
            SharedMediaCollection smc = MediaCollectionUtils.constructSharedMediaCollection(mc);
            if (smc == null) continue;
            smcs.add(smc);
        }
        return smcs;
    }

    public static MediaCollection mapFrom(ChangeCollection cc) {
        MediaCollection mc = new MediaCollection();
        try {
            String institutionId = MediaCollectionUtils.generateInstitutionId(cc.getId(), 3);
            mc.setInstitutionId(institutionId);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        mc.setVcId("NA");
        mc.setCollectionType(MediaCollection.CollectionType.distribution.toString());
        mc.setExtendedCollectionProperties(MediaCollectionUtils.createExtendedCollectionProperties(cc));
        mc.setTotalMediaCount(cc.getTotalItems());
        mc.setUserCollection(1);
        mc.setUserId(1);
        mc.setVirtualCollection(false);
        return mc;
    }

    public static MediaCollection mapFrom(Object cc) {
        MediaCollection mc = new MediaCollection();
        URI id = null;
        Integer total = 0;
        if (cc instanceof Collection) {
            id = ((Collection)cc).getIdentifier();
            total = ((Collection)cc).getTotal();
        } else if (cc instanceof JSONObject) {
            id = MediaCollectionUtils.getIiifID((JSONObject)cc);
            try {
                total = ((JSONObject)cc).has("items") ? 0 : ((JSONObject)cc).getJSONArray("items").length();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        try {
            String institutionId = MediaCollectionUtils.generateInstitutionId(id.toString(), 3);
            mc.setInstitutionId(institutionId);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        mc.setVcId("NA");
        mc.setCollectionType(MediaCollection.CollectionType.distribution.toString());
        mc.setExtendedCollectionProperties(MediaCollectionUtils.createExtendedCollectionProperties(cc));
        if (total != null && total > 0) {
            mc.setTotalMediaCount(total);
        }
        mc.setUserCollection(1);
        mc.setUserId(1);
        mc.setVirtualCollection(false);
        return mc;
    }

    public static int getCollectionMaxIdByInstitution(List<MediaCollection> mcs, String institutionId) {
        int maxId = 0;
        if (mcs == null || mcs.size() == 0) {
            return maxId;
        }
        for (MediaCollection mc : mcs) {
            try {
                if (!StringUtils.equals((CharSequence)mc.getInstitutionId(), (CharSequence)institutionId) || Integer.parseInt(mc.getCollectionId()) <= maxId) continue;
                maxId = Integer.parseInt(mc.getCollectionId());
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
        }
        return maxId;
    }

    public static String generateInstitutionId(String collectionUri, int suffixLength) throws MalformedURLException {
        String institutionId = null;
        int MAX_LENGTH = 12;
        URL u = new URL(collectionUri);
        String domain = u.getHost();
        String s = CollectionTools.encrypt((String)domain);
        s = RegExUtils.removeAll((String)s, (Pattern)Pattern.compile("[^0-9A-Za-z]"));
        institutionId = domain;
        if (InternetDomainName.from((String)domain).hasPublicSuffix()) {
            institutionId = StringUtils.substringBeforeLast((String)InternetDomainName.from((String)domain).topPrivateDomain().toString(), (String)("." + InternetDomainName.from((String)domain).topPrivateDomain().publicSuffix()));
        }
        String subdomain = "";
        if (!StringUtils.startsWithIgnoreCase((CharSequence)domain, (CharSequence)institutionId)) {
            subdomain = StringUtils.substringBefore((String)domain, (String)("." + institutionId));
        }
        if (StringUtils.equals((CharSequence)subdomain, (CharSequence)"www")) {
            subdomain = "";
        }
        institutionId = StringUtils.substring((String)institutionId, (int)0, (int)MAX_LENGTH);
        String[] sub = StringUtils.split((String)subdomain, (char)'.');
        subdomain = "";
        for (int i = sub.length - 1; i >= 0; --i) {
            subdomain = subdomain + StringUtils.substring((String)sub[i], (int)0, (int)MAX_LENGTH);
        }
        institutionId = institutionId + subdomain + StringUtils.substring((String)s, (int)(s.length() > suffixLength ? s.length() - suffixLength : 0));
        return institutionId.toUpperCase();
    }

    protected static ExtendedCollectionProperties createExtendedCollectionProperties(ChangeCollection cc) {
        SharedExtendedCollectionProperties ecp = new SharedExtendedCollectionProperties();
        ecp.setUri(cc.getId());
        ecp.setUseAsDefault(false);
        ecp.setDefaultGroupId(0);
        return ecp;
    }

    protected static ExtendedCollectionProperties createExtendedCollectionProperties(Object cc) {
        SharedExtendedCollectionProperties ecp = new SharedExtendedCollectionProperties();
        URI id = null;
        if (cc instanceof Collection) {
            id = ((Collection)cc).getIdentifier();
        } else if (cc instanceof JSONObject) {
            id = MediaCollectionUtils.getIiifID((JSONObject)cc);
        }
        ecp.setUri(id.toString());
        ecp.setUseAsDefault(false);
        ecp.setDefaultGroupId(0);
        return ecp;
    }

    public static URI getIiifID(JSONObject resource) {
        if (resource != null) {
            if (resource.has("id")) {
                try {
                    return new URI(resource.getString("id"));
                }
                catch (URISyntaxException | JSONException e) {
                    e.printStackTrace();
                }
            }
            if (resource.has("@id")) {
                try {
                    return new URI(resource.getString("@id"));
                }
                catch (URISyntaxException | JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

