/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.lunaimaging.insight.core.domain.ActionResponse;
import com.lunaimaging.insight.core.domain.SimpleActionResponse;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONEntity;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringLiteral;

public class JsonUtils {
    private static Log log = LogFactory.getLog(JsonUtils.class);
    protected static final String[] COMMON_UNWANTED_BEAN_PROPERTIES = new String[]{"class", "superclass", "interfaces", "annotations", "methods", "enclosingConstructor", "enclosingMethod", "genericInterfaces", "declaredMethods", "declaredAnnotations", "declaredConstructors", "typeParameters", "componentType", "declaringClass", "genericType", "classLoader"};

    public static JSONEntity constrcutJsonObject(Object obj) throws JSONException {
        return JsonUtils.constrcutJsonObject(obj, -1, true, null);
    }

    public static JSONEntity constrcutJsonObject(Object obj, int maxRecursion) throws JSONException {
        return JsonUtils.constrcutJsonObject(obj, maxRecursion, true, null);
    }

    public static JSONEntity constrcutJsonObject(Object obj, int maxRecursion, boolean ignoreCommonBeanProperties, String[] skipProperties) throws JSONException {
        JSONObject jsonObject;
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            jsonObject = new JSONObject();
                            if (obj == null) {
                                obj = new SimpleActionResponse("Object is null!", ActionResponse.Status.FAILED);
                            }
                            if (!(obj instanceof HashMap)) break block3;
                            for (Object key : ((Map)obj).keySet()) {
                                if (ignoreCommonBeanProperties && (ParsingUtils.equalsIgnoreCase(String.valueOf(key), COMMON_UNWANTED_BEAN_PROPERTIES) || ParsingUtils.equalsIgnoreCase(String.valueOf(key), skipProperties))) continue;
                                jsonObject.put(String.valueOf(key), (Object)JsonUtils.constrcutJsonObject(((Map)obj).get(key), maxRecursion, ignoreCommonBeanProperties, skipProperties));
                            }
                            break block4;
                        }
                        if (!(obj instanceof Collection)) break block5;
                        jsonObject = JsonUtils.constrcutJsonObject((Collection)obj, maxRecursion, ignoreCommonBeanProperties, skipProperties);
                        break block4;
                    }
                    if (!obj.getClass().isArray()) break block6;
                    jsonObject = JsonUtils.constrcutJsonObject((Object[])obj, maxRecursion, ignoreCommonBeanProperties, skipProperties);
                    break block4;
                }
                if (!(obj instanceof CharSequence)) break block7;
                jsonObject = new JSONStringLiteral(obj.toString());
                break block4;
            }
            if (obj == null) break block4;
            BeanMap bean = new BeanMap(obj);
            for (Object key : bean.keySet()) {
                if (ignoreCommonBeanProperties && (ParsingUtils.equalsIgnoreCase(String.valueOf(key), COMMON_UNWANTED_BEAN_PROPERTIES) || ParsingUtils.equalsIgnoreCase(String.valueOf(key), skipProperties)) || ignoreCommonBeanProperties && bean.get(key) instanceof Class) continue;
                JsonUtils.addValue(String.valueOf(key), bean, jsonObject, maxRecursion, ignoreCommonBeanProperties, skipProperties);
            }
        }
        return jsonObject;
    }

    private static JSONArray constrcutJsonObject(Object[] objects, int maxRecursion, boolean ignoreCommonBeanProperties, String[] skipProperties) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        ArrayList<JSONEntity> jsonObjects = new ArrayList<JSONEntity>();
        if (!ArrayUtils.isEmpty((Object[])objects)) {
            for (Object obj : objects) {
                jsonObjects.add(JsonUtils.constrcutJsonObject(obj, maxRecursion, ignoreCommonBeanProperties, skipProperties));
            }
            jsonArray = new JSONArray(jsonObjects);
        }
        return jsonArray;
    }

    private static JSONArray constrcutJsonObject(Collection objects, int maxRecursion, boolean ignoreCommonBeanProperties, String[] skipProperties) throws JSONException {
        if (objects != null) {
            return JsonUtils.constrcutJsonObject(objects.toArray(), maxRecursion, ignoreCommonBeanProperties, skipProperties);
        }
        return new JSONArray();
    }

    private static void addValue(String key, BeanMap data, JSONObject jsonObject, int maxRecursion, boolean ignoreCommonBeanProperties, String[] skipProperties) throws JSONException {
        if (key != null && data != null && jsonObject != null) {
            Integer[] value = data.get((Object)key);
            Class c = data.getType(key);
            if (value instanceof Number || value instanceof Boolean || value instanceof CharSequence) {
                jsonObject.put(key, (Object)value);
            } else if (c.isArray() && maxRecursion >= 0) {
                if (value instanceof int[]) {
                    value = ArrayUtils.toObject((int[])value);
                }
                jsonObject.put(key, (Object)JsonUtils.constrcutJsonObject(value, maxRecursion - 1, ignoreCommonBeanProperties, skipProperties).toString());
            } else if (value instanceof Collection && maxRecursion >= 0) {
                jsonObject.put(key, (Object)JsonUtils.constrcutJsonObject((Collection)value, maxRecursion - 1, ignoreCommonBeanProperties, skipProperties).toString());
            } else if (value != null && maxRecursion >= 0) {
                jsonObject.put(key, (Object)JsonUtils.constrcutJsonObject((Object)value, maxRecursion - 1, ignoreCommonBeanProperties, skipProperties).toString());
            }
        }
    }

    public static String prettyPrint(String filePath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        File jsonFile = new File(filePath);
        JsonNode jsonNode = objectMapper.readTree(jsonFile);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        String prettyJson = objectWriter.writeValueAsString((Object)jsonNode);
        return prettyJson;
    }
}

