/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.lunaimaging.insight.core.MessageManager;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaGroup;
import com.lunaimaging.insight.core.domain.Presentation;
import com.lunaimaging.insight.core.domain.SlideImageState;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.search.facet.Facet;
import com.lunaimaging.insight.core.utils.MediaCollectionUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.insight.core.utils.UrlUtils;
import java.awt.Dimension;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.MessageSource;

public class InsightCoreUtils {
    public static final String LUNA_ID_DELIMETER = "~";
    private static char[] BAD_DETAIL_URL_CHARS = new char[]{'(', ')', '/', '\\', ';', ':', '[', ']', '.', '\'', '\"', '?', '#'};
    private static boolean INCLUDE_DETAIL_URL_TITLE = true;
    private static int DETAIL_URL_TITLE_MAX_LENGTH = 35;

    public static String constructGroupUrl(String domain, String appContext, MediaGroup group, int mgid, MessageSource messageSource) {
        String page = messageSource.getMessage(MessageManager.MessageKeys.VIEW_GROUP_URL.getValue(), null, null);
        if (group != null) {
            return domain + appContext + page + "/" + group.getId();
        }
        if (mgid > 0) {
            return domain + appContext + page + "/" + String.valueOf(mgid);
        }
        return null;
    }

    public static String constructHomePageUrl(String domain, String appContext, MessageSource messageSource) {
        String toReturn = domain + appContext + messageSource.getMessage(MessageManager.MessageKeys.VIEW_HOME_URL.getValue(), null, null);
        return toReturn;
    }

    public static String constructMediaCollectionHomePageUrl(String domain, String appContext, Object value, MessageSource messageSource) {
        StringBuilder sb = new StringBuilder();
        sb.append(domain);
        sb.append(appContext);
        sb.append(messageSource.getMessage(MessageManager.MessageKeys.MEDIA_COLLECTION_HOMEPAGE_URL.getValue(), null, null));
        if (value instanceof MediaCollection) {
            sb.append(((MediaCollection)value).getAbbreviatedName());
        }
        return sb.toString();
    }

    public static String constructCategoryHomePageUrl(String domain, String appContext, String value, MessageSource messageSource) {
        StringBuilder sb = new StringBuilder();
        sb.append(domain);
        sb.append(appContext);
        sb.append(messageSource.getMessage(MessageManager.MessageKeys.MEDIA_COLLECTION_HOMEPAGE_URL.getValue(), null, null));
        sb.append(value);
        return sb.toString();
    }

    public static String constructMediaCollectionUrl(String domain, String appContext, Object value, MessageSource messageSource) {
        MediaCollection mc = (MediaCollection)value;
        String mcid = mc.getAbbreviatedName();
        if (StringUtils.isEmpty((String)mcid)) {
            mcid = String.valueOf(mc.getId());
        }
        String url = domain + appContext + messageSource.getMessage(MessageManager.MessageKeys.VIEW_MEDIA_COLLECTION_URL.getValue(), null, null) + "/" + mcid;
        return url;
    }

    public static String constructDetailUrl(String domain, String appContext, MessageSource messageSource, String mediaId, String title, String fullTextSearch) {
        return InsightCoreUtils.constructDetailUrl(domain, appContext, messageSource.getMessage(MessageManager.MessageKeys.VIEW_DETAIL_URL.getValue(), null, null), mediaId, title, null, fullTextSearch);
    }

    public static String constructDetailUrl(String domain, String appContext, MessageSource messageSource, String mediaId, String title, String sort, String fullTextSearch) {
        return InsightCoreUtils.constructDetailUrl(domain, appContext, messageSource.getMessage(MessageManager.MessageKeys.VIEW_DETAIL_URL.getValue(), null, null), mediaId, title, sort, fullTextSearch);
    }

    public static String constructDetailUrl(String domain, String appContext, String view, String id, String title, String fullTextSearch) {
        return InsightCoreUtils.constructDetailUrl(domain, appContext, view, id, title, null, fullTextSearch);
    }

    public static String constructDetailUrl(String domain, String appContext, String view, String id, String title, String sort, String fullTextSearch) {
        if (INCLUDE_DETAIL_URL_TITLE && title != null && title.length() > 0) {
            int maxToUse = DETAIL_URL_TITLE_MAX_LENGTH > title.length() ? title.length() : DETAIL_URL_TITLE_MAX_LENGTH;
            title = StringUtils.substring((String)title, (int)0, (int)maxToUse);
            for (char temp : BAD_DETAIL_URL_CHARS) {
                title = StringUtils.replaceChars((String)title, (char)temp, (char)' ');
            }
            title = StringUtils.replaceChars((String)title, (char)' ', (char)'-');
            if (StringUtils.isNotBlank((String)(title = InsightCoreUtils.normalizeToAscii(title)))) {
                title = ":" + title;
            }
        } else {
            title = "";
        }
        String encodedSort = "";
        try {
            sort = UrlUtils.sanitize(sort);
            encodedSort = sort != null && sort.length() > 0 ? "?sort=" + URLEncoder.encode(sort, "UTF-8") : "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        fullTextSearch = "checked".equals(fullTextSearch) ? (encodedSort.length() == 0 ? "?fullTextSearch=fullTextSearch" : "&fullTextSearch=fullTextSearch") : "";
        return domain + appContext + view + "/" + id + title + encodedSort + fullTextSearch;
    }

    public static String constructBrowseByCategoryUrl(String domain, String appContext, MessageSource messageSource) {
        String url = domain + appContext + messageSource.getMessage(MessageManager.MessageKeys.BROWSE_BY_CATEGORY_URL.getValue(), null, null);
        return url;
    }

    public static String constructBrowseByTitleUrl(String domain, String appContext, MessageSource messageSource, Object value) {
        String url = domain + appContext + messageSource.getMessage(MessageManager.MessageKeys.BROWSE_BY_TITLE_URL.getValue(), null, null) + "/" + value;
        return url;
    }

    public static String constructW4Url(String domain, String appContext, String type, String value, String view, boolean firstValue) {
        String newValue = "";
        if (firstValue) {
            newValue = domain + appContext + view;
        }
        newValue = newValue + "/" + type.toLowerCase() + "/" + value.replace(" ", "+");
        return newValue;
    }

    public static String constructW4ComboUrl(String domain, String appContext, List<Facet> facet, String view) {
        String entireUrl = "";
        boolean firstValue = true;
        for (int i = 0; i < facet.size(); ++i) {
            if (i > 0) {
                firstValue = false;
            }
            entireUrl = entireUrl + InsightCoreUtils.constructW4Url(domain, appContext, facet.get(i).getType().toString(), facet.get(i).getValue(), view, firstValue);
        }
        return entireUrl;
    }

    public static int getObjectIdFromLunaMediaId(String id) {
        int objectId = -1;
        if (InsightCoreUtils.isValidLunaMediaIdFormat(id)) {
            String[] split = id.split(LUNA_ID_DELIMETER);
            objectId = NumberUtils.toInt((String)split[3], (int)-1);
        }
        return objectId;
    }

    public static String getUniqueCollectionIdFromLunaMediaId(String id) {
        String[] parts;
        String ucId = "";
        if (StringUtils.isNotEmpty((String)id) && (parts = id.split(LUNA_ID_DELIMETER)).length > 2) {
            ucId = parts[2];
        }
        return ucId;
    }

    public static int getMediaIdFromLunaMediaId(String id) {
        int mediaId = -1;
        if (InsightCoreUtils.isValidLunaMediaIdFormat(id)) {
            mediaId = NumberUtils.toInt((String)id.substring(id.lastIndexOf(LUNA_ID_DELIMETER) + 1), (int)-1);
        }
        return mediaId;
    }

    public static String getCollectionIdFromLunaMediaId(String id) {
        String collectionId = "";
        if (InsightCoreUtils.isValidLunaMediaIdFormat(id)) {
            String[] split = id.split(LUNA_ID_DELIMETER);
            collectionId = split[0] + LUNA_ID_DELIMETER + split[1] + LUNA_ID_DELIMETER + split[2];
        }
        return collectionId;
    }

    public static String getCollectionIdFromLunaMedia(LunaMedia media) {
        String collectionId = "";
        if (media != null) {
            collectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(media.getId());
        }
        return collectionId;
    }

    public static String constructMediaCollectionId(String intitutionId, String collectionId, String uniqueCollectionId) {
        String id = "";
        id = intitutionId + LUNA_ID_DELIMETER + collectionId + LUNA_ID_DELIMETER + uniqueCollectionId;
        return id;
    }

    public static String getCollectionIdFromMediaField(MediaField mf) {
        String id = "";
        if (mf != null) {
            id = InsightCoreUtils.constructMediaCollectionId(mf.getInstitutionId(), String.valueOf(mf.getCollectionId()), String.valueOf(mf.getUniqueCollectionId()));
        }
        return id;
    }

    public static boolean isValidLunaMediaIdFormat(String id) {
        List<Object> list;
        boolean valid = false;
        if (id == null) {
            return false;
        }
        if (id.contains(",")) {
            list = id == null || id.trim().isEmpty() ? Collections.emptyList() : Arrays.stream(id.split(",")).map(String::trim).filter(id_ -> !id_.isEmpty()).collect(Collectors.toList());
        } else {
            list = new ArrayList();
            list.add(id);
        }
        for (String string : list) {
            String[] split = string.split(LUNA_ID_DELIMETER);
            if (split.length == 5) {
                valid = true;
            }
            for (String str : split) {
                String s = ParsingUtils.replace(new String[]{"-", "_"}, str, "");
                if (StringUtils.isAlphanumeric((String)s)) continue;
                valid = false;
                break;
            }
            if (valid) continue;
            break;
        }
        return valid;
    }

    public static String constructLunaImageSourceUrl(LunaMedia lm, int x, int y, int width, int height, int level) {
        String url = "";
        if (StringUtils.isNotEmpty((String)lm.getUrlSource())) {
            long adjustedX = 0L;
            long adjustedY = 0L;
            if (lm.getUrlSource().toLowerCase().indexOf(".sid") >= 0) {
                adjustedX = (x + width / 2) * (1 << level);
                adjustedY = (y + height / 2) * (1 << level);
            } else {
                adjustedX = x * (1 << level);
                adjustedY = y * (1 << level);
            }
            url = lm.getUrlSource();
            url = UrlUtils.appendParameter(url, "x", String.valueOf(adjustedX));
            url = UrlUtils.appendParameter(url, "y", String.valueOf(adjustedY));
            url = UrlUtils.appendParameter(url, "width", String.valueOf(width));
            url = UrlUtils.appendParameter(url, "height", String.valueOf(height));
            url = UrlUtils.appendParameter(url, "level", level);
        }
        return url;
    }

    public static String constructLunaImageSourceUrl(SlideImageState slideImageState) {
        if (slideImageState != null && slideImageState.getSlideImage() != null && slideImageState.getSlideImage().getMedia() instanceof LunaMedia) {
            LunaMedia lm = (LunaMedia)slideImageState.getSlideImage().getMedia();
            Dimension sourceImageSize = InsightCoreUtils.calculateImageDimensions(lm, slideImageState.getLevel());
            double width = slideImageState.getPanelDimensions().width;
            double height = slideImageState.getPanelDimensions().height;
            double x = (double)slideImageState.getCenterPoint().x - width / 2.0;
            double y = (double)slideImageState.getCenterPoint().y - height / 2.0;
            width = width * (double)sourceImageSize.width / (double)slideImageState.getActualImageSize().width;
            height = height * (double)sourceImageSize.height / (double)slideImageState.getActualImageSize().height;
            x = x * (double)sourceImageSize.width / (double)slideImageState.getActualImageSize().width;
            y = y * (double)sourceImageSize.height / (double)slideImageState.getActualImageSize().height;
            if ((x = Math.max(0.0, x)) + width > (double)sourceImageSize.width) {
                width = (double)sourceImageSize.width - x;
            }
            if ((y = Math.max(0.0, y)) + height > (double)sourceImageSize.height) {
                height = (double)sourceImageSize.height - y;
            }
            return InsightCoreUtils.constructLunaImageSourceUrl(lm, (int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(width), (int)Math.floor(height), slideImageState.getLevel());
        }
        return "";
    }

    public static Dimension calculateImageDimensions(LunaMedia media, int level) {
        Dimension toReturn = new Dimension();
        if (media != null && level >= 0 && media.getMaxWidth() > 0 && media.getMaxHeight() > 0) {
            double scaler = Math.pow(2.0, level);
            toReturn.width = (int)Math.floor((double)media.getMaxWidth() / scaler);
            toReturn.height = (int)Math.floor((double)media.getMaxHeight() / scaler);
        }
        return toReturn;
    }

    public static String constructPresentationUrl(String domainName, String appContext, int pid, Presentation pres, MessageSource messageSource) {
        if (pres != null || pid > 0) {
            String page = messageSource.getMessage(MessageManager.MessageKeys.VIEW_PRESENTATION_URL.getValue(), null, null);
            return domainName + appContext + page + pid + "?sipc=1";
        }
        return null;
    }

    public static String constructMediaId(String collectionId, String objectId, String mediaId) {
        return collectionId + LUNA_ID_DELIMETER + objectId + LUNA_ID_DELIMETER + mediaId;
    }

    public static String constructRandomString(int len) {
        return InsightCoreUtils.constructRandomString(len, false, null);
    }

    public static String constructRandomString(int len, boolean includeUpperCase, String charExclude) {
        char[] toReturn = new char[len];
        int c = 97;
        int rand = 0;
        char[] excl = new char[]{};
        boolean isDone = false;
        if (charExclude != null) {
            excl = charExclude.toCharArray();
        }
        for (int i = 0; i < len; ++i) {
            isDone = false;
            do {
                rand = (int)(Math.random() * (double)(includeUpperCase ? 3 : 2));
                switch (rand) {
                    case 0: {
                        c = 48 + (int)(Math.random() * 10.0);
                        break;
                    }
                    case 1: {
                        c = 97 + (int)(Math.random() * 26.0);
                        break;
                    }
                    case 2: {
                        c = 65 + (int)(Math.random() * 26.0);
                    }
                }
                boolean doAgain = false;
                for (int j = 0; j < excl.length; ++j) {
                    if ((char)c != excl[j]) continue;
                    doAgain = true;
                    break;
                }
                if (doAgain) continue;
                isDone = true;
            } while (!isDone);
            toReturn[i] = (char)c;
        }
        return new String(toReturn);
    }

    public static String getValidatedSortFields(List<String> paramList, List<MediaCollection> mcs) {
        String toReturn = "";
        if (paramList == null || mcs == null) {
            return toReturn;
        }
        List<MediaField> collectionSortFields = MediaCollectionUtils.getSortableFields(mcs);
        block0: for (String param : paramList) {
            for (MediaField mf : collectionSortFields) {
                if (!param.equalsIgnoreCase(mf.getFieldName())) continue;
                toReturn = toReturn + (toReturn.length() == 0 ? "" : ",") + param;
                continue block0;
            }
        }
        return toReturn;
    }

    public static String subStringAnchor(String text, int maxLength, String suffix) {
        char LEFT_ARROW = '<';
        char RIGHT_ARROW = '>';
        if (text == null || text.isEmpty()) {
            return null;
        }
        char[] arrChar = text.toCharArray();
        char[] arrResult = new char[text.length()];
        int index = 0;
        int count = 0;
        int indexEndOfString = 0;
        boolean passedLeft = false;
        boolean passedRight = false;
        boolean passedStartTag = false;
        boolean passedEndTag = false;
        boolean isInText = false;
        boolean isInTag = false;
        boolean isLimitReached = false;
        for (int i = 0; i < arrChar.length; ++i) {
            if (arrChar[i] == LEFT_ARROW) {
                passedLeft = true;
                isInTag = true;
                isInText = false;
            } else if (arrChar[i] == RIGHT_ARROW) {
                passedRight = true;
                if (i > 1 && arrChar[i - 1] == '/') {
                    if (passedStartTag) {
                        passedEndTag = true;
                    }
                } else {
                    passedStartTag = true;
                }
            }
            if (!isInTag) {
                ++count;
            }
            if (count <= maxLength || isInTag) {
                arrResult[index++] = arrChar[i];
            } else if (!isLimitReached) {
                indexEndOfString = i;
                isLimitReached = true;
            }
            if (passedLeft && passedRight) {
                passedLeft = false;
                passedRight = false;
                isInTag = false;
            } else if (!passedLeft || passedRight || index > maxLength) {
                // empty if block
            }
            if (passedStartTag && passedEndTag) {
                passedStartTag = false;
                passedEndTag = false;
                isInText = false;
                continue;
            }
            if (!passedStartTag || passedEndTag || isInTag) continue;
            isInText = true;
        }
        String toReturn = new String(arrResult);
        if (count > maxLength) {
            toReturn = toReturn.trim();
            toReturn = toReturn.substring(0, indexEndOfString) + suffix + toReturn.substring(indexEndOfString, toReturn.length());
        }
        return toReturn;
    }

    public static boolean hasAnchor(String text) {
        return text != null && ParsingUtils.containsIgnoreCaseTrim(text, "<a ");
    }

    public static String createCatalogDataFullTextQuery(String query) {
        String temp = query.replaceAll("(\\s+|^)[Aa][Nn][Dd]", "&#_");
        temp = temp.trim();
        temp = temp.replaceAll("&#_", " AND ");
        return temp;
    }

    public static String addLimitToQuery(String query, String limitToAdd) {
        String limit = "";
        Matcher matcher = MediaSearchCriteria.LIMIT_DEFINITION.matcher(query);
        if (matcher.find()) {
            limit = query.substring(matcher.start(), matcher.end());
            query = query.substring(0, matcher.start()).trim();
        }
        query = query + " " + "Limit:" + limitToAdd + (limit.isEmpty() ? "" : "," + limit);
        return query;
    }

    public static String normalizeToAscii(String input) {
        String normalized = Normalizer.normalize(input, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{M}+");
        String withoutDiacritics = pattern.matcher(normalized).replaceAll("");
        String asciiOnly = withoutDiacritics.replaceAll("[^\\x00-\\x7F]", "");
        return asciiOnly;
    }
}

