/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.luna.insight.server.ImageFile;
import com.lunaimaging.insight.core.domain.LunaMedia;
import java.awt.Dimension;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;

public class ImageInfoUtils {
    public static void populateMediaImageData(LunaMedia media, Vector<ImageFile> imageFiles) {
        if (CollectionUtils.isNotEmpty(imageFiles)) {
            try {
                if (imageFiles.get(0) != null) {
                    media.setType(ImageFile.getMediaTypeToString((int)imageFiles.get(0).getMediaType()));
                    media.setUrlSize0(ImageInfoUtils.prepareStaticImageUrl(imageFiles.get(0).getUrl()));
                }
                if (imageFiles.get(1) != null) {
                    media.setType(ImageFile.getMediaTypeToString((int)imageFiles.get(1).getMediaType()));
                    media.setUrlSize1(ImageInfoUtils.prepareStaticImageUrl(imageFiles.get(1).getUrl()));
                }
                if (imageFiles.get(2) != null) {
                    media.setType(ImageFile.getMediaTypeToString((int)imageFiles.get(2).getMediaType()));
                    media.setUrlSize2(ImageInfoUtils.prepareStaticImageUrl(imageFiles.get(2).getUrl()));
                }
                if (imageFiles.get(3) != null) {
                    media.setType(ImageFile.getMediaTypeToString((int)imageFiles.get(3).getMediaType()));
                    media.setUrlSize3(ImageInfoUtils.prepareStaticImageUrl(imageFiles.get(3).getUrl()));
                }
                if (imageFiles.get(4) != null) {
                    media.setType(ImageFile.getMediaTypeToString((int)imageFiles.get(4).getMediaType()));
                    media.setUrlSize4(ImageInfoUtils.prepareStaticImageUrl(imageFiles.get(4).getUrl()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!media.isImage()) {
                ImageFile nonImageFile = ImageInfoUtils.getNonImageFile(imageFiles);
                if (nonImageFile != null) {
                    media.setUrlSource(nonImageFile.getUrl());
                }
                if (!media.isBook()) {
                    for (int i = imageFiles.size() - 1; i >= 0; --i) {
                        if (imageFiles.get(i).getFormat() != 0) continue;
                        Dimension refImageDim = imageFiles.get(i).getImageSize();
                        media.setRefImageDim(refImageDim);
                        media.setUrlRefMedia(ImageInfoUtils.prepareStaticImageUrl(imageFiles.get(i).getUrl()));
                        break;
                    }
                }
            } else {
                ImageFile largestResolution = ImageInfoUtils.getLargestResolutionImageFile(imageFiles);
                if (largestResolution != null) {
                    media.setMaxLevel(largestResolution.getResolution());
                    if (largestResolution.getFormat() == 1 || largestResolution.getFormat() == 13) {
                        media.setUrlSource(ImageInfoUtils.getSourceUrl(largestResolution.getUrl()));
                    }
                    if (largestResolution.getImageSize() != null) {
                        media.setMaxHeight((int)largestResolution.getImageSize().getHeight());
                        media.setMaxWidth((int)largestResolution.getImageSize().getWidth());
                    }
                }
            }
        }
    }

    private static ImageFile getLargestResolutionImageFile(Vector<ImageFile> imageFiles) {
        ImageFile imf = null;
        if (CollectionUtils.isNotEmpty(imageFiles)) {
            int i = imageFiles.size() - 1;
            while (i >= 0 && i < imageFiles.size()) {
                if ((imf = imageFiles.get(i--)) == null || imf.getFormat() != 1 && imf.getFormat() != 13 && imf.getFormat() != 0) continue;
                return imf;
            }
        }
        return null;
    }

    private static String getSourceUrl(String url) {
        String toReturn = "";
        if (url != null) {
            toReturn = url.contains(".sid") ? url.substring(0, url.indexOf(".sid") + 4) : ImageInfoUtils.prepareStaticImageUrl(url);
        }
        return toReturn;
    }

    private static String prepareStaticImageUrl(String url) {
        return url;
    }

    private static ImageFile getNonImageFile(Vector<ImageFile> imageFiles) {
        ImageFile imf = null;
        if (CollectionUtils.isNotEmpty(imageFiles)) {
            int i = imageFiles.size() - 1;
            while (i >= 0 && i < imageFiles.size()) {
                if ((imf = imageFiles.get(i--)) == null || imf.getResolution() < 2) continue;
                return imf;
            }
        }
        return null;
    }
}

