/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IiifUtils {
    public static final String PRESENTATION_API_2_CONTEXT = "http://iiif.io/api/presentation/2/context.json";
    public static final String DICOVERY_API_0_CONTEXT = "http://iiif.io/api/discovery/0/context.json";
    public static final String IMAGE_API_LEVEL_ZERO = "http://iiif.io/api/image/2/level0.json";
    public static final String IMAGE_API_LEVEL_ONE = "http://iiif.io/api/image/2/level1.json";
    public static final String IMAGE_API_LEVEL_TWO = "http://iiif.io/api/image/2/level2.json";
    private String imageProfile = "http://iiif.io/api/image/2/level1.json";
    private String presentationApiContext = "http://iiif.io/api/presentation/2/context.json";
    private static Log logger = LogFactory.getLog(IiifUtils.class);

    public IiifUtils() {
    }

    public IiifUtils(String imageProfile) {
        this.imageProfile = imageProfile;
    }

    public static String getIdFromManifestUri(String uri) {
        return StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)uri, (String)"/manifest"), (String)"/");
    }

    public static boolean isLunaManifest(String lunaManifestUri) {
        String s = StringUtils.substringBetween((String)lunaManifestUri, (String)"iiif/m/", (String)"/manifest");
        return s != null && StringUtils.isNotEmpty((String)s);
    }

    public static boolean isLunaCanvas(String uri) {
        String s = StringUtils.substringBetween((String)uri, (String)"iiif/m/", (String)"/canvas");
        return s != null && StringUtils.isNotEmpty((String)s);
    }

    public static String getIdFromCanvasUri(String uri) {
        return StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)uri, (String)"/canvas"), (String)"/");
    }

    public static Map<String, Object> getCollectionInfoFromUrl(URL activityStreamUrl) {
        HashMap<String, Object> collectionInfo = new HashMap<String, Object>();
        if (activityStreamUrl == null) {
            return collectionInfo;
        }
        HashMap<String, Serializable> toReturn = null;
        boolean validActivityStream = false;
        try {
            InputStreamReader reader = new InputStreamReader(activityStreamUrl.openStream());
            JsonElement cc = (JsonElement)new Gson().fromJson((Reader)reader, JsonElement.class);
            JsonObject ccObj = cc.getAsJsonObject();
            JsonArray sas = null;
            if (ccObj != null && ccObj.has("seeAlso")) {
                JsonElement sasObj = ccObj.get("seeAlso");
                if (sasObj instanceof JsonArray) {
                    sas = ccObj.get("seeAlso").getAsJsonArray();
                } else if (sasObj instanceof JsonObject) {
                    sas = new JsonArray();
                    sas.add(ccObj.get("seeAlso"));
                } else if (sasObj instanceof JsonPrimitive) {
                    // empty if block
                }
            }
            if (ccObj.has("last")) {
                validActivityStream = true;
            }
            if (sas != null) {
                for (int i = 0; i < sas.size(); ++i) {
                    JsonObject obj;
                    JsonElement ss;
                    InputStreamReader ins;
                    JsonObject sa = sas.get(i).getAsJsonObject();
                    if (sa.has("conformsTo") && sa.get("conformsTo").getAsString().equals("LunaCollectionSchema") && sa.has("format") && sa.get("format").getAsString().endsWith("/json")) {
                        ins = new InputStreamReader(new URL(sa.get("id").getAsString()).openStream());
                        ss = (JsonElement)new Gson().fromJson((Reader)ins, JsonElement.class);
                        obj = ss.getAsJsonObject();
                        JsonObject info = obj.get("collectionInfo").getAsJsonObject();
                        collectionInfo.put("collectionName", info.get("collectionName").getAsString());
                        collectionInfo.put("institutionName", info.get("institutionName").getAsString());
                        collectionInfo.put("type", "LUNA");
                        break;
                    }
                    if (sa.has("id") && sa.get("type").getAsString().equals("Dataset")) {
                        JsonElement pub;
                        ins = new InputStreamReader(new URL(sa.get("id").getAsString()).openStream());
                        ss = (JsonElement)new Gson().fromJson((Reader)ins, JsonElement.class);
                        obj = ss.getAsJsonObject();
                        JsonElement title = obj.get("title");
                        if (title != null) {
                            collectionInfo.put("collectionName", title.getAsString());
                        }
                        if ((pub = obj.get("publisher")) != null) {
                            InputStreamReader ins_ = new InputStreamReader(new URL(pub.getAsJsonObject().get("id").getAsString()).openStream());
                            JsonElement pub_ = (JsonElement)new Gson().fromJson((Reader)ins_, JsonElement.class);
                            collectionInfo.put("institutionName", pub_.getAsJsonObject().get("name").getAsString());
                        }
                        collectionInfo.put("type", "Content DM");
                        continue;
                    }
                    collectionInfo.put("type", "Other");
                }
            }
            toReturn = new HashMap<String, Serializable>();
            toReturn.put("collectionInfo", collectionInfo);
            toReturn.put("validActivityStream", Boolean.valueOf(validActivityStream));
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Bad URL:" + activityStreamUrl), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Bad URL:" + activityStreamUrl), (Throwable)e);
        }
        return toReturn;
    }
}

