/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.luna.insight.server.ImageFile;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.image.ResolvingException;
import de.digitalcollections.iiif.model.image.SizeRequest;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    protected static final String ZIP_CROSS_PLATFORM_FILE_SEPERATOR = "/";

    public static void sendInputToOutputStream(InputStream in, OutputStream out) throws IOException {
        int numRead;
        int BUFFER_SIZE = 0x100000;
        byte[] buffer = new byte[0x100000];
        while ((numRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, numRead);
        }
    }

    public static File createTempFolder(String baseName, String location) throws IOException {
        return FileUtils.createTempFolder(baseName, "", location);
    }

    public static File createTempFolder(String baseName, String suffix, String location) throws IOException {
        if (baseName.length() < 3) {
            baseName = "LUNA_" + baseName;
        }
        if ((baseName = baseName.replaceAll("[\\\\/:*?\"<>|]", "_")).length() > 100) {
            baseName = baseName.substring(0, 100);
        }
        File tempFolderFile = File.createTempFile(baseName, suffix, new File(location));
        tempFolderFile.delete();
        File returnFolder = new File(tempFolderFile.getAbsolutePath());
        returnFolder.mkdir();
        return returnFolder;
    }

    public static String makeValidFilename(String s, String replacement) {
        return s.replaceAll("[\\:\\*\\?\\<\\>\\|]", replacement).replace(File.pathSeparator, replacement);
    }

    public static String makeValidFilename(String s) {
        return FileUtils.makeValidFilename(s, "-");
    }

    public static void createPathToFile(File file) {
        if (file != null) {
            FileUtils.createPathToFile(file, file.getName());
        }
    }

    public static void createPathToFile(File file, String name) {
        if (file != null) {
            if (!file.getParentFile().exists()) {
                FileUtils.createPathToFile(file.getParentFile(), name);
                if (!StringUtils.equals((String)file.getName(), (String)name)) {
                    file.mkdir();
                }
            } else if (!file.exists() && !StringUtils.equals((String)file.getName(), (String)name)) {
                file.mkdir();
            }
        }
    }

    public static void deleteFolderContent(File folderToRemove) {
        FileUtils.deleteFolderRecursive(folderToRemove, true);
    }

    public static void deleteFolderRecursive(File folderToRemove) {
        FileUtils.deleteFolderRecursive(folderToRemove, false);
    }

    protected static void deleteFolderRecursive(File folderToRemove, boolean deleteContentOnly) {
        ArrayList<String> fileList = FileUtils.fetchFileList(folderToRemove);
        if (CollectionUtils.isNotEmpty(fileList)) {
            File f;
            for (String s : fileList) {
                f = new File(s);
                f.delete();
            }
            ArrayList<String> dirList = FileUtils.fetchDirectoryList(folderToRemove);
            for (int i = dirList.size() - 1; i >= 0; --i) {
                String path = dirList.get(i);
                if (deleteContentOnly && StringUtils.equalsIgnoreCase((String)path, (String)folderToRemove.getAbsolutePath())) continue;
                f = new File(path);
                f.delete();
            }
        }
    }

    public static ArrayList<String> fetchFileList(File f) {
        return FileUtils.fetchFileList(f, null, null);
    }

    public static ArrayList<String> fetchFileList(File f, String prefix, String suffix) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (f != null) {
            if (f.isDirectory()) {
                File[] filesInFolder = f.listFiles();
                for (int i = 0; i < filesInFolder.length; ++i) {
                    fileList.addAll(FileUtils.fetchFileList(filesInFolder[i], prefix, suffix));
                }
            } else {
                String path = f.getPath();
                if ((StringUtils.isEmpty((String)prefix) || ParsingUtils.startsWithIgnoreCaseTrim(path, prefix)) && (StringUtils.isEmpty((String)suffix) || ParsingUtils.endsWithIgnoreCaseTrim(path, suffix))) {
                    fileList.add(path);
                }
            }
        }
        return fileList;
    }

    public static ArrayList<String> fetchDirectoryList(File f) {
        ArrayList<String> dirList = new ArrayList<String>();
        if (f.exists() && f.isDirectory()) {
            dirList.add(f.getAbsolutePath());
            File[] filesInFolder = f.listFiles();
            for (int i = 0; i < filesInFolder.length; ++i) {
                dirList.addAll(FileUtils.fetchDirectoryList(filesInFolder[i]));
            }
        } else if (!f.exists() && f.getAbsolutePath().indexOf(46) < 0) {
            dirList.add(f.getAbsolutePath());
        }
        return dirList;
    }

    public static void writeFilesToZip(File directoryToZip, String relativePath, String rootFolder, ZipOutputStream zipOut) throws FileNotFoundException, IOException {
        ArrayList<String> fileList = FileUtils.fetchFileList(directoryToZip);
        FileUtils.writeFilesToZip(fileList, relativePath, rootFolder, zipOut);
    }

    public static void writeFilesToZip(ArrayList<String> fileList, String relativePath, String rootFolder, ZipOutputStream zipOut) throws FileNotFoundException, IOException {
        String zipName = null;
        for (String filename : fileList) {
            File f = new File(filename);
            if (f.isDirectory()) {
                zipName = filename.equalsIgnoreCase(relativePath) ? f.getName() : filename.substring(relativePath.length());
                if (ParsingUtils.startsWithIgnoreCaseTrim(zipName, File.separator)) {
                    zipName = zipName.substring(1);
                }
                zipName = zipName.replaceAll("\\\\", ZIP_CROSS_PLATFORM_FILE_SEPERATOR);
                ZipEntry zipEntry = new ZipEntry(zipName + ZIP_CROSS_PLATFORM_FILE_SEPERATOR);
                zipOut.putNextEntry(zipEntry);
                zipOut.closeEntry();
                continue;
            }
            FileInputStream zipFileInput = new FileInputStream(f);
            zipName = filename.substring(relativePath.length());
            if (ParsingUtils.startsWithIgnoreCaseTrim(zipName, File.separator)) {
                zipName = zipName.substring(1);
            }
            zipName = rootFolder + File.separator + zipName;
            zipName = zipName.replaceAll("\\\\", ZIP_CROSS_PLATFORM_FILE_SEPERATOR);
            ZipEntry zipEntry = new ZipEntry(zipName);
            zipOut.putNextEntry(zipEntry);
            FileUtils.sendInputToOutputStream(zipFileInput, zipOut);
            zipFileInput.close();
            zipOut.closeEntry();
        }
    }

    public static void unzipFiles(File[] files, boolean deleteSource) throws IOException {
        if (files != null) {
            for (File file : files) {
                FileUtils.unzipFile(file);
                if (!deleteSource) continue;
                file.delete();
            }
        }
    }

    public static void unzipFile(File file) throws IOException {
        FileUtils.unzipFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File file, File expandToDirectory) throws IOException {
        ZipFile zipFile = null;
        OutputStream fileOut = null;
        BufferedOutputStream bufferedOut = null;
        try {
            if (expandToDirectory == null) {
                expandToDirectory = file.getParentFile();
            }
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(entry.getName()).mkdir();
                    continue;
                }
                File f = new File(expandToDirectory.getAbsolutePath() + File.separator + entry.getName());
                FileUtils.createPathToFile(f);
                fileOut = new FileOutputStream(f);
                bufferedOut = new BufferedOutputStream(fileOut);
                FileUtils.sendInputToOutputStream(zipFile.getInputStream(entry), bufferedOut);
                bufferedOut.flush();
                bufferedOut.close();
                fileOut.flush();
                ((FileOutputStream)fileOut).close();
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
            if (bufferedOut != null) {
                bufferedOut.flush();
                bufferedOut.close();
            }
            if (fileOut != null) {
                fileOut.flush();
                ((FileOutputStream)fileOut).close();
            }
        }
    }

    public static String getFileExtension(String fileName) {
        String extension = "";
        if (StringUtils.isNotEmpty((String)fileName) && fileName.lastIndexOf(".") > 0) {
            extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return extension;
    }

    public static String getMediaFileExtensionFromUrl(String fileName, String supportedFileExtensions, String defaultExtension) {
        String toReturn = "";
        if (supportedFileExtensions != null) {
            String[] split = ParsingUtils.splitIgnoreCaseTrim(supportedFileExtensions, ",");
            toReturn = FileUtils.getMediaFileExtensionFromUrl(fileName, split, defaultExtension);
        }
        return toReturn;
    }

    public static String getMediaFileExtensionFromUrl(String fileName, String[] supportedFileExtensions, String defaultExtension) {
        String toReturn = null;
        String extension = "";
        if (StringUtils.isNotEmpty((String)fileName)) {
            int index = -1;
            index = fileName.indexOf("&");
            if (index > 0) {
                String mediaFilePart = fileName.substring(0, index);
                if (mediaFilePart != null && (index = mediaFilePart.lastIndexOf(".")) > 0 && mediaFilePart.length() > index + 1) {
                    extension = mediaFilePart.substring(index + 1);
                }
            } else {
                index = fileName.lastIndexOf(".");
                if (fileName.length() > index + 1) {
                    extension = fileName.substring(index);
                }
            }
            extension = extension.trim().toLowerCase();
            if (StringUtils.isNotEmpty((String)extension)) {
                for (String ext : supportedFileExtensions) {
                    if (!StringUtils.contains((String)extension, (String)ext)) continue;
                    toReturn = ext;
                    break;
                }
            }
            if (StringUtils.isEmpty(toReturn)) {
                toReturn = defaultExtension;
            }
        }
        return toReturn;
    }

    public static String getMediaFileNameFromUrl(String url, String mediaFileExtension) {
        String toReturn = "";
        String tmp = "";
        if (StringUtils.isNotEmpty((String)url) && StringUtils.isNotEmpty((String)mediaFileExtension)) {
            if (url.lastIndexOf(mediaFileExtension) > 0) {
                tmp = url.substring(0, url.lastIndexOf(mediaFileExtension));
                toReturn = url.substring(tmp.lastIndexOf(ZIP_CROSS_PLATFORM_FILE_SEPERATOR) + 1, url.lastIndexOf(mediaFileExtension)) + mediaFileExtension;
            } else if (mediaFileExtension.equalsIgnoreCase(".jpg") && url.lastIndexOf("jp2") > 0) {
                tmp = url.substring(0, url.lastIndexOf("jp2"));
                toReturn = url.substring(tmp.lastIndexOf(ZIP_CROSS_PLATFORM_FILE_SEPERATOR) + 1, url.lastIndexOf("jp2")) + mediaFileExtension;
            }
        }
        return toReturn;
    }

    public static String getFullMediaFileNameFromUrl(String url, boolean noExtension) {
        String toReturn = "";
        String tmp = "";
        String extension = "";
        if (StringUtils.isNotEmpty((String)url)) {
            if (url.lastIndexOf(".") > 0) {
                extension = url.substring(url.lastIndexOf("."));
            }
            int index = extension.indexOf("&");
            int index2 = extension.indexOf("?");
            if (index >= 0 || index2 >= 0) {
                if (index2 < index && index2 >= 0) {
                    index = index2;
                }
                extension = extension.substring(0, index);
            }
            extension = extension.trim();
        }
        if (StringUtils.isNotEmpty((String)url) && StringUtils.isNotEmpty((String)extension) && url.lastIndexOf(extension) > 0) {
            tmp = url.substring(0, url.lastIndexOf(extension));
            toReturn = url.substring(tmp.lastIndexOf(ZIP_CROSS_PLATFORM_FILE_SEPERATOR) + 1, url.lastIndexOf(extension));
            try {
                ImageApiSelector selector = ImageApiSelector.fromImageApiUri((URI)new URI(url));
                selector.setSize(new SizeRequest(Integer.valueOf(96), null));
                String path = selector.toString();
                toReturn = toReturn + "_" + UUID.nameUUIDFromBytes(path.getBytes()).toString();
            }
            catch (ResolvingException selector) {
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (!noExtension) {
                toReturn = toReturn + extension;
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File f) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (f != null && f.exists() && f.isFile()) {
            FileReader reader = null;
            BufferedReader bufferedReader = null;
            try {
                reader = new FileReader(f);
                bufferedReader = new BufferedReader(reader);
                String line = "";
                while (line != null) {
                    sb.append(line + "\n");
                    line = bufferedReader.readLine();
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return sb.toString();
    }

    public static Properties readPropertiesFile(File f) throws IOException {
        Properties toReturn = new Properties();
        if (f != null && f.exists()) {
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(f);
                toReturn.load(inputStream);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(Properties props, File f, String comments) throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(f);
            props.store(out, comments);
        }
    }

    public static void writeToFile(File f, String toWrite) throws IOException {
        if (f != null && toWrite != null) {
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(f);
                fw.write(toWrite);
            }
            finally {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
            }
        }
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        if (source != null && destination != null && destination.isDirectory() && source.isDirectory()) {
            File newDestination = new File(destination, source.getName());
            newDestination.mkdir();
            for (File f : source.listFiles()) {
                FileUtils.copyFile(f, newDestination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws IOException {
        if (source != null && destination != null && destination.isDirectory()) {
            if (source.isDirectory()) {
                FileUtils.copyDirectory(source, destination);
            } else if (source.isFile()) {
                File newFile = new File(destination, source.getName());
                newFile.createNewFile();
                FileInputStream in = null;
                OutputStream out = null;
                try {
                    in = new FileInputStream(source);
                    out = new FileOutputStream(newFile);
                    FileUtils.sendInputToOutputStream(in, out);
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
    }

    public static String getMediaFileExtensionFromUrl(Media file, String supportedFileExtensions, String defaultExtension) {
        String toReturn = "";
        if (supportedFileExtensions != null) {
            String[] split = ParsingUtils.splitIgnoreCaseTrim(supportedFileExtensions, ",");
            try {
                int format = Integer.parseInt(file.getFormat());
                toReturn = FileUtils.getMediaFileExtensionFromUrl("FILE." + ImageFile.getFormatTypeToString((int)format), split, defaultExtension);
            }
            catch (Exception e) {
                toReturn = FileUtils.getMediaFileExtensionFromUrl("FILE." + file.getFormat(), split, defaultExtension);
            }
        }
        return toReturn;
    }
}

