/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.utils;

import com.luna.insight.server.SimpleDate;
import com.lunaimaging.insight.core.domain.Annotation;
import com.lunaimaging.insight.core.domain.AnnotationHistory;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.PolygonUtils;
import com.lunaimaging.publisher.common.domain.PublisherAnnotation;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.awt.Polygon;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMPolygonElement;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.ParseUtils;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class AnnotationMapper {
    protected static Log logger = LogFactory.getLog(AnnotationMapper.class);
    public static final String[] DATE_PATTERNS = new String[]{"MM/dd/yyyy", "dd MMM yyyy", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss aa", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd hh:mm:ss aa", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd't'HH:mm:ss'z'"};

    public static void processAnnoHistory(PublisherAnnotation pa, List<AnnotationHistory> history) {
        if (history != null && pa != null) {
            AnnotationHistory mostRecent = null;
            for (AnnotationHistory hist : history) {
                if (StringUtils.equals((CharSequence)hist.getCreatorType(), (CharSequence)"Software")) {
                    if (StringUtils.equals((CharSequence)hist.getCreatorName(), (CharSequence)"mapKurator:ocr")) {
                        Document doc = Jsoup.parse((String)hist.getValue());
                        pa.addField(PublisherAnnotation.ANNOTATION_OCR_TEXT, (Object)doc.text());
                        pa.addField(PublisherAnnotation.ANNOTATION_OCR_TEXT + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                        pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_OCR_TEXT, (Object)doc.text());
                        pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                        pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                        pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)hist.getCreatorName(), (CharSequence)"mapKurator:post-ocr-correction")) continue;
                    Document doc = Jsoup.parse((String)hist.getValue());
                    pa.addField(PublisherAnnotation.ANNOTATION_POST_OCR_TEXT, (Object)doc.text());
                    pa.addField(PublisherAnnotation.ANNOTATION_POST_OCR_TEXT + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                    pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_POST_OCR_TEXT, (Object)doc.text());
                    pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                    pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                    pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                    continue;
                }
                if (mostRecent == null) {
                    mostRecent = hist;
                    continue;
                }
                int cp = mostRecent.getModifiedTimestamp().compareTo(hist.getModifiedTimestamp());
                if (cp >= 0) continue;
                mostRecent = hist;
            }
            if (mostRecent != null) {
                Document doc = Jsoup.parse((String)mostRecent.getValue());
                pa.addField(PublisherAnnotation.ANNOTATION_USER_CORRECTION_TEXT, (Object)doc.text());
                pa.addField(PublisherAnnotation.ANNOTATION_USER_CORRECTION_TEXT + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_USER_CORRECTION_TEXT, (Object)doc.text());
                pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
            }
        }
    }

    public static void processAnnoHistoryForParentDoc(PublisherAnnotation pa, List<AnnotationHistory> history) {
        if (history != null && pa != null) {
            AnnotationHistory mostRecent = null;
            for (AnnotationHistory hist : history) {
                if (StringUtils.equals((CharSequence)hist.getCreatorType(), (CharSequence)"Software")) {
                    if (StringUtils.equals((CharSequence)hist.getCreatorName(), (CharSequence)"mapKurator:ocr")) {
                        Document doc = Jsoup.parse((String)hist.getValue());
                        pa.addField(PublisherMedia.ANNOTATION_OCR_TEXT, (Object)doc.text());
                        pa.addField(PublisherMedia.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)hist.getCreatorName(), (CharSequence)"mapKurator:post-ocr-correction")) continue;
                    Document doc = Jsoup.parse((String)hist.getValue());
                    pa.addField(PublisherMedia.ANNOTATION_POST_OCR_TEXT, (Object)doc.text());
                    pa.addField(PublisherMedia.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                    continue;
                }
                if (mostRecent == null) {
                    mostRecent = hist;
                    continue;
                }
                int cp = mostRecent.getModifiedTimestamp().compareTo(hist.getModifiedTimestamp());
                if (cp >= 0) continue;
                mostRecent = hist;
            }
            if (mostRecent != null) {
                Document doc = Jsoup.parse((String)mostRecent.getValue());
                pa.addField(PublisherMedia.ANNOTATION_USER_CORRECTION_TEXT, (Object)doc.text());
                pa.addField(PublisherMedia.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
            }
        }
    }

    public static PublisherAnnotation createPublisherAnnotationParentDoc(String mediaId, List<Annotation> annoList) {
        if (annoList != null) {
            PublisherAnnotation pm = new PublisherAnnotation();
            pm.addField("id", (Object)mediaId);
            pm.addField("mediaId", (Object)mediaId);
            pm.addField(PublisherAnnotation.MEDIA_COLLECTION_ID, (Object)InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId));
            return pm;
        }
        return null;
    }

    public static PublisherAnnotation createPublisherAnnotation(Annotation annot) {
        PublisherAnnotation pa = new PublisherAnnotation();
        try {
            String[] coordinates;
            pa.addField(PublisherAnnotation.ANNOTATION_ID, (Object)annot.getId());
            pa.addField(PublisherAnnotation.USER_ID, (Object)annot.getUserId());
            pa.addField(PublisherAnnotation.MEDIA_ID, (Object)annot.getMediaId());
            pa.addField(PublisherAnnotation.MEDIA_COLLECTION_ID, (Object)InsightCoreUtils.getCollectionIdFromLunaMediaId(annot.getMediaId()));
            pa.addField(PublisherAnnotation.MEDIA_GROUP_ID, (Object)annot.getMgid());
            pa.addField("_luna_fct_" + PublisherAnnotation.MEDIA_ID, (Object)annot.getMediaId());
            if (annot.getColor() != null) {
                pa.addField("color", (Object)annot.getColor());
            }
            if (annot.getAnnotationUri() != null) {
                pa.addField(PublisherAnnotation.ANNOTATION_URI, (Object)annot.getAnnotationUri());
            }
            if (annot.getContextUri() != null) {
                pa.addField("context", (Object)annot.getContextUri());
            }
            if (annot.getManifestUri() != null) {
                pa.addField(PublisherAnnotation.MANIFEST_URI, (Object)annot.getManifestUri());
            }
            if (annot.getCanvasUri() != null) {
                pa.addField(PublisherAnnotation.CANVAS_URI, (Object)annot.getCanvasUri());
            }
            if (annot.getCollectionUri() != null) {
                pa.addField(PublisherAnnotation.COLLECTION_URI, (Object)annot.getCollectionUri());
            }
            if (annot.getCoordinates() != null && AnnotationMapper.validateCoordinates(coordinates = StringUtils.split((String)annot.getCoordinates()))) {
                ArrayList<Coordinate> geocoords = new ArrayList<Coordinate>();
                for (int i = 0; i < coordinates.length; ++i) {
                    pa.addField(PublisherAnnotation.GEO_COORD, (Object)StringUtils.trim((String)coordinates[i]));
                    String[] latLng = StringUtils.split((String)coordinates[i], (char)',');
                    geocoords.add(new Coordinate(Double.parseDouble(latLng[0]), Double.parseDouble(latLng[1])));
                }
                Coordinate center = PolygonUtils.calculateCentroid(geocoords);
                pa.addField(PublisherAnnotation.CENTROID, (Object)(center.x + "," + center.y));
            }
            if (annot.getImageCoordinates() != null) {
                coordinates = StringUtils.split((String)annot.getImageCoordinates(), (char)',');
                for (int i = 0; i < coordinates.length; ++i) {
                    pa.addField(PublisherAnnotation.IMG_COORD, (Object)StringUtils.trim((String)coordinates[i]));
                }
            }
            if (annot.getHistory() == null) {
                Document doc;
                if (annot.getAnnotation() != null) {
                    doc = Jsoup.parse((String)annot.getAnnotation());
                    pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                    pa.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                    pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_SEARCH_FIELD, (Object)doc.text());
                }
                if (annot.getOcrText() != null) {
                    doc = Jsoup.parse((String)annot.getOcrText());
                    pa.addField(PublisherAnnotation.ANNOTATION_OCR_TEXT, (Object)doc.text());
                    pa.addField(PublisherAnnotation.ANNOTATION_OCR_TEXT + PublisherAnnotation._LOWERCASE, (Object)doc.text());
                    pa.addField("_luna_fct_" + PublisherAnnotation.ANNOTATION_OCR_TEXT, (Object)doc.text());
                }
            } else {
                AnnotationMapper.processAnnoHistory(pa, annot.getHistory());
            }
            if (annot.getSource() != null) {
                pa.addField(PublisherAnnotation.SOURCE, (Object)annot.getSource());
            }
            if (annot.getScore() > 0.0) {
                pa.addField(PublisherAnnotation.SCORE, (Object)annot.getScore());
            }
            if (annot.getModifiedTimestamp() != null) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    df.setTimeZone(TimeZone.getTimeZone("Zulu"));
                    SimpleDate sDate = new SimpleDate(annot.getModifiedTimestamp());
                    String dateValue = df.format(sDate.getDate());
                    pa.addField(PublisherAnnotation.MODIFIEDTIMESTAMP, (Object)dateValue);
                }
                catch (Exception e) {
                    logger.error((Object)"Could not parse date", (Throwable)e);
                }
            }
            if (annot.getxPos() > 0) {
                pa.addField(PublisherAnnotation.XPOS, (Object)annot.getxPos());
            }
            if (annot.getyPos() > 0) {
                pa.addField(PublisherAnnotation.YPOS, (Object)annot.getyPos());
            }
            if (annot.getImgHeight() > 0) {
                pa.addField(PublisherAnnotation.IMGHEIGHT, (Object)annot.getImgHeight());
            }
            if (annot.getImgWidth() > 0) {
                pa.addField(PublisherAnnotation.IMGWIDTH, (Object)annot.getImgWidth());
            }
            if (annot.getfHeight() > 0) {
                pa.addField(PublisherAnnotation.FHEIGHT, (Object)annot.getfHeight());
            }
            if (annot.getfWidth() > 0) {
                pa.addField(PublisherAnnotation.FWIDTH, (Object)annot.getfWidth());
            }
        }
        catch (Exception e) {
            logger.error((Object)"conversion manifest to publisher annotation failed", (Throwable)e);
        }
        return pa;
    }

    public static Annotation webAnnoToAnnotation(JSONObject json, String iiifBaseUrl, LunaMedia media, String manifestUri, String canvasUri) {
        return AnnotationMapper.webAnnoToAnnotation(json, iiifBaseUrl, media, manifestUri, canvasUri, null, true);
    }

    public static Annotation webAnnoToAnnotation(JSONObject json, String iiifBaseUrl, LunaMedia media, String manifestUri, String canvasUri, User user, boolean escapeSvgDoubleQuotes) {
        json = JSONObject.fromObject((Object)json.toString());
        Annotation annot = new Annotation();
        String value = null;
        annot.setMediaId((String)media.getIdentity());
        annot.setImgHeight(media.getMaxHeight());
        annot.setImgWidth(media.getMaxWidth());
        annot.setManifestUri(manifestUri);
        annot.setCanvasUri(canvasUri);
        if (json.containsKey((Object)"@context")) {
            annot.setContextUri(json.getString("@context"));
        }
        if (json.containsKey((Object)"id")) {
            if (StringUtils.startsWith((CharSequence)json.getString("id"), (CharSequence)"http")) {
                String annotationUri = (String)json.get("id");
                int id = Integer.parseInt(annotationUri.substring(annotationUri.lastIndexOf(47) + 1));
                annot.setId(id);
                annot.setAnnotationUri(annotationUri);
            }
        } else if (iiifBaseUrl != null && annot.getMediaId() != null && annot.getId() > 0) {
            annot.setAnnotationUri(iiifBaseUrl + annot.getMediaId() + "/annotation/" + annot.getId());
        }
        try {
            String imgCoord;
            JSONObject target = json.getJSONObject("target");
            if (target.containsKey((Object)"source")) {
                String source = target.getString("source");
                annot.setSource(source);
            }
            JSONObject jsonSelector = target.getJSONObject("selector");
            value = jsonSelector.getString("value");
            if (escapeSvgDoubleQuotes) {
                jsonSelector.put((Object)"value", (Object)AnnotationMapper.fixEscapeChar(value));
            }
            annot.setSelector(jsonSelector.toString());
            String selectorType = (String)jsonSelector.get("type");
            if (selectorType.equals("FragmentSelector")) {
                if (StringUtils.contains((CharSequence)(value = value.substring(value.indexOf(61) + 1)), (CharSequence)":")) {
                    value = value.substring(value.indexOf(58) + 1);
                }
                String[] split = StringUtils.split((String)value, (char)',');
                annot.setxPos((int)Double.parseDouble(split[0]));
                annot.setyPos((int)Double.parseDouble(split[1]));
                annot.setfWidth((int)Double.parseDouble(split[2]));
                annot.setfHeight((int)Double.parseDouble(split[3]));
                imgCoord = AnnotationMapper.getImgCoordString((int)Double.parseDouble(split[0]), (int)Double.parseDouble(split[1]), (int)Double.parseDouble(split[2]), (int)Double.parseDouble(split[3]));
                if (imgCoord != null) {
                    annot.setImageCoordinates(imgCoord);
                }
            } else if (selectorType.equals("SvgSelector")) {
                if (!StringUtils.startsWith((CharSequence)value, (CharSequence)"<svg>") && !StringUtils.endsWith((CharSequence)value, (CharSequence)"</svg>")) {
                    value = "<svg>" + value + "</svg>";
                }
                if (AnnotationMapper.isSvgPolygon(value)) {
                    Polygon plyg = AnnotationMapper.getPolygonFromSvg(value);
                    annot.setxPos(plyg.getBounds().x);
                    annot.setyPos(plyg.getBounds().y);
                    annot.setfWidth(plyg.getBounds().width);
                    annot.setfHeight(plyg.getBounds().height);
                    imgCoord = AnnotationMapper.getImgCoordStringFromSvg(value);
                    if (imgCoord != null) {
                        annot.setImageCoordinates(imgCoord);
                    }
                } else {
                    logger.error((Object)("Not a polygon: " + value));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String chars = "";
        if (json.has("body")) {
            Object obj = json.get("body");
            if (obj instanceof JSONArray) {
                JSONArray arr = (JSONArray)obj;
                for (int i = 0; i < arr.size(); ++i) {
                    JSONObject body = ((JSONArray)obj).getJSONObject(i);
                    AnnotationHistory hist = new AnnotationHistory();
                    if (body.containsKey((Object)"creator")) {
                        JSONObject creator = body.getJSONObject("creator");
                        if (creator.containsKey((Object)"id")) {
                            hist.setUserId(creator.getInt("id"));
                            hist.setCreatorType("Person");
                        }
                        if (creator.containsKey((Object)"type")) {
                            hist.setCreatorType(creator.getString("type"));
                        }
                        if (creator.containsKey((Object)"name")) {
                            hist.setCreatorName(creator.getString("name"));
                        }
                    }
                    if (body.containsKey((Object)"purpose")) {
                        hist.setPurpose(body.getString("purpose"));
                    } else {
                        hist.setPurpose("transcribing");
                    }
                    if (body.containsKey((Object)"created")) {
                        String created = body.getString("created");
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        format.setTimeZone(TimeZone.getTimeZone("Zulu"));
                        Date date = null;
                        try {
                            date = format.parse(created);
                        }
                        catch (ParseException e) {
                            logger.error((Object)("Could not parse: " + created + " will try to parse with milliseconds."));
                            try {
                                format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                                date = format.parse(created);
                            }
                            catch (ParseException e1) {
                                logger.error((Object)("Could not parse: " + created + "."));
                            }
                        }
                        hist.setModifiedTimestamp(new SimpleDate(date).get());
                    }
                    hist.setValue(body.getString("value"));
                    annot.addHistory(hist);
                }
                AnnotationHistory latest = annot.getLatestChange();
                if (latest != null) {
                    chars = latest.getValue();
                    annot.setAnnotation(chars);
                    annot.setModifiedTimestamp(latest.getModifiedTimestamp());
                }
            } else {
                chars = ((JSONObject)obj).getString("value");
            }
        }
        annot.setAnnotation(chars);
        return annot;
    }

    public static boolean isSvgPolygon(String svgStr) {
        if (StringUtils.contains((CharSequence)(svgStr = RegExUtils.replaceFirst((String)svgStr, (String)"<svg[ ]+>", (String)"<svg>")), (CharSequence)"<svg>")) {
            svgStr = StringUtils.replace((String)svgStr, (String)"<svg>", (String)"<svg xmlns=\"http://www.w3.org/2000/svg\">");
        }
        StringReader reader = new StringReader(svgStr);
        String uri = "file:make-something-up";
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        try {
            SVGDocument doc = f.createSVGDocument(uri, (Reader)reader);
            NodeList polygons = doc.getElementsByTagName("polygon");
            return polygons != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Polygon getPolygonFromSvg(String svgStr) {
        if (StringUtils.contains((CharSequence)(svgStr = RegExUtils.replaceFirst((String)svgStr, (String)"<svg[ ]+>", (String)"<svg>")), (CharSequence)"<svg>")) {
            svgStr = StringUtils.replace((String)svgStr, (String)"<svg>", (String)"<svg xmlns=\"http://www.w3.org/2000/svg\">");
        }
        StringReader reader = new StringReader(svgStr);
        String uri = "file:make-something-up";
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        try {
            SVGDocument doc = f.createSVGDocument(uri, (Reader)reader);
            NodeList polygons = doc.getElementsByTagName("polygon");
            if (polygons != null) {
                Polygon plygn = new Polygon();
                for (int j = 0; j < polygons.getLength(); ++j) {
                    SVGOMPolygonElement plyElem = (SVGOMPolygonElement)polygons.item(j);
                    SVGPointList pointList = plyElem.getPoints();
                    for (int k = 0; k < pointList.getNumberOfItems(); ++k) {
                        SVGPoint pt = pointList.getItem(k);
                        plygn.addPoint((int)pt.getX(), (int)pt.getY());
                    }
                }
                return plygn;
            }
        }
        catch (IOException e) {
            System.out.println(svgStr);
            e.printStackTrace();
        }
        return null;
    }

    public static boolean validateCoordinates(String[] coordinates) {
        if (coordinates == null || coordinates.length == 0) {
            return false;
        }
        for (String c : coordinates) {
            try {
                ParseUtils.parseLatitudeLongitude((String)c);
            }
            catch (InvalidShapeException e) {
                logger.error((Object)("Invalid LatLng:" + c));
                return false;
            }
        }
        return true;
    }

    private static String getImgCoordString(int x, int y, int width, int height) {
        String imgCoordStr = "";
        if (x > 0 && y > 0 && width > 0 && height > 0) {
            imgCoordStr = imgCoordStr + x + " " + y;
            imgCoordStr = imgCoordStr + "," + (x + width) + " " + y;
            imgCoordStr = imgCoordStr + "," + (x + width) + " " + (y + height);
            imgCoordStr = imgCoordStr + "," + x + " " + (y + height);
            imgCoordStr = imgCoordStr + "," + x + " " + y;
        }
        return imgCoordStr;
    }

    private static String getImgCoordStringFromSvg(String svgStr) {
        String imgCoordStr = "";
        if (StringUtils.contains((CharSequence)(svgStr = RegExUtils.replaceFirst((String)svgStr, (String)"<svg[ ]+>", (String)"<svg>")), (CharSequence)"<svg>")) {
            svgStr = StringUtils.replace((String)svgStr, (String)"<svg>", (String)"<svg xmlns=\"http://www.w3.org/2000/svg\">");
        }
        StringReader reader = new StringReader(svgStr);
        String uri = "file:make-something-up";
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        try {
            SVGDocument doc = f.createSVGDocument(uri, (Reader)reader);
            NodeList polygons = doc.getElementsByTagName("polygon");
            if (polygons != null) {
                for (int j = 0; j < polygons.getLength(); ++j) {
                    SVGOMPolygonElement plyElem = (SVGOMPolygonElement)polygons.item(j);
                    SVGPointList pointList = plyElem.getPoints();
                    String initialPoint = "";
                    for (int k = 0; k < pointList.getNumberOfItems(); ++k) {
                        SVGPoint pt = pointList.getItem(k);
                        imgCoordStr = imgCoordStr + (StringUtils.isNotBlank((CharSequence)imgCoordStr) ? "," : "") + (int)pt.getX() + " " + (int)pt.getY();
                        if (k != 0) continue;
                        initialPoint = (int)pt.getX() + " " + (int)pt.getY();
                    }
                    imgCoordStr = imgCoordStr + (StringUtils.isNotBlank((CharSequence)imgCoordStr) ? "," : "") + initialPoint;
                }
                return imgCoordStr;
            }
        }
        catch (IOException e) {
            System.out.println(svgStr);
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        String payloadRequest = "{  \"@context\": \"http://iiif.io/api/presentation/2/context.json\",  \"@type\": \"oa:Annotation\",  \"motivation\": [    \"oa:commenting\"  ],  \"resource\": [    {      \"@type\": \"dctypes:Text\",      \"format\": \"text/html\",      \"chars\": \"<p>haha</p>\"    }  ],  \"on\": [    {      \"@type\": \"oa:SpecificResource\",      \"full\": \"https://lunatest.lunaimaging.com/luna/servlet/iiif/m/luna715~18~18~2~100012703/canvas/c1\",      \"selector\": {        \"@type\": \"oa:Choice\",        \"default\": {          \"@type\": \"oa:FragmentSelector\",          \"value\": \"xywh=77,43,135,152\"        },        \"item\": {          \"@type\": \"oa:SvgSelector\",          \"value\": \"<svg xmlns='http://www.w3.org/2000/svg'><path xmlns=\\\"http://www.w3.org/2000/svg\\\" d=\\\"M119.87618,89.17465c-1.8497,0 -4.88934,-1.78394 -8.49788,-1.06224c-8.70005,1.74001 -16.2314,12.53513 -20.18247,19.12023c-2.87883,4.79805 -9.35307,10.22177 -10.62235,15.93353c-3.57925,16.10664 -6.38253,30.69499 3.18671,44.61388c10.18975,14.82145 32.90499,17.48992 48.86282,21.24471c9.18981,2.16231 16.79314,5.05426 26.55588,5.31118c2.58216,0.06795 35.59797,2.6425 41.42717,-3.18671c5.17667,-5.17667 6.03378,-17.88938 7.43565,-24.43141c2.72619,-12.7222 5.40101,-28.14132 3.18671,-41.42717c-1.08042,-6.48255 -6.96881,-12.42884 -10.62235,-16.99576c-9.9668,-12.45851 -19.71356,-24.26873 -31.86706,-33.99153c-16.99372,-13.59498 -19.59882,-30.80482 -43.55165,-30.80482c-1.00138,0 -5.24052,-0.56644 -6.37341,0c-4.78419,2.3921 -4.55291,7.2853 -6.37341,12.74682c-8.02827,24.0848 13.0369,34.35413 25.49365,49.92506c4.35479,5.44349 8.71059,11.61412 12.74682,16.99576c1.91936,2.55915 14.13482,18.79448 8.49788,24.43141c-2.96449,2.96449 -12.97493,1.84643 -16.99576,3.18671c-1.85712,0.61904 -8.52219,6.3491 -10.62235,4.24894c-2.14207,-2.14207 -14.32602,-22.85222 -10.62235,-26.55588c3.26126,-3.26126 15.33412,-1.06224 20.18247,-1.06224\\\" data-paper-data=\\\"{&quot;strokeWidth&quot;:1,&quot;deleteIcon&quot;:null,&quot;editable&quot;:true,&quot;annotation&quot;:null}\\\" id=\\\"smooth_path_bd26ec95-9188-4b2f-8700-0c6af1d5bd99\\\" fill=\\\"none\\\" fill-rule=\\\"nonzero\\\" stroke=\\\"#00bfff\\\" stroke-width=\\\"1\\\" stroke-linecap=\\\"butt\\\" stroke-linejoin=\\\"miter\\\" stroke-miterlimit=\\\"10\\\" stroke-dasharray=\\\"\\\" stroke-dashoffset=\\\"0\\\" font-family=\\\"none\\\" font-weight=\\\"none\\\" font-size=\\\"none\\\" text-anchor=\\\"none\\\" style=\\\"mix-blend-mode: normal\\\"/></svg>\"        }      },      \"within\": {        \"@id\": \"https://lunatest.lunaimaging.com/luna/servlet/iiif/m/luna715~18~18~2~100012703/manifest\",        \"@type\": \"sc:Manifest\"      }    }  ]}";
        JSONObject jsonObj = JSONObject.fromObject((Object)payloadRequest);
        Object o = jsonObj.get("motivation");
        if (o instanceof JSONArray && ((JSONArray)o).size() == 1) {
            Object motObj = ((JSONArray)o).get(0);
            jsonObj.put((Object)"motivation", motObj);
        }
        String iiifBaseUrl = "http://dwong.lunaimaging.com/luna/servlet/iiif";
    }

    public static String fixSvgQuotes(String str) {
        String[] found = StringUtils.substringsBetween((String)str, (String)"<svg ", (String)"</svg>");
        if (found == null) {
            found = StringUtils.substringsBetween((String)str, (String)"<svg>", (String)"</svg>");
        }
        if (found == null || found.length == 0) {
            return str;
        }
        for (int i = 0; i < found.length; ++i) {
            String temp = found[i].replace("\"", "'");
            str = StringUtils.replace((String)str, (String)found[i], (String)temp);
        }
        return str;
    }

    public static String fixQuotes(String str) {
        return str.replace("\"", "'");
    }

    public static String fixEscapeChar(String str) {
        return str.replace("\"", "\\\"");
    }
}

