/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.search.facet;

import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.search.facet.Facet;
import com.lunaimaging.insight.core.search.facet.FacetComparator;
import com.lunaimaging.insight.core.search.facet.Facets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class W4Facets
extends Facets {
    protected List<Facet> who = new ArrayList<Facet>();
    protected List<Facet> what = new ArrayList<Facet>();
    protected List<Facet> where = new ArrayList<Facet>();
    protected List<Facet> when = new ArrayList<Facet>();

    @Override
    public void addAll(List<Facet> facets) {
        if (!CollectionUtils.isEmpty(facets)) {
            for (Facet facet : facets) {
                this.add(facet);
            }
        }
    }

    @Override
    public void add(Facet facet) {
        super.add(facet);
        if (facet != null) {
            switch (facet.type) {
                case WHO: {
                    this.who.add(facet);
                    break;
                }
                case WHAT: {
                    this.what.add(facet);
                    break;
                }
                case WHERE: {
                    this.where.add(facet);
                    break;
                }
                case WHEN: {
                    this.when.add(facet);
                }
            }
        }
    }

    public List<Facet> getWhat() {
        return this.what;
    }

    public List<Facet> getWhen() {
        return this.when;
    }

    public List<Facet> getWhere() {
        return this.where;
    }

    public List<Facet> getWho() {
        return this.who;
    }

    public void sort(FacetComparator.Sort sort, FacetComparator.SortOrder order, MediaField.W4Type type) {
        this.comparator.setSort(sort);
        this.comparator.setSortOrder(order);
        switch (type) {
            case WHO: {
                Collections.sort(this.who, this.comparator);
                break;
            }
            case WHAT: {
                Collections.sort(this.what, this.comparator);
                break;
            }
            case WHERE: {
                Collections.sort(this.where, this.comparator);
                break;
            }
            case WHEN: {
                Collections.sort(this.when, this.comparator);
            }
        }
    }

    @Override
    public void sort(FacetComparator.Sort sort, FacetComparator.SortOrder order) {
        this.comparator.setSort(sort);
        this.comparator.setSortOrder(order);
        Collections.sort(this.who, this.comparator);
        Collections.sort(this.what, this.comparator);
        Collections.sort(this.where, this.comparator);
        Collections.sort(this.when, this.comparator);
    }
}

