/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.search.facet;

import com.lunaimaging.insight.core.search.facet.Facet;
import com.lunaimaging.insight.core.search.facet.FacetComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class Facets {
    protected final FacetComparator comparator = new FacetComparator();
    protected List<Facet> facets = new ArrayList<Facet>();

    public void add(Facet facet) {
        if (facet != null) {
            this.facets.add(facet);
        }
    }

    public void addAll(List<Facet> facets) {
        if (!CollectionUtils.isEmpty(facets)) {
            this.facets.addAll(facets);
        }
    }

    public boolean isEmpty() {
        return this.facets.isEmpty();
    }

    public void sort(FacetComparator.Sort sort, FacetComparator.SortOrder order) {
        this.comparator.setSort(sort);
        this.comparator.setSortOrder(order);
        Collections.sort(this.facets, this.comparator);
    }

    public void sort(FacetComparator.Sort sort) {
        this.sort(sort, FacetComparator.DEFAULT_SORT_ORDER);
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public int size() {
        return this.facets.size();
    }

    public int getSize() {
        return this.size();
    }
}

