/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.search.facet;

import com.lunaimaging.insight.core.search.facet.Facet;
import java.util.Comparator;

public class FacetComparator
implements Comparator {
    public static final Sort DEFAULT_SORT = Sort.BY_COUNT;
    public static final SortOrder DEFAULT_SORT_ORDER = SortOrder.ASC;
    protected Sort sort;
    protected SortOrder sortOrder;

    public FacetComparator(Sort sort, SortOrder sortOrder) {
        this.setSort(sort);
        this.setSortOrder(sortOrder);
    }

    public FacetComparator(Sort sort) {
        this(sort, DEFAULT_SORT_ORDER);
    }

    public FacetComparator() {
        this(DEFAULT_SORT);
    }

    public int compare(Object o1, Object o2) {
        int toReturn = 0;
        if (o1 instanceof Facet && o2 instanceof Facet) {
            Facet f1 = (Facet)o1;
            Facet f2 = (Facet)o2;
            if (this.sort == Sort.BY_COUNT) {
                toReturn = f1.getCount() > f2.getCount() ? 1 : (f1.getCount() < f2.getCount() ? -1 : 0);
            } else if (this.sort == Sort.BY_VALUE) {
                toReturn = f1.getValue().compareToIgnoreCase(f2.getValue());
            }
        }
        if (this.sortOrder == SortOrder.DESC) {
            toReturn *= -1;
        }
        return toReturn;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }

    public static enum Sort {
        BY_COUNT,
        BY_VALUE;

    }
}

