/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.lucene;

import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;

public class LuceneDocumentFactory {
    private static final Log log = LogFactory.getLog(LuceneDocumentFactory.class);
    public static final String SIMPLE_SEARCH_FIELD = "simpleSearchField";
    public static final String FULL_TEXT_SEARCH_FIELD = "fullTextSearchField";
    public static final String DEFAULT_DATE_FIELD = "defaultDateField";
    public static final String ANCILLARY_INDEX_FIELD = "ancillaryIndexField";
    public static final String LUNA_RESERVED_INDEX_FIELD_PREFIX = "_luna_";
    public static final String MEDIA_PREFIX = "_luna_media_";
    public static final String MEDIA_ID = "_luna_media_id";
    public static final String MEDIA_RESOLUTION = "_luna_media_resolution_";
    public static final String MEDIA_FORMAT = "_luna_media_format_";
    public static final String MEDIA_TYPE = "_luna_media_type_";
    public static final String MEDIA_WIDTH = "_luna_media_width_";
    public static final String MEDIA_HEIGHT = "_luna_media_height_";
    public static final String DATE_SUFFIX = "_dt";
    public static final String GEO_COORDINATES_SUFFIX = "_geo";
    public static final String LUNA_COLLECTION_NAME = "_luna_collection";
    public static final String LUNA_DISPLAY_FIELD_PREFIX = "_luna_display_";
    public static final String LUNA_DISPLAY_ORDER_PREFIX = "_luna_display_order_";
    public static final String LUNA_MEDIA_RESTRICTION_FIELD = "_luna_media_restricted_to";
    public static final String LUNA_RECORD_RESTRICTION_FIELD = "_luna_record_restricted_to";
    public static final String LUNA_COLLECTION_OWNER_FIELD = "_luna_collection_owner";
    protected static final String SIMPLE_TOKEN_PLACEMENT = " ";
    protected List<MediaField> storableFields;
    protected Collection<String> simpleSearchTokens;
    protected List<String> facetValueDelimiter;

    public LuceneDocumentFactory(List<MediaField> storableFields, List<String> delimiter) {
        this.storableFields = new ArrayList<MediaField>();
        this.setStorableFields(storableFields);
        this.facetValueDelimiter = delimiter;
    }

    public LuceneDocumentFactory(List<String> delimiter) {
        this(null, delimiter);
    }

    public LuceneDocumentFactory() throws Exception {
        throw new Exception("NO Delimiter!!!!");
    }

    public Collection<String> getSimpleSearchTokens() {
        return this.simpleSearchTokens;
    }

    public void setSimpleSearchTokens(Collection<String> simpleSearchTokens) {
        this.simpleSearchTokens = simpleSearchTokens;
    }

    public void setStorableFields(List<MediaField> mediaFields) {
        if (mediaFields != null) {
            this.storableFields.addAll(mediaFields);
        }
    }

    public Document constrcutMediaDocument(LunaMedia media, PublisherMedia publisherMedia) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Document doc = null;
        if (media != null && media.getCollection() != null) {
            BeanMap bean = new BeanMap((Object)media);
            for (LuceneAttribute la : LuceneAttribute.values()) {
                if (bean.get((Object)la.getAttributeName()) == null) continue;
                data.put(la.getAttributeName(), bean.get((Object)la.getAttributeName()));
                publisherMedia.addField(la.getAttributeName(), bean.get((Object)la.getAttributeName()));
            }
            if (media.getFieldValues() != null) {
                ArrayList<Object> simpleSearchValues = new ArrayList<Object>();
                for (MediaFieldValue mfv : media.getFieldValues()) {
                    if (mfv == null || mfv.getField() == null || mfv.getField().getFieldName() == null || mfv.getValue() == null) continue;
                    String name = mfv.getField().getFieldName();
                    if (mfv.getField().isSearchable()) {
                        simpleSearchValues.add(mfv.getValue());
                    }
                    data.put(name, mfv.getValue());
                    if (!(name == null || "mediaId".equalsIgnoreCase(name) || SIMPLE_SEARCH_FIELD.equalsIgnoreCase(name) || name.endsWith("_sortable"))) {
                        List<Object> valueList = mfv.getValueList();
                        for (Object v : valueList) {
                            publisherMedia.addField(name, v);
                        }
                    }
                    if (mfv.getValue() == null || mfv.getValue().toString().indexOf(" of ") <= -1) continue;
                    log.debug((Object)("constrcutMediaDocument(..): fieldname = " + name + ", value = " + mfv.getValue()));
                }
                if (!simpleSearchValues.isEmpty()) {
                    publisherMedia.addField(SIMPLE_SEARCH_FIELD, simpleSearchValues);
                }
            }
            doc = this.constrcutMediaDocument(data, media.getCollection().getMediaFields(), publisherMedia);
        }
        return doc;
    }

    protected String[] parseFieldValues(String fieldValue) {
        String[] fieldValues = null;
        if (CollectionUtils.isNotEmpty(this.facetValueDelimiter) && StringUtils.isNotEmpty((String)fieldValue)) {
            fieldValues = ParsingUtils.splitIgnoreCaseTrim(fieldValue, this.facetValueDelimiter);
        }
        return fieldValues;
    }

    public Document constrcutMediaDocument(Map<String, Object> rawData, List<MediaField> allMediaFields, PublisherMedia pm) {
        Document doc = new Document();
        MediaField mf = null;
        String fieldName = null;
        String fieldValue = null;
        StringBuilder simpleSearchValue = new StringBuilder();
        W4FieldValues w4FieldValues = new W4FieldValues();
        for (LuceneAttribute la : LuceneAttribute.values()) {
            fieldName = la.getAttributeName();
            fieldValue = this.properStringValue(rawData.get(fieldName));
            if (fieldValue != null) {
                mf = this.properField(fieldName, allMediaFields);
                w4FieldValues.append(mf, fieldValue);
                if ("id".equals(fieldName)) {
                    doc.add((IndexableField)new Field(fieldName + "_sortable", fieldValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
                }
                doc.add((IndexableField)new Field(la.getAttributeName(), fieldValue, Field.Store.YES, Field.Index.ANALYZED));
                this.appendToReservedFieldValue(simpleSearchValue, fieldValue);
                rawData.remove(fieldName);
                continue;
            }
            if (!la.isRequired()) continue;
            log.error((Object)("PublisherMedia missing required value for: [" + fieldName + "] in " + rawData));
            doc = null;
            break;
        }
        if (doc != null && rawData != null) {
            Set<String> keys = rawData.keySet();
            for (String key : keys) {
                fieldValue = this.properStringValue(rawData.get(key));
                mf = this.properField(key, allMediaFields);
                w4FieldValues.append(mf, fieldValue);
                if (mf != null) {
                    fieldName = mf.getFieldName();
                }
                if (!StringUtils.isNotEmpty((String)fieldName) || !StringUtils.isNotEmpty((String)fieldValue)) continue;
                if (!FULL_TEXT_SEARCH_FIELD.equals(fieldName)) {
                    if (mf != null && mf.isSearchable()) {
                        this.appendToReservedFieldValue(simpleSearchValue, fieldValue);
                        doc.add((IndexableField)new Field(this.getProperMediaFieldName(fieldName) + "_wildcard", fieldValue, Field.Store.NO, Field.Index.ANALYZED));
                    }
                    if (!fieldName.startsWith(LUNA_RESERVED_INDEX_FIELD_PREFIX)) {
                        doc.add((IndexableField)new Field(this.getProperMediaFieldName(fieldName) + "_sortable", fieldValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    }
                    doc.add((IndexableField)new Field(this.getProperMediaFieldName(fieldName), fieldValue, Field.Store.YES, Field.Index.ANALYZED));
                    continue;
                }
                doc.add((IndexableField)new Field(this.getProperMediaFieldName(fieldName), fieldValue, Field.Store.NO, Field.Index.ANALYZED));
            }
            w4FieldValues.add(doc);
            w4FieldValues.addTo(pm);
            doc.add((IndexableField)new Field(SIMPLE_SEARCH_FIELD, simpleSearchValue.toString(), Field.Store.NO, Field.Index.ANALYZED));
        }
        return doc;
    }

    protected MediaField properField(String key, List<MediaField> allMediaFields) {
        MediaField toReturn = null;
        if (key != null) {
            for (MediaField mf : allMediaFields) {
                if (!StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)key)) continue;
                toReturn = mf;
                break;
            }
        }
        return toReturn;
    }

    public Term constrcutMediaTerm(Media media) {
        Term term = new Term(LuceneAttribute.id.getAttributeName() + "_sortable", this.properStringValue(media.getIdentity()));
        return term;
    }

    protected void appendToReservedFieldValue(StringBuilder reservedFieldValue, String value) {
        if (value != null) {
            if (ParsingUtils.containsAny(this.simpleSearchTokens, value)) {
                reservedFieldValue.append(ParsingUtils.replaceWith(value, this.simpleSearchTokens, SIMPLE_TOKEN_PLACEMENT)).append(SIMPLE_TOKEN_PLACEMENT);
            }
            reservedFieldValue.append(value).append(SIMPLE_TOKEN_PLACEMENT);
        }
    }

    protected String properStringValue(Object value) {
        String toReturn = null;
        if (value instanceof Date) {
            toReturn = DateTools.dateToString((Date)((Date)value), (DateTools.Resolution)DateTools.Resolution.YEAR);
        } else if (value != null) {
            toReturn = value instanceof Clob ? this.getStringValue((Clob)value) : String.valueOf(value);
        }
        return toReturn;
    }

    protected boolean isStorableField(String key) {
        if (key != null && this.storableFields != null) {
            for (MediaField mf : this.storableFields) {
                if (mf == null || !StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)key)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getProperMediaFieldName(String fieldName) {
        String toReturn = fieldName;
        if (fieldName != null && this.storableFields != null) {
            for (MediaField mf : this.storableFields) {
                if (mf == null || !StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName)) continue;
                toReturn = mf.getFieldName();
                break;
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringValue(Clob clob) {
        StringBuilder toReturn = new StringBuilder();
        BufferedReader reader = null;
        try {
            char[] charbuffer = new char[65536];
            reader = new BufferedReader(clob.getCharacterStream());
            int read = 0;
            read = reader.read(charbuffer, 0, 65536);
            while (read != -1) {
                toReturn.append(charbuffer, 0, read);
                read = reader.read(charbuffer, 0, 65536);
            }
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return toReturn.toString();
    }

    public class W4FieldValues {
        Map<String, List<String>> w4FieldValueMap = new HashMap<String, List<String>>();

        W4FieldValues() {
            this.w4FieldValueMap.put(MediaField.W4Type.WHAT.toString(), new ArrayList());
            this.w4FieldValueMap.put(MediaField.W4Type.WHEN.toString(), new ArrayList());
            this.w4FieldValueMap.put(MediaField.W4Type.WHERE.toString(), new ArrayList());
            this.w4FieldValueMap.put(MediaField.W4Type.WHO.toString(), new ArrayList());
        }

        boolean isW4Field(MediaField mf) {
            boolean b = false;
            if (mf != null && mf.getType() != null) {
                b = true;
            }
            return b;
        }

        void append(MediaField mf, String value) {
            if (this.isW4Field(mf)) {
                this.append(mf.getW4Type(), value);
            }
        }

        void append(String w4Type, String value) {
            List<String> fieldValues = this.w4FieldValueMap.get(w4Type);
            if (fieldValues == null) {
                String m = "ERROR: Check W4 type";
                log.error((Object)m);
                throw new RuntimeException(m);
            }
            fieldValues.add(value);
        }

        void add(Document doc) {
            for (String k : this.w4FieldValueMap.keySet()) {
                List<String> fieldValues = this.w4FieldValueMap.get(k);
                if (fieldValues == null || fieldValues.size() <= 0) continue;
                for (String fieldValue : fieldValues) {
                    String[] fieldValuesParsed = LuceneDocumentFactory.this.parseFieldValues(fieldValue);
                    if (fieldValuesParsed == null || fieldValuesParsed.length == 0) continue;
                    for (String s : fieldValuesParsed) {
                        if (s == null || s.length() <= 0) continue;
                        doc.add((IndexableField)new Field(LuceneDocumentFactory.LUNA_RESERVED_INDEX_FIELD_PREFIX + k.toLowerCase(), s, Field.Store.NO, Field.Index.ANALYZED));
                    }
                }
            }
        }

        void addTo(PublisherMedia pm) {
            for (String k : this.w4FieldValueMap.keySet()) {
                List<String> fieldValues = this.w4FieldValueMap.get(k);
                if (fieldValues == null || fieldValues.size() <= 0) continue;
                for (String fieldValue : fieldValues) {
                    String[] fieldValuesParsed = LuceneDocumentFactory.this.parseFieldValues(fieldValue);
                    if (fieldValuesParsed == null || fieldValuesParsed.length == 0) continue;
                    for (String s : fieldValuesParsed) {
                        if (s == null || s.length() <= 0) continue;
                        pm.addField(LuceneDocumentFactory.LUNA_RESERVED_INDEX_FIELD_PREFIX + k.toLowerCase(), (Object)s);
                    }
                }
            }
        }
    }

    public static enum LuceneAttribute {
        id("id", true),
        uniqueCollectionID("uniqueCollectionId", true),
        objectID("objectId", true),
        mediaId("mediaId", true),
        source("source", true),
        institutionId("institutionId", true),
        urlSize0("urlSize0", true),
        urlSize1("urlSize1", true),
        urlSize2("urlSize2", true),
        urlSize3("urlSize3", false),
        urlSize4("urlSize4", false),
        urlSize5("urlSize5", false),
        urlSize6("urlSize6", false),
        urlSize7("urlSize7", false),
        urlSize8("urlSize8", false),
        urlSource("urlSource", false),
        mediaCollectionId("mediaCollectionId", true),
        mediaType("mediaType", true),
        displayTitle("displayTitle", false),
        canonicalServerAddress("canonicalServerAddress", false),
        referenceMediaId("referenceMediaId", false),
        refUrlSize0("refUrlSize0", false),
        refUrlSize1("refUrlSize1", false),
        refUrlSize2("refUrlSize2", false),
        refUrlSize3("refUrlSize3", false),
        refUrlSize4("refUrlSize4", false),
        uri("uri", false);

        protected String attributeName;
        protected boolean required;

        private LuceneAttribute() {
        }

        private LuceneAttribute(String attributeName, boolean required) {
            this.attributeName = attributeName;
            this.required = required;
        }

        public String getAttributeName() {
            if (StringUtils.isEmpty((String)this.attributeName)) {
                return this.toString();
            }
            return this.attributeName;
        }

        public boolean isRequired() {
            return this.required;
        }

        public static boolean isLuceneAttribute(String s) {
            for (LuceneAttribute la : LuceneAttribute.values()) {
                if (!StringUtils.equalsIgnoreCase((String)s, (String)la.getAttributeName())) continue;
                return true;
            }
            return false;
        }

        public static LuceneAttribute findLuceneAttribute(String s) {
            for (LuceneAttribute la : LuceneAttribute.values()) {
                if (!StringUtils.equalsIgnoreCase((String)s, (String)la.getAttributeName())) continue;
                return la;
            }
            return null;
        }
    }
}

