/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.client.solrj.SolrServer;

public class LuceneConnectorFactory {
    protected static Log log = LogFactory.getLog(LuceneConnectorFactory.class);
    protected String indexPhysicalDirectory;
    protected String publicIndexPhysicalDirectory;
    protected String facetCacheDirectory;
    protected IndexReader reader;
    protected int connectorPoolSize = 1;
    protected SolrServer solrServer = null;

    public void setIndexPhysicalDirectory(String indexPhysicalLocation) {
        this.indexPhysicalDirectory = indexPhysicalLocation;
    }

    public String getIndexPhysicalDirectory() {
        return this.indexPhysicalDirectory;
    }

    public void setPublicIndexPhysicalDirectory(String publicIndexPhysicalLocation) {
        this.publicIndexPhysicalDirectory = publicIndexPhysicalLocation;
    }

    public String getPublicIndexPhysicalDirectory() {
        return this.publicIndexPhysicalDirectory;
    }

    public String getFacetCacheDirectory() {
        return this.facetCacheDirectory;
    }

    public void setFacetCacheDirectory(String path) {
        this.facetCacheDirectory = path;
    }

    public long dirContentsLastModified(String dirPath) {
        String[] contentList;
        File f;
        long lastModified = 0L;
        if (dirPath != null && (f = new File(dirPath)).isDirectory() && (contentList = f.list()) != null) {
            for (String cl : contentList) {
                String contentPath = dirPath + File.separator + cl;
                long cTime = new File(contentPath).lastModified();
                if (cTime <= lastModified) continue;
                lastModified = cTime;
            }
        }
        return lastModified;
    }

    public boolean dirContelntsLastModifiedNewer(String dirPath, long time) {
        String[] contentList;
        File f;
        boolean newer = false;
        if (dirPath != null && (f = new File(dirPath)).isDirectory() && (contentList = f.list()) != null) {
            for (String cl : contentList) {
                String contentPath = dirPath + File.separator + cl;
                long cTime = new File(contentPath).lastModified();
                if (cTime <= time) continue;
                newer = true;
                break;
            }
        }
        return newer;
    }

    public boolean facetCacheDirectoryUpdateRequired() {
        boolean required = true;
        long cacheDirContentsLastModified = this.dirContentsLastModified(this.facetCacheDirectory);
        if (!this.dirContelntsLastModifiedNewer(this.indexPhysicalDirectory, cacheDirContentsLastModified) && !this.dirContelntsLastModifiedNewer(this.publicIndexPhysicalDirectory, cacheDirContentsLastModified)) {
            required = false;
        }
        return required;
    }

    public synchronized IndexReader getReader() throws IOException {
        if (this.reader == null) {
            File localIndex;
            log.debug((Object)("indexPhysicalDirectory: " + this.indexPhysicalDirectory));
            log.debug((Object)("publicIndexPhysicalDirectory: " + this.publicIndexPhysicalDirectory));
            if (StringUtils.isNotEmpty((String)this.indexPhysicalDirectory) && StringUtils.isNotEmpty((String)this.publicIndexPhysicalDirectory)) {
                localIndex = new File(this.indexPhysicalDirectory);
                File publicIndex = new File(this.publicIndexPhysicalDirectory);
                if (localIndex.exists() && publicIndex.exists() && !ArrayUtils.isEmpty((Object[])localIndex.listFiles()) && !ArrayUtils.isEmpty((Object[])publicIndex.listFiles())) {
                    IndexReader[] subReaders = new IndexReader[2];
                    FSDirectory localIndexDir = FSDirectory.open((File)localIndex);
                    subReaders[0] = DirectoryReader.open((Directory)localIndexDir);
                    FSDirectory publicIndexDir = FSDirectory.open((File)publicIndex);
                    subReaders[1] = DirectoryReader.open((Directory)publicIndexDir);
                    this.reader = new MultiReader(subReaders);
                }
            }
            if (this.reader == null) {
                localIndex = new File(this.indexPhysicalDirectory);
                FSDirectory localIndexDir = FSDirectory.open((File)localIndex);
                this.reader = DirectoryReader.open((Directory)localIndexDir);
            }
        }
        return this.reader;
    }

    public synchronized void closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public IndexWriter getWriter(boolean diacritics) throws IOException {
        StopAnalyzer analyzer = diacritics ? new StopAnalyzer() : new StandardAnalyzer();
        return this.getWriter((Analyzer)analyzer, true);
    }

    public IndexWriter getWriter(boolean diacritics, String indexDestinationPath) throws IOException {
        return this.getWriter(diacritics, indexDestinationPath, true);
    }

    public IndexWriter getWriter(boolean diacritics, String indexDestinationPath, boolean confirmEmptyLocationOnWrite) throws IOException {
        if (StringUtils.isEmpty((String)indexDestinationPath)) {
            return this.getWriter(diacritics);
        }
        StopAnalyzer analyzer = diacritics ? new StopAnalyzer() : new StandardAnalyzer();
        return this.getWriter((Analyzer)analyzer, indexDestinationPath, confirmEmptyLocationOnWrite);
    }

    public IndexWriter getWriter(boolean diacritics, String indexDestinationPath, boolean confirmEmptyLocationOnWrite, boolean forceNewIndex) throws IOException {
        if (StringUtils.isEmpty((String)indexDestinationPath)) {
            return this.getWriter(diacritics);
        }
        StopAnalyzer analyzer = diacritics ? new StopAnalyzer() : new StandardAnalyzer();
        return this.getWriter((Analyzer)analyzer, indexDestinationPath, confirmEmptyLocationOnWrite, forceNewIndex);
    }

    public IndexWriter getWriter(Analyzer analyzer, boolean confirmEmptyLocationOnWrite) throws IOException {
        return this.getWriter(analyzer, this.indexPhysicalDirectory, confirmEmptyLocationOnWrite);
    }

    public IndexWriter getWriter(Analyzer analyzer, String indexDestinationPath, boolean confirmEmptyLocationOnWrite) throws IOException {
        return this.getWriter(analyzer, indexDestinationPath, confirmEmptyLocationOnWrite, false);
    }

    public IndexWriter getWriter(Analyzer analyzer, String indexDestinationPath, boolean confirmEmptyLocationOnWrite, boolean forceNewIndex) throws IOException {
        IndexWriter writer = null;
        File directory = new File(indexDestinationPath);
        if (confirmEmptyLocationOnWrite && directory.exists()) {
            throw new IOException("Cannot create writer to index at '" + indexDestinationPath + "', please delete it first");
        }
        IndexWriterConfig conf = new IndexWriterConfig(null, analyzer);
        FSDirectory indexDir = FSDirectory.open((File)new File(indexDestinationPath));
        if (forceNewIndex || ArrayUtils.isEmpty((Object[])directory.listFiles())) {
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            writer = new IndexWriter((Directory)indexDir, conf);
        } else {
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            writer = new IndexWriter((Directory)indexDir, conf);
        }
        return writer;
    }

    public SolrServer getSolrServer() {
        return this.solrServer;
    }

    public void setSolrServer(SolrServer s) {
        this.solrServer = s;
    }
}

