/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.lucene;

import com.lunaimaging.insight.core.dao.lucene.SolrServerAnnotationDAO;
import com.lunaimaging.insight.core.domain.Annotation;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.logic.InsightFacade;
import com.lunaimaging.insight.core.domain.search.AnnotationSearchFieldValue;
import com.lunaimaging.insight.core.domain.search.AnnotationSearchResult;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.Result;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneAnnotationGroupResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneAnnotationResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchResult;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.domain.PublisherAnnotation;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.distance.DistanceOp;

public class AnnotationSearcher {
    protected static Log logger = LogFactory.getLog(AnnotationSearcher.class);
    public String parentDocSearchField = PublisherMedia.ANNOTATION_SEARCH_FIELD;
    public String childDocSearchField = PublisherAnnotation.ANNOTATION_SEARCH_FIELD;
    private static final int MAX_CHARACTER_DISTANCE = 2;
    private List<String> searchTerms;
    private List<String> collectionIds;
    private MediaSearchCriteria criteria;
    private int offset;
    private int pageSize;
    private User user;
    private int d = 200000;
    private int facetLimit = 100000;
    private String facetField = "_luna_fct_" + PublisherAnnotation.ANNOTATION_SEARCH_FIELD;
    private boolean facetZeros = false;
    private String facetSort = "count";
    private SolrServerAnnotationDAO solrAnnotationDao;
    private InsightFacade insight;
    private int maxCharDist = 2;
    private final String STACK_OUTPUT_STRING = "~~ | ";

    public AnnotationSearcher(List<String> searchTerms, SolrServerAnnotationDAO solrAnnotationDao, InsightFacade insight, MediaSearchCriteria criteria, int offset, int pageSize) {
        if (searchTerms != null) {
            for (int i = 0; i < searchTerms.size(); ++i) {
                searchTerms.set(i, StringUtils.lowerCase((String)searchTerms.get(i)));
            }
        }
        this.searchTerms = searchTerms;
        this.solrAnnotationDao = solrAnnotationDao;
        this.insight = insight;
        this.criteria = criteria;
        if (offset < 0) {
            offset = 0;
        }
        this.offset = offset;
        if (pageSize < 0) {
            pageSize = 200000;
        }
        this.pageSize = pageSize;
        this.initializeSearchFields();
    }

    private void initializeSearchFields() {
        List<SearchFieldValue> searchFieldValues;
        String fieldName = PublisherMedia.ANNOTATION_SEARCH_FIELD;
        if (this.criteria != null && (searchFieldValues = this.criteria.getSearchFieldValues()) != null) {
            for (SearchFieldValue sfv : searchFieldValues) {
                if (!AnnotationSearchFieldValue.getAnnotationSearchFields().contains(sfv.getField()) || StringUtils.equals((String)AnnotationSearchFieldValue.ANNOTATION_ALL_TEXT, (String)sfv.getField())) continue;
                fieldName = sfv.getField();
                this.parentDocSearchField = PublisherMedia.ANNO_SEARCH_FIELD_PREFIX + fieldName;
                this.childDocSearchField = fieldName;
                break;
            }
        }
    }

    public AnnotationSearchResult doSearch() {
        List<String> mediaIds = this.findMediaIds();
        return this.doSearch(mediaIds);
    }

    public AnnotationSearchResult doSearch(List<String> mediaIds) {
        logger.debug((Object)("# of media Ids : " + (mediaIds == null || mediaIds.size() == 0 ? 0 : mediaIds.size())));
        logger.debug("Searching " + mediaIds == null ? Integer.valueOf(0) : (mediaIds.size() + " images. [" + mediaIds == null ? "null" : mediaIds + "]"));
        ArrayList<ArrayList<LuceneAnnotationResult>> foundAnnos = new ArrayList<ArrayList<LuceneAnnotationResult>>();
        AnnotationSearchResult results = new AnnotationSearchResult();
        if (mediaIds != null) {
            for (String mediaId : mediaIds) {
                List<String> orderedTerms = this.findLeastOccurredAnnosInMedia(mediaId);
                String firstTerm = this.searchTerms.get(0);
                if (orderedTerms != null && orderedTerms.size() > 0) {
                    firstTerm = orderedTerms.get(0);
                }
                ArrayList<LuceneAnnotationResult> foundAnnotations = new ArrayList<LuceneAnnotationResult>();
                List<ArrayList<LuceneAnnotationResult>> foundAnnotationGroups = new ArrayList<ArrayList<LuceneAnnotationResult>>();
                ArrayList<String> remainingTermsToMatch = new ArrayList<String>(this.searchTerms);
                String first = firstTerm;
                remainingTermsToMatch.removeIf(value -> value.equalsIgnoreCase(first));
                foundAnnotationGroups = this.findAnnotationGroup(mediaId, firstTerm, remainingTermsToMatch, foundAnnotations, foundAnnotationGroups);
                if (foundAnnotationGroups.size() > 0) {
                    logger.debug((Object)("\nfoundAnnotationGroups:\n " + foundAnnotationGroups + " media: " + mediaId + "\n"));
                    foundAnnos.addAll(foundAnnotationGroups);
                    continue;
                }
                logger.debug((Object)("\nNot found for media: " + mediaId));
            }
            if (foundAnnos.size() > 0) {
                logger.debug((Object)("\n\nfoundAnnos: " + foundAnnos + "\n"));
            }
            for (int i = 0; i < foundAnnos.size(); ++i) {
                if (i < this.offset || i >= this.offset + this.pageSize) continue;
                LuceneAnnotationGroupResult lagr = new LuceneAnnotationGroupResult();
                for (LuceneAnnotationResult lar : (ArrayList)foundAnnos.get(i)) {
                    try {
                        lagr.setMediaId(lar.getMediaId());
                        lagr.addAnnotation(lar);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                results.add(lagr);
            }
            results.setTotalNumberOfResults(foundAnnos.size());
            if (this.criteria != null) {
                results.setSearchCriteria(this.criteria);
            }
        }
        return results;
    }

    private List<ArrayList<LuceneAnnotationResult>> findAnnotationGroup(String mediaId, Annotation currentAnno, List<String> remainingTermsToMatch, ArrayList<LuceneAnnotationResult> foundAnnotations, List<ArrayList<LuceneAnnotationResult>> foundAnnoGroups, String outputPrefix) {
        outputPrefix = outputPrefix + "~~ | ";
        try {
            TwoEnds twoEnds = this.getTwoEnds(currentAnno.getImageCoordinates());
            logger.debug((Object)(outputPrefix + " Text: " + currentAnno + " Start: " + twoEnds.start + " End: " + twoEnds.end + " MaxDist: " + twoEnds.maxDist));
            ArrayList<String> termFilter = new ArrayList<String>(remainingTermsToMatch);
            termFilter.addAll(currentAnno.getSearchableTerms());
            List<LuceneAnnotationResult> closestTermsLeftEnd = this.findClosest(mediaId, twoEnds.start, this.getMaxDist(twoEnds, currentAnno.getAnnotation(), this.maxCharDist), 10, termFilter);
            if (closestTermsLeftEnd != null) {
                ArrayList<String> _remainingTermsForLeft = new ArrayList<String>(remainingTermsToMatch);
                ArrayList<LuceneAnnotationResult> _foundAnnotations = new ArrayList<LuceneAnnotationResult>(foundAnnotations);
                LuceneAnnotationResult annoAddIfMatched = null;
                logger.debug((Object)(outputPrefix + " Closest at Start: " + closestTermsLeftEnd + " _remainingTermsForLeft: " + _remainingTermsForLeft + " currently foundAnnotations: " + _foundAnnotations));
                for (LuceneAnnotationResult anno : closestTermsLeftEnd) {
                    if (this.listMatch(anno.getSearchableTerms(), currentAnno.getSearchableTerms()) && !this.containsIgnoreCase(_foundAnnotations, anno.getAnnotation())) {
                        annoAddIfMatched = anno;
                    }
                    if (!this.listMatch(anno.getSearchableTerms(), _remainingTermsForLeft)) continue;
                    if (annoAddIfMatched != null) {
                        _foundAnnotations.add(annoAddIfMatched);
                        logger.debug((Object)(outputPrefix + "*****************annoAddIfMatched added: " + annoAddIfMatched + " _remainingTermsForLeft: " + _remainingTermsForLeft));
                    }
                    Iterator iter = _remainingTermsForLeft.iterator();
                    while (iter.hasNext()) {
                        String t = (String)iter.next();
                        if (!this.tokenize(anno.getSearchableTerms()).contains(t.toLowerCase())) continue;
                        iter.remove();
                        if (!_foundAnnotations.contains(anno)) {
                            _foundAnnotations.add(anno);
                        }
                        logger.debug((Object)(outputPrefix + "*****************added: " + anno + " _remainingTermsForLeft: " + _remainingTermsForLeft));
                        break;
                    }
                    if (!_remainingTermsForLeft.isEmpty()) {
                        List<ArrayList<LuceneAnnotationResult>> _foundAnnoGroups = this.findAnnotationGroup(mediaId, this.insight.getAnnotation(Integer.parseInt((String)anno.getId()), this.user), _remainingTermsForLeft, _foundAnnotations, foundAnnoGroups, "L" + outputPrefix);
                        remainingTermsToMatch.clear();
                        remainingTermsToMatch.addAll(_remainingTermsForLeft);
                        foundAnnotations.clear();
                        foundAnnotations.addAll(_foundAnnotations);
                        if (_foundAnnoGroups == null || !_remainingTermsForLeft.isEmpty()) continue;
                        this.addIfNotExist(foundAnnoGroups, _foundAnnoGroups);
                        continue;
                    }
                    this.addIfNotExist(foundAnnoGroups, _foundAnnotations);
                }
            }
            ArrayList<String> termFilter2 = new ArrayList<String>(remainingTermsToMatch);
            termFilter2.addAll(currentAnno.getSearchableTerms());
            List<LuceneAnnotationResult> closestTermsRightEnd = this.findClosest(mediaId, twoEnds.end, this.getMaxDist(twoEnds, currentAnno.getAnnotation(), this.maxCharDist), 10, termFilter2);
            if (closestTermsRightEnd != null) {
                ArrayList<String> _remainingTermsForRight = new ArrayList<String>(remainingTermsToMatch);
                ArrayList<LuceneAnnotationResult> _foundAnnotations = new ArrayList<LuceneAnnotationResult>(foundAnnotations);
                LuceneAnnotationResult annoAddIfMatched = null;
                logger.debug((Object)(outputPrefix + " Closest at End: " + closestTermsRightEnd + " _remainingTermsForRight: " + _remainingTermsForRight + " currently foundAnnotations: " + _foundAnnotations));
                for (LuceneAnnotationResult anno : closestTermsRightEnd) {
                    if (this.listMatch(anno.getSearchableTerms(), currentAnno.getSearchableTerms()) && !this.containsIgnoreCase(_foundAnnotations, anno.getAnnotation())) {
                        annoAddIfMatched = anno;
                    }
                    if (!this.listMatch(anno.getSearchableTerms(), _remainingTermsForRight)) continue;
                    if (annoAddIfMatched != null) {
                        _foundAnnotations.add(annoAddIfMatched);
                        logger.debug((Object)(outputPrefix + "*****************annoAddIfMatched added: " + annoAddIfMatched + " _remainingTermsForRight: " + _remainingTermsForRight));
                    }
                    Iterator iter = _remainingTermsForRight.iterator();
                    while (iter.hasNext()) {
                        String t = (String)iter.next();
                        if (!this.tokenize(anno.getSearchableTerms()).contains(t.toLowerCase())) continue;
                        iter.remove();
                        if (!_foundAnnotations.contains(anno)) {
                            _foundAnnotations.add(anno);
                        }
                        logger.debug((Object)(outputPrefix + "*****************added: " + anno + " _remainingTermsForRight: " + _remainingTermsForRight));
                        break;
                    }
                    if (!_remainingTermsForRight.isEmpty()) {
                        List<ArrayList<LuceneAnnotationResult>> _foundAnnoGroups = this.findAnnotationGroup(mediaId, this.insight.getAnnotation(Integer.parseInt((String)anno.getId()), this.user), _remainingTermsForRight, _foundAnnotations, foundAnnoGroups, "R" + outputPrefix);
                        remainingTermsToMatch.clear();
                        remainingTermsToMatch.addAll(_remainingTermsForRight);
                        foundAnnotations.clear();
                        foundAnnotations.addAll(_foundAnnotations);
                        if (_foundAnnoGroups == null || !_remainingTermsForRight.isEmpty()) continue;
                        this.addIfNotExist(foundAnnoGroups, _foundAnnoGroups);
                        continue;
                    }
                    this.addIfNotExist(foundAnnoGroups, _foundAnnotations);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return foundAnnoGroups;
    }

    private List<ArrayList<LuceneAnnotationResult>> findAnnotationGroup(String mediaId, String currentTerm, ArrayList<String> remainingTermsToMatch, ArrayList<LuceneAnnotationResult> foundAnnotations, List<ArrayList<LuceneAnnotationResult>> foundAnnoGroups) {
        if (currentTerm == null) {
            return null;
        }
        if (remainingTermsToMatch == null || remainingTermsToMatch.size() == 0) {
            return foundAnnoGroups;
        }
        logger.debug((Object)("+++++++++++++++++++currentTerm: " + currentTerm));
        List<Annotation> annotList = this.getAnnotations(currentTerm, mediaId);
        for (Annotation a : annotList) {
            List<Object> _foundAnnoGroups;
            List<Object> remainingTermsToMatch_ = (ArrayList)SerializationUtils.clone(remainingTermsToMatch);
            if ((remainingTermsToMatch_ = this.removeMatchedLowerCase(a, (List<String>)remainingTermsToMatch_)).size() > 0) {
                _foundAnnoGroups = this.findAnnotationGroup(mediaId, a, new ArrayList<Object>(remainingTermsToMatch_), new ArrayList<LuceneAnnotationResult>(), foundAnnoGroups, "");
                this.addIfNotExist(foundAnnoGroups, _foundAnnoGroups);
                continue;
            }
            _foundAnnoGroups = new ArrayList();
            ArrayList currentAnnoResult = (ArrayList)this.solrAnnotationDao.findByAnnotationId(a.getId());
            if (currentAnnoResult != null) {
                _foundAnnoGroups.add(currentAnnoResult);
            }
            this.addIfNotExist(foundAnnoGroups, _foundAnnoGroups);
        }
        return foundAnnoGroups;
    }

    private List<String> tokenize(String text) {
        ArrayList<String> emptyList = new ArrayList<String>();
        if (text == null || text.length() == 0) {
            return emptyList;
        }
        String cleanedInput = text.toLowerCase().replaceAll("[^\\w\\s]", "");
        String[] wordsInAnno = cleanedInput.split("\\s+");
        if (wordsInAnno.length == 0) {
            return emptyList;
        }
        return Arrays.asList(wordsInAnno);
    }

    private List<String> tokenize(List<String> list) {
        HashSet<String> wordSet = new HashSet<String>();
        if (list == null || list.isEmpty()) {
            return new ArrayList<String>();
        }
        for (String text : list) {
            wordSet.addAll(this.tokenize(text));
        }
        return new ArrayList<String>(wordSet);
    }

    private List<String> removeMatchedLowerCase(Annotation annot, List<String> terms) {
        if (annot != null && terms != null) {
            ArrayList<String> termListLowerCase = new ArrayList<String>();
            for (String s : terms) {
                termListLowerCase.add(s.toLowerCase());
            }
            termListLowerCase.removeAll(this.tokenize(annot.getAnnotation()));
            return termListLowerCase;
        }
        return terms;
    }

    private List<Annotation> getAnnotations(String term, String mediaId) {
        long startTime = System.currentTimeMillis();
        ArrayList<Annotation> annotList = new ArrayList<Annotation>();
        SolrQuery sq = new SolrQuery();
        String query = this.childDocSearchField + ":\"" + ClientUtils.escapeQueryChars((String)term) + "\"";
        sq.setQuery(query);
        String fq = PublisherAnnotation.MEDIA_ID + ":\"" + mediaId + "\"";
        sq.setFilterQueries(new String[]{fq});
        sq.addField(PublisherAnnotation.ANNOTATION_ID);
        sq.addField(PublisherAnnotation.MEDIA_ID);
        sq.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD);
        sq.addField(this.childDocSearchField);
        sq.setRows(Integer.valueOf(1000));
        List pms = this.solrAnnotationDao.find(sq);
        if (pms != null) {
            for (PublisherAnnotation pm : pms) {
                Annotation a = this.insight.getAnnotation(pm.getId(), this.user);
                String[] annoArr = (a.getAnnotation() == null ? "" : a.getAnnotation()).split("\\s+");
                String[] ocrArr = (a.getOcrText() == null ? "" : a.getOcrText()).split("\\s+");
                if (!ParsingUtils.equalsIgnoreCase(term, annoArr) && !ParsingUtils.equalsIgnoreCase(term, ocrArr)) {
                    logger.error((Object)("Skipping: Annotation id: " + a.getId() + " term: " + term + " does not match: " + (a.getAnnotation() == null ? "" : a.getAnnotation()) + " or " + (a.getOcrText() == null ? "" : a.getOcrText()) + "!"));
                    continue;
                }
                if (a == null) continue;
                annotList.add(a);
            }
        }
        logger.debug((Object)("getAnnotations() term: " + term + " mediaId: " + mediaId + " took: " + (System.currentTimeMillis() - startTime) + "ms"));
        return annotList;
    }

    public List<String> findMediaIds() {
        List idList;
        if (this.searchTerms == null || this.searchTerms.size() == 0) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        ArrayList<String> foundMediaIds = new ArrayList<String>();
        String query = "";
        String filterQuery = "";
        for (String term : this.searchTerms) {
            query = query + (StringUtils.isNotBlank((String)query) ? " AND " : "") + this.parentDocSearchField + ":" + ClientUtils.escapeQueryChars((String)term);
        }
        if (this.collectionIds != null) {
            for (String cid : this.collectionIds) {
                filterQuery = filterQuery + (StringUtils.isNotBlank((String)filterQuery) ? " OR " : "") + PublisherAnnotation.MEDIA_COLLECTION_ID + ":\"" + cid + "\"";
            }
        }
        if ((idList = this.criteria.getSpecificMediaIds()) != null) {
            if (filterQuery.length() > 0) {
                filterQuery = "(" + filterQuery + ") AND ";
            }
            String idFilter = "";
            for (String id : idList) {
                idFilter = idFilter + (StringUtils.isBlank((String)idFilter) ? "" : " OR") + " mediaId:\"" + ClientUtils.escapeQueryChars((String)id) + "\"";
            }
            filterQuery = filterQuery + idFilter;
        }
        String collFilter = "";
        if (this.criteria.getCollectionLimit() != null) {
            for (MediaCollection mc : this.criteria.getCollectionLimit()) {
                collFilter = collFilter + (StringUtils.isNotBlank((String)collFilter) ? " OR " : "") + PublisherMedia.MEDIA_COLLECTION_ID + ":\"" + mc.getId() + "\"";
            }
        }
        if (StringUtils.isNotBlank((String)collFilter)) {
            filterQuery = StringUtils.isBlank((String)filterQuery) ? collFilter : "(" + filterQuery + ") AND (" + collFilter + ")";
        }
        SolrQuery sq = new SolrQuery();
        sq.setQuery(query);
        sq.addFilterQuery(new String[]{filterQuery});
        sq.addField(PublisherAnnotation.ANNOTATION_ID);
        sq.addField(PublisherAnnotation.MEDIA_ID);
        sq.setRows(Integer.valueOf(100000));
        List pas = this.solrAnnotationDao.find(sq);
        if (pas != null) {
            for (PublisherAnnotation pa : pas) {
                if (pa.getMediaId() == null) continue;
                foundMediaIds.add(pa.getMediaId());
            }
        }
        logger.debug((Object)("findMediaIds() found: " + foundMediaIds.size() + " took: " + (System.currentTimeMillis() - startTime) + "ms"));
        return foundMediaIds;
    }

    private TwoEnds getTwoEnds(String pointsInPolygon) throws ParseException {
        Geometry geom = new WKTReader().read("POLYGON((" + pointsInPolygon + "))");
        GeometryFactory gf = new GeometryFactory();
        double maxDist = 0.0;
        Point start = null;
        Point end = null;
        for (Coordinate c : geom.getCoordinates()) {
            Point p = gf.createPoint(c);
            for (Coordinate c2 : geom.getCoordinates()) {
                Point p2 = gf.createPoint(c2);
                double d = DistanceOp.distance((Geometry)p, (Geometry)p2);
                if (!(d > maxDist)) continue;
                maxDist = d;
                start = p;
                end = p2;
            }
        }
        if (start.getX() > end.getX()) {
            return new TwoEnds(end, start, maxDist);
        }
        return new TwoEnds(start, end, maxDist);
    }

    private List<LuceneAnnotationResult> findClosest(String mediaId, Point point, double maxDist, int maxResult, List<String> filteredByTerms) {
        long startTime = System.currentTimeMillis();
        LuceneSearchResult pointResult = this.solrAnnotationDao.findClosestByImageCoordinate(mediaId, String.valueOf(point.getX()) + " " + String.valueOf(point.getY()), this.d, maxResult, this.user, filteredByTerms, this.childDocSearchField);
        ArrayList<LuceneAnnotationResult> closestTerms = new ArrayList<LuceneAnnotationResult>();
        if (pointResult != null && pointResult.getResults().size() > 0) {
            List<? extends Result> results = pointResult.getResults();
            for (LuceneAnnotationResult luceneAnnotationResult : results) {
                try {
                    if (Double.parseDouble((String)luceneAnnotationResult.getAttributes().get("score")) > maxDist) {
                        logger.debug((Object)("Found: " + luceneAnnotationResult.getAnnotation() + " score: " + luceneAnnotationResult.getAttributes().get("score") + " id: " + luceneAnnotationResult.getId() + " maxDist: " + maxDist + " skipped."));
                        continue;
                    }
                    logger.debug((Object)("Found: " + luceneAnnotationResult.getAnnotation() + " score: " + luceneAnnotationResult.getAttributes().get("score") + " id: " + luceneAnnotationResult.getId() + " maxDist: " + maxDist));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                closestTerms.add(luceneAnnotationResult);
            }
        }
        logger.debug((Object)("findClosest() took: " + (System.currentTimeMillis() - startTime) + "ms"));
        return closestTerms;
    }

    private List<String> findLeastOccurredAnnosInMedia(String mediaId) {
        long startTime = System.currentTimeMillis();
        SolrQuery sq = new SolrQuery();
        String query = "";
        for (String term : this.searchTerms) {
            query = query + (StringUtils.isNotBlank((String)query) ? " OR " : "") + this.childDocSearchField + PublisherAnnotation._LOWERCASE + ":" + ClientUtils.escapeQueryChars((String)term);
        }
        sq.setQuery(query);
        String fq = PublisherAnnotation.MEDIA_ID + ":\"" + mediaId + "\"";
        sq.setFilterQueries(new String[]{fq});
        sq.addFacetField(new String[]{this.facetField});
        sq.setFacet(true);
        sq.setFacetLimit(this.facetLimit);
        sq.setFacetSort(this.facetSort);
        sq.set("facet.zeros", this.facetZeros);
        sq.addField(PublisherAnnotation.ANNOTATION_ID);
        sq.addField(PublisherAnnotation.MEDIA_ID);
        sq.addField(PublisherAnnotation.ANNOTATION_SEARCH_FIELD);
        sq.addField(this.childDocSearchField);
        sq.setRows(Integer.valueOf(0));
        List facets = this.solrAnnotationDao.facets(sq);
        ArrayList<String> foundList = new ArrayList<String>();
        for (String f : facets) {
            if (foundList.contains(f.toLowerCase()) || !this.containsStringIgnoreCase(this.searchTerms, f)) continue;
            foundList.add(f.toLowerCase());
        }
        Collections.reverse(foundList);
        logger.debug((Object)("findLeastOccurredAnnosInMedia() mediaId: " + mediaId + " took: " + (System.currentTimeMillis() - startTime) + "ms"));
        return foundList;
    }

    private boolean containsIgnoreCase(List<LuceneAnnotationResult> annotList, String term) {
        if (annotList == null || annotList.size() == 0 || term == null) {
            return false;
        }
        for (LuceneAnnotationResult a : annotList) {
            if (!StringUtils.equalsIgnoreCase((String)term, (String)a.getAnnotation())) continue;
            return true;
        }
        return false;
    }

    private boolean containsStringIgnoreCase(List<String> termList, String term) {
        if (termList == null || termList.size() == 0 || term == null) {
            return false;
        }
        for (String a : termList) {
            if (!StringUtils.equalsIgnoreCase((String)term, (String)a)) continue;
            return true;
        }
        return false;
    }

    private boolean listMatch(List<String> list1, List<String> list2) {
        List<String> tokenized2;
        List<String> tokenized1 = this.tokenize(list1);
        List matched = ListUtils.intersection(tokenized1, tokenized2 = this.tokenize(list2));
        return matched != null && matched.size() > 0;
    }

    private void addIfNotExist(List<ArrayList<LuceneAnnotationResult>> groups, ArrayList<LuceneAnnotationResult> groupToAdd) {
        if (groups == null || groupToAdd == null) {
            return;
        }
        if (groupToAdd.size() > 1) {
            groupToAdd = this.sort(groupToAdd);
        }
        for (ArrayList<LuceneAnnotationResult> group : groups) {
            if (!ListUtils.isEqualList(group, groupToAdd)) continue;
            logger.debug((Object)("\nAlready exists! " + groupToAdd));
            logger.debug((Object)("\nEquals " + group));
            return;
        }
        groups.add(groupToAdd);
    }

    private void addIfNotExist(List<ArrayList<LuceneAnnotationResult>> groups, List<ArrayList<LuceneAnnotationResult>> groupsToAdd) {
        if (groups == null || groupsToAdd == null) {
            return;
        }
        for (ArrayList<LuceneAnnotationResult> groupToAdd : groupsToAdd) {
            this.addIfNotExist(groups, groupToAdd);
        }
    }

    private ArrayList<LuceneAnnotationResult> sort(ArrayList<LuceneAnnotationResult> groups) {
        ArrayList lists = new ArrayList(this.searchTerms.size());
        for (int i = 0; i < this.searchTerms.size(); ++i) {
            lists.add(new ArrayList());
        }
        block1: for (LuceneAnnotationResult anno : groups) {
            for (int i = 0; i < this.searchTerms.size(); ++i) {
                if (!this.tokenize(anno.getSearchableTerms()).contains(this.searchTerms.get(i).toLowerCase()) || ((ArrayList)lists.get(i)).contains(anno)) continue;
                ((ArrayList)lists.get(i)).add(anno);
                continue block1;
            }
        }
        ArrayList<LuceneAnnotationResult> newGroups = new ArrayList<LuceneAnnotationResult>();
        for (ArrayList arrayList : lists) {
            newGroups.addAll(arrayList);
        }
        return newGroups;
    }

    private double getMaxDist(TwoEnds twoEnds, String term, int maxAllowedCharDist) {
        if (twoEnds == null || term == null || maxAllowedCharDist == 0) {
            return 0.0;
        }
        double avWidth = twoEnds.maxDist / (double)term.length();
        return avWidth * (double)maxAllowedCharDist;
    }

    public void setSearchTerms(List<String> searchTerms) {
        if (searchTerms != null) {
            for (String t : searchTerms) {
                String string = StringUtils.lowerCase((String)t);
            }
            this.searchTerms = searchTerms;
        }
    }

    public void setD(int d) {
        this.d = d;
    }

    public void setSolrAnnotationDao(SolrServerAnnotationDAO solrAnnotationDao) {
        this.solrAnnotationDao = solrAnnotationDao;
    }

    public void setMaxCharDist(int maxCharDist) {
        this.maxCharDist = maxCharDist;
    }

    class TwoEnds {
        private Point start;
        private Point end;
        double maxDist;

        public TwoEnds(Point start, Point end, double maxDist) {
            this.start = start;
            this.end = end;
            this.maxDist = maxDist;
        }
    }
}

