/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.jdbc;

import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.beans.PropertyDescriptor;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;

public class SkippablePropertiesRowProcessor
extends BasicRowProcessor {
    public static final int PROPERTY_NOT_FOUND = -1;
    protected String[] skipProperties = new String[0];

    public SkippablePropertiesRowProcessor(String[] skipProperties) {
        this.setSkipProperties(skipProperties);
    }

    public SkippablePropertiesRowProcessor(BeanProcessor convert) {
        super(convert);
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String columnName = rsmd.getColumnName(col);
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getName();
                if (ParsingUtils.equalsIgnoreCase(name, this.skipProperties) || !columnName.equalsIgnoreCase(name)) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }

    public String[] getSkipProperties() {
        return this.skipProperties;
    }

    public void setSkipProperties(String[] skipProperties) {
        this.skipProperties = skipProperties;
    }
}

