/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.jdbc;

import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class MediaBeanHandler
extends BeanHandler {
    static final Log log = LogFactory.getLog(MediaBeanHandler.class);
    static final Class MEDIA_CLASS = LunaMedia.class;
    protected List<MediaField> mediaFields;
    protected String titleColumn;

    public MediaBeanHandler(List<MediaField> mediaFields, String titleColumn) {
        super(MEDIA_CLASS);
        this.setMediaFields(mediaFields);
        this.setTitleColumn(titleColumn);
    }

    public MediaBeanHandler(String titleColumn) {
        this(null, titleColumn);
    }

    public MediaBeanHandler() {
        this(null);
    }

    public Object handle(ResultSet rs) throws SQLException {
        LunaMedia media = (LunaMedia)super.handle(rs);
        if (media != null && !CollectionUtils.isEmpty(this.mediaFields)) {
            for (MediaField mediaField : this.mediaFields) {
                try {
                    Object value = this.getValue(rs, mediaField);
                    MediaFieldValue mfv = new MediaFieldValue(mediaField, value);
                    media.add(mfv);
                }
                catch (SQLException e) {
                    log.error((Object)("Unable to include " + this.mediaFields + "to media " + media));
                }
            }
            try {
                if (StringUtils.isNotEmpty((String)this.getTitleColumn())) {
                    media.setDisplayTitle(rs.getString(this.getTitleColumn()));
                }
            }
            catch (SQLException e) {
                log.info((Object)("Unable to find title column: " + this.getTitleColumn() + ". " + media));
            }
        }
        return media;
    }

    private Object getValue(ResultSet rs, MediaField field) throws SQLException {
        Object value = null;
        if (rs != null && field != null) {
            value = rs.getObject(field.getFieldName());
        }
        return value;
    }

    public String getTitleColumn() {
        return this.titleColumn;
    }

    public void setTitleColumn(String titleColumn) {
        this.titleColumn = titleColumn;
    }

    public List<MediaField> getMediaFields() {
        return this.mediaFields;
    }

    public void setMediaFields(List<MediaField> mediaFields) {
        this.mediaFields = mediaFields;
    }
}

