/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.http;

import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.http.WebAdminClient;
import com.lunaimaging.publisher.common.http.PublisherHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class WebAdminHttpClient
extends PublisherHttpClient
implements WebAdminClient {
    protected HttpClient httpClient = null;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public WebAdminHttpClient(HttpClient hc) {
        super(hc);
    }

    @Override
    public boolean postForPermissionSetup(String webServiceURL, MediaCollection mc, String username) {
        RestTemplate restTemplate = this.createRestTemplate();
        LinkedMultiValueMap entity = new LinkedMultiValueMap();
        entity.add((Object)"username", (Object)username);
        entity.add((Object)"mediaCollection", (Object)mc);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(new MediaType("multipart", "form-data"));
        HttpEntity request = new HttpEntity((Object)entity, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.postForEntity(webServiceURL, (Object)request, String.class, new Object[0]);
        HttpStatus returnCode = response.getStatusCode();
        return returnCode == HttpStatus.CREATED;
    }

    @Override
    public void purgePermissions(String webServiceURL, MediaCollection mc) {
        RestTemplate restTemplate = this.createRestTemplate();
        try {
            restTemplate.delete(webServiceURL + "/" + mc.getId(), new Object[0]);
        }
        catch (RestClientException re) {
            this.logger.error((Object)re);
        }
    }

    public void purgeCategoryCollection(String webServiceURL, MediaCollection mc) {
        RestTemplate restTemplate = this.createRestTemplate();
        try {
            restTemplate.delete(webServiceURL + "/" + mc.getId(), new Object[0]);
        }
        catch (RestClientException re) {
            this.logger.error((Object)re);
        }
    }

    @Override
    public String findUsers(String webServiceURL, String prefix) {
        RestTemplate restTemplate = this.createRestTemplate();
        String usersJson = "";
        try {
            usersJson = (String)restTemplate.getForObject(webServiceURL + "?prefix=" + prefix, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            this.logger.error((Object)"Error in findUsers()", (Throwable)e);
        }
        return usersJson;
    }
}

