/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.http;

import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.http.LunaMediaClient;
import com.lunaimaging.publisher.common.domain.CommitRequest;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import com.lunaimaging.publisher.common.domain.xml.PublisherMediaList;
import com.lunaimaging.publisher.common.http.PublisherHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class LunaHttpClient
extends PublisherHttpClient
implements LunaMediaClient {
    public final Log logger = LogFactory.getLog(LunaHttpClient.class);

    public LunaHttpClient(HttpClient hc) {
        super(hc);
    }

    @Override
    public MediaCollection postForMediaCollection(String webServiceURL, MediaCollection mc) {
        RestTemplate restTemplate = this.createRestTemplate();
        HttpEntity entity = new HttpEntity((Object)mc);
        ResponseEntity response = restTemplate.postForEntity(webServiceURL, (Object)entity, MediaCollection.class, new Object[0]);
        MediaCollection m = (MediaCollection)response.getBody();
        return m;
    }

    @Override
    public PublisherMedia postForMediaRecord(String webServiceURL, PublisherMedia pm) {
        RestTemplate restTemplate = this.createRestTemplate();
        HttpEntity entity = new HttpEntity((Object)pm);
        ResponseEntity response = restTemplate.postForEntity(webServiceURL, (Object)entity, PublisherMedia.class, new Object[0]);
        PublisherMedia p = (PublisherMedia)response.getBody();
        return p;
    }

    @Override
    public Integer postForMediaRecords(String webServiceURL, PublisherMediaList pms) {
        RestTemplate restTemplate = this.createRestTemplate();
        HttpEntity entity = new HttpEntity((Object)pms);
        ResponseEntity response = restTemplate.postForEntity(webServiceURL, (Object)entity, Integer.class, new Object[0]);
        Integer p = (Integer)response.getBody();
        return p;
    }

    @Override
    public boolean postForTemplate(String webServiceURL, String xml) {
        RestTemplate restTemplate = this.createRestTemplate();
        HttpEntity entity = new HttpEntity((Object)xml);
        ResponseEntity response = restTemplate.postForEntity(webServiceURL, (Object)entity, Boolean.class, new Object[0]);
        Boolean b = (Boolean)response.getBody();
        return b;
    }

    public <T> T postForXml(String webServiceURL, String xml, Class<T> type) {
        RestTemplate restTemplate = this.createRestTemplate();
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_XML);
        HttpEntity entity = new HttpEntity((Object)xml);
        this.logger.debug((Object)("Posting this xml: " + xml));
        System.out.println("Posting data to >>>>>>>>>>>>>>>>>>>>>" + webServiceURL);
        ResponseEntity response = restTemplate.postForEntity(webServiceURL, (Object)entity, type, new Object[0]);
        Object result = response.getBody();
        System.out.println("Response data >>>>>>>>>>>>>>>>>>>>>" + result);
        this.logger.debug((Object)("Rest response : " + result));
        return (T)result;
    }

    public <T> T postForUploadFile(String webServiceURL, String uploadFilePath, Class<T> type) {
        RestTemplate restTemplate = this.createRestTemplate();
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"file", (Object)new FileSystemResource(uploadFilePath));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(new MediaType("multipart", "form-data"));
        HttpEntity request = new HttpEntity((Object)form, (MultiValueMap)headers);
        Object result = null;
        try {
            ResponseEntity response = restTemplate.exchange(webServiceURL, HttpMethod.POST, request, type, new Object[0]);
            result = response.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    public <T> T postForCollection(String webServiceURL, MultiValueMap<String, String> postParameters, Class<T> type) {
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity requestEntity = new HttpEntity(postParameters, (MultiValueMap)requestHeaders);
        RestTemplate restTemplate = this.createRestTemplate();
        ResponseEntity response = restTemplate.postForEntity(webServiceURL, (Object)requestEntity, type, new Object[0]);
        Object result = response.getBody();
        return (T)result;
    }

    @Override
    public void put(String url, CommitRequest cRequest) {
        RestTemplate restTemplate = this.createRestTemplate();
        HttpEntity entity = new HttpEntity((Object)cRequest);
        restTemplate.put(url, (Object)entity, new Object[0]);
    }

    @Override
    public void deleteCollection(String url, String lunaCollectionId) {
        this.delete(url, lunaCollectionId);
    }

    @Override
    public void deleteRecord(String url, String lunaMediaId) {
        this.delete(url, lunaMediaId);
    }

    @Override
    public void deleteRecordsByCollection(String url, String collectionId) {
        this.delete(url, collectionId);
    }

    void delete(String url, String id) {
        RestTemplate restTemplate = this.createRestTemplate();
        restTemplate.delete(url + "/" + id, new Object[0]);
    }

    @Override
    public Long getMediaCount(String webServiceURL, String collectionId) {
        RestTemplate restTemplate = this.createRestTemplate();
        ResponseEntity response = restTemplate.getForEntity(webServiceURL + "/" + collectionId, Long.class, new Object[0]);
        Long p = (Long)response.getBody();
        return p;
    }
}

