/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.http;

import com.lunaimaging.inscribe.domain.LunaCollectionId;
import com.lunaimaging.inscribe.domain.PublishEntity;
import com.lunaimaging.inscribe.domain.SharedSchema;
import com.lunaimaging.insight.core.domain.ActivityResult;
import com.lunaimaging.insight.core.http.LibraryClient;
import com.lunaimaging.orion.editor.domain.Schema;
import com.lunaimaging.publisher.common.http.PublisherHttpClient;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class LibraryHttpClient
extends PublisherHttpClient
implements LibraryClient {
    public final Log logger = LogFactory.getLog(LibraryHttpClient.class);

    public LibraryHttpClient(HttpClient hc) {
        super(hc);
    }

    @Override
    public ActivityResult getActivityBeforeLastId(String webServiceURL, List<String> cids, int lastId, int pageSize) {
        System.out.println("==========sending request: getActivityBeforeLastId");
        RestTemplate restTemplate = this.createRestTemplate();
        String collectionString = "";
        for (String cid : cids) {
            if (StringUtils.isNotBlank((String)collectionString)) {
                cid = cid + ",";
            }
            collectionString = collectionString + cid;
        }
        ResponseEntity response = restTemplate.exchange(webServiceURL + "?collectionId=" + collectionString + "&status=P&lastId=" + lastId + "&pageSize=" + pageSize, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<PublishEntity>>(){}, new Object[0]);
        System.out.println("<<<<<<<<<<<<received response: getActivityBeforeLastId");
        List entities = (List)response.getBody();
        ActivityResult ar = new ActivityResult();
        HttpHeaders headers = response.getHeaders();
        List total = headers.get((Object)"Total");
        try {
            int t = Integer.parseInt((String)total.get(0));
            int l = t <= 0 ? 0 : t / pageSize;
            ar.setTotal(t);
            ar.setEntities(entities);
            ar.setLastPageNumber(l);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in setting results", (Throwable)e);
        }
        return ar;
    }

    @Override
    public ActivityResult getActivity(String webServiceURL, List<String> cids, int pageNo, int pageSize) {
        System.out.println("==========sending request: getActivity");
        RestTemplate restTemplate = this.createRestTemplate();
        String collectionString = "";
        for (String cid : cids) {
            if (StringUtils.isNotBlank((String)collectionString)) {
                cid = cid + ",";
            }
            collectionString = collectionString + cid;
        }
        ResponseEntity response = restTemplate.exchange(webServiceURL + "?collectionId=" + collectionString + "&status=P&pageNo=" + pageNo + "&pageSize=" + pageSize, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<PublishEntity>>(){}, new Object[0]);
        System.out.println("<<<<<<<<<<<<received response: getActivity");
        List entities = (List)response.getBody();
        ActivityResult ar = new ActivityResult();
        HttpHeaders headers = response.getHeaders();
        List total = headers.get((Object)"Total");
        try {
            int t = Integer.parseInt((String)total.get(0));
            int l = t <= 0 ? 0 : t / pageSize;
            ar.setTotal(t);
            ar.setEntities(entities);
            ar.setLastPageNumber(l);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in setting results", (Throwable)e);
        }
        return ar;
    }

    public int getTotal(String webServiceURL, List<String> cids) {
        System.out.println("==========sending request: getTotal");
        RestTemplate restTemplate = this.createRestTemplate();
        String collectionString = "";
        for (String cid : cids) {
            if (StringUtils.isNotBlank((String)collectionString)) {
                cid = cid + ",";
            }
            collectionString = collectionString + cid;
        }
        ResponseEntity response = restTemplate.exchange(webServiceURL + "?collectionId=" + collectionString + "&status=P&offset=" + 0 + "&pageSize=" + 1, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<PublishEntity>>(){}, new Object[0]);
        System.out.println("<<<<<<<<<<<<received response: getTotal");
        HttpHeaders headers = response.getHeaders();
        List total = headers.get((Object)"Total");
        try {
            return Integer.parseInt((String)total.get(0));
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in getting Total", (Throwable)e);
            return -1;
        }
    }

    public SharedSchema getSharedSchema(String webServiceURL, String cid) {
        System.out.println("==========sending request: getSharedSchema");
        RestTemplate restTemplate = this.createRestTemplate();
        ResponseEntity response = restTemplate.exchange(webServiceURL + "?collectionId=" + cid, HttpMethod.GET, null, String.class, new Object[0]);
        System.out.println("<<<<<<<<<<<<received response: getSharedSchema");
        String ss = (String)response.getBody();
        SAXReader reader = new SAXReader();
        try {
            Document sDoc = reader.read((Reader)new StringReader(ss));
            return new SharedSchema(sDoc);
        }
        catch (DocumentException e) {
            this.logger.error((Object)"Error in getting schema", (Throwable)e);
            return null;
        }
    }

    public Schema getSchema(String webServiceURL, String cid) {
        System.out.println("==========sending request: getSchema");
        RestTemplate restTemplate = this.createRestTemplate();
        ResponseEntity response = restTemplate.exchange(webServiceURL + "?collectionId=" + cid, HttpMethod.GET, null, String.class, new Object[0]);
        System.out.println("<<<<<<<<<<<<received response: getSchema");
        String ss = (String)response.getBody();
        SAXReader reader = new SAXReader();
        try {
            Document sDoc = reader.read((Reader)new StringReader(ss));
            return new Schema(new LunaCollectionId(cid), sDoc);
        }
        catch (DocumentException e) {
            this.logger.error((Object)"Error in getting schema", (Throwable)e);
            return null;
        }
    }
}

