/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.http;

import com.lunaimaging.inscribe.domain.SharedSchema;
import com.lunaimaging.insight.core.domain.ActivityResult;
import com.lunaimaging.insight.core.http.LibraryHttpClient;
import com.lunaimaging.insight.core.http.LibraryHttpClientFactory;
import com.lunaimaging.orion.editor.domain.Schema;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryHttpAdapter {
    private String username;
    private String password;
    private String loginUrl;
    private LibraryHttpClientFactory libraryHttpClientFactory;
    private LibraryHttpClient libraryHttpClient;
    private String libraryUrl;
    private static final String ACTIVITY_PATH = "/activities";
    private static final String SCHEMA_PATH = "/schema";
    private final Log logger = LogFactory.getLog(this.getClass());

    public LibraryHttpAdapter() {
    }

    public LibraryHttpAdapter(String username, String password, String loginUrl) {
        this.username = username;
        this.password = password;
        this.loginUrl = loginUrl;
    }

    public boolean login() {
        this.libraryHttpClient = (LibraryHttpClient)this.libraryHttpClientFactory.newInstance();
        boolean loggedIn = this.libraryHttpClient.login(this.loginUrl, this.username, this.password);
        if (!loggedIn) {
            this.logger.error((Object)("loggedIn = " + loggedIn));
        }
        return loggedIn;
    }

    public ActivityResult getPublishEntities(List<String> collectionIds, int pageNo, int pageSize) {
        return this.libraryHttpClient.getActivity(this.libraryUrl + ACTIVITY_PATH, collectionIds, pageNo, pageSize);
    }

    public ActivityResult getPublishEntitiesBeforeLastId(List<String> collectionIds, int lastId, int pageSize) {
        return this.libraryHttpClient.getActivityBeforeLastId(this.libraryUrl + ACTIVITY_PATH, collectionIds, lastId, pageSize);
    }

    public int getTotal(List<String> collectionIds) {
        return this.libraryHttpClient.getTotal(this.libraryUrl + ACTIVITY_PATH, collectionIds);
    }

    public int getLastActivityPageNo(List<String> collectionIds, int pageSize) {
        int total = this.getTotal(collectionIds);
        if (total <= 0) {
            return 0;
        }
        return total / pageSize;
    }

    public Schema getSchema(String cid) {
        return this.libraryHttpClient.getSchema(this.libraryUrl + SCHEMA_PATH, cid);
    }

    public SharedSchema getSharedSchema(String cid) {
        return this.libraryHttpClient.getSharedSchema(this.libraryUrl + SCHEMA_PATH, cid);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public LibraryHttpClientFactory getLibraryHttpClientFactory() {
        return this.libraryHttpClientFactory;
    }

    public void setLibraryHttpClientFactory(LibraryHttpClientFactory libraryHttpClientFactory) {
        this.libraryHttpClientFactory = libraryHttpClientFactory;
    }

    public String getActivityUrl() {
        return this.libraryUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.libraryUrl = activityUrl;
    }

    public String getLibraryUrl() {
        return this.libraryUrl;
    }

    public void setLibraryUrl(String libraryUrl) {
        this.libraryUrl = libraryUrl;
    }
}

