/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneMediaResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchResult;
import com.lunaimaging.insight.core.lucene.LuceneResultProcessor;
import com.lunaimaging.insight.core.utils.MediaFieldUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class MediaResultProcessor
implements LuceneResultProcessor {
    protected static final String SEPERATOR = ", ";
    protected List<String> valueDelimeter;

    public MediaResultProcessor() {
    }

    public MediaResultProcessor(List<String> valueDelimeter) {
        this();
        this.setValueDelimeter(valueDelimeter);
    }

    @Override
    public LuceneSearchResult process(List<Document> docs) {
        LuceneSearchResult results = new LuceneSearchResult();
        if (CollectionUtils.isNotEmpty(docs)) {
            for (Document doc : docs) {
                if (doc == null) continue;
                LuceneMediaResult result = new LuceneMediaResult();
                for (int f = 0; f < doc.getFields().size(); ++f) {
                    Field field = (Field)doc.getFields().get(f);
                    if (!field.fieldType().stored()) continue;
                    result.putAttribute(new String(field.name()), this.getProperValue(doc.get(field.name())));
                }
                results.add(result);
            }
        }
        return results;
    }

    @Override
    public LuceneSearchResult processSolrDocumentList(SolrDocumentList docs, List<MediaCollection> mcs) {
        LuceneSearchResult results = new LuceneSearchResult();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (docs != null && docs.size() > 0) {
            for (int i = 0; i < docs.size(); ++i) {
                SolrDocument doc = (SolrDocument)docs.get(i);
                PublisherMedia pm = new PublisherMedia();
                this.prepareSerialization(pm, doc);
                String collId = pm.getMediaCollectionId();
                MediaCollection thisCollection = null;
                for (MediaCollection mediaCollection : mcs) {
                    if (!mediaCollection.getId().equals(collId)) continue;
                    thisCollection = mediaCollection;
                    break;
                }
                if (doc == null) continue;
                LuceneMediaResult result = new LuceneMediaResult();
                Collection fieldNames = doc.getFieldNames();
                for (String field : fieldNames) {
                    if (doc.getFieldValue(field) == null) continue;
                    Collection fvs = doc.getFieldValues(field);
                    for (Object fv : fvs) {
                        String value = "";
                        if (fv instanceof Date) {
                            df.setTimeZone(TimeZone.getTimeZone("UTC"));
                            value = df.format((Date)fv);
                        } else {
                            value = fv.toString();
                        }
                        result.putAttribute(field, value);
                    }
                }
                if (thisCollection != null) {
                    List<MediaFieldValue> list = MediaFieldUtils.getOrderedMediaFieldValues(pm, thisCollection);
                    result.fieldValues = new ArrayList<MediaFieldValue>();
                    result.fieldValues.addAll(list);
                }
                results.add(result);
            }
            results.setTotalNumberOfResults(docs.getNumFound());
        }
        return results;
    }

    @Override
    public LuceneSearchResult processSolrDocuments(List<SolrDocument> docs) {
        LuceneSearchResult results = new LuceneSearchResult();
        if (docs != null && docs.size() > 0) {
            for (int i = 0; i < docs.size(); ++i) {
                SolrDocument doc = docs.get(i);
                if (doc == null) continue;
                LuceneMediaResult result = new LuceneMediaResult();
                Collection fieldNames = doc.getFieldNames();
                for (String field : fieldNames) {
                    if (doc.getFieldValue(field) == null) continue;
                    result.putAttribute(field, doc.getFieldValue(field).toString());
                }
                results.add(result);
            }
        }
        return results;
    }

    protected String getProperValue(String value) {
        String toReturn = "";
        if (StringUtils.isNotEmpty((String)value) && CollectionUtils.isNotEmpty(this.valueDelimeter)) {
            toReturn = ParsingUtils.regxReplaceWith(value, this.valueDelimeter, SEPERATOR);
        }
        return toReturn;
    }

    protected void prepareSerialization(PublisherMedia m, SolrDocument sDoc) {
        if (sDoc == null || sDoc.size() == 0) {
            return;
        }
        for (String fieldName : sDoc.getFieldNames()) {
            if (!PublisherMedia.isSerializableFields((String)fieldName)) continue;
            m.addField(fieldName, sDoc.getFieldValue(fieldName));
        }
    }

    public List<String> getValueDelimeter() {
        return this.valueDelimeter;
    }

    public void setValueDelimeter(List<String> valueDelimeter) {
        this.valueDelimeter = valueDelimeter;
    }
}

