/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.DefaultDateField;
import com.lunaimaging.insight.core.domain.FullTexIndexField;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.search.AnnotationSearchFieldValue;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.SearchDateRangeValue;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchStringValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import com.lunaimaging.insight.core.domain.search.W4SearchFieldValue;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import com.lunaimaging.security.permission.PermissionManager;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.solr.schema.LunaFieldType;

public class LuceneSearchCriteriaParserDeprecated {
    protected static final String OR = SearchFieldValue.Condition.OR.name();
    protected static final String AND = SearchFieldValue.Condition.AND.name();
    protected static final String TO = "TO";
    protected static final int LUCENE_MAX_BOOLEAN_COUNT = 6000;
    protected static LuceneSearchCriteriaParserDeprecated instance = new LuceneSearchCriteriaParserDeprecated();
    protected static Log log = LogFactory.getLog(LuceneSearchCriteriaParserDeprecated.class);
    protected static final String REGEX_RANGE_DEFINITION = "\\[.+\\sTO\\s.+\\]";
    protected Pattern RANGE_OPERATOR_DEFINITION = Pattern.compile("\\[.+\\sTO\\s.+\\]", 2);
    protected Analyzer analyzer = new LunaFieldType().getQueryAnalyzer();
    protected QueryParser parser = new QueryParser(null, this.analyzer);
    protected double proximitySearchRange = 0.7;
    protected boolean strFieldForExactMatch = false;

    protected LuceneSearchCriteriaParserDeprecated() {
        this.parser.setAllowLeadingWildcard(true);
    }

    public static synchronized LuceneSearchCriteriaParserDeprecated getInstance() {
        if (instance == null) {
            instance = new LuceneSearchCriteriaParserDeprecated();
        }
        return instance;
    }

    public Sort getSort(MediaSearchCriteria criteria) {
        Sort sort = null;
        SortField[] sortFields = null;
        if (!CollectionUtils.isEmpty(criteria.getSortFields())) {
            sortFields = new SortField[criteria.getSortFields().size()];
            for (int i = 0; i < criteria.getSortFields().size(); ++i) {
                MediaField mediaField = criteria.getSortFields().get(i);
                sortFields[i] = new SortField(mediaField.getFieldName(), SortField.Type.STRING);
            }
        }
        if (!ArrayUtils.isEmpty(sortFields)) {
            sort = new Sort(sortFields);
        }
        return sort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query parse(MediaSearchCriteria criteria) throws InvalidParameterException, ParseException {
        if (criteria == null) {
            throw new InvalidParameterException("MediaSearchCritera cannot be null!");
        }
        if (CollectionUtils.isEmpty(criteria.getMediaFields())) {
            throw new InvalidParameterException("MediaSearchCritera contains no media fields!");
        }
        String generatedQuery = this.generateQueryString(criteria);
        criteria.setLuceneQueryString(generatedQuery);
        Query query = null;
        log.debug((Object)("Query:" + generatedQuery));
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread() + " Before parse: " + new Date()));
        }
        QueryParser queryParser = this.parser;
        synchronized (queryParser) {
            BooleanQuery.setMaxClauseCount((int)6000);
            query = this.parser.parse(generatedQuery);
            Analyzer analyzer = this.parser.getAnalyzer();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread() + " 2Before parse: " + new Date()));
        }
        return query;
    }

    public String generateQueryString(MediaSearchCriteria criteria) {
        String specificMediaLimit;
        StringBuilder sb = new StringBuilder();
        List<SearchFieldValue> searchFieldValues = criteria.getSearchFieldValues();
        if (!criteria.isW4FilteredSearch()) {
            searchFieldValues.addAll(criteria.getW4SearchFieldValue());
        }
        for (SearchFieldValue fieldValue : searchFieldValues) {
            if (CollectionUtils.isEmpty(fieldValue.getSearchValues())) continue;
            sb.append(this.generateFieldValue(fieldValue, criteria));
            if (fieldValue.equals(criteria.getSearchFieldValues().get(criteria.getSearchFieldValues().size() - 1))) continue;
            sb.append(" " + fieldValue.getCondition().name() + " ");
        }
        String w4Query = this.facetQueryString(criteria);
        if (w4Query.length() > 0) {
            sb.append(sb.length() == 0 ? w4Query : " " + AND + " " + w4Query);
        }
        if (sb.length() != 0) {
            sb.insert(0, "( ");
            sb.append(" )");
        }
        ArrayList specificMedia = new ArrayList();
        if (criteria.getMediaGroup() != null && CollectionUtils.isNotEmpty((Collection)criteria.getMediaGroup().getMediaIds())) {
            specificMedia.addAll(criteria.getMediaGroup().getMediaIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)criteria.getSpecificMediaIds())) {
            specificMedia.addAll(criteria.getSpecificMediaIds());
        }
        if (CollectionUtils.isNotEmpty(specificMedia) && StringUtils.isNotEmpty((String)(specificMediaLimit = this.generateSpecificMediaLimit(specificMedia)))) {
            if (sb.length() != 0) {
                sb.append(" " + AND + " ");
            }
            sb.append("( " + specificMediaLimit + " )");
        }
        if (!CollectionUtils.isEmpty(criteria.getMediaTypeLimit())) {
            if (sb.length() != 0) {
                sb.append(" " + AND + " ");
            }
            sb.append(this.generateMediaTypeLimit(criteria.getMediaTypeLimit()));
        }
        if (!CollectionUtils.isEmpty(criteria.getCollectionLimit())) {
            if (sb.length() != 0) {
                sb.append(" " + AND + " ");
            }
            sb.append(this.generateCollectionLimit(criteria.getCollectionLimit()));
        }
        String generatedQueryString = sb.toString();
        log.info((Object)("generatedQueryString = " + generatedQueryString));
        return generatedQueryString;
    }

    public String generateRestrictionQuery(MediaSearchCriteria criteria) {
        boolean isSuperAdmin = false;
        try {
            Subject subject = SecurityUtils.getSubject();
            isSuperAdmin = subject.hasRole(PermissionManager.getRoleSuperAdmin());
        }
        catch (Exception e) {
            log.error((Object)"No subject obtained");
        }
        if (isSuperAdmin) {
            return "";
        }
        String filterQuery = "(*:* AND -_luna_record_restricted_to:*)";
        Authenticable authenticable = criteria.getAuthenticable();
        if (authenticable != null) {
            String username;
            int credId = authenticable.getCredentialsId();
            filterQuery = filterQuery + " OR ( *:* AND _luna_record_restricted_to:" + credId + ")";
            if (authenticable instanceof User && (username = ((User)authenticable).getUsername()) != null) {
                filterQuery = filterQuery + " OR ( *:* AND _luna_record_restricted_to:" + username + ")";
                filterQuery = filterQuery + " OR ( *:* AND _luna_collection_owner:" + username + ")";
            }
        }
        log.info((Object)("restriction query = " + filterQuery));
        return filterQuery;
    }

    protected String facetQueryString(MediaSearchCriteria criteria) {
        StringBuilder sb = new StringBuilder();
        List<W4SearchFieldValue> w4SearchFieldValueList = criteria.getW4SearchFieldValue();
        if (w4SearchFieldValueList != null) {
            for (W4SearchFieldValue w4fv : w4SearchFieldValueList) {
                String temp = this.w4SearchFieldValue(w4fv, criteria.isW4FilteredSearch());
                sb.append(sb.length() == 0 ? temp : " " + AND + " " + temp);
            }
        }
        log.debug((Object)("w4FieldQueryString: " + sb.toString()));
        return sb.toString();
    }

    protected String w4SearchFieldValue(W4SearchFieldValue w4fv, boolean isW4FilteredSearch) {
        StringBuilder sb = new StringBuilder();
        MediaField.W4Type type = w4fv.getW4Field();
        List<SearchValue> searchValueList = w4fv.getSearchValues();
        for (SearchValue sv : searchValueList) {
            String facetQuery = "_luna_" + type.toString().toLowerCase() + (isW4FilteredSearch ? "" : "_text") + ":\"" + sv.getValue() + "\"";
            log.debug((Object)facetQuery);
            sb.append(sb.length() == 0 ? facetQuery : " " + AND + " " + facetQuery);
        }
        return sb.toString();
    }

    protected String generateCollectionLimit(List<MediaCollection> collections) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(collections)) {
            sb.append("( ");
            for (MediaCollection mc : collections) {
                if (mc == null) continue;
                sb.append(LuceneDocumentFactory.LuceneAttribute.mediaCollectionId.getAttributeName() + ":\"" + mc.getId().replaceAll("\\~", "\\\\~") + "\" ");
                if (mc.equals(collections.get(collections.size() - 1))) continue;
                sb.append(OR + " ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    protected String generateMediaTypeLimit(List<Media.MediaType> mediaTypes) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            sb.append("( ");
            for (Media.MediaType mt : mediaTypes) {
                if (mt == null) continue;
                sb.append(LuceneDocumentFactory.LuceneAttribute.mediaType.getAttributeName() + ":\"" + mt.toString() + "\" ");
                if (mt.equals((Object)mediaTypes.get(mediaTypes.size() - 1))) continue;
                sb.append(OR + " ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    protected String generateSpecificMediaLimit(List ids) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            for (Object id : ids) {
                if (!(id instanceof String) || !InsightCoreUtils.isValidLunaMediaIdFormat((String)id)) continue;
                if (sb.length() != 0) {
                    sb.append(" " + OR + " ");
                }
                sb.append("\"" + this.preValueForLucene((String)id) + "\"");
            }
            if (sb.length() != 0) {
                sb.insert(0, LuceneDocumentFactory.LuceneAttribute.id.name() + "_sortable:(");
                sb.append(" )");
            }
        }
        String query = sb.toString();
        log.debug((Object)("generateSpecificMediaLimit(..): query = " + query));
        return query;
    }

    protected String generateFieldValue(SearchFieldValue fieldValue, MediaSearchCriteria criteria) {
        String toReturn = "";
        if (fieldValue instanceof W4SearchFieldValue) {
            toReturn = this.generateW4FieldValue((W4SearchFieldValue)fieldValue, criteria);
        } else if (fieldValue.getField().equals(LuceneDocumentFactory.LuceneAttribute.mediaCollectionId.getAttributeName())) {
            toReturn = LuceneDocumentFactory.LuceneAttribute.mediaCollectionId.getAttributeName() + ":\"" + fieldValue.getSearchValues().get(0).toString().replaceAll("\\~", "\\\\~") + "\" ";
        } else if (fieldValue instanceof AnnotationSearchFieldValue) {
            List<SearchValue> searchValues = fieldValue.getSearchValues();
            if (fieldValue instanceof AnnotationSearchFieldValue) {
                ArrayList<SearchValue> fuzziedSearchValues = new ArrayList<SearchValue>();
                for (SearchValue sv : searchValues) {
                    SearchValue fsv = (SearchValue)SerializationUtils.clone((Serializable)sv);
                    if (sv.getValue().matches("^[^~]+~[0-9]+$")) {
                        String value = StringUtils.replace((String)sv.getValue(), (String)"~", (String)"0x7e");
                        fsv.setValue(value);
                    }
                    fuzziedSearchValues.add(fsv);
                }
                searchValues = fuzziedSearchValues;
                toReturn = AnnotationSearchFieldValue.getAnnotationSearchFields().contains(fieldValue.getField()) ? fieldValue.getField() + ":\"" + StringUtils.join(searchValues, (String)" ") + "\" " : (searchValues != null && searchValues.size() == 1 && StringUtils.equals((String)searchValues.get(0).getValue(), (String)"*") ? "" : AnnotationSearchFieldValue.ANNOTATION_SEARCH_FIELD + ":\"" + StringUtils.join(searchValues, (String)" ") + "\" ");
            }
        } else {
            List<SearchValue> searchValues = fieldValue.getSearchValues();
            toReturn = this.generateFieldValue(criteria.getMediaField(fieldValue.getField()), searchValues, fieldValue.getOperator(), criteria);
        }
        return toReturn;
    }

    protected String generateW4FieldValue(W4SearchFieldValue fieldValue, MediaSearchCriteria criteria) {
        StringBuilder sb = new StringBuilder();
        MediaField.W4Type type = fieldValue.getW4Field();
        List<MediaField> mediaFields = this.getMediaFields(criteria.getCollectionLimit());
        for (MediaField mediaField : mediaFields) {
            String generatedFieldValue;
            if (mediaField.getType() != type || !StringUtils.isNotEmpty((String)(generatedFieldValue = this.generateFieldValue(mediaField, fieldValue.getSearchValues(), fieldValue.getOperator(), criteria)))) continue;
            if (sb.length() != 0) {
                sb.append(" " + OR + " ");
            }
            sb.append(generatedFieldValue);
        }
        if (sb.length() > 0) {
            sb.insert(0, "( ");
            sb.append(" )");
        }
        return sb.toString();
    }

    protected String derivePrefix(SearchValue ssv, SearchFieldValue.Operator operator) {
        String prefix = "";
        if (ssv != null) {
            if (ssv instanceof SearchStringValue && ((SearchStringValue)ssv).isPhrase()) {
                prefix = "\"";
            } else {
                switch (operator) {
                    case EQUALS: {
                        prefix = "";
                        break;
                    }
                    case CONTAINS: {
                        prefix = "";
                        break;
                    }
                    case STARTS_WITH: {
                        prefix = "";
                    }
                }
            }
        }
        return prefix;
    }

    protected String deriveSuffix(SearchValue ssv, SearchFieldValue.Operator operator) {
        String suffix = "";
        if (ssv != null) {
            if (ssv instanceof SearchStringValue && ((SearchStringValue)ssv).isPhrase()) {
                suffix = "\"~0";
            } else {
                switch (operator) {
                    case EQUALS: {
                        suffix = "";
                        break;
                    }
                    case CONTAINS: {
                        if (ssv instanceof SearchStringValue && !((SearchStringValue)ssv).isPhrase()) {
                            suffix = "";
                            break;
                        }
                        suffix = "~" + this.proximitySearchRange;
                        break;
                    }
                    case STARTS_WITH: {
                        suffix = "*";
                    }
                }
            }
        }
        return suffix;
    }

    protected String generateFieldValue(MediaField field, List<SearchValue> values, SearchFieldValue.Operator operator, MediaSearchCriteria criteria) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(values)) {
            ArrayList<String> stringValues = new ArrayList<String>();
            boolean isPhrase = false;
            for (SearchValue sv : values) {
                if (sv instanceof SearchDateRangeValue) {
                    String start = "";
                    String end = "";
                    try {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        Date dateStart = ((SearchDateRangeValue)sv).getStart();
                        df.setTimeZone(TimeZone.getTimeZone("UTC"));
                        start = df.format(dateStart);
                        Date dateEnd = ((SearchDateRangeValue)sv).getEnd();
                        df.setTimeZone(TimeZone.getTimeZone("UTC"));
                        end = df.format(dateEnd);
                    }
                    catch (Exception e) {
                        log.debug((Object)("generateFieldValue(): " + e.getMessage()));
                        e.printStackTrace();
                    }
                    String temp = "[" + start + " " + TO + " " + end + "]";
                    if (((SearchDateRangeValue)sv).getStart() == null || ((SearchDateRangeValue)sv).getEnd() == null) continue;
                    stringValues.add(temp);
                    continue;
                }
                if (field != null && !(sv instanceof SearchStringValue)) continue;
                String prefix = this.derivePrefix(sv, operator);
                String suffix = this.deriveSuffix(sv, operator);
                String value = prefix + sv.getValue() + suffix;
                if (!sv.equals(values.get(values.size() - 1))) {
                    value = value + " " + (Object)((Object)sv.getCondition()) + " ";
                }
                if (((SearchStringValue)sv).isPhrase()) {
                    isPhrase = true;
                }
                if (isPhrase && field != null && field.isDateField()) {
                    isPhrase = false;
                }
                stringValues.add(value);
            }
            if (CollectionUtils.isNotEmpty(stringValues)) {
                String searchTerm = this.constrcutSearchTerm(field, stringValues, isPhrase);
                sb.append(searchTerm);
            }
        } else if (!CollectionUtils.isEmpty(values) && sb.length() > 0) {
            sb.insert(0, "( ");
            sb.append(" )");
        }
        return sb.toString();
    }

    protected String constrcutSearchTerm(MediaField mf, List<String> stringValues, boolean isPhrase) {
        int i;
        StringBuilder sb = new StringBuilder();
        boolean isWildCardSearch = false;
        for (i = 0; i < stringValues.size(); ++i) {
            if (!this.isWildCardSearch(stringValues.get(i))) continue;
            isWildCardSearch = true;
            stringValues.set(i, stringValues.get(i).toLowerCase());
        }
        if (mf != null && mf instanceof FullTexIndexField) {
            sb.append("fullTextSearchField:");
            sb.append("(" + ParsingUtils.toDelimitedString(stringValues, "", " ") + ")");
        } else if (mf != null && mf instanceof DefaultDateField) {
            sb.append("defaultDateField:");
            sb.append("(" + ParsingUtils.toDelimitedString(stringValues, "", " ") + ")");
        } else if (mf == null) {
            sb.append("simpleSearchField:");
            if (!isWildCardSearch && !isPhrase) {
                for (i = 0; i < stringValues.size(); ++i) {
                    stringValues.set(i, ParsingUtils.escapeQueryChars(stringValues.get(i)));
                }
            }
            sb.append("(" + ParsingUtils.toDelimitedString(stringValues, "", " ") + ")");
        } else if (this.isRangeSearch(ParsingUtils.toDelimitedString(stringValues, "", " "))) {
            String luceneFieldName = this.prepFieldNameForLucene(mf.getFieldName());
            if (!"_processedDateMilli".equals(luceneFieldName)) {
                luceneFieldName = luceneFieldName + "_dt";
            }
            sb.append(luceneFieldName + ":");
            sb.append(ParsingUtils.toDelimitedString(stringValues, "", " "));
        } else {
            sb.append(this.prepFieldNameForLucene(mf.getFieldName()) + (isPhrase && this.strFieldForExactMatch ? "_s" : (isWildCardSearch ? PublisherMedia._SORTABLE : "")) + ":");
            sb.append("(" + ParsingUtils.toDelimitedString(stringValues, "", " ") + ")");
        }
        return sb.toString();
    }

    protected MediaField getProperField(String fieldName, Collection<MediaField> mediaFields) {
        MediaField toReturn = null;
        for (MediaField mf : mediaFields) {
            if (mf == null || !StringUtils.equalsIgnoreCase((String)fieldName, (String)mf.getFieldName()) && !StringUtils.equalsIgnoreCase((String)fieldName, (String)mf.getDisplayName())) continue;
            toReturn = mf;
            break;
        }
        if (toReturn == null) {
            log.info((Object)("Unable to locate media field [" + fieldName + "] in " + mediaFields));
        }
        return toReturn;
    }

    protected List<MediaField> getMediaFields(List<MediaCollection> mcs) {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        if (!CollectionUtils.isEmpty(mcs)) {
            for (MediaCollection mc : mcs) {
                if (mc == null || mc.getMediaFields() == null) continue;
                toReturn.addAll(mc.getMediaFields());
            }
        }
        return toReturn;
    }

    protected String preValueForLucene(String value) {
        value = QueryParser.escape((String)value);
        return value;
    }

    protected String prepFieldNameForLucene(String fieldName) {
        fieldName = QueryParser.escape((String)fieldName);
        return fieldName;
    }

    protected boolean isRangeSearch(String value) {
        Matcher m = this.RANGE_OPERATOR_DEFINITION.matcher(value);
        return m.find();
    }

    protected boolean isWildCardSearch(String value) {
        if (value != null) {
            return value.contains("*") || value.contains("?");
        }
        return false;
    }

    public void setStrFieldForExactMatch(boolean strFieldForExactMatch) {
        this.strFieldForExactMatch = strFieldForExactMatch;
    }
}

