/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.search.Result;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class LuceneResult
implements Result {
    protected int docId;
    protected Map<String, Object> attributes;
    protected List<String> displayAttributeNames;
    protected String descriptionField;

    public LuceneResult(int docId) {
        this.setDocId(docId);
        this.attributes = new HashMap<String, Object>();
        this.displayAttributeNames = new ArrayList<String>();
    }

    public LuceneResult() {
        this(0);
    }

    @Override
    public Object getIdentity() {
        return this.attributes.get(LuceneDocumentFactory.LuceneAttribute.id.getAttributeName());
    }

    public Object getId() {
        return this.attributes == null ? null : this.attributes.get("id");
    }

    @Override
    public String getDisplayName() {
        Object obj = ParsingUtils.getIgnoreCase(this.attributes, this.displayAttributeNames);
        String toReturn = "";
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            for (String s : list) {
                if (toReturn.length() > 0) {
                    toReturn = toReturn + ", ";
                }
                toReturn = toReturn + s;
            }
        }
        return toReturn;
    }

    @Override
    public String getDescription() {
        if (this.attributes.containsKey(this.descriptionField)) {
            return (String)this.attributes.get(this.descriptionField);
        }
        return "";
    }

    public String getDescriptionField() {
        return this.descriptionField;
    }

    public void setDescriptionField(String descriptionField) {
        this.descriptionField = descriptionField;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public void putAttribute(String field, String value) {
        if (!this.attributes.containsKey(field)) {
            this.attributes.put(field, value);
        } else {
            Object existingVal = this.attributes.get(field);
            if (existingVal instanceof List) {
                ((List)existingVal).add(value);
                this.attributes.put(field, existingVal);
            } else if (existingVal instanceof String) {
                ArrayList<String> l = new ArrayList<String>();
                l.add((String)existingVal);
                l.add(value);
                this.attributes.put(field, l);
            }
        }
    }

    public void removeAttribute(String field) {
        if (this.attributes != null) {
            this.attributes.remove(field);
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public List<String> getDisplayAttributeNames() {
        return this.displayAttributeNames;
    }

    public void setDisplayAttributeNames(List<String> displayAttributeNames) {
        if (displayAttributeNames != null) {
            this.displayAttributeNames = displayAttributeNames;
        }
    }

    public void setDisplayAttributeNames(String[] displayAttributeNames) {
        if (displayAttributeNames != null) {
            this.setDisplayAttributeNames(CollectionUtils.arrayToList((Object)displayAttributeNames));
        }
    }

    public boolean equals(Object o) {
        return o instanceof LuceneResult && this.getIdentity().equals(((LuceneResult)o).getIdentity());
    }

    public String toString() {
        return "LuceneResult[" + this.getIdentity() + "]";
    }
}

