/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.search.MediaResult;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.MediaSearchResult;
import com.lunaimaging.insight.core.domain.search.Result;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneMediaResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchResult;
import java.util.List;

public class LuceneMediaSearchResult
extends MediaSearchResult {
    protected int maximumSearchResults;

    public LuceneMediaSearchResult(List<MediaResult> results) {
        super(results);
    }

    public LuceneMediaSearchResult() {
    }

    public LuceneMediaSearchResult(LuceneSearchResult lsr) {
        if (lsr != null) {
            this.setMaximumSearchResults(lsr.getMaximumSearchResults());
            this.setResultIds(lsr.getResultIds());
            this.results = lsr.getResults();
            this.totalNumberOfResults = lsr.getTotalNumberOfResults();
        }
    }

    @Override
    public void addAll(List<? extends Result> results) {
        if (results == null) {
            super.addAll(results);
        } else {
            for (Result result : results) {
                this.add(result);
            }
        }
    }

    @Override
    public void add(Result result) {
        if (result != null && result instanceof LuceneMediaResult) {
            ((LuceneMediaResult)result).setFieldValues(this.searchCriteria.getCollectionLimit());
        }
        super.add(result);
    }

    public int getMaximumSearchResults() {
        return this.maximumSearchResults;
    }

    public void setMaximumSearchResults(int maximumSearchResults) {
        this.maximumSearchResults = maximumSearchResults;
    }

    @Override
    public void setSearchCriteria(MediaSearchCriteria searchCriteria) {
        super.setSearchCriteria(searchCriteria);
        this.setMediaFields();
    }

    public void setMediaFields() {
        for (MediaResult result : this.results) {
            if (result == null || !(result instanceof LuceneMediaResult)) continue;
            LuceneMediaResult lr = (LuceneMediaResult)result;
            lr.setDisplayAttributeNames(this.getDisplayAttributeNames());
            lr.setFieldValues(this.searchCriteria.getCollectionLimit());
        }
    }
}

