/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.search.AnnotationSearchFieldValue;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.SearchDateRangeValue;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchStringValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import com.lunaimaging.insight.core.domain.search.W4SearchFieldValue;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.solr.common.SolrDocument;

public class LuceneMediaSearchCriteriaParser {
    protected static Log log = LogFactory.getLog(LuceneMediaSearchCriteriaParser.class);
    protected static final int LUCENE_MAX_BOOLEAN_CLASES = 5000;
    protected static final float FUZZY_SEARCH_SLOP = 0.82f;
    protected static final Pattern DECIMAL_PATTER = Pattern.compile("[0-9]+\\.[0-9]+");
    protected static final Pattern EXTENSION_PATTER = Pattern.compile("^.*\\.[a-zA-Z]{3,4}$");
    protected static final String[] LUCENE_RESERVED_WORDS_DELIMETERS = new String[]{"\\+", "\\-", "~", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", ":", "\\\\", " ", "_\\."};
    protected static final String[] LUCENE_RESERVED_WORDS_DELIMETERS2 = new String[]{"\\+", "_", "~", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", ":", "\\\\", " ", "\\-", "\\."};
    protected static final String[] LUCENE_RESERVED_CHARACTER_IGNORE = new String[]{"!", "^", "\"", "*", "?", "&", ". ", ",", "."};
    protected static final String[] LUCENE_RESERVED_WORDS_IGNORE = new String[]{"a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    protected static final String[] LUCENE_IGNORE_SUFFIX = new String[]{"."};
    protected static final String[] LUCENE_IGNORE_PREFIX = new String[]{"."};
    protected static LuceneMediaSearchCriteriaParser instance;

    protected LuceneMediaSearchCriteriaParser() {
    }

    public static synchronized LuceneMediaSearchCriteriaParser getInstance() {
        if (instance == null) {
            instance = new LuceneMediaSearchCriteriaParser();
        }
        return instance;
    }

    public List<String> getSortFieldNames(MediaSearchCriteria criteria, SolrDocument docForSortableField) {
        ArrayList<String> sortFieldNames = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(criteria.getSortFields())) {
            for (int i = 0; i < criteria.getSortFields().size(); ++i) {
                MediaField mediaField = criteria.getSortFields().get(i);
                String sortableFieldName = mediaField.getFieldName();
                sortableFieldName = mediaField.getFieldType() == 2 ? sortableFieldName + "_i" : sortableFieldName + "_sortable";
                if (docForSortableField != null && (docForSortableField == null || docForSortableField.getFieldValueMap().get(sortableFieldName) == null)) continue;
                sortFieldNames.add(sortableFieldName);
            }
        }
        return sortFieldNames;
    }

    public Sort getSort(MediaSearchCriteria criteria, Document docFor_sortableField) {
        Sort sort = null;
        Object[] sortFields = null;
        ArrayList<SortField> alist = new ArrayList<SortField>();
        if (!CollectionUtils.isEmpty(criteria.getSortFields())) {
            if (!criteria.getSortByRequest()) {
                List<MediaField> list = criteria.getSortFields();
                Collections.sort(list);
            }
            for (int i = 0; i < criteria.getSortFields().size(); ++i) {
                MediaField mediaField = criteria.getSortFields().get(i);
                String _sortableFieldName = mediaField.getFieldName() + "_sortable";
                if (docFor_sortableField == null || docFor_sortableField.getField(_sortableFieldName) == null) continue;
                alist.add(new SortField(_sortableFieldName, SortField.Type.STRING));
            }
        }
        sortFields = new SortField[alist.size()];
        if (!ArrayUtils.isEmpty((Object[])(sortFields = alist.toArray(sortFields)))) {
            sort = new Sort((SortField[])sortFields);
        }
        return sort;
    }

    public Query parse(MediaSearchCriteria criteria) throws InvalidParameterException, ParseException {
        Query toReturn = null;
        if (criteria == null) {
            throw new InvalidParameterException("MediaSearchCritera cannot be null!");
        }
        if (CollectionUtils.isEmpty(criteria.getMediaFields())) {
            throw new InvalidParameterException("MediaSearchCritera contains no media fields!");
        }
        if (BooleanQuery.getMaxClauseCount() < 5000) {
            BooleanQuery.setMaxClauseCount((int)5000);
        }
        log.info((Object)(Thread.currentThread() + " Before parse: " + new Date()));
        toReturn = this.generateQuery(criteria);
        log.info((Object)(Thread.currentThread() + " 2Before parse: " + new Date()));
        return toReturn;
    }

    protected Query generateQuery(MediaSearchCriteria criteria) {
        Query q;
        BooleanQuery toReturn = new BooleanQuery();
        Query fieldedSearch = this.generateFieldValues(criteria);
        if (fieldedSearch != null) {
            toReturn.add(fieldedSearch, BooleanClause.Occur.MUST);
        }
        ArrayList<String> specificMedia = new ArrayList<String>();
        if (criteria.getMediaGroup() != null && CollectionUtils.isNotEmpty((Collection)criteria.getMediaGroup().getMediaIds())) {
            specificMedia.addAll(criteria.getMediaGroup().getMediaIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)criteria.getSpecificMediaIds())) {
            specificMedia.addAll(criteria.getSpecificMediaIds());
        }
        if ((q = this.generateSpecificMediaIdQuery(specificMedia)) != null) {
            toReturn.add(q, BooleanClause.Occur.MUST);
        }
        if ((q = this.generateLimitByTypeQuery(criteria.getMediaTypeLimit())) != null) {
            toReturn.add(q, BooleanClause.Occur.MUST);
        }
        if ((q = this.generateLimitByCollectionQuery(criteria.getCollectionLimit())) != null) {
            toReturn.add(q, BooleanClause.Occur.MUST);
        }
        return toReturn;
    }

    protected Query generateLimitByCollectionQuery(List<MediaCollection> mcs) {
        BooleanQuery toReturn = null;
        if (CollectionUtils.isNotEmpty(mcs)) {
            toReturn = new BooleanQuery();
            for (MediaCollection mc : mcs) {
                if (mc == null || mc.getId() == null) continue;
                Term[] terms = this.generateTerms(LuceneDocumentFactory.LuceneAttribute.mediaCollectionId.name(), mc.getId(), LUCENE_RESERVED_WORDS_DELIMETERS, LUCENE_RESERVED_CHARACTER_IGNORE);
                PhraseQuery q = this.constructPhraseQuery(terms);
                toReturn.add((Query)q, BooleanClause.Occur.SHOULD);
            }
        }
        return toReturn;
    }

    protected Query generateLimitByTypeQuery(List<Media.MediaType> mediaTypes) {
        BooleanQuery toReturn = null;
        if (CollectionUtils.isNotEmpty(mediaTypes)) {
            toReturn = new BooleanQuery();
            for (Media.MediaType mt : mediaTypes) {
                toReturn.add((Query)new TermQuery(new Term(LuceneDocumentFactory.LuceneAttribute.mediaType.name(), mt.name())), BooleanClause.Occur.SHOULD);
            }
        }
        return toReturn;
    }

    protected Query generateSpecificMediaIdQuery(List<String> mediaIds) {
        BooleanQuery toReturn = null;
        if (CollectionUtils.isNotEmpty(mediaIds)) {
            toReturn = new BooleanQuery();
            for (String mediaId : mediaIds) {
                Term[] terms = this.generateTerms(LuceneDocumentFactory.LuceneAttribute.id.name(), mediaId, LUCENE_RESERVED_WORDS_DELIMETERS, LUCENE_RESERVED_CHARACTER_IGNORE);
                PhraseQuery q = this.constructPhraseQuery(terms);
                toReturn.add((Query)q, BooleanClause.Occur.SHOULD);
            }
        }
        return toReturn;
    }

    protected Query generateFieldValues(MediaSearchCriteria criteria) {
        BooleanQuery toReturn = null;
        List<SearchFieldValue> searchFieldValues = criteria.getSearchFieldValues();
        if (!criteria.isW4FilteredSearch()) {
            searchFieldValues.addAll(criteria.getW4SearchFieldValue());
        }
        if (CollectionUtils.isNotEmpty(searchFieldValues)) {
            toReturn = new BooleanQuery();
            for (SearchFieldValue fieldValue : searchFieldValues) {
                if (CollectionUtils.isEmpty(fieldValue.getSearchValues())) continue;
                toReturn.add(this.generateFieldValue(fieldValue, criteria), this.getBooleanClause(fieldValue.getCondition()));
            }
        }
        return toReturn;
    }

    protected Query generateFieldValue(SearchFieldValue fieldValue, MediaSearchCriteria criteria) {
        Query toReturn = null;
        if (fieldValue instanceof W4SearchFieldValue) {
            toReturn = this.generateW4FieldValue((W4SearchFieldValue)fieldValue, criteria);
        } else {
            List<SearchValue> searchValues = fieldValue.getSearchValues();
            if (fieldValue instanceof AnnotationSearchFieldValue) {
                ArrayList<SearchValue> fuzziedSearchValues = new ArrayList<SearchValue>();
                for (SearchValue sv : searchValues) {
                    SearchValue fsv = (SearchValue)SerializationUtils.clone((Serializable)sv);
                    if (sv.getValue().matches("^[^~]+~[0-9]+$")) {
                        String value = StringUtils.replace((String)sv.getValue(), (String)"~", (String)"0x7e");
                        fsv.setValue(value);
                    }
                    fuzziedSearchValues.add(fsv);
                }
                searchValues = fuzziedSearchValues;
            }
            toReturn = this.generateFieldValue(criteria.getMediaField(fieldValue.getField()), searchValues, fieldValue.getOperator(), criteria);
        }
        return toReturn;
    }

    protected Query generateFieldValue(MediaField field, List<SearchValue> values, SearchFieldValue.Operator operator, MediaSearchCriteria criteria) {
        BooleanQuery toReturn = new BooleanQuery();
        if (!CollectionUtils.isEmpty(values)) {
            for (SearchValue sv : values) {
                Query query;
                if ((field == null || !field.isDateField()) && sv instanceof SearchStringValue) {
                    SearchStringValue ssv = (SearchStringValue)sv;
                    switch (operator) {
                        case EQUALS: {
                            query = this.constructTermQuery(field, ssv);
                            if (query == null) break;
                            toReturn.add(query, this.getBooleanClause(sv.getCondition()));
                            break;
                        }
                        case CONTAINS: {
                            query = this.constrcutFuzzyQuery(field, ssv);
                            if (query == null) break;
                            toReturn.add(query, this.getBooleanClause(sv.getCondition()));
                            break;
                        }
                        case STARTS_WITH: {
                            query = this.constrcutPrefixQuery(field, ssv);
                            if (query == null) break;
                            toReturn.add(query, this.getBooleanClause(sv.getCondition()));
                        }
                    }
                    continue;
                }
                if (field != null && !field.isDateField() || !(sv instanceof SearchDateRangeValue) || ((SearchDateRangeValue)sv).getStart() == null || ((SearchDateRangeValue)sv).getEnd() == null) continue;
                if (field != null) {
                    toReturn.add((Query)TermRangeQuery.newStringRange((String)this.getProperFieldName(field), (String)DateTools.dateToString((Date)((SearchDateRangeValue)sv).getStart(), (DateTools.Resolution)DateTools.Resolution.YEAR), (String)DateTools.dateToString((Date)((SearchDateRangeValue)sv).getEnd(), (DateTools.Resolution)DateTools.Resolution.YEAR), (boolean)true, (boolean)true), this.getBooleanClause(sv.getCondition()));
                    continue;
                }
                query = this.constructTermQuery(field, sv);
                if (query == null) continue;
                toReturn.add(query, this.getBooleanClause(sv.getCondition()));
            }
        } else if (!CollectionUtils.isEmpty(values)) {
            log.error((Object)("Error generating Lucene query, no values given!: " + values));
        }
        return toReturn;
    }

    protected Query generateW4FieldValue(W4SearchFieldValue fieldValue, MediaSearchCriteria criteria) {
        BooleanQuery toReturn = new BooleanQuery();
        MediaField.W4Type type = fieldValue.getW4Field();
        List<MediaField> mediaFields = this.getMediaFields(criteria.getCollectionLimit());
        for (MediaField mediaField : mediaFields) {
            if (mediaField.getType() != type) continue;
            toReturn.add(this.generateFieldValue(mediaField, fieldValue.getSearchValues(), fieldValue.getOperator(), criteria), BooleanClause.Occur.SHOULD);
        }
        return toReturn;
    }

    protected BooleanClause.Occur getBooleanClause(SearchFieldValue.Condition condition) {
        switch (condition) {
            case AND: {
                return BooleanClause.Occur.MUST;
            }
            case OR: {
                return BooleanClause.Occur.SHOULD;
            }
        }
        return BooleanClause.Occur.SHOULD;
    }

    protected String getProperFieldName(MediaField mf) {
        String toReturn = "simpleSearchField";
        if (mf != null && StringUtils.isNotEmpty((String)mf.getFieldName()) && (toReturn = mf.getFieldName()).equalsIgnoreCase("AmicoID")) {
            toReturn = toReturn.toUpperCase();
        }
        return toReturn;
    }

    protected List<MediaField> getMediaFields(List<MediaCollection> mcs) {
        ArrayList<MediaField> toReturn = new ArrayList<MediaField>();
        if (!CollectionUtils.isEmpty(mcs)) {
            for (MediaCollection mc : mcs) {
                if (mc == null || mc.getMediaFields() == null) continue;
                toReturn.addAll(mc.getMediaFields());
            }
        }
        return toReturn;
    }

    protected Term[] generateTerms(MediaField field, String value, String[] delimeters, String[] ignoreWords) {
        return this.generateTerms(this.getProperFieldName(field), value, delimeters, ignoreWords);
    }

    protected Term[] generateTerms(String fieldName, String value, String[] delimeters, String[] ignoreWords) {
        ArrayList<Term> terms = new ArrayList<Term>();
        Term term = new Term(fieldName, "");
        Matcher decimalMatcher = DECIMAL_PATTER.matcher(value);
        if (decimalMatcher.matches()) {
            terms.add(new Term(fieldName, value.trim()));
        } else {
            String[] parts;
            for (String part : parts = ParsingUtils.splitIgnoreCaseTrim(value, delimeters)) {
                if (!StringUtils.isNotEmpty((String)part)) continue;
                part = ParsingUtils.repacePrefix(LUCENE_IGNORE_PREFIX, part, "");
                decimalMatcher = DECIMAL_PATTER.matcher(part);
                Matcher extentionMatcher = EXTENSION_PATTER.matcher(part);
                if (decimalMatcher.matches() || extentionMatcher.matches()) {
                    terms.add(new Term(fieldName, part.toLowerCase().trim()));
                    continue;
                }
                part = ParsingUtils.replace(ignoreWords, part, "");
                if (!StringUtils.isNotEmpty((String)(part = ParsingUtils.repaceSuffix(LUCENE_IGNORE_SUFFIX, part, ""))) || ParsingUtils.equalsIgnoreCase(part, LUCENE_RESERVED_WORDS_IGNORE)) continue;
                terms.add(new Term(fieldName, part.toLowerCase().trim()));
            }
        }
        return terms.toArray(new Term[0]);
    }

    protected PhraseQuery constructPhraseQuery(MediaField field, SearchStringValue ssv) {
        Object[] terms;
        PhraseQuery toReturn = null;
        if (ssv != null && !ArrayUtils.isEmpty((Object[])(terms = this.generateTerms(field, ssv.getStringValue(), LUCENE_RESERVED_WORDS_DELIMETERS, LUCENE_RESERVED_CHARACTER_IGNORE)))) {
            toReturn = this.constructPhraseQuery((Term[])terms);
        }
        return toReturn;
    }

    protected PhraseQuery constructPhraseQuery(Term[] terms) {
        PhraseQuery toReturn = null;
        if (!ArrayUtils.isEmpty((Object[])terms)) {
            toReturn = new PhraseQuery();
            for (Term t : terms) {
                toReturn.add(t);
            }
        }
        return toReturn;
    }

    protected Query constructTermQuery(MediaField field, SearchValue sv) {
        PhraseQuery toReturn = null;
        if (sv != null) {
            Term[] terms = this.generateTerms(field, sv.getValue(), LUCENE_RESERVED_WORDS_DELIMETERS, LUCENE_RESERVED_CHARACTER_IGNORE);
            if (sv instanceof SearchStringValue && ((SearchStringValue)sv).isPhrase()) {
                toReturn = this.constructPhraseQuery(terms);
            } else if (terms.length == 1) {
                toReturn = new TermQuery(terms[0]);
            } else if (terms.length > 1) {
                toReturn = this.constructPhraseQuery(terms);
            }
        }
        return toReturn;
    }

    protected Query constructRangeQuery(MediaField field, SearchValue sv) {
        Query toReturn = null;
        if (sv instanceof SearchStringValue && ((SearchStringValue)sv).isPhrase()) {
            Term term = new Term(this.getProperFieldName(field), sv.getValue());
            toReturn = TermRangeQuery.newStringRange((String)this.getProperFieldName(field), (String)term.text(), (String)term.text(), (boolean)true, (boolean)true);
        } else {
            toReturn = this.constructTermQuery(field, sv);
        }
        return toReturn;
    }

    protected Query constrcutFuzzyQuery(MediaField field, SearchStringValue ssv) {
        PhraseQuery toReturn = null;
        if (ssv != null) {
            Term[] terms = this.generateTerms(field, ssv.getStringValue(), LUCENE_RESERVED_WORDS_DELIMETERS, LUCENE_RESERVED_CHARACTER_IGNORE);
            if (ssv.isPhrase()) {
                toReturn = this.constructPhraseQuery(terms);
            } else if (terms.length == 1) {
                toReturn = new FuzzyQuery(terms[0]);
            } else if (terms.length > 1) {
                BooleanQuery bq = new BooleanQuery();
                for (Term term : terms) {
                    bq.add((Query)new FuzzyQuery(term), BooleanClause.Occur.SHOULD);
                }
                toReturn = bq;
            }
        }
        return toReturn;
    }

    protected Query constrcutPrefixQuery(MediaField field, SearchStringValue ssv) {
        PhraseQuery toReturn = null;
        if (ssv != null) {
            Term[] terms = this.generateTerms(field, ssv.getStringValue(), LUCENE_RESERVED_WORDS_DELIMETERS, LUCENE_RESERVED_CHARACTER_IGNORE);
            if (ssv.isPhrase()) {
                toReturn = this.constructPhraseQuery(terms);
            } else if (terms.length == 1) {
                toReturn = new PrefixQuery(terms[0]);
            } else if (terms.length > 1) {
                BooleanQuery bq = new BooleanQuery();
                for (Term term : terms) {
                    bq.add((Query)new PrefixQuery(term), BooleanClause.Occur.SHOULD);
                }
                toReturn = bq;
            }
        }
        return toReturn;
    }
}

