/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.domain.search.MediaResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneResult;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.security.permission.PermissionManager;
import com.lunaimaging.security.util.SubjectUtils;
import com.techempower.ReflectiveComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.util.CollectionUtils;

public class LuceneMediaResult
extends LuceneResult
implements MediaResult {
    protected List<MediaFieldValue> fieldValues;
    protected List<MediaFieldValue> summaryFieldValues;
    protected List<MediaFieldValue> previewFieldValues;
    protected List<MediaFieldValue> relatedItemFieldValues;
    protected String iiifManifest;
    public static final String RESTRICTED_ICON_URL = "/luna/images/luna-media-icons/restricted-thumbnail.gif";

    public LuceneMediaResult(int docId) {
        super(docId);
    }

    public LuceneMediaResult() {
        this(0);
    }

    @Override
    public List<MediaFieldValue> getSummaryFieldValues() {
        return this.summaryFieldValues;
    }

    @Override
    public List<MediaFieldValue> getPreviewFieldValues() {
        return this.previewFieldValues;
    }

    public List<MediaFieldValue> getRelatedItemFieldValues() {
        return this.relatedItemFieldValues;
    }

    @Override
    public List<MediaFieldValue> getFieldValues() {
        return this.fieldValues;
    }

    private MediaCollection getMediaCollection(List<MediaCollection> mcs) {
        MediaCollection toReturn = null;
        if (mcs != null) {
            String mediaCollectionId = (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.mediaCollectionId.getAttributeName());
            for (MediaCollection mc : mcs) {
                if (mc == null || !StringUtils.equalsIgnoreCase((String)mc.getId(), (String)mediaCollectionId)) continue;
                toReturn = mc;
                break;
            }
        }
        return toReturn;
    }

    public void setFieldValues(List<MediaCollection> mcs) {
        MediaCollection mc = this.getMediaCollection(mcs);
        if (mc != null) {
            List<MediaField> fields = mc.getMediaFields();
            MediaFieldValue mfv = null;
            if (!CollectionUtils.isEmpty(fields) && !CollectionUtils.isEmpty((Map)this.attributes)) {
                this.fieldValues = new ArrayList<MediaFieldValue>();
                this.summaryFieldValues = new ArrayList<MediaFieldValue>();
                this.previewFieldValues = new ArrayList<MediaFieldValue>();
                this.relatedItemFieldValues = new ArrayList<MediaFieldValue>();
                for (String key : this.attributes.keySet()) {
                    MediaField field = this.getMediaField(fields, key);
                    if (field == null) continue;
                    mfv = new MediaFieldValue(field, this.attributes.get(key));
                    this.fieldValues.add(mfv);
                    if (field.isSummaryDescriptionField()) {
                        this.summaryFieldValues.add(mfv);
                    }
                    if (field.isPreviewField()) {
                        this.previewFieldValues.add(mfv);
                    }
                    if (!field.isRelatedItemField()) continue;
                    this.relatedItemFieldValues.add(mfv);
                }
                MediaField processedDate = new MediaField(1000, 1, "_processedDate", "Processed Date", 1000);
                processedDate.setSortable(true);
                MediaField processedDateMilli = new MediaField(1001, 1, "_processedDateMilli", "Processed Date (epoch)", 1001);
                processedDateMilli.setSortable(true);
                MediaField canonicalServerAddress = new MediaField(1002, 1, "canonicalServerAddress", "CanonicalServerAddress", 1002);
                processedDateMilli.setSortable(false);
                MediaFieldValue pDv = new MediaFieldValue(processedDate, this.attributes.get("_processedDate"));
                this.fieldValues.add(pDv);
                MediaFieldValue pDmv = new MediaFieldValue(processedDateMilli, this.attributes.get("_processedDateMilli"));
                this.fieldValues.add(pDmv);
                MediaFieldValue pCv = new MediaFieldValue(canonicalServerAddress, this.attributes.get("canonicalServerAddress"));
                this.fieldValues.add(pCv);
                Collections.sort(this.summaryFieldValues, new ReflectiveComparator("getSummaryDescriptionFieldSort", 2));
                Collections.sort(this.previewFieldValues, new ReflectiveComparator("getPreviewFieldSort", 2));
            }
        }
    }

    @Override
    public void removeFieldValues() {
        this.fieldValues = null;
        this.previewFieldValues = null;
        this.summaryFieldValues = null;
        this.relatedItemFieldValues = null;
    }

    public void removeFieldValues(List<Object> values) {
        for (Object value : values) {
            Iterator<MediaFieldValue> itr = this.fieldValues.iterator();
            while (itr.hasNext()) {
                MediaFieldValue mfv = itr.next();
                if (!mfv.getField().getFieldName().equalsIgnoreCase(value.toString())) continue;
                itr.remove();
            }
        }
    }

    @Override
    public void trimAttributes() {
        if (!this.attributes.isEmpty()) {
            Iterator keySetItr = this.attributes.keySet().iterator();
            while (keySetItr.hasNext()) {
                String key = keySetItr.next().toString();
                if (key.equals("id") || key.equals("mediaType") || key.equals("urlSize0") || key.equals("urlSize1") || key.equals("urlSize2") || key.equals("urlSize3") || key.equals("urlSize4") || key.equals("displayTitle") || key.equals("refUrlSize0") || key.equals("refUrlSize1") || key.equals("refUrlSize2") || key.equals("refUrlSize3") || key.equals("refUrlSize4") || key.equals("_luna_media_restricted_to") || key.equals("_luna_record_restricted_to") || key.equals("_luna_collection_owner")) continue;
                keySetItr.remove();
            }
        }
    }

    private MediaField getMediaField(Collection<MediaField> fields, String fieldName) {
        for (MediaField field : fields) {
            if (field == null || !StringUtils.equalsIgnoreCase((String)field.getFieldName(), (String)fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public String getUrlSize0() {
        if (this.isPermitted() && this.isPermittedByIiifSource()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize0.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    @Override
    public String getUrlSize1() {
        if (this.isPermitted() && this.isPermittedByIiifSource()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize1.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    @Override
    public String getUrlSize2() {
        if (this.isPermitted() && this.isPermittedByIiifSource()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize2.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    @Override
    public String getUrlSize3() {
        if (this.isPermitted() && this.isPermittedByIiifSource()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize3.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    @Override
    public String getUrlSize4() {
        if (this.isPermitted() && this.isPermittedByIiifSource()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize4.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    public String getUrlSource() {
        if (this.isPermitted()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSource.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    @Override
    public void setUrlSize3(String url) {
        this.attributes.put(LuceneDocumentFactory.LuceneAttribute.urlSize3.getAttributeName(), url);
    }

    @Override
    public void setUrlSize4(String url) {
        this.attributes.put(LuceneDocumentFactory.LuceneAttribute.urlSize4.getAttributeName(), url);
    }

    @Override
    public boolean isImage() {
        return StringUtils.isEmpty((String)((String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.mediaType.getAttributeName()))) || StringUtils.equalsIgnoreCase((String)Media.MediaType.IMAGE.toString(), (String)this.getMediaType());
    }

    @Override
    public boolean isVideo() {
        return StringUtils.equalsIgnoreCase((String)Media.MediaType.VIDEO.toString(), (String)this.getMediaType());
    }

    @Override
    public boolean isAudio() {
        return StringUtils.equalsIgnoreCase((String)Media.MediaType.AUDIO.toString(), (String)this.getMediaType());
    }

    @Override
    public boolean isMisc() {
        return StringUtils.equalsIgnoreCase((String)Media.MediaType.MISC.toString(), (String)this.getMediaType());
    }

    public boolean isPdf() {
        String url;
        return StringUtils.equalsIgnoreCase((String)Media.MediaType.MISC.toString(), (String)this.getMediaType()) && (url = this.getUrlSize2()) != null && url.toLowerCase().endsWith(".pdf");
    }

    @Override
    public boolean isBook() {
        return StringUtils.equalsIgnoreCase((String)Media.MediaType.BOOK.toString(), (String)this.getMediaType());
    }

    @Override
    public String getMediaType() {
        return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.mediaType.getAttributeName());
    }

    public String getCanonicalServerAddress() {
        return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.canonicalServerAddress.getAttributeName());
    }

    public String getReferenceMediaId() {
        return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.referenceMediaId.getAttributeName());
    }

    public String getRefUrlSize0() {
        if (this.isPermitted()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.refUrlSize0.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    public String getRefUrlSize1() {
        if (this.isPermitted()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.refUrlSize1.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    public String getRefUrlSize2() {
        if (this.isPermitted()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.refUrlSize2.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    public String getRefUrlSize3() {
        if (this.isPermitted()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.refUrlSize3.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    public String getRefUrlSize4() {
        if (this.isPermitted()) {
            return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.refUrlSize4.getAttributeName());
        }
        return RESTRICTED_ICON_URL;
    }

    public String getIiifManifest() {
        return this.iiifManifest;
    }

    @Override
    public void setIiifManifestUrl(String iiifManifestUrl) {
        this.iiifManifest = iiifManifestUrl;
    }

    @Override
    public String getUri() {
        Object uri;
        Object v0 = uri = this.attributes.get(LuceneDocumentFactory.LuceneAttribute.uri.getAttributeName()) == null ? null : this.attributes.get(LuceneDocumentFactory.LuceneAttribute.uri.getAttributeName());
        if (uri != null && uri instanceof String) {
            return uri;
        }
        if (uri != null && uri instanceof List) {
            ArrayList l = uri;
            return (String)l.get(0);
        }
        return null;
    }

    private boolean isPermittedByIiifSource() {
        return this.getUri() == null || !this.isImage() || this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize0.getAttributeName()) != null || this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize1.getAttributeName()) != null || this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize2.getAttributeName()) != null || this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize3.getAttributeName()) != null || this.attributes.get(LuceneDocumentFactory.LuceneAttribute.urlSize4.getAttributeName()) != null;
    }

    public boolean isPermitted() {
        String collectionOwner = "";
        if (this.attributes.containsKey("_luna_collection_owner")) {
            collectionOwner = (String)this.attributes.get("_luna_collection_owner");
        }
        try {
            Subject subject = SecurityUtils.getSubject();
            int credentialsId = SubjectUtils.getCredentialsId((Subject)subject);
            ArrayList<String> permittedUsers = new ArrayList<String>();
            Object rObj = this.attributes.get("_luna_media_restricted_to");
            if (rObj instanceof String) {
                permittedUsers.add((String)rObj);
            } else if (rObj instanceof List) {
                permittedUsers.addAll((List)rObj);
            }
            if (subject != null && permittedUsers.size() > 0) {
                String thisUser;
                String string = thisUser = subject.getPrincipal() == null ? "" : subject.getPrincipal().toString();
                if (subject.hasRole(PermissionManager.getRoleSuperAdmin()) || permittedUsers.contains(thisUser) || StringUtils.isNotEmpty((String)collectionOwner) && collectionOwner.equals(thisUser) || permittedUsers.contains(String.valueOf(credentialsId))) {
                    return true;
                }
                if (!subject.isAuthenticated()) {
                    Session s = subject.getSession();
                    Object credId = s.getAttribute((Object)"IPRANGE_DEFAULT_CREDENTIAL_ID");
                    return credId != null && permittedUsers != null && permittedUsers.contains(String.valueOf(credId));
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        List<MediaFieldValue> mfvs;
        Object obj = ParsingUtils.getIgnoreCase(this.attributes, this.displayAttributeNames);
        String toReturn = "";
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            for (String s : list) {
                if (toReturn.length() > 0) {
                    toReturn = toReturn + ", ";
                }
                toReturn = toReturn + s;
            }
        }
        if (StringUtils.isBlank((String)toReturn) && (mfvs = this.fieldValues) != null) {
            for (MediaFieldValue mfv : mfvs) {
                if (!mfv.getField().isDisplayTitleField()) continue;
                toReturn = toReturn + mfv.getValue();
            }
        }
        return toReturn;
    }
}

