/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.Annotation;
import com.lunaimaging.insight.core.domain.search.AnnotationResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneResult;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.publisher.common.domain.PublisherAnnotation;
import com.lunaimaging.security.permission.PermissionManager;
import com.lunaimaging.security.util.SubjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class LuceneAnnotationResult
extends LuceneResult
implements AnnotationResult {
    protected int xPos;
    protected int yPos;
    protected int fWidth;
    protected int fHeight;
    protected int imgWidth;
    protected int imgHeight;
    protected String imgCoordinates;
    protected String source;

    public LuceneAnnotationResult(int docId) {
        super(docId);
    }

    public LuceneAnnotationResult() {
        this(0);
    }

    public void setValues(Annotation a) {
        this.xPos = a.getxPos();
        this.yPos = a.getyPos();
        this.fWidth = a.getfWidth();
        this.fHeight = a.getfHeight();
        this.imgWidth = a.getImgWidth();
        this.imgHeight = a.getImgHeight();
        this.source = a.getSource();
        if (a.getImageCoordinates() != null) {
            this.attributes.put(PublisherAnnotation.IMG_COORD, a.getImageCoordinates());
        }
        if (!this.attributes.containsKey(LuceneDocumentFactory.LuceneAttribute.id.toString())) {
            this.attributes.put(LuceneDocumentFactory.LuceneAttribute.id.toString(), a.getId());
        }
        if (!this.attributes.containsKey(PublisherAnnotation.ANNOTATION_SEARCH_FIELD)) {
            this.attributes.put(PublisherAnnotation.ANNOTATION_SEARCH_FIELD, a.getAnnotation());
        }
        if (!this.attributes.containsKey(LuceneDocumentFactory.LuceneAttribute.mediaId.getAttributeName())) {
            this.attributes.put(LuceneDocumentFactory.LuceneAttribute.mediaId.getAttributeName(), a.getMediaId());
        }
    }

    public boolean isPermitted() {
        String collectionOwner = "";
        if (this.attributes.containsKey("_luna_collection_owner")) {
            collectionOwner = (String)this.attributes.get("_luna_collection_owner");
        }
        try {
            Subject subject = SecurityUtils.getSubject();
            int credentialsId = SubjectUtils.getCredentialsId((Subject)subject);
            ArrayList<String> permittedUsers = new ArrayList<String>();
            Object rObj = this.attributes.get("_luna_media_restricted_to");
            if (rObj instanceof String) {
                permittedUsers.add((String)rObj);
            } else if (rObj instanceof List) {
                permittedUsers.addAll((List)rObj);
            }
            if (subject != null && permittedUsers.size() > 0) {
                String thisUser;
                String string = thisUser = subject.getPrincipal() == null ? "" : subject.getPrincipal().toString();
                if (subject.hasRole(PermissionManager.getRoleSuperAdmin()) || permittedUsers.contains(thisUser) || StringUtils.isNotEmpty((String)collectionOwner) && collectionOwner.equals(thisUser) || permittedUsers.contains(String.valueOf(credentialsId))) {
                    return true;
                }
                if (!subject.isAuthenticated()) {
                    Session s = subject.getSession();
                    Object credId = s.getAttribute((Object)"IPRANGE_DEFAULT_CREDENTIAL_ID");
                    return credId != null && permittedUsers != null && permittedUsers.contains(String.valueOf(credId));
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        return this.getAnnotation();
    }

    @Override
    public String getAnnotation() {
        Object annoObj = this.attributes.get(PublisherAnnotation.ANNOTATION_SEARCH_FIELD);
        if (annoObj instanceof String) {
            return (String)annoObj;
        }
        List annoList = (List)annoObj;
        return annoList.toString();
    }

    public List<String> getSearchableTerms() {
        Object annoObj = this.attributes.get(PublisherAnnotation.ANNOTATION_SEARCH_FIELD);
        ArrayList<String> searchList = new ArrayList<String>();
        if (annoObj instanceof String) {
            searchList.add(((String)annoObj).toLowerCase());
        } else {
            List terms = (List)annoObj;
            for (String t : terms) {
                if (searchList.contains(t.toLowerCase())) continue;
                searchList.add(t.toLowerCase());
            }
        }
        return searchList;
    }

    public List<String> getImgCoordinates() {
        if (!this.attributes.containsKey(PublisherAnnotation.IMG_COORD)) {
            return null;
        }
        Object imgCoordsObj = this.attributes.get(PublisherAnnotation.IMG_COORD);
        if (imgCoordsObj instanceof String) {
            String imgCoords = (String)imgCoordsObj;
            imgCoords = StringUtils.removeStart((String)imgCoords, (String)"[");
            imgCoords = StringUtils.removeEnd((String)imgCoords, (String)"]");
            String[] imgCoordsArry = StringUtils.split((String)imgCoords, (String)",");
            return Arrays.asList(imgCoordsArry);
        }
        if (imgCoordsObj instanceof List) {
            return (List)imgCoordsObj;
        }
        return null;
    }

    @Override
    public String getCentroid() {
        Object centObj = null;
        if (this.attributes.containsKey(PublisherAnnotation.CENTROID)) {
            centObj = this.attributes.get(PublisherAnnotation.CENTROID);
        }
        if (centObj != null) {
            return centObj.toString();
        }
        return "";
    }

    @Override
    public String getMediaId() {
        if (!this.attributes.containsKey(LuceneDocumentFactory.LuceneAttribute.mediaId.getAttributeName())) {
            return null;
        }
        return (String)this.attributes.get(LuceneDocumentFactory.LuceneAttribute.mediaId.getAttributeName());
    }

    @Override
    public int getxPos() {
        return this.xPos;
    }

    @Override
    public int getyPos() {
        return this.yPos;
    }

    @Override
    public int getfWidth() {
        return this.fWidth;
    }

    @Override
    public int getfHeight() {
        return this.fHeight;
    }

    @Override
    public int getImgWidth() {
        return this.imgWidth;
    }

    @Override
    public int getImgHeight() {
        return this.imgHeight;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return "AnnoResult[" + this.getIdentity() + "]: " + this.getAnnotation();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof LuceneAnnotationResult && this.getIdentity() != null && StringUtils.equals((String)((String)this.getIdentity()), (String)((String)((LuceneAnnotationResult)obj).getIdentity())) && this.getId() != null && StringUtils.equals((String)((String)this.getId()), (String)((String)((LuceneAnnotationResult)obj).getId())) && this.getAnnotation() != null && StringUtils.equals((String)this.getAnnotation(), (String)((LuceneAnnotationResult)obj).getAnnotation());
    }
}

