/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.search.AnnotationResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneAnnotationResult;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.utils.PolygonUtils;
import com.lunaimaging.publisher.common.domain.PublisherAnnotation;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Coordinate;

public class LuceneAnnotationGroupResult
extends LuceneAnnotationResult
implements AnnotationResult {
    public static final String IDENTITY_SEPARATOR = ",";
    protected List<LuceneAnnotationResult> annotationList;
    private Polygon polygon = null;
    private String id = null;
    private String mediaId = null;
    private String centroid = null;

    public LuceneAnnotationGroupResult(int docId) {
        super(docId);
    }

    public LuceneAnnotationGroupResult() {
        this(0);
    }

    public void addAnnotation(LuceneAnnotationResult a) throws Exception {
        Object mediaId;
        if (this.annotationList == null) {
            this.annotationList = new ArrayList<LuceneAnnotationResult>();
            this.polygon = new Polygon();
        }
        if (this.annotationList.size() > 0 && !StringUtils.equals((String)(mediaId = this.annotationList.get(this.annotationList.size() - 1).getMediaId()), (String)a.getMediaId())) {
            throw new Exception("Invalid annotation for media id: " + (String)mediaId);
        }
        this.annotationList.add(a);
        if (a.getImgHeight() > 0) {
            this.imgHeight = a.getImgHeight();
        } else if (a.getAttributes().containsKey(PublisherAnnotation.IMGHEIGHT)) {
            this.imgHeight = Integer.parseInt((String)a.getAttributes().get(PublisherAnnotation.IMGHEIGHT));
        }
        if (a.getImgWidth() > 0) {
            this.imgWidth = a.getImgWidth();
        } else if (a.getAttributes().containsKey(PublisherAnnotation.IMGWIDTH)) {
            this.imgWidth = Integer.parseInt((String)a.getAttributes().get(PublisherAnnotation.IMGWIDTH));
        }
        for (String coord : a.getImgCoordinates()) {
            String[] xy = StringUtils.split((String)coord);
            this.polygon.addPoint(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
        }
        this.centroid = this.getCentroid();
        String identity = "";
        for (LuceneAnnotationResult lar : this.annotationList) {
            identity = identity + (StringUtils.isNotBlank((String)identity) ? IDENTITY_SEPARATOR : "") + lar.getId();
        }
        this.id = identity;
        this.putAttribute(LuceneDocumentFactory.LuceneAttribute.id.getAttributeName(), identity);
    }

    @Override
    public String getDisplayName() {
        if (this.annotationList == null) {
            return "";
        }
        String displayName = "";
        for (LuceneAnnotationResult a : this.annotationList) {
            displayName = displayName + (StringUtils.isNotEmpty((String)displayName) ? " " : "") + a.getAnnotation();
        }
        return displayName;
    }

    @Override
    public String getAnnotation() {
        return this.getDisplayName();
    }

    @Override
    public String getMediaId() {
        if (this.mediaId == null) {
            return this.annotationList.get(0).getMediaId();
        }
        return this.mediaId;
    }

    @Override
    public int getxPos() {
        return this.polygon.getBounds().x;
    }

    @Override
    public int getyPos() {
        return this.polygon.getBounds().y;
    }

    @Override
    public int getfWidth() {
        return this.polygon.getBounds().width;
    }

    @Override
    public int getfHeight() {
        return this.polygon.getBounds().height;
    }

    @Override
    public int getImgWidth() {
        return this.imgWidth;
    }

    @Override
    public int getImgHeight() {
        return this.imgHeight;
    }

    @Override
    public String toString() {
        return "AnnoGroupResult[" + this.getIdentity() + "]: " + this.getAnnotation();
    }

    @Override
    public Object getIdentity() {
        if (this.annotationList == null) {
            return null;
        }
        String identity = "";
        for (LuceneAnnotationResult a : this.annotationList) {
            identity = identity + (StringUtils.isNotEmpty((String)identity) ? IDENTITY_SEPARATOR : "") + a.getId();
        }
        return identity;
    }

    @Override
    public String getCentroid() {
        Object centObj = null;
        if (this.annotationList == null) {
            return null;
        }
        ArrayList<String> centroids = new ArrayList<String>();
        for (LuceneAnnotationResult a : this.annotationList) {
            if (a.attributes.containsKey(PublisherAnnotation.CENTROID)) {
                centObj = a.attributes.get(PublisherAnnotation.CENTROID);
            }
            if (centObj == null) continue;
            centroids.add(centObj);
        }
        if (centroids != null && centroids.size() == 1) {
            return (String)centroids.get(0);
        }
        if (centroids != null && centroids.size() > 1) {
            ArrayList<Coordinate> geocoords = new ArrayList<Coordinate>();
            for (int i = 0; i < centroids.size(); ++i) {
                String[] latLng = StringUtils.split((String)((String)centroids.get(i)), (char)',');
                geocoords.add(new Coordinate(Double.parseDouble(latLng[0]), Double.parseDouble(latLng[1])));
            }
            Coordinate mid = PolygonUtils.getMidpoint(geocoords);
            return mid.x + IDENTITY_SEPARATOR + mid.y;
        }
        return "";
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof LuceneAnnotationGroupResult && this.getIdentity() != null && this.getIdentity() == ((LuceneAnnotationGroupResult)obj).getIdentity() && this.getId() != null && this.getId() == ((LuceneAnnotationGroupResult)obj).getId() && this.getAnnotation() != null && this.getAnnotation() == ((LuceneAnnotationGroupResult)obj).getAnnotation();
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }
}

