/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search.lucene;

import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneAnnotationResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchResult;
import com.lunaimaging.insight.core.lucene.LuceneResultProcessor;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.publisher.common.domain.PublisherAnnotation;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class AnnotationResultProcessor
implements LuceneResultProcessor {
    protected static Log logger = LogFactory.getLog(AnnotationResultProcessor.class);
    protected static final String SEPERATOR = ", ";
    protected List<String> valueDelimeter;

    public AnnotationResultProcessor() {
    }

    public AnnotationResultProcessor(List<String> valueDelimeter) {
        this();
        this.setValueDelimeter(valueDelimeter);
    }

    @Override
    public LuceneSearchResult process(List<Document> docs) {
        LuceneSearchResult results = new LuceneSearchResult();
        if (CollectionUtils.isNotEmpty(docs)) {
            for (Document doc : docs) {
                if (doc == null) continue;
                LuceneAnnotationResult result = new LuceneAnnotationResult();
                for (int f = 0; f < doc.getFields().size(); ++f) {
                    Field field = (Field)doc.getFields().get(f);
                    if (!field.fieldType().stored()) continue;
                    result.putAttribute(new String(field.name()), this.getProperValue(doc.get(field.name())));
                }
                results.add(result);
            }
        }
        return results;
    }

    @Override
    public LuceneSearchResult processSolrDocuments(List<SolrDocument> docs) {
        LuceneSearchResult results = new LuceneSearchResult();
        if (docs != null && docs.size() > 0) {
            for (int i = 0; i < docs.size(); ++i) {
                SolrDocument doc = docs.get(i);
                if (doc == null) continue;
                LuceneAnnotationResult result = new LuceneAnnotationResult();
                Collection fieldNames = doc.getFieldNames();
                for (String field : fieldNames) {
                    if (doc.getFieldValue(field) == null) continue;
                    result.putAttribute(field, doc.getFieldValue(field).toString());
                }
                results.add(result);
            }
        }
        return results;
    }

    protected String getProperValue(String value) {
        String toReturn = "";
        if (StringUtils.isNotEmpty((String)value) && CollectionUtils.isNotEmpty(this.valueDelimeter)) {
            toReturn = ParsingUtils.regxReplaceWith(value, this.valueDelimeter, SEPERATOR);
        }
        return toReturn;
    }

    protected void prepareSerialization(PublisherAnnotation m, SolrDocument sDoc) {
        if (sDoc == null || sDoc.size() == 0) {
            return;
        }
        for (String fieldName : sDoc.getFieldNames()) {
            logger.debug((Object)("name = " + fieldName + ", value = " + sDoc.getFieldValue(fieldName)));
            if (!PublisherMedia.isSerializableFields((String)fieldName)) continue;
            m.addField(fieldName, sDoc.getFieldValue(fieldName));
        }
    }

    public List<String> getValueDelimeter() {
        return this.valueDelimeter;
    }

    public void setValueDelimeter(List<String> valueDelimeter) {
        this.valueDelimeter = valueDelimeter;
    }

    @Override
    public LuceneSearchResult processSolrDocumentList(SolrDocumentList docs, List<MediaCollection> mcs) {
        LuceneSearchResult results = new LuceneSearchResult();
        if (docs != null && docs.size() > 0) {
            for (int i = 0; i < docs.size(); ++i) {
                SolrDocument doc = (SolrDocument)docs.get(i);
                if (doc == null) continue;
                LuceneAnnotationResult result = new LuceneAnnotationResult();
                Collection fieldNames = doc.getFieldNames();
                for (String field : fieldNames) {
                    Object fvObj = doc.getFieldValue(field);
                    if (fvObj == null) continue;
                    if (!(fvObj instanceof Collection)) {
                        result.putAttribute(field, fvObj.toString());
                        continue;
                    }
                    Collection fvs = (Collection)fvObj;
                    for (Object fv : fvs) {
                        result.putAttribute(field, fv.toString());
                    }
                }
                results.add(result);
            }
            results.setTotalNumberOfResults(docs.getNumFound());
        }
        return results;
    }
}

