/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchStringValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import java.util.List;

public class W4SearchFieldValue
extends SearchFieldValue {
    protected MediaField.W4Type w4Field;

    public W4SearchFieldValue(MediaField.W4Type field, List<SearchValue> searchValues, SearchFieldValue.Operator operator, SearchFieldValue.Condition condition) {
        super("", searchValues, operator, condition);
        this.setField(field);
    }

    public W4SearchFieldValue(MediaField.W4Type field, SearchValue searchValue, SearchFieldValue.Operator operator, SearchFieldValue.Condition condition) {
        this(field, (List<SearchValue>)null, operator, condition);
        this.setField(field);
        this.add(searchValue);
    }

    public W4SearchFieldValue() {
        this((MediaField.W4Type)null, (List<SearchValue>)null, DEFAULT_OPERATION, DEFAULT_CONDITION);
    }

    @Override
    public boolean parse(String term) {
        if (super.parse(term)) {
            this.isValid = false;
            if (this.w4Field != null) {
                this.isValid = true;
                for (SearchValue sv : this.searchValues) {
                    if (!(sv instanceof SearchStringValue)) continue;
                    ((SearchStringValue)sv).setPhrase(true);
                }
            }
        }
        return this.isValid;
    }

    @Override
    public void setField(String field) {
        block3: {
            try {
                if (field != null) {
                    this.setField(MediaField.W4Type.valueOf(field.toUpperCase()));
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Unable to find W4Type from:[" + field + "]"));
            }
        }
    }

    public void setField(MediaField.W4Type field) {
        if (field != null) {
            this.w4Field = field;
            super.setField(field.getDisplayName());
        }
    }

    public MediaField.W4Type getW4Field() {
        return this.w4Field;
    }

    public void setW4Field(MediaField.W4Type field) {
        this.w4Field = field;
    }

    @Override
    public void add(SearchValue searchValue) {
        if (searchValue != null) {
            if (searchValue instanceof SearchStringValue) {
                ((SearchStringValue)searchValue).setPhrase(true);
            }
            super.add(searchValue);
        }
    }
}

