/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SearchValue
implements Serializable {
    protected static final Log log = LogFactory.getLog(SearchValue.class);
    protected String value;
    protected SearchFieldValue.Condition condition;

    public SearchValue(String value, SearchFieldValue.Condition condition) {
        this.setValue(value);
        this.setCondition(condition);
    }

    public SearchValue(String value) {
        this(value, SearchFieldValue.DEFAULT_CONDITION);
    }

    public abstract boolean parse();

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public SearchFieldValue.Condition getCondition() {
        return this.condition;
    }

    public void setCondition(SearchFieldValue.Condition condition) {
        this.condition = condition;
    }

    public boolean equals(Object o) {
        if (o instanceof SearchValue) {
            SearchValue sv = (SearchValue)o;
            if (this.condition == sv.condition && StringUtils.equalsIgnoreCase((String)this.value, (String)sv.value)) {
                return true;
            }
        }
        return false;
    }
}

