/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import org.apache.commons.lang.StringUtils;

public class SearchStringValue
extends SearchValue {
    protected String stringValue;
    protected boolean isPhrase;
    protected boolean isValid;

    public SearchStringValue(String value, SearchFieldValue.Condition condition) {
        super(value, condition);
    }

    public SearchStringValue(String value) {
        super(value);
    }

    @Override
    public boolean parse() {
        return this.parse(false);
    }

    public boolean parse(boolean includeQuotes) {
        this.isValid = false;
        this.stringValue = StringUtils.strip((String)this.value);
        if (this.stringValue != null) {
            this.isValid = true;
            if (this.stringValue.startsWith("\"") && this.stringValue.endsWith("\"")) {
                this.isPhrase = true;
            }
            if (!includeQuotes) {
                this.stringValue = ParsingUtils.removePrefixIgnoreCaseTrim(this.stringValue, "\"");
                this.stringValue = ParsingUtils.removeSuffixIgnoreCaseTrim(this.stringValue, "\"");
            }
            this.stringValue = this.stringValue.replace("\"", "\\\"");
            super.setValue(this.stringValue);
        }
        return this.isValid;
    }

    public boolean isPhrase() {
        return this.isPhrase;
    }

    public void setPhrase(boolean isPhrase) {
        this.isPhrase = isPhrase;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SearchStringValue && super.equals(o)) {
            SearchStringValue ssv = (SearchStringValue)o;
            if (this.isPhrase == ssv.isPhrase) {
                return true;
            }
        }
        return false;
    }
}

