/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.domain.search.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class SearchResult {
    protected List results = new ArrayList();
    protected String[] resultIds;
    protected long totalNumberOfResults = 0L;

    public SearchResult(List<? extends Result> results) {
        if (results != null) {
            this.addAll(results);
            this.totalNumberOfResults = results.size();
        }
    }

    public SearchResult() {
        this(null);
    }

    public void add(Result result) {
        this.results.add(result);
    }

    public void addAll(List<? extends Result> results) {
        this.results.addAll(results);
    }

    public int getSize() {
        if (this.results != null) {
            return this.results.size();
        }
        return 0;
    }

    public List<? extends Result> getResults() {
        return this.results;
    }

    @Deprecated
    public String[] getResultIds() {
        return this.resultIds;
    }

    @Deprecated
    public void setResultIds(String[] resultIds) {
        this.resultIds = resultIds;
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty((Collection)this.results);
    }

    public Result getByIdentity(Object id) {
        Result toReturn = null;
        if (id != null && !this.isEmpty()) {
            for (Result result : this.getResults()) {
                if (result == null || !result.getIdentity().equals(id)) continue;
                toReturn = result;
                break;
            }
        }
        return toReturn;
    }

    public long getTotalNumberOfResults() {
        return this.totalNumberOfResults;
    }

    public void setTotalNumberOfResults(long num) {
        this.totalNumberOfResults = num;
    }
}

