/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.domain.search.SearchDateRangeValue;
import com.lunaimaging.insight.core.domain.search.SearchStringValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class SearchFieldValue
implements Serializable {
    public static final Log log = LogFactory.getLog(SearchFieldValue.class);
    public static final Operator DEFAULT_OPERATION = Operator.EQUALS;
    public static final Condition DEFAULT_CONDITION = Condition.OR;
    protected String field;
    protected List<SearchValue> searchValues = new ArrayList<SearchValue>();
    protected Operator operator;
    protected Condition condition;
    protected String term;
    protected boolean isValid;

    public SearchFieldValue(String field, List<SearchValue> searchValues, Operator operator, Condition condition) {
        this.setField(field);
        this.setSearchValues(searchValues);
        this.setOperator(operator);
        this.setCondition(condition);
    }

    public SearchFieldValue(String field, List<SearchValue> searchValues, Operator operator) {
        this(field, searchValues, operator, DEFAULT_CONDITION);
    }

    public SearchFieldValue() {
        this("", null, DEFAULT_OPERATION);
    }

    public boolean parse(String term) {
        return this.parse(term, DEFAULT_CONDITION);
    }

    public boolean parse(String term, Condition defaultCondition) {
        this.term = term;
        this.isValid = false;
        if (StringUtils.isNotEmpty((String)term)) {
            Condition condition = defaultCondition;
            if (condition == null) {
                condition = DEFAULT_CONDITION;
            }
            Operator op = null;
            String field = "";
            List<Object> values = new ArrayList();
            if (term.trim().endsWith(" " + Condition.OR.name())) {
                condition = Condition.OR;
                term = ParsingUtils.removeSuffixIgnoreCaseTrim(term, " " + Condition.OR.name());
            } else if (term.trim().endsWith(" " + Condition.AND.name())) {
                condition = Condition.AND;
                term = ParsingUtils.removeSuffixIgnoreCaseTrim(term, " " + Condition.AND.name());
            }
            op = this.findOperator(term);
            if (op != null) {
                String[] split = StringUtils.split((String)term, (String)op.token);
                if (split.length == 2) {
                    field = split[0];
                    values = this.parseValues(split[1]);
                } else if (split.length == 1) {
                    List<SearchValue> list;
                    if (op.equals((Object)Operator.CONTAINS)) {
                        values = this.parseValues(split[0] + "*");
                        list = values;
                    } else {
                        list = this.parseValues(split[0]);
                    }
                    values = list;
                }
            } else {
                op = Operator.CONTAINS;
                field = "";
                values = this.parseValues(term);
            }
            if (op == null || field == null || values == null) {
                this.isValid = false;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Unable to parse Term: [" + term + "]. op:[" + (Object)((Object)op) + "]field:[" + field + "]values:[" + ArrayUtils.toString(values) + "]"));
                }
            } else {
                this.isValid = true;
                this.setField(field);
                this.setSearchValues(values);
                this.setOperator(op);
                this.setCondition(condition);
            }
        }
        return this.isValid;
    }

    protected List<SearchValue> parseValues(String values) {
        ArrayList<SearchValue> toReturn = new ArrayList<SearchValue>();
        List<String> split = ParsingUtils.unalteredSplit(" OR | AND ", values);
        for (String s : split) {
            if (s == null) continue;
            SearchValue sv = new SearchDateRangeValue(s = StringUtils.strip((String)s));
            if (sv.parse()) {
                toReturn.add(sv);
                continue;
            }
            Condition condition = this.findCondition(s, Condition.OR);
            sv = new SearchStringValue(ParsingUtils.removeSuffixIgnoreCase(s, " " + condition.name()).trim(), condition);
            if (!sv.parse()) continue;
            if (((SearchStringValue)sv).isPhrase()) {
                toReturn.add(sv);
                continue;
            }
            toReturn.addAll(this.parseWords(s));
        }
        return toReturn;
    }

    protected List<SearchStringValue> parseWords(String s) {
        ArrayList<SearchStringValue> toReturn = new ArrayList<SearchStringValue>();
        if (StringUtils.isNotEmpty((String)s)) {
            List<String> words = ParsingUtils.unalteredSplit(" OR | AND ", s);
            SearchStringValue ssv = null;
            for (String word : words) {
                this.condition = this.findCondition(word, Condition.AND);
                if (!StringUtils.isNotEmpty((String)(word = ParsingUtils.removeSuffixIgnoreCase(word, " " + this.condition.name()).trim()))) continue;
                if (word.indexOf(" ") > 0) {
                    String[] subWords;
                    for (String subWord : subWords = word.split(" ")) {
                        if (!StringUtils.isNotEmpty((String)subWord) || !(ssv = new SearchStringValue(subWord, Condition.AND)).parse()) continue;
                        toReturn.add(ssv);
                    }
                    continue;
                }
                ssv = new SearchStringValue(word, this.condition);
                if (!ssv.parse()) continue;
                toReturn.add(ssv);
            }
        }
        return toReturn;
    }

    protected Condition findCondition(String term, Condition defaultValue) {
        Condition toReturn = null;
        for (Condition c : Condition.values()) {
            if (!ParsingUtils.endsWithIgnoreCaseTrim(term, c.name())) continue;
            toReturn = c;
            break;
        }
        if (toReturn == null) {
            toReturn = defaultValue;
        }
        return toReturn;
    }

    protected Operator findOperator(String term) {
        Operator toReturn = null;
        for (Operator operator : Operator.values()) {
            if (!StringUtils.contains((String)term, (String)operator.token)) continue;
            return operator;
        }
        return toReturn;
    }

    public void add(SearchValue searchValue) {
        if (searchValue != null) {
            this.searchValues.add(searchValue);
        }
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public List<SearchValue> getSearchValues() {
        return this.searchValues;
    }

    public void setSearchValues(List<SearchValue> searchValues) {
        if (searchValues != null) {
            this.searchValues = searchValues;
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getDescription() {
        StringBuilder description = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.getField())) {
            description.append(StringUtils.capitalize((String)this.getField()));
        } else {
            description.append("All Fields");
        }
        description.append(" " + this.getOperator().getTitleName());
        if (!CollectionUtils.isEmpty(this.searchValues)) {
            description.append(" '");
            for (int i = 0; i < this.searchValues.size(); ++i) {
                SearchValue value = this.searchValues.get(i);
                if (value == null) continue;
                if (i != 0) {
                    description.append(" ");
                }
                description.append(StringUtils.capitalize((String)value.getValue()));
                if (i == this.searchValues.size() - 1) continue;
                description.append(" " + value.getCondition().getDisplayName());
            }
            description.append("'");
        }
        return description.toString();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String toString() {
        return this.term;
    }

    public boolean equals(Object o) {
        if (o instanceof SearchFieldValue) {
            SearchFieldValue sfv = (SearchFieldValue)o;
            if (this.condition == sfv.condition && StringUtils.equalsIgnoreCase((String)this.field, (String)sfv.field) && this.operator == sfv.operator && this.searchValues.containsAll(sfv.searchValues)) {
                return true;
            }
        }
        return false;
    }

    public static enum Condition {
        OR("or"),
        AND("and");

        String displayName;

        private Condition(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum Operator {
        EQUALS("Equals", "equal to", "="),
        CONTAINS("SimilarTo", "similar to", "|"),
        STARTS_WITH("StartsWith", "starting with", "^");

        String token;
        String displayName;
        String titleName;

        private Operator(String displayName, String titleName, String token) {
            this.displayName = displayName;
            this.titleName = titleName;
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getTitleName() {
            return this.titleName;
        }
    }
}

