/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class SearchDateRangeValue
extends SearchValue {
    public static final String RANGE_DELIMIETER = "...";
    protected static final String RANGE_DELIMIETER_REGEX = "\\.\\.\\.";
    protected static final String[] DATE_PATTERNS = new String[]{"MM/dd/yyyy", "dd MMM yyyy", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss aa", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd hh:mm:ss aa", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd't'HH:mm:ss'z'"};
    protected static final String[] YEAR_PATTERNS = new String[]{"yyyy"};
    protected Date start;
    protected Date end;

    public SearchDateRangeValue(String value, SearchFieldValue.Condition condition) {
        super(value, condition);
    }

    public SearchDateRangeValue(String value) {
        super(value);
    }

    @Override
    public boolean parse() {
        boolean success = false;
        if (StringUtils.isNotEmpty((String)this.value)) {
            if (!StringUtils.contains((String)this.value, (String)RANGE_DELIMIETER)) {
                return false;
            }
            String[] split = StringUtils.strip((String)this.value).split(RANGE_DELIMIETER_REGEX);
            try {
                if (split.length == 1) {
                    this.start = this.parseDate(StringUtils.strip((String)split[0]), true);
                    this.end = this.parseDate(StringUtils.strip((String)split[0]), false);
                    success = true;
                } else if (split.length == 2) {
                    this.start = this.parseDate(StringUtils.strip((String)split[0]), true);
                    this.end = this.parseDate(StringUtils.strip((String)split[1]), false);
                    success = true;
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to parse date range: [" + this.value + "]"));
                }
            }
            catch (ParseException e) {
                success = false;
            }
        }
        return success;
    }

    public Date parseDate(String value, boolean start) throws ParseException {
        Date toReturn = null;
        if (value != null) {
            try {
                if (value.endsWith("Z")) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    df.setTimeZone(TimeZone.getTimeZone("Zulu"));
                    toReturn = df.parse(value);
                } else {
                    String[] datePatterns = (String[])ArrayUtils.addAll((Object[])DATE_PATTERNS, (Object[])YEAR_PATTERNS);
                    toReturn = DateUtils.parseDate((String)value, (String[])datePatterns);
                }
            }
            catch (ParseException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to parse date: [" + value + "]"));
                }
                throw e;
            }
        }
        if (!start && this.isYearOnly(value)) {
            toReturn = DateUtils.addYears(toReturn, (int)1);
            toReturn = DateUtils.round((Date)toReturn, (int)1);
            toReturn = DateUtils.addMilliseconds((Date)toReturn, (int)-1);
        }
        return toReturn;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SearchDateRangeValue) {
            SearchDateRangeValue sv = (SearchDateRangeValue)o;
            if (this.start.equals(sv.start) && this.end.equals(sv.end)) {
                return true;
            }
        }
        return false;
    }

    public boolean isYearOnly(String value) {
        boolean isCalendarDate = false;
        boolean isYearDate = false;
        try {
            DateUtils.parseDate((String)value, (String[])DATE_PATTERNS);
            isCalendarDate = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            DateUtils.parseDate((String)value, (String[])YEAR_PATTERNS);
            isYearDate = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return !isCalendarDate && isYearDate;
    }
}

