/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.MessageManager;
import com.lunaimaging.insight.core.dao.exceptions.InvalidSearchQuery;
import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.DefaultDateField;
import com.lunaimaging.insight.core.domain.FullTexIndexField;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaGroup;
import com.lunaimaging.insight.core.domain.search.AnnotationSearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.W4SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchCriteriaParserDeprecated;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.Query;
import org.springframework.context.MessageSource;

public class MediaSearchCriteria
implements Serializable {
    private static final long serialVersionUID = 6361331668732739653L;
    protected static final Log log = LogFactory.getLog(MediaSearchCriteria.class);
    public static final String LIMIT_PREFIX = "Limit:";
    public static final String REGEX_LIMIT_DEFINITION = "Limit:.*$";
    public static Pattern LIMIT_DEFINITION = Pattern.compile("Limit:.*$", 2);
    public static int SEARCH_RADIUS = 20;
    protected static final String REGEX_OPERATOR_DEFINITION = "[a-zA-z0-9_]*[=\\|\\^]{1}";
    protected Pattern OPERATOR_DEFINITION = Pattern.compile("[a-zA-z0-9_]*[=\\|\\^]{1}", 2);
    protected List<MediaField> mediaFields;
    protected List<SearchFieldValue> fieldValues = new ArrayList<SearchFieldValue>();
    protected List<W4SearchFieldValue> w4FieldValues = new ArrayList<W4SearchFieldValue>();
    protected List<SearchFieldValue> cfFieldValues = new ArrayList<SearchFieldValue>();
    protected List<MediaCollection> collectionLimit;
    protected List<MediaField> sortFields = new ArrayList<MediaField>();
    protected String parsedQuery;
    protected MediaGroup mediaGroup;
    protected List specificMediaIds;
    protected List<String> internalMediaIds;
    protected boolean w4FilteredSearch = true;
    protected Authenticable authenticable;
    protected List<Media.MediaType> mediaTypeLimit;
    protected boolean sortByRequest = false;
    protected boolean sortOrder = false;
    protected boolean annotationSearch = false;
    protected boolean spatialSearch = false;
    protected String distanceInKm = null;
    protected String latitude = null;
    protected String longtitude = null;
    protected boolean luceneQueryParsed = false;
    protected Query luceneQuery = null;
    protected String luceneQueryString = null;
    protected String description = null;
    protected transient MessageSource messageSource = null;
    public final boolean REVERSE = true;

    public MediaSearchCriteria() {
        this.collectionLimit = new ArrayList<MediaCollection>();
        this.mediaTypeLimit = new ArrayList<Media.MediaType>();
        this.setW4FilteredSearch(true);
    }

    public void addSortField(MediaField mediaField) {
        if (mediaField != null) {
            this.sortFields.add(mediaField);
        }
    }

    public void addSortField(List<MediaField> mediaField) {
        if (mediaField != null) {
            this.sortFields.addAll(mediaField);
        }
    }

    public void add(SearchFieldValue searchFieldValue) {
        if (searchFieldValue != null) {
            if (searchFieldValue instanceof W4SearchFieldValue) {
                this.w4FieldValues.add((W4SearchFieldValue)searchFieldValue);
            } else {
                this.fieldValues.add(searchFieldValue);
            }
        }
    }

    public void parseCustomFacetValues() {
        if (this.w4FieldValues != null) {
            for (W4SearchFieldValue w4Fv : this.w4FieldValues) {
                if (!this.isCustomFacetField(w4Fv.getField())) continue;
                this.cfFieldValues.add(w4Fv);
            }
        }
        if (this.fieldValues != null) {
            for (SearchFieldValue fv : this.fieldValues) {
                if (!this.isCustomFacetField(fv.getField())) continue;
                this.cfFieldValues.add(fv);
            }
        }
    }

    public void addAll(List<SearchFieldValue> searchFieldValues) {
        if (searchFieldValues != null) {
            this.fieldValues.addAll(searchFieldValues);
        }
    }

    public List<SearchFieldValue> getSearchFieldValues() {
        return this.fieldValues;
    }

    public List<W4SearchFieldValue> getW4SearchFieldValue() {
        return this.w4FieldValues;
    }

    public List<MediaField> getMediaFields() {
        return this.mediaFields;
    }

    public MediaField getMediaField(String fieldName) {
        if ("fullTextSearchField".equalsIgnoreCase(fieldName)) {
            return new FullTexIndexField();
        }
        if ("defaultDateField".equalsIgnoreCase(fieldName)) {
            return new DefaultDateField();
        }
        if (StringUtils.isNotEmpty((String)fieldName) && CollectionUtils.isNotEmpty(this.mediaFields)) {
            for (MediaField mf : this.mediaFields) {
                if (mf == null || !StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName)) continue;
                return mf;
            }
        }
        if (fieldName != null && fieldName.startsWith("_luna_media_")) {
            MediaField mf = new MediaField();
            mf.setFieldName(fieldName);
            return mf;
        }
        return null;
    }

    public void setMediaFields(List<MediaField> mediaFields) {
        this.mediaFields = mediaFields;
    }

    public List<MediaField> getSortFields() {
        return this.sortFields;
    }

    public void setSortOrder(boolean order) {
        this.sortOrder = order;
    }

    public boolean getSortOrder() {
        return this.sortOrder;
    }

    private boolean isCustomFacetField(String customFieldName) {
        if (this.mediaFields != null) {
            for (MediaField mf : this.mediaFields) {
                if (!mf.isFacetField() || !mf.getFieldName().equals(customFieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public List<MediaCollection> getCollectionLimit() {
        return this.collectionLimit;
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.fieldValues) && CollectionUtils.isEmpty(this.w4FieldValues) && CollectionUtils.isEmpty(this.collectionLimit);
    }

    public void findAllMedia(List<MediaCollection> collections) throws InvalidSearchQuery {
        this.parseLimit(null, collections, true);
    }

    public void findAllMedia(MediaCollection mc) throws InvalidSearchQuery {
        ArrayList<MediaCollection> collections = new ArrayList<MediaCollection>();
        if (mc != null) {
            collections.add(mc);
        }
        this.findAllMedia(collections);
    }

    public void findSpecificMedia(List ids, List<MediaCollection> collections) throws InvalidSearchQuery {
        this.specificMediaIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            this.specificMediaIds.addAll(ids);
        }
        this.findAllMedia(collections);
    }

    public void findInternalMedia(List<String> ids, List<MediaCollection> collections) throws InvalidSearchQuery {
        this.internalMediaIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(ids)) {
            this.internalMediaIds.addAll(ids);
        }
        this.findAllMedia(collections);
    }

    public void findByMediaGroup(MediaGroup mediaGroup, List<MediaCollection> collections) throws InvalidSearchQuery {
        if (mediaGroup == null) {
            throw new InvalidSearchQuery("PublisherMedia group cannot be null!");
        }
        this.mediaGroup = mediaGroup;
    }

    public void parse(String query, List<MediaCollection> collections) throws InvalidSearchQuery {
        this.parse(query, collections, true);
    }

    public void parse(String query, List<MediaCollection> collections, boolean addAllCollectionsIfNoneSpecified) throws InvalidSearchQuery {
        if (StringUtils.isNotEmpty((String)query)) {
            this.parsedQuery = query;
            query = StringUtils.trim((String)query);
            String limit = "";
            Matcher matcher = LIMIT_DEFINITION.matcher(query);
            if (matcher.find()) {
                limit = query.substring(matcher.start(), matcher.end());
                query = query.substring(0, matcher.start()).trim();
            }
            this.parseLimit(limit, collections, addAllCollectionsIfNoneSpecified);
            List<String> terms = this.parseTerms(query);
            SearchFieldValue.Condition lastCondition = SearchFieldValue.Condition.OR;
            boolean _annotationSearch = false;
            for (String term : terms) {
                if (!StringUtils.isNotEmpty((String)term)) continue;
                SearchFieldValue sfv = new W4SearchFieldValue();
                if (!sfv.parse(term)) {
                    SearchFieldValue defaultSfv = new SearchFieldValue();
                    if (!defaultSfv.parse(term, lastCondition)) {
                        defaultSfv = null;
                    }
                    if (defaultSfv != null && AnnotationSearchFieldValue.getAnnotationSearchFields().contains(defaultSfv.getField())) {
                        this.annotationSearch = true;
                        _annotationSearch = true;
                    } else if (this.annotationSearch && StringUtils.isEmpty((String)defaultSfv.getField())) {
                        this.annotationSearch = true;
                        _annotationSearch = true;
                    } else {
                        _annotationSearch = false;
                    }
                    sfv = _annotationSearch ? new AnnotationSearchFieldValue() : new SearchFieldValue();
                    if (!sfv.parse(term, lastCondition)) {
                        sfv = null;
                    }
                }
                if (sfv == null) continue;
                lastCondition = sfv.getCondition();
                this.add(sfv);
            }
        }
    }

    public List<String> parseTerms(String query) {
        ArrayList<String> terms = new ArrayList<String>();
        if (query != null) {
            String currentMatch;
            Matcher matcher = this.OPERATOR_DEFINITION.matcher(query);
            int lastStart = 0;
            while (matcher.find()) {
                if (lastStart < matcher.start()) {
                    currentMatch = query.substring(lastStart, matcher.start());
                    terms.add(currentMatch);
                }
                lastStart = matcher.start();
            }
            currentMatch = query.substring(lastStart, query.length());
            terms.add(currentMatch);
        }
        return terms;
    }

    private void parseLimit(String limit, List<MediaCollection> collections, boolean addAllCollectionsIfNoneSpecified) throws InvalidSearchQuery {
        if (CollectionUtils.isEmpty(collections)) {
            throw new InvalidSearchQuery("Must contain at least one PublisherMedia Collection to search from!");
        }
        if (limit != null && StringUtils.isNotEmpty((String)limit)) {
            String[] split;
            limit = ParsingUtils.removePrefixIgnoreCaseTrim(limit, LIMIT_PREFIX);
            for (String s : split = limit.split(",")) {
                MediaCollection c = this.getMediaCollection(StringUtils.strip((String)s), collections);
                if (c != null) {
                    this.addCollectionLimit(c);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Unable to locate collection [" + s + "]"));
            }
        }
        if (addAllCollectionsIfNoneSpecified && CollectionUtils.isEmpty(this.collectionLimit) && collections != null) {
            this.setCollectionLimit(collections);
        }
    }

    public void addCollectionLimit(MediaCollection mc) {
        if (mc != null) {
            for (MediaCollection mcl : this.collectionLimit) {
                if (!mcl.equals(mc)) continue;
                return;
            }
            this.collectionLimit.add(mc);
        }
    }

    public void setCollectionLimit(List<MediaCollection> mcs) {
        if (mcs != null) {
            for (MediaCollection mc : mcs) {
                this.addCollectionLimit(mc);
            }
        }
    }

    private MediaCollection getMediaCollection(String value, List<MediaCollection> collections) {
        MediaCollection toReturn = null;
        for (MediaCollection c : collections) {
            if ((c == null || !value.equalsIgnoreCase(c.getCollectionName()) && !value.equalsIgnoreCase(c.getAbbreviatedName())) && !value.equalsIgnoreCase(c.getId())) continue;
            toReturn = c;
            break;
        }
        return toReturn;
    }

    public String getDescription() {
        return this.getDescription(true);
    }

    public String getDescription(boolean includeHeader) {
        if (this.description != null) {
            return this.description;
        }
        StringBuilder result = new StringBuilder();
        try {
            if (includeHeader) {
                result.append("Search Results: ");
            }
            if (!CollectionUtils.isEmpty(this.fieldValues)) {
                List sfvs = new ArrayList<SearchFieldValue>();
                sfvs.addAll(this.fieldValues);
                sfvs.addAll(this.w4FieldValues);
                sfvs = ParsingUtils.removeDuplicateItems(sfvs);
                for (SearchFieldValue sfv : sfvs) {
                    String replace;
                    SearchFieldValue deepCopy = (SearchFieldValue)SerializationUtils.clone((Serializable)sfv);
                    String toFind = deepCopy.field;
                    for (MediaField m : this.mediaFields) {
                        if (m == null || m.getFieldName() == null || !m.getFieldName().equals(toFind)) continue;
                        deepCopy.setField(m.getDisplayName());
                        break;
                    }
                    if (!sfv.equals(sfvs.get(0))) {
                        result.append(" " + deepCopy.getCondition().getDisplayName() + " ");
                    }
                    String description = deepCopy.getDescription();
                    if (this.messageSource != null && deepCopy instanceof AnnotationSearchFieldValue && StringUtils.isNotBlank((String)(replace = this.messageSource.getMessage(MessageManager.MessageKeys.SEARCH_SELECT_ANNOTATIONS.getValue(), null, null)))) {
                        description = StringUtils.replace((String)description, (String)AnnotationSearchFieldValue.DESC_PLACEOLDER, (String)replace);
                    }
                    result.append(description);
                }
            }
        }
        catch (Exception e) {
            log.info((Object)"Unable to generate search description (title).", (Throwable)e);
        }
        return result.toString();
    }

    public String toString() {
        return this.parsedQuery;
    }

    public MediaGroup getMediaGroup() {
        return this.mediaGroup;
    }

    public List getSpecificMediaIds() {
        return this.specificMediaIds;
    }

    public String[] getInternalMediaIds() {
        if (this.internalMediaIds == null || this.internalMediaIds.size() == 0) {
            return null;
        }
        String[] ret = new String[this.internalMediaIds.size()];
        for (int i = 0; i < this.internalMediaIds.size(); ++i) {
            try {
                ret[i] = this.internalMediaIds.get(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isW4FilteredSearch() {
        return this.w4FilteredSearch;
    }

    public void setW4FilteredSearch(boolean filterSearch) {
        this.w4FilteredSearch = filterSearch;
    }

    public Authenticable getAuthenticable() {
        return this.authenticable;
    }

    public void setAuthenticable(Authenticable authenticable) {
        this.authenticable = authenticable;
    }

    public void addMediaTypeLimit(Media.MediaType mt) {
        if (mt != null) {
            this.mediaTypeLimit.add(mt);
        }
    }

    public List<Media.MediaType> getMediaTypeLimit() {
        return this.mediaTypeLimit;
    }

    public boolean getSortByRequest() {
        return this.sortByRequest;
    }

    public void setSortByRequest(boolean b) {
        this.sortByRequest = b;
    }

    public Query luceneQuery() {
        return this.luceneQuery(false);
    }

    public Query luceneQuery(boolean forceParse) {
        block3: {
            try {
                if (!this.luceneQueryParsed || forceParse) {
                    this.luceneQuery = LuceneSearchCriteriaParserDeprecated.getInstance().parse(this);
                }
                this.luceneQueryParsed = true;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) break block3;
                throw new RuntimeException(e);
            }
        }
        return this.luceneQuery;
    }

    public String getLuceneQueryString() {
        return this.luceneQueryString;
    }

    public void setLuceneQueryString(String s) {
        this.luceneQueryString = s;
    }

    public void setAnnotationSearch(boolean annotationSearch) {
        this.annotationSearch = annotationSearch;
    }

    public boolean isAnnotationSearch() {
        return this.annotationSearch;
    }

    public List<SearchFieldValue> getCfFieldValues() {
        return this.cfFieldValues;
    }

    public void setCfFieldValues(List<SearchFieldValue> cfFieldValues) {
        this.cfFieldValues = cfFieldValues;
    }

    public boolean isSpatialSearch() {
        return this.spatialSearch;
    }

    public void setSpatialSearch(boolean spatialSearch) {
        this.spatialSearch = spatialSearch;
    }

    public String getDistanceInKm() {
        return this.distanceInKm;
    }

    public void setDistanceInKm(String distanceInKm) {
        this.distanceInKm = distanceInKm;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongtitude() {
        return this.longtitude;
    }

    public void setLongtitude(String longtitude) {
        this.longtitude = longtitude;
    }

    public void setSpecificMediaIds(List specificMediaIds) {
        this.specificMediaIds = specificMediaIds;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

