/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.search;

import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class AnnotationSearchFieldValue
extends SearchFieldValue {
    public static String ANNOTATION_OCR_TEXT = "ocrText";
    public static String ANNOTATION_POST_OCR_TEXT = "postOcrText";
    public static String ANNOTATION_USER_CORRECTION_TEXT = "userCorrectionText";
    public static String ANNOTATION_ALL_TEXT = "allAnnotations";
    public static String ANNOTATION_SEARCH_FIELD = "simpleSearchField";
    public static String DESC_PLACEOLDER = "[[ANNOTATIONS]]";
    private static final long serialVersionUID = 6833383872256103244L;

    public static List<String> getAnnotationSearchFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(ANNOTATION_OCR_TEXT);
        fields.add(ANNOTATION_POST_OCR_TEXT);
        fields.add(ANNOTATION_USER_CORRECTION_TEXT);
        fields.add(ANNOTATION_ALL_TEXT);
        return fields;
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append(DESC_PLACEOLDER);
        description.append(" " + this.getOperator().getTitleName());
        if (!CollectionUtils.isEmpty((Collection)this.searchValues)) {
            description.append(" '");
            for (int i = 0; i < this.searchValues.size(); ++i) {
                SearchValue value = (SearchValue)this.searchValues.get(i);
                if (value == null) continue;
                if (i != 0) {
                    description.append(" ");
                }
                description.append(StringUtils.capitalize((String)value.getValue()));
                if (i == this.searchValues.size() - 1) continue;
                description.append(" " + value.getCondition().getDisplayName());
            }
            description.append("'");
        }
        return description.toString();
    }

    @Override
    public String getField() {
        if (ANNOTATION_ALL_TEXT.equals(this.field)) {
            return ANNOTATION_SEARCH_FIELD;
        }
        return this.field;
    }
}

