/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.logic;

import com.lunaimaging.insight.core.dao.MediaDao;
import com.lunaimaging.insight.core.dao.MediaFieldDao;
import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.logic.StandardInsight;
import com.lunaimaging.security.CredentialsAuthenticationInfo;
import com.lunaimaging.security.IpAddressUsernamePasswordToken;
import com.lunaimaging.security.mgt.LunaWebSecurityManager;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.dao.DataAccessException;

public class StandardInsightViewer
extends StandardInsight {
    private static Log log = LogFactory.getLog(StandardInsightViewer.class);

    public Authenticable authenticate(String ipAddress, IpAddressUsernamePasswordToken token) throws DataAccessException {
        token.setIpAddress(ipAddress);
        return this.authenticate(token);
    }

    @Override
    public Authenticable authenticate(String ipAddress, String username, String password) throws DataAccessException {
        IpAddressUsernamePasswordToken token = new IpAddressUsernamePasswordToken(username, password);
        token.setIpAddress(ipAddress);
        return this.authenticate(token);
    }

    @Override
    public Authenticable authenticate(IpAddressUsernamePasswordToken token) throws DataAccessException {
        Authenticable authenticable = null;
        try {
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)token);
            log.debug((Object)("authenticated = " + subject.isAuthenticated()));
            LunaWebSecurityManager manager = (LunaWebSecurityManager)SecurityUtils.getSecurityManager();
            CredentialsAuthenticationInfo authc = manager.getCredentialsAuthenticationInfo((UsernamePasswordToken)token);
            authenticable = authc.getAauthenticable();
            log.debug((Object)("authenticable = " + authenticable));
        }
        catch (UnknownAccountException ex) {
            log.debug((Object)ex.getMessage());
        }
        catch (IncorrectCredentialsException ex) {
            ex.printStackTrace();
            log.debug((Object)ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.debug((Object)ex.getMessage());
        }
        return authenticable;
    }

    @Override
    synchronized void initialize() {
        if (this.mediaFieldDao != null && this.mediaCollectionDao != null) {
            this.legacyAnnotationDao.setAllMediaCollections(this.mediaCollectionDao.getAllMediaCollections());
            for (String type : this.mediaDao.keySet()) {
                ArrayList<MediaCollection> collectionListByType = new ArrayList<MediaCollection>();
                for (MediaCollection mc : this.mediaCollectionDao.getAllMediaCollections()) {
                    if (!type.equals(mc.getCollectionType())) continue;
                    log.debug((Object)("mediaDao:   " + type + " => " + mc.getAbbreviatedName() + "(" + mc.getCollectionId() + ")"));
                    collectionListByType.add(mc);
                }
                ((MediaDao)this.mediaDao.get(type)).setAllMediaCollections(collectionListByType);
            }
            this.contentDistributionDao.setAllLocalMediaCollections(this.mediaCollectionDao.getLocalMediaCollections());
            log.info((Object)"LUNA field cache initialization. Please wait...");
            ArrayList<MediaField> allW4MediaFields = new ArrayList<MediaField>();
            for (MediaCollection mc : this.mediaCollectionDao.getAllMediaCollections()) {
                if (mc == null || mc.getCollectionType() == null || this.mediaFieldDao.get(mc.getCollectionType()) == null) continue;
                allW4MediaFields.addAll(((MediaFieldDao)this.mediaFieldDao.get(mc.getCollectionType())).getW4MediaFields(mc));
            }
            log.info((Object)"End of LUNA field cache initialization.");
        }
    }
}

