/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.logic;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.SimpleDate;
import com.lunaimaging.inscribe.domain.PublishEntity;
import com.lunaimaging.inscribe.domain.SharedSchema;
import com.lunaimaging.insight.core.dao.AnalyticsDao;
import com.lunaimaging.insight.core.dao.AnnotationDao;
import com.lunaimaging.insight.core.dao.ApplicationConfigurationDao;
import com.lunaimaging.insight.core.dao.AuthenticationDao;
import com.lunaimaging.insight.core.dao.CategoriesDao;
import com.lunaimaging.insight.core.dao.ContentDistributionDao;
import com.lunaimaging.insight.core.dao.FacetsDao;
import com.lunaimaging.insight.core.dao.FailedLoginAttemptDao;
import com.lunaimaging.insight.core.dao.FoldersDao;
import com.lunaimaging.insight.core.dao.MediaCollectionDao;
import com.lunaimaging.insight.core.dao.MediaDao;
import com.lunaimaging.insight.core.dao.MediaFieldDao;
import com.lunaimaging.insight.core.dao.MediaFieldRelationDao;
import com.lunaimaging.insight.core.dao.MediaFieldStandardDao;
import com.lunaimaging.insight.core.dao.MediaGroupsDao;
import com.lunaimaging.insight.core.dao.MediaManifestDao;
import com.lunaimaging.insight.core.dao.MediaSearchDao;
import com.lunaimaging.insight.core.dao.MediaStandardFieldDao;
import com.lunaimaging.insight.core.dao.PresentationDao;
import com.lunaimaging.insight.core.dao.ResumptionTokenDao;
import com.lunaimaging.insight.core.dao.SendEmailDao;
import com.lunaimaging.insight.core.dao.TinyUrlDao;
import com.lunaimaging.insight.core.dao.UserActivityDao;
import com.lunaimaging.insight.core.dao.exceptions.AuthenticationFailureException;
import com.lunaimaging.insight.core.dao.exceptions.EmailFailureException;
import com.lunaimaging.insight.core.dao.exceptions.InsufficientPermissionException;
import com.lunaimaging.insight.core.dao.exceptions.InvalidSearchQuery;
import com.lunaimaging.insight.core.dao.http.LibraryHttpDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcAnnotationDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcAuthenticationDao;
import com.lunaimaging.insight.core.dao.legacy.LegacyAnnotationDao;
import com.lunaimaging.insight.core.dao.legacy.LegacyMediaDao;
import com.lunaimaging.insight.core.dao.lucene.LunaMediaDAO;
import com.lunaimaging.insight.core.dao.lucene.SolrServerAnnotationDAO;
import com.lunaimaging.insight.core.domain.ActivityResult;
import com.lunaimaging.insight.core.domain.Annotation;
import com.lunaimaging.insight.core.domain.AnnotationHistory;
import com.lunaimaging.insight.core.domain.ApplicationConfiguration;
import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.Category;
import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.ExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.ExternalMedia;
import com.lunaimaging.insight.core.domain.FailedLoginAttempt;
import com.lunaimaging.insight.core.domain.Folder;
import com.lunaimaging.insight.core.domain.IpRange;
import com.lunaimaging.insight.core.domain.LunaMedia;
import com.lunaimaging.insight.core.domain.Media;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.MediaField;
import com.lunaimaging.insight.core.domain.MediaFieldRelation;
import com.lunaimaging.insight.core.domain.MediaFieldValue;
import com.lunaimaging.insight.core.domain.MediaGroup;
import com.lunaimaging.insight.core.domain.MediaManifest;
import com.lunaimaging.insight.core.domain.Presentation;
import com.lunaimaging.insight.core.domain.ResumptionToken;
import com.lunaimaging.insight.core.domain.SharedLunaMedia;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.Slide;
import com.lunaimaging.insight.core.domain.SlideMedia;
import com.lunaimaging.insight.core.domain.TinyUrl;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.UserActivity;
import com.lunaimaging.insight.core.domain.comparator.DisplayableComparator;
import com.lunaimaging.insight.core.domain.comparator.FacetFieldComparator;
import com.lunaimaging.insight.core.domain.comparator.MediaCollectionComparator;
import com.lunaimaging.insight.core.domain.comparator.MediaFieldCustomComparator;
import com.lunaimaging.insight.core.domain.iiif.ChangeCollection;
import com.lunaimaging.insight.core.domain.iiif.ChangeItem;
import com.lunaimaging.insight.core.domain.iiif.ChangeObject;
import com.lunaimaging.insight.core.domain.iiif.ChangePage;
import com.lunaimaging.insight.core.domain.iiif.ChangeResource;
import com.lunaimaging.insight.core.domain.logic.InsightFacade;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.domain.search.AnnotationSearchResult;
import com.lunaimaging.insight.core.domain.search.MediaResult;
import com.lunaimaging.insight.core.domain.search.MediaSearchCriteria;
import com.lunaimaging.insight.core.domain.search.MediaSearchResult;
import com.lunaimaging.insight.core.domain.search.Result;
import com.lunaimaging.insight.core.domain.search.SearchCriteria;
import com.lunaimaging.insight.core.domain.search.SearchFieldValue;
import com.lunaimaging.insight.core.domain.search.SearchValue;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneAnnotationResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneMediaResult;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchCriteriaParserDeprecated;
import com.lunaimaging.insight.core.domain.search.lucene.LuceneSearchResult;
import com.lunaimaging.insight.core.lucene.AnnotationSearcher;
import com.lunaimaging.insight.core.lucene.LuceneDocumentFactory;
import com.lunaimaging.insight.core.search.facet.Facets;
import com.lunaimaging.insight.core.search.facet.W4Facets;
import com.lunaimaging.insight.core.utils.AnnotationMapper;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import com.lunaimaging.insight.core.utils.PasswordEncryptUtils;
import com.lunaimaging.insight.core.utils.UrlUtils;
import com.lunaimaging.orion.editor.domain.Schema;
import com.lunaimaging.publisher.common.domain.PublisherAnnotation;
import com.lunaimaging.publisher.common.domain.PublisherMedia;
import com.lunaimaging.security.IpAddressUsernamePasswordToken;
import com.lunaimaging.security.permission.PermissionManager;
import com.techempower.ReflectiveComparator;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.springframework.context.MessageSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class StandardInsight
implements InsightFacade {
    private static int DEFAULT_MAX_MEDIA = 250;
    private static int PUBLIC_MEDIA_MAX_RESOLUTIONS = 5;
    private static Log log = LogFactory.getLog(StandardInsight.class);
    private boolean maintenanceInProgress = false;
    private String contentDistributionLogin;
    private String contentDistributionPassword;
    private int searchLimit;
    private int searchDist = -1;
    private int maxCharDist = -1;
    protected LinkedHashMap<String, MediaDao> mediaDao;
    protected LinkedHashMap<String, MediaFieldDao> mediaFieldDao;
    protected LunaMediaDAO<W4Facets, String> lunaMediaDAO;
    private MediaFieldRelationDao mediaFieldRelationDao;
    private MediaSearchDao mediaSearchDao;
    protected FacetsDao facetsDao;
    protected MediaCollectionDao mediaCollectionDao;
    private AuthenticationDao authenticationDao;
    private MediaGroupsDao mediaGroupsDao;
    private PresentationDao presentationDao;
    private AnnotationDao annotationDao;
    protected LegacyAnnotationDao legacyAnnotationDao;
    private FoldersDao foldersDao;
    private SendEmailDao sendEmailDao;
    protected ContentDistributionDao contentDistributionDao;
    private AnalyticsDao analyticsDao;
    private ApplicationConfigurationDao applicationConfigurationDao;
    private TinyUrlDao tinyUrlDao;
    private ResumptionTokenDao resumptionTokenDao;
    private UserActivityDao userActivityDao;
    private FailedLoginAttemptDao failedLoginAttemptDao;
    private MediaFieldStandardDao mediaFieldStandardDao;
    private MediaStandardFieldDao mediaStandardFieldDao;
    private MediaManifestDao manifestDao;
    private List<Maintainable> maintainableObjects;
    private LibraryHttpDao libraryHttpDao;
    private CategoriesDao categoriesDao;
    private SolrServerAnnotationDAO solrAnnotationDao;
    private final ReentrantLock addToMediaGroupLock = new ReentrantLock(true);
    protected Map<String, Boolean> collectionIsPublicMap = null;
    protected Cache<String, Integer> mediaCountCache = null;
    protected Cache<String, List<MediaCollection>> categoryCollectionCache = null;
    protected boolean cachesEnabled = false;
    protected boolean isLuna7 = true;

    private synchronized void initializeMediaCountCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.maximumSize(100L).expireAfterWrite(1L, TimeUnit.DAYS);
        this.mediaCountCache = builder.build();
    }

    private void addToMediaCountCache(String cid, int count) {
        if (this.cachesEnabled) {
            this.mediaCountCache.put((Object)cid, (Object)count);
        }
    }

    private synchronized void initializeCategoryCollectionCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.maximumSize(100L).expireAfterWrite(7L, TimeUnit.DAYS);
        this.categoryCollectionCache = builder.build();
    }

    private void addToCategoryCollectionCache(Authenticable authenticable, int categoryId, List<MediaCollection> collList) {
        if (this.cachesEnabled) {
            this.categoryCollectionCache.put((Object)(authenticable.toString().trim() + ":" + categoryId), collList);
        }
    }

    private void purgeCaches() {
        this.mediaCountCache = null;
        this.categoryCollectionCache = null;
    }

    public void setMaintainableObjects(List<Maintainable> list) {
        this.maintainableObjects = list;
    }

    public void setContentDistributionLogin(String contentDistributionLogin) {
        this.contentDistributionLogin = contentDistributionLogin;
    }

    public void setContentDistributionPassword(String contentDistributionPassword) {
        this.contentDistributionPassword = contentDistributionPassword;
        this.addMaintainable(contentDistributionPassword);
    }

    public LunaMediaDAO<W4Facets, String> getLunaMediaDAO() {
        return this.lunaMediaDAO;
    }

    public void setLunaMediaDAO(LunaMediaDAO<W4Facets, String> dao) {
        this.lunaMediaDAO = dao;
    }

    public void setMediaDao(LinkedHashMap<String, MediaDao> mediaDao) {
        this.mediaDao = mediaDao;
        this.addMaintainable(mediaDao);
    }

    public void setMediaFieldDao(LinkedHashMap<String, MediaFieldDao> mediaFieldDao) {
        this.mediaFieldDao = mediaFieldDao;
        this.addMaintainable(mediaFieldDao);
    }

    public void setMediaFieldRelationDao(MediaFieldRelationDao mediaFieldRelationDao) {
        this.mediaFieldRelationDao = mediaFieldRelationDao;
        this.addMaintainable(mediaFieldRelationDao);
    }

    public void setMediaSearchDao(MediaSearchDao mediaSearchDao) {
        this.mediaSearchDao = mediaSearchDao;
        this.addMaintainable(mediaSearchDao);
    }

    public void setFacetsDao(FacetsDao facetsDao) {
        this.facetsDao = facetsDao;
        this.addMaintainable(facetsDao);
    }

    public void setMediaCollectionDao(MediaCollectionDao mediaCollectionDao) {
        this.mediaCollectionDao = mediaCollectionDao;
        this.addMaintainable(mediaCollectionDao);
    }

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
        this.addMaintainable(authenticationDao);
    }

    public void setMediaGroupsDao(MediaGroupsDao mediaGroupsDao) {
        this.mediaGroupsDao = mediaGroupsDao;
        this.addMaintainable(mediaGroupsDao);
    }

    public void setFoldersDao(FoldersDao foldersDao) {
        this.foldersDao = foldersDao;
        this.addMaintainable(foldersDao);
    }

    public void setPresentationDao(PresentationDao presentationDao) {
        this.presentationDao = presentationDao;
        this.addMaintainable(presentationDao);
    }

    public void setAnnotationDao(AnnotationDao annotationDao) {
        this.annotationDao = annotationDao;
        this.addMaintainable(annotationDao);
    }

    public void setTinyUrlDao(TinyUrlDao tinyUrlDao) {
        this.tinyUrlDao = tinyUrlDao;
        this.addMaintainable(tinyUrlDao);
    }

    public void setManifestDao(MediaManifestDao manifestDao) {
        this.manifestDao = manifestDao;
        this.addMaintainable(manifestDao);
    }

    public void setLegacyAnnotationDao(LegacyAnnotationDao legacyAnnotationDao) {
        this.legacyAnnotationDao = legacyAnnotationDao;
        this.addMaintainable(legacyAnnotationDao);
    }

    public void setSendEmailDao(SendEmailDao sendEmailDao) {
        this.sendEmailDao = sendEmailDao;
        this.addMaintainable(sendEmailDao);
    }

    public void setContentDistributionDao(ContentDistributionDao contentDistributionDao) {
        this.contentDistributionDao = contentDistributionDao;
        this.addMaintainable(contentDistributionDao);
    }

    public void setApplicationConfigurationDao(ApplicationConfigurationDao applicationConfigurationDao) {
        this.applicationConfigurationDao = applicationConfigurationDao;
        this.addMaintainable(applicationConfigurationDao);
    }

    public void setAnalyticsDao(AnalyticsDao analyticsDao) {
        this.analyticsDao = analyticsDao;
        this.addMaintainable(analyticsDao);
    }

    public void setResumptionTokenDao(ResumptionTokenDao resumptionTokenDao) {
        this.resumptionTokenDao = resumptionTokenDao;
        this.addMaintainable(resumptionTokenDao);
    }

    public void setUserActivityDao(UserActivityDao userActivityDao) {
        this.userActivityDao = userActivityDao;
        this.addMaintainable(userActivityDao);
    }

    public void setSearchLimit(int searchLimit) {
        this.searchLimit = searchLimit;
    }

    public void setFailedLoginAttemptDao(FailedLoginAttemptDao failedLoginAttemptDao) {
        this.failedLoginAttemptDao = failedLoginAttemptDao;
        this.addMaintainable(failedLoginAttemptDao);
    }

    public void setMediaFieldStandardDao(MediaFieldStandardDao mediaFieldStandardDao) {
        this.mediaFieldStandardDao = mediaFieldStandardDao;
        this.addMaintainable(mediaFieldStandardDao);
    }

    public void setMediaStandardFieldDao(MediaStandardFieldDao mediaStandardFieldDao) {
        this.mediaStandardFieldDao = mediaStandardFieldDao;
        this.addMaintainable(mediaStandardFieldDao);
    }

    public void setLibraryHttpDao(LibraryHttpDao libraryHttpDao) {
        this.libraryHttpDao = libraryHttpDao;
        this.addMaintainable(libraryHttpDao);
    }

    public void setCategoriesDao(CategoriesDao categoriesDao) {
        this.categoriesDao = categoriesDao;
        this.addMaintainable(categoriesDao);
    }

    public void setSolrAnnotationDao(SolrServerAnnotationDAO solrAnnotationDao) {
        this.solrAnnotationDao = solrAnnotationDao;
        this.addMaintainable((Object)solrAnnotationDao);
    }

    @Override
    public Media getMedia(Credentials credentials, Object id) {
        return this.getMedia(credentials, id, false);
    }

    @Override
    public Media getMedia(Credentials credentials, Object id, boolean includeMediaFieldValues) {
        return this.getMedia(credentials, id, includeMediaFieldValues, false);
    }

    @Override
    public Media getMedia(Credentials credentials, Object id, boolean includeMediaFieldValues, boolean updateCache) throws DataAccessException {
        if (credentials == null) {
            throw new InvalidParameterException("Credentials cannot be null!");
        }
        Object identity = id;
        if (NumberUtils.isDigits((String)String.valueOf(identity))) {
            identity = NumberUtils.toInt((String)String.valueOf(identity), (int)-1);
        }
        if (identity instanceof String) {
            return this.getLunaMedia(credentials, (String)id, includeMediaFieldValues, updateCache);
        }
        if (identity instanceof URI) {
            return this.getLunaMedia(credentials, (URI)id, includeMediaFieldValues, updateCache);
        }
        if (identity instanceof Integer) {
            ExternalMedia media = this.getExternalObjectDataMedia(String.valueOf(identity));
            if (media.getObjectId() != null) {
                identity = media.getObjectId();
                if (NumberUtils.isDigits((String)String.valueOf(identity))) {
                    identity = NumberUtils.toInt((String)String.valueOf(identity), (int)-1);
                }
                if (identity instanceof String && InsightCoreUtils.isValidLunaMediaIdFormat(String.valueOf(identity)) && this.getLunaMedia(credentials, (String)identity, includeMediaFieldValues, updateCache) == null) {
                    return null;
                }
            }
            return media;
        }
        log.info((Object)("Unknown media id: [" + identity + "]"));
        return null;
    }

    @Override
    public List<Media> getMediaFromSearchResult(MediaSearchResult sr, Authenticable authenticable) {
        return this.getMediaFromSearchResult(sr, authenticable, DEFAULT_MAX_MEDIA, false);
    }

    @Override
    public List<Media> getMediaFromSearchResult(MediaSearchResult sr, Authenticable authenticable, boolean includeMediaFieldValues) {
        return this.getMediaFromSearchResult(sr, authenticable, DEFAULT_MAX_MEDIA, includeMediaFieldValues);
    }

    @Override
    public List<Media> getMediaFromSearchResult(MediaSearchResult sr, Authenticable authenticable, int maximum, boolean includeMediaFieldValues) {
        ArrayList<Media> toReturn = new ArrayList<Media>();
        if (sr != null && !sr.isEmpty()) {
            for (Result result : sr.getResults()) {
                Media m;
                if (maximum >= 0 && toReturn.size() >= maximum) break;
                if (result == null) continue;
                try {
                    m = this.getMedia(authenticable.getCredentials(), result.getIdentity(), includeMediaFieldValues);
                }
                catch (InvalidParameterException e) {
                    m = null;
                }
                catch (InsufficientPermissionException e) {
                    m = null;
                }
                if (m == null) continue;
                toReturn.add(m);
            }
        }
        return toReturn;
    }

    private LunaMedia getLunaMedia(Credentials credentials, URI id, boolean includeMediaFieldValues, boolean updateCache) throws InsufficientPermissionException {
        return this.getLunaMedia(credentials, id.toString(), includeMediaFieldValues, updateCache, true);
    }

    private LunaMedia getLunaMedia(Credentials credentials, String id, boolean includeMediaFieldValues, boolean updateCache) throws InsufficientPermissionException {
        return this.getLunaMedia(credentials, id, includeMediaFieldValues, updateCache, false);
    }

    private LunaMedia getLunaMedia(Credentials credentials, String id, boolean includeMediaFieldValues, boolean updateCache, boolean isUri) throws InsufficientPermissionException {
        LunaMedia toReturn = null;
        log.debug((Object)("getLunaMedia(..): id = " + id));
        PublisherMedia pm = null;
        if (!isUri) {
            pm = this.lunaMediaDAO.findByMediaId(id);
        } else {
            ArrayList<String> uriList = new ArrayList<String>();
            uriList.add(id);
            List pms = this.lunaMediaDAO.findByUriList(uriList, 1);
            if (pms != null && pms.size() > 0) {
                pm = (PublisherMedia)pms.get(0);
                id = pm.getFieldValue("id");
            }
        }
        if (pm == null) {
            return null;
        }
        log.debug((Object)("getLunaMedia(..): pm = " + pm));
        String cType = this.getMediaCollectionType(id);
        LunaMedia media = null;
        media = this.isLuna7 ? this.mediaDao.get(cType).getLunaMedia(pm, updateCache) : this.mediaDao.get(cType).getLunaMedia(id, updateCache);
        if (media != null && media.getCollection() != null) {
            int maxResolution = media.getCollection().isPublicCollection() ? PUBLIC_MEDIA_MAX_RESOLUTIONS : credentials.retrieveMaxResolution(media.getCollection().getId());
            log.info((Object)("getLunaMedia:credentials " + credentials));
            log.info((Object)("getLunaMedia:media " + media + " ; " + maxResolution));
            log.info((Object)("getLunaMedia:mediaCollection " + media.getCollection() + " ; " + media.getCollection().isPublicCollection()));
            if (maxResolution < 0) {
                log.info((Object)("No Permission for media: " + media));
                media = null;
                throw new InsufficientPermissionException("No permisions for this collection");
            }
            toReturn = media.getCollection() instanceof SharedMediaCollection ? new SharedLunaMedia() : new LunaMedia();
            toReturn.setMaxLevel(media.getMaxLevel());
            toReturn.setMaxWidth(media.getMaxWidth());
            toReturn.setMaxHeight(media.getMaxHeight());
            MediaDao mdao = this.mediaDao.get(cType);
            if (mdao instanceof LegacyMediaDao && maxResolution < PUBLIC_MEDIA_MAX_RESOLUTIONS) {
                try {
                    Vector<ImageFile> mediaImageData = ((LegacyMediaDao)mdao).getImageFilesFromSolr(media.getId());
                    double newMaxWidth = mediaImageData.get(maxResolution).getImageSize().getWidth();
                    double newMaxHeight = mediaImageData.get(maxResolution).getImageSize().getHeight();
                    log.debug((Object)("newMaxWidth:" + newMaxWidth + " newMaxHeight:" + newMaxHeight));
                    toReturn.setMaxWidth((int)newMaxWidth);
                    toReturn.setMaxHeight((int)newMaxHeight);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            toReturn.setObjectId(media.getObjectId());
            toReturn.setUniqueCollectionId(media.getUniqueCollectionId());
            toReturn.setMediaId(media.getMediaId());
            toReturn.setId(media.getId());
            toReturn.setFormat(media.getFormat());
            toReturn.setDisplayTitle(media.getDisplayTitle());
            toReturn.setCollection(this.getMediaCollection(InsightCoreUtils.getCollectionIdFromLunaMedia(media)));
            toReturn.setPermittedUsers(media.getPermittedUsers());
            toReturn.setCollectionOwner(media.getCollectionOwner());
            toReturn.setRefImageDim(media.getRefImageDim());
            if (media.getCollection() != null) {
                toReturn.setInstitutionId(media.getCollection().getInstitutionId());
            }
            if (includeMediaFieldValues) {
                media.setCollection(toReturn.getCollection());
                toReturn.setFieldValues(this.mediaFieldDao.get(cType).getMediaFieldValues(media));
            } else {
                toReturn.setFieldValues(new ArrayList<MediaFieldValue>());
            }
            if (media.getType() != null) {
                toReturn.setMediaType(media.getType().toString());
            }
            log.debug((Object)("ObjectId:" + toReturn.getObjectId()));
            log.debug((Object)("UniqueCollectionId:" + toReturn.getUniqueCollectionId()));
            log.debug((Object)("MediaId:" + toReturn.getMediaId()));
            log.debug((Object)("Id:" + toReturn.getId()));
            log.debug((Object)("Format:" + toReturn.getFormat()));
            log.debug((Object)("DisplayTitle:" + toReturn.getDisplayTitle()));
            log.debug((Object)("MaxHeight:" + toReturn.getMaxHeight()));
            log.debug((Object)("MaxLevel:" + toReturn.getMaxLevel()));
            log.debug((Object)("MaxWidth:" + toReturn.getMaxWidth()));
            log.debug((Object)("Collection:" + toReturn.getCollection()));
            log.debug((Object)("MediaType:" + toReturn.getMediaType()));
            log.debug((Object)("max:" + maxResolution));
            switch (maxResolution) {
                case 8: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 7: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 6: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 5: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 4: {
                    toReturn.setUrlSize4(media.getUrlSize4());
                }
                case 3: {
                    toReturn.setUrlSize3(media.getUrlSize3());
                }
                case 2: {
                    toReturn.setUrlSize2(media.getUrlSize2());
                }
                case 1: {
                    toReturn.setUrlSize1(media.getUrlSize1());
                }
                case 0: {
                    toReturn.setUrlSize0(media.getUrlSize0());
                }
            }
            if (maxResolution < 5 && media.getType() != Media.MediaType.IMAGE) {
                toReturn.setUrlSource(media.getUrlSource());
            }
            if (media.getUrlRefMedia() != null) {
                toReturn.setUrlRefMedia(media.getUrlRefMedia());
            }
            if (media.getUri() != null) {
                toReturn.setUri(media.getUri());
            }
            if (media instanceof SharedLunaMedia) {
                ((SharedLunaMedia)toReturn).setMiscInfo(((SharedLunaMedia)media).getMiscInfo());
            }
        }
        return toReturn;
    }

    private LunaMedia getLunaMedia(Credentials credentials, String id, boolean includeMediaFieldValues) throws InsufficientPermissionException {
        LunaMedia toReturn = null;
        String cType = this.getMediaCollectionType(id);
        LunaMedia media = this.mediaDao.get(cType).getLunaMedia(id);
        if (media != null && media.getCollection() != null) {
            int maxResolution = media.getCollection().isPublicCollection() ? PUBLIC_MEDIA_MAX_RESOLUTIONS : credentials.retrieveMaxResolution(media.getCollection().getId());
            log.debug((Object)("getLunaMedia:credentials " + credentials));
            log.debug((Object)("getLunaMedia:media " + media + " ; " + maxResolution));
            log.debug((Object)("getLunaMedia:mediaCollection " + media.getCollection() + " ; " + media.getCollection().isPublicCollection()));
            if (maxResolution < 0) {
                log.info((Object)("No Permission for media: " + media));
                media = null;
                throw new InsufficientPermissionException("No permisions for this collection");
            }
            toReturn = new LunaMedia();
            toReturn.setObjectId(media.getObjectId());
            toReturn.setUniqueCollectionId(media.getUniqueCollectionId());
            toReturn.setMediaId(media.getMediaId());
            toReturn.setId(media.getId());
            toReturn.setDisplayTitle(media.getDisplayTitle());
            toReturn.setMaxHeight(media.getMaxHeight());
            toReturn.setMaxLevel(media.getMaxLevel());
            toReturn.setFormat(media.getFormat());
            toReturn.setMaxWidth(media.getMaxWidth());
            toReturn.setCollection(this.getMediaCollection(InsightCoreUtils.getCollectionIdFromLunaMedia(media)));
            toReturn.setPermittedUsers(media.getPermittedUsers());
            toReturn.setCollectionOwner(media.getCollectionOwner());
            if (toReturn.getCollection() != null) {
                toReturn.setInstitutionId(toReturn.getCollection().getInstitutionId());
            }
            if (includeMediaFieldValues) {
                toReturn.setFieldValues(this.mediaFieldDao.get(cType).getMediaFieldValues(media));
            } else {
                toReturn.setFieldValues(new ArrayList<MediaFieldValue>());
            }
            if (media.getType() != null) {
                toReturn.setMediaType(media.getType().toString());
            }
            switch (maxResolution) {
                case 8: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 7: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 6: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 5: {
                    toReturn.setUrlSource(media.getUrlSource());
                }
                case 4: {
                    toReturn.setUrlSize4(media.getUrlSize4());
                }
                case 3: {
                    toReturn.setUrlSize3(media.getUrlSize3());
                }
                case 2: {
                    toReturn.setUrlSize2(media.getUrlSize2());
                }
                case 1: {
                    toReturn.setUrlSize1(media.getUrlSize1());
                }
                case 0: {
                    toReturn.setUrlSize0(media.getUrlSize0());
                }
            }
            if (maxResolution < 5 && media.getType() == Media.MediaType.BOOK) {
                toReturn.setUrlSource(media.getUrlSource());
            }
        }
        return toReturn;
    }

    public ExternalMedia getExternalObjectDataMedia(String id) {
        ExternalMedia toReturn = null;
        ExternalMedia media = this.mediaDao.get("legacy").getExternalMedia(id);
        media.setFieldValues(new ArrayList<MediaFieldValue>());
        toReturn = media;
        return toReturn;
    }

    @Override
    public List<MediaField> getMediaFields(MediaCollection mc) {
        String collectionType = mc.getCollectionType();
        MediaFieldDao dao = this.mediaFieldDao.get(collectionType);
        if (dao == null) {
            log.error((Object)("Could find collection type = " + collectionType + " Collection ID: " + mc.getId()));
            return null;
        }
        List<MediaField> mediaFields = dao.getAllMediaFields(mc);
        this.sortMediaFields(mediaFields);
        return mediaFields;
    }

    @Override
    public List<MediaField> getMediaFields(List<MediaCollection> mediaCollections) {
        ArrayList<MediaField> mediaFields = new ArrayList<MediaField>();
        if (CollectionUtils.isEmpty(mediaCollections) || mediaCollections.size() > 1) {
            mediaFields.addAll(this.getCrossCollectionMediaFields(mediaCollections));
            mediaFields.addAll(this.getPreviewMediaFields(mediaCollections));
        } else {
            mediaFields = this.getMediaFields(mediaCollections.get(0));
            this.sortMediaFields(mediaFields);
        }
        return mediaFields;
    }

    @Override
    public List<MediaField> getCrossCollectionMediaFields(List<MediaCollection> mediaCollections) {
        ArrayList<MediaField> mediaFields = new ArrayList<MediaField>();
        for (MediaFieldDao mfd : this.mediaFieldDao.values()) {
            mediaFields.addAll(mfd.getCrossCollectionMediaFields(mediaCollections));
        }
        this.sortMediaFields(mediaFields);
        return mediaFields;
    }

    @Override
    public List<MediaField> getPreviewMediaFields(List<MediaCollection> mediaCollections) {
        ArrayList<MediaField> mediaFields = new ArrayList<MediaField>();
        for (MediaFieldDao mfd : this.mediaFieldDao.values()) {
            mediaFields.addAll(mfd.getPreviewMediaFields(mediaCollections));
        }
        this.sortMediaFields(mediaFields);
        return mediaFields;
    }

    @Override
    public MediaField getMediaField(MediaCollection mc, String fieldName) {
        List<MediaField> mediaFields = this.getMediaFields(mc);
        for (MediaField mf : mediaFields) {
            if (mf == null || !StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName)) continue;
            return mf;
        }
        return null;
    }

    @Override
    public MediaField getMediaField(List<MediaCollection> mcs, String fieldName) {
        List<MediaField> mediaFields = this.getMediaFields(mcs);
        for (MediaField mf : mediaFields) {
            if (mf == null || !StringUtils.equalsIgnoreCase((String)mf.getFieldName(), (String)fieldName)) continue;
            return mf;
        }
        return null;
    }

    @Override
    public List<String> mediaFieldSuggestionValues(List<MediaCollection> mcs, MediaField mf, String prefix) {
        List<String> suggestionValues = null;
        Map<String, String> toReturn = null;
        if (CollectionUtils.isEmpty(mcs) || mcs.size() > 1) {
            toReturn = this.facetsDao.getUniqueValues(mf.getType(), prefix);
            if (toReturn != null) {
                suggestionValues = new ArrayList<String>(toReturn.values());
            }
        } else {
            String fieldName = mf == null ? "" : mf.getFieldName();
            suggestionValues = this.lunaMediaDAO.suggestions(mcs, fieldName, prefix);
        }
        return suggestionValues;
    }

    @Override
    public Map<String, String> getUniqueMediaFieldValues(String term, List<MediaCollection> mcs, MediaField mf) {
        Map<String, String> toReturn = null;
        if (CollectionUtils.isEmpty(mcs) || mcs.size() > 1) {
            toReturn = this.facetsDao.getUniqueValues(mf.getType(), term);
        } else {
            MediaCollection collection = mcs.get(0);
            toReturn = this.mediaFieldDao.get(collection.getCollectionType()).getUniqueValues(term, collection, mf);
        }
        return toReturn;
    }

    @Override
    public MediaResult findMedia(String mediaId, Authenticable authenticable) {
        MediaResult result = null;
        if (mediaId != null && authenticable != null) {
            try {
                MediaSearchCriteria criteria = new MediaSearchCriteria();
                criteria.setAuthenticable(authenticable);
                ArrayList<String> mediaIds = new ArrayList<String>();
                mediaIds.add(mediaId);
                criteria.setMediaFields(this.getMediaFields(authenticable.getMediaCollections()));
                criteria.findSpecificMedia(mediaIds, authenticable.getMediaCollections());
                MediaSearchResult searchResults = this.findMedia(criteria, 0, 1);
                if (!searchResults.isEmpty()) {
                    result = searchResults.getResults().get(0);
                }
            }
            catch (InvalidSearchQuery invalidSearchQuery) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public List<Annotation> findAnnotationsByIds(List<Integer> annotIds) {
        return this.annotationDao.getAnnotations(annotIds);
    }

    @Override
    public MediaSearchResult findMedia(MediaSearchCriteria criteria, int offset, int maximumNumberOfDocuments) {
        return this.findMedia(criteria, offset, maximumNumberOfDocuments, false);
    }

    @Override
    public MediaSearchResult findMedia(MediaSearchCriteria criteria, int offset, int maximumNumberOfDocuments, boolean fullData) {
        MediaSearchResult msr = null;
        try {
            if (criteria.isAnnotationSearch()) {
                List<Annotation> annots = this.getAnnotationsByCriteria(criteria, offset, maximumNumberOfDocuments);
                ArrayList<Integer> annotIds = new ArrayList<Integer>();
                for (Annotation annotation : annots) {
                    annotIds.add(annotation.getId());
                }
                if (annots != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (Annotation annot : annots) {
                        hashSet.add(annot.getMediaId());
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(hashSet);
                    return this.mediaSearchByIds(criteria.getAuthenticable(), arrayList);
                }
            }
            if ((msr = fullData ? this.mediaSearchDao.findMedia(criteria, offset, maximumNumberOfDocuments, true) : this.mediaSearchDao.findMedia(criteria, offset, maximumNumberOfDocuments)) != null) {
                block4: for (Result result : msr.getResults()) {
                    List<MediaFieldValue> list;
                    if (!(result instanceof LuceneMediaResult) || (list = ((LuceneMediaResult)result).getFieldValues()) == null) continue;
                    for (MediaFieldValue fieldValue : list) {
                        if (!fieldValue.getField().isDisplayTitleField()) continue;
                        ((LuceneMediaResult)result).putAttribute(LuceneDocumentFactory.LuceneAttribute.displayTitle.toString(), String.valueOf(fieldValue.getValue()));
                        continue block4;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Lucene search failed ", (Throwable)e);
        }
        return msr;
    }

    @Override
    public MediaSearchResult findMediaRandomized(MediaSearchCriteria criteria, int maximumNumberOfDocuments) {
        MediaSearchResult msr = null;
        try {
            msr = this.mediaSearchDao.findMediaRandomized(criteria, maximumNumberOfDocuments, String.valueOf(System.currentTimeMillis()));
        }
        catch (Exception e) {
            log.error((Object)"Lucene search failed ", (Throwable)e);
        }
        return msr;
    }

    @Override
    public List<MediaResult> findMediaByGroup(Authenticable authenticable, MediaGroup group, int offset, int maxMedia) {
        ArrayList<MediaResult> toReturn = new ArrayList<MediaResult>();
        if (authenticable != null && group != null && CollectionUtils.isNotEmpty((Collection)group.getMediaIds())) {
            if (maxMedia < 0) {
                maxMedia = group.getMediaIds().size();
            }
            List idList = group.getMediaIds().subList(offset, Math.min(maxMedia + offset, group.getMediaIds().size()));
            MediaSearchCriteria criteria = null;
            MediaSearchResult lunaMedia = null;
            try {
                criteria = new MediaSearchCriteria();
                criteria.findSpecificMedia(idList, authenticable.getMediaCollections());
                criteria.setMediaFields(this.getMediaFields(criteria.getCollectionLimit()));
                criteria.setAuthenticable(authenticable);
                lunaMedia = this.findMedia(criteria, 0, idList.size());
            }
            catch (InvalidSearchQuery invalidSearchQuery) {
                // empty catch block
            }
            for (Object id : idList) {
                try {
                    MediaResult media = id instanceof String && InsightCoreUtils.isValidLunaMediaIdFormat((String)id) ? lunaMedia.getByIdentity(id) : this.getMedia(authenticable.getCredentials(), id, false);
                    if (media == null) continue;
                    toReturn.add(media);
                }
                catch (DataAccessException e) {
                    log.error((Object)("Error getting media for " + group + " with id [" + id + "]"), (Throwable)e);
                }
            }
        }
        return toReturn;
    }

    @Override
    public MediaSearchResult mediaSearchByIds(Authenticable authenticable, List idList) {
        ArrayList<MediaResult> toReturn = new ArrayList<MediaResult>();
        MediaSearchCriteria criteria = null;
        MediaSearchResult lunaMedia = null;
        try {
            criteria = new MediaSearchCriteria();
            criteria.findSpecificMedia(idList, authenticable.getMediaCollections());
            criteria.setMediaFields(this.getMediaFields(criteria.getCollectionLimit()));
            criteria.setAuthenticable(authenticable);
            lunaMedia = this.findMedia(criteria, 0, idList.size());
        }
        catch (InvalidSearchQuery invalidSearchQuery) {
            // empty catch block
        }
        if (lunaMedia != null) {
            for (Object id : idList) {
                try {
                    MediaResult media = id instanceof String && InsightCoreUtils.isValidLunaMediaIdFormat((String)id) ? lunaMedia.getByIdentity(id) : this.getMedia(authenticable.getCredentials(), id, false);
                    if (media == null) continue;
                    toReturn.add(media);
                }
                catch (DataAccessException e) {
                    log.error((Object)("Error getting media for ids [" + idList + "]"), (Throwable)e);
                }
            }
        }
        MediaSearchResult sr = new MediaSearchResult((List<MediaResult>)toReturn);
        sr.setSearchCriteria(criteria);
        return sr;
    }

    @Override
    public MediaSearchResult mediaSearchByGroupAllCollections(Authenticable authenticable, MediaGroup group, int offset, int maxMedia) {
        if (authenticable != null && group != null && CollectionUtils.isNotEmpty((Collection)group.getMediaIds())) {
            if (maxMedia < 0) {
                maxMedia = group.getMediaIds().size();
            }
            ArrayList mids = new ArrayList(group.getMediaIds());
            List idList = mids.subList(offset, Math.min(maxMedia + offset, group.getMediaIds().size()));
            return this.mediaSearchByIds(authenticable, idList);
        }
        return null;
    }

    @Override
    public List<MediaResult> findMediaByGroupAllCollections(Authenticable authenticable, MediaGroup group, int offset, int maxMedia) {
        ArrayList<MediaResult> toReturn = new ArrayList<MediaResult>();
        if (authenticable != null && group != null && CollectionUtils.isNotEmpty((Collection)group.getMediaIds())) {
            if (maxMedia < 0) {
                maxMedia = group.getMediaIds().size();
            }
            List idList = group.getMediaIds().subList(offset, Math.min(maxMedia + offset, group.getMediaIds().size()));
            MediaSearchCriteria criteria = null;
            MediaSearchResult lunaMedia = null;
            try {
                criteria = new MediaSearchCriteria();
                criteria.findSpecificMedia(idList, this.mediaCollectionDao.getAllMediaCollections());
                criteria.setMediaFields(this.getMediaFields(criteria.getCollectionLimit()));
                criteria.setAuthenticable(authenticable);
                lunaMedia = this.findMedia(criteria, 0, idList.size());
            }
            catch (InvalidSearchQuery invalidSearchQuery) {
                // empty catch block
            }
            for (Object id : idList) {
                try {
                    MediaResult media;
                    if (id instanceof String && InsightCoreUtils.isValidLunaMediaIdFormat((String)id)) {
                        media = lunaMedia.getByIdentity(id);
                        media = this.getLunaMedia(authenticable.getCredentials(), (String)id, true);
                    } else {
                        media = this.getMedia(authenticable.getCredentials(), id, false);
                    }
                    if (media == null) continue;
                    toReturn.add(media);
                }
                catch (DataAccessException e) {
                    log.error((Object)("Error getting media for " + group + " with id [" + id + "]"), (Throwable)e);
                }
            }
        }
        return toReturn;
    }

    @Override
    public Facets getMediaFacets(MediaSearchResult searchResult, String sortOption) {
        return this.facetsDao.generateFacets(searchResult, sortOption);
    }

    @Override
    public Facets getMediaFacets(MediaSearchResult searchResult, String sortOption, int userFacetLimit) {
        return this.facetsDao.generateFacets(searchResult, sortOption, userFacetLimit);
    }

    @Override
    public Facets getMediaFacets(MediaSearchCriteria criteria) {
        Facets facets = null;
        if (criteria != null) {
            String generatedQueryString = LuceneSearchCriteriaParserDeprecated.getInstance().generateQueryString(criteria);
            log.debug((Object)("generatedQueryString = " + generatedQueryString));
            facets = this.facetsDao.generateFacets(criteria);
        }
        return facets;
    }

    @Override
    public List<String> getAllFacetValues() {
        return this.facetsDao.getFacetValues(this.getMediaFields((MediaCollection)null));
    }

    @Override
    public Facets getRelatedItemFacets(MediaCollection mc, String relatedItemField, String prefix, Authenticable authenticable) {
        return this.facetsDao.generateRelatedItemFacets(mc, relatedItemField, prefix, authenticable);
    }

    @Override
    public List<Pair> getCustomFacets(MediaSearchResult searchResult, String sortOption, int userFacetLimit, List<MediaField> customFacetFields) {
        List<Pair> facetList = this.facetsDao.generateCustomFacets(searchResult, sortOption, userFacetLimit, customFacetFields);
        if (facetList != null) {
            Collections.sort(facetList, new FacetFieldComparator());
        }
        return facetList;
    }

    @Override
    public ExtendedCollectionProperties getDefaultExtendedCollectionProperties() {
        return this.mediaCollectionDao.getDefaultExtendedCollectionProperties();
    }

    @Override
    public ExtendedCollectionProperties getAllCollectionsExtendedCollectionProperties() {
        return this.mediaCollectionDao.getAllCollectionsExtendedCollectionProperties();
    }

    @Override
    public MediaCollection getMediaCollection(String id) {
        MediaCollection mc = this.mediaCollectionDao.getMediaCollection(id);
        if (mc != null) {
            List<MediaField> mfs = this.getMediaFields(mc);
            if (mfs == null) {
                this.mediaCollectionDao.suspendMediaCollection(mc);
                return null;
            }
            mc.setMediaFields(mfs);
            if (mc.getTotalMediaCount() <= 0) {
                this.setMediaCount(mc);
            }
        }
        return mc;
    }

    @Override
    public void setMediaCount(MediaCollection mc) {
        if (this.lunaMediaDAO != null) {
            mc.setTotalMediaCount(this.getMediaCountFromCache(mc.getId()));
        }
    }

    @Override
    public List<MediaCollection> getUnavailableCollectionsForGroup(Authenticable authenticable, MediaGroup group) {
        ArrayList<MediaCollection> toReturn = new ArrayList<MediaCollection>();
        if (authenticable != null && group != null) {
            MediaCollection tempColl;
            String collId = null;
            ArrayList<MediaCollection> groupCollections = new ArrayList<MediaCollection>();
            if (!this.isLuna7) {
                List<MediaResult> media = this.findMediaByGroupAllCollections(authenticable, group);
                for (Result result : media) {
                    if (result.getClass().toString().equalsIgnoreCase(LuceneMediaResult.class.toString())) {
                        LuceneMediaResult res = (LuceneMediaResult)result;
                        collId = InsightCoreUtils.getCollectionIdFromLunaMediaId(res.getId().toString());
                    } else {
                        collId = result.getClass().toString().equalsIgnoreCase(LunaMedia.class.toString()) ? InsightCoreUtils.getCollectionIdFromLunaMediaId(((LunaMedia)result).getId().toString()) : (result.getClass().toString().equalsIgnoreCase(ExternalMedia.class.toString()) ? InsightCoreUtils.getCollectionIdFromLunaMediaId(((ExternalMedia)result).getObjectId()) : null);
                    }
                    if (!StringUtils.isNotEmpty((String)collId) || (tempColl = this.getMediaCollection(collId)) == null || groupCollections.contains(tempColl)) continue;
                    groupCollections.add(tempColl);
                }
            } else {
                ArrayList mediaIds = group.getMediaIds();
                if (mediaIds != null && !mediaIds.isEmpty()) {
                    for (String string : mediaIds) {
                        if (StringUtils.isNumeric((String)string) || (tempColl = this.getMediaCollection(collId = InsightCoreUtils.getCollectionIdFromLunaMediaId(string))) == null || groupCollections.contains(tempColl)) continue;
                        groupCollections.add(tempColl);
                    }
                }
            }
            ArrayList<MediaCollection> userCollections = authenticable.getMediaCollections();
            for (MediaCollection mediaCollection : groupCollections) {
                if (userCollections.contains(mediaCollection)) continue;
                toReturn.add(mediaCollection);
            }
        }
        return toReturn;
    }

    @Override
    public List<MediaCollection> getPublicMediaCollections() {
        log.debug((Object)"getPublicMediaCollections(): ");
        List<MediaCollection> mcs = this.mediaCollectionDao.getPublicMediaCollections();
        log.debug((Object)("getPublicMediaCollections(): public media collections size = " + (mcs != null ? mcs.size() : 0)));
        if (CollectionUtils.isNotEmpty(mcs)) {
            long start = System.currentTimeMillis();
            for (MediaCollection mc : mcs) {
                if (mc == null) continue;
                log.debug((Object)"getPublicMediaCollections(): before getting media fields.");
                mc.setMediaFields(this.getMediaFields(mc));
                log.debug((Object)"getPublicMediaCollections(): before counts the number.");
                this.setMediaCount(mc);
                log.debug((Object)"getPublicMediaCollections(): after counts the number.");
            }
            long end = System.currentTimeMillis();
            log.debug((Object)("getPublicMediaCollections(): total " + (end - start) / 1000L + " seconds."));
        }
        return mcs;
    }

    public ArrayList<MediaCollection> getMultipleMediaCollections(ArrayList ids) {
        ArrayList<MediaCollection> mediaCollections = new ArrayList<MediaCollection>();
        for (Object id : ids) {
            MediaCollection mc = this.getMediaCollection((String)id);
            if (mc == null) continue;
            mediaCollections.add(mc);
        }
        Collections.sort(mediaCollections, new MediaCollectionComparator());
        return mediaCollections;
    }

    @Override
    public Authenticable authenticate(String ipAddress) {
        IpRange matchingIpRange = this.authenticationDao.authenticate(ipAddress);
        if (matchingIpRange != null) {
            matchingIpRange.setMediaCollections(this.getMultipleMediaCollections(matchingIpRange.getCredentials().getAuthorizedCollectionIds()));
        }
        return matchingIpRange;
    }

    @Override
    public User getUser(String username) {
        User user = this.authenticationDao.getUser(username, null);
        return user;
    }

    @Override
    public Authenticable authenticate(IpAddressUsernamePasswordToken token) throws DataAccessException {
        User user = this.authenticationDao.getUser(token.getUsername(), token.getIpAddress());
        if (user == null) {
            user = (User)this.authenticationDao.authenticate(token);
        } else if (user.isEnabled()) {
            try {
                ((JdbcAuthenticationDao)this.authenticationDao).setMediaCollectionList(this.mediaCollectionDao.getAllMediaCollections());
            }
            catch (Exception e) {
                log.error((Object)"Exception in authenticate()", (Throwable)e);
            }
            Subject subject = SecurityUtils.getSubject();
            if (!subject.isAuthenticated()) {
                user = (User)this.authenticationDao.authenticate(token);
            }
        } else if (!user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        this.loadUserCollections(user);
        return user;
    }

    @Override
    public Authenticable authenticate(String ipAddress, String username, String password) throws DataAccessException {
        IpAddressUsernamePasswordToken token = new IpAddressUsernamePasswordToken(username, password);
        token.setIpAddress(ipAddress);
        return this.authenticate(token);
    }

    @Override
    public Map<Integer, String> getAllUsers() {
        return this.authenticationDao.getAllUsersMap(false);
    }

    @Override
    public synchronized void processForgotPassword(String email, String ipAddress) throws DataAccessException {
        User user = this.authenticationDao.getUserByEmailAddress(email, ipAddress);
        if (!user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        user.setPassword(this.authenticationDao.generateRandomPassword(10));
        this.sendEmailDao.sendForgotPassword(user.getEmail(), user.getFirstName(), user.getPassword());
        String encrptedPassword = PasswordEncryptUtils.digest(user.getPassword());
        user.setPassword(encrptedPassword);
        this.saveUser(user);
    }

    @Override
    public synchronized void saveUser(User user) throws DataAccessException {
        if (!user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        this.authenticationDao.saveUser(user);
        this.loadUserCollections(user);
    }

    @Override
    public void registerUser(User user) throws AuthenticationFailureException, InsufficientPermissionException {
        if (this.isUsernameTaken(user.getUsername())) {
            throw new AuthenticationFailureException("Username is already taken.");
        }
        user.setCredentials(this.authenticationDao.getDefaultCredentials());
        user.setCredentialsId(this.authenticationDao.getDefaultCredentials().getId());
        user.setEnabled(true);
        this.saveUser(user);
        try {
            this.sendEmailDao.sendNewRegistrationEmail(user.getEmail(), user.getUsername());
        }
        catch (EmailFailureException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public boolean isUsernameTaken(String username) {
        boolean toReturn = this.authenticationDao.isUniqueName(username);
        return toReturn;
    }

    @Override
    public boolean isUserEmailTaken(String userEmail, String ipAddress) {
        boolean toReturn = false;
        User u = null;
        try {
            u = this.authenticationDao.getUserByEmailAddress(userEmail, ipAddress);
            if (u != null) {
                toReturn = true;
            }
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        return toReturn;
    }

    @Override
    public List<Presentation> getPresentations(int sampleSize) {
        List<Presentation> presentation = this.presentationDao.getPresentations(sampleSize);
        this.addPresentationUsername(presentation);
        return presentation;
    }

    @Override
    public List<Presentation> getPresentations(User user) {
        if (!user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        return this.presentationDao.getPresentations(user);
    }

    @Override
    public Presentation getPresentation(User user, int presentationId) {
        if (!user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        List<Presentation> presentations = this.getPresentations(user);
        for (Presentation p : presentations) {
            if (p == null || p.getId() != presentationId) continue;
            return p;
        }
        return null;
    }

    @Override
    public Presentation getPresentation(Authenticable authenticable, int pId, String password) {
        User user = null;
        if (authenticable instanceof User) {
            user = (User)authenticable;
        }
        Presentation toReturn = null;
        Presentation presentation = this.presentationDao.getPresentation(pId);
        if (presentation != null) {
            if (user == null || user.getId() != presentation.getUserId()) {
                if (presentation.isPubliclyViewable()) {
                    if (StringUtils.isEmpty((String)presentation.getPassword())) {
                        toReturn = presentation;
                    } else if (presentation.getPassword().equals(password)) {
                        toReturn = presentation;
                    }
                }
            } else {
                toReturn = presentation;
            }
        }
        return toReturn;
    }

    @Override
    public List<Presentation> getPublicPresentations(int sampleSize) {
        List<Presentation> presentations = this.getPresentations(sampleSize * 3);
        ArrayList<Presentation> publicPresentations = new ArrayList<Presentation>();
        int publicPresentationSize = 0;
        for (int i = presentations.size() - 1; i >= 0; --i) {
            Presentation s = presentations.get(i);
            if (publicPresentationSize >= sampleSize) break;
            if (s == null || !s.isPubliclyViewable()) continue;
            publicPresentations.add(s);
            ++publicPresentationSize;
        }
        return publicPresentations;
    }

    @Override
    public List<Presentation> getPresentations(SearchCriteria presentationSearchCriteria, User user) {
        List<Presentation> searchResults = this.executePresentationSearch(presentationSearchCriteria, user);
        if (!presentationSearchCriteria.getSearchText().trim().equals("")) {
            Collections.sort(searchResults, new DisplayableComparator(presentationSearchCriteria.getSearchText()));
        }
        this.addPresentationUsername(searchResults);
        return searchResults;
    }

    @Override
    public List<Slide> getSlides(Authenticable authenticable, Presentation p, boolean includeMediaFieldValues) throws DataAccessException {
        return this.getSlides(authenticable, p, includeMediaFieldValues, null);
    }

    @Override
    public List<Slide> getSlides(Authenticable authenticable, Presentation p, boolean includeMediaFieldValues, String lunaLibraryUrl) throws DataAccessException {
        List<Slide> slides = this.presentationDao.getSlides(p);
        if (authenticable != null && p != null) {
            Media media = null;
            if (!CollectionUtils.isEmpty(slides)) {
                for (Slide slide : slides) {
                    Date slideStartTime = new Date();
                    for (SlideMedia sm : slide.getSlideImages()) {
                        Date startTime = new Date();
                        try {
                            media = this.getMedia(authenticable.getCredentials(), sm.getMediaId(), includeMediaFieldValues);
                        }
                        catch (DataAccessException e) {
                            log.info((Object)(sm + " contains invalid media: "), (Throwable)e);
                            media = null;
                        }
                        if (media == null && lunaLibraryUrl != null && "DEFAULT~0~0".equals(InsightCoreUtils.getCollectionIdFromLunaMediaId(sm.getMediaId()))) {
                            media = this.getExternalMediaDetails(String.valueOf(InsightCoreUtils.getMediaIdFromLunaMediaId(sm.getMediaId())), authenticable.getId(), lunaLibraryUrl, true);
                        }
                        if (media != null) {
                            sm.setMedia(media);
                        }
                        log.info((Object)("Time to get the media =" + (new Date().getTime() - startTime.getTime())));
                    }
                    log.info((Object)("Time to get the slide data = " + (new Date().getTime() - slideStartTime.getTime())));
                }
            }
        }
        return slides;
    }

    private List<String> getLunaMediaIds(List<Slide> slides) {
        ArrayList<String> mediaIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(slides)) {
            for (Slide slide : slides) {
                for (SlideMedia sm : slide.getSlideImages()) {
                    String mediaId = sm.getMediaId();
                    if (mediaIds.contains(mediaId) || NumberUtils.isDigits((String)mediaId)) continue;
                    mediaIds.add(mediaId);
                }
            }
        }
        return mediaIds;
    }

    private void loadMedias(List<Slide> slides) {
        List<String> lunaMediaIds = this.getLunaMediaIds(slides);
        log.info((Object)"Starts mass media load");
        for (MediaDao dao : this.mediaDao.values()) {
            dao.getImageFiles(lunaMediaIds);
        }
        log.info((Object)"Stops mass media load");
    }

    @Override
    public List<MediaCollection> getUnavailableCollectionsForPresentation(Authenticable authenticable, Presentation p) throws DataAccessException {
        ArrayList<MediaCollection> toReturn = new ArrayList<MediaCollection>();
        List<Object> tempList = new ArrayList();
        List<Slide> slides = this.presentationDao.getSlides(p);
        if (authenticable != null && p != null && !CollectionUtils.isEmpty(slides)) {
            List<Object> images = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            MediaGroup tempGroup = new MediaGroup();
            tempGroup.setMediaIds(new ArrayList());
            for (Slide slide : slides) {
                images = slide.getSlideImages();
                for (SlideMedia slideMedia : images) {
                    idList.add(slideMedia.getMediaId());
                }
                tempGroup.addMedia(idList);
                tempList = this.getUnavailableCollectionsForGroup(authenticable, tempGroup);
                for (MediaCollection mediaCollection : tempList) {
                    if (toReturn.contains(mediaCollection)) continue;
                    toReturn.add(mediaCollection);
                }
            }
        }
        return toReturn;
    }

    @Override
    public synchronized void savePresentation(Presentation p) throws DataAccessException {
        this.presentationDao.savePresentation(p);
    }

    @Override
    public synchronized void deletePresentation(Presentation p) {
        this.presentationDao.deletePresentation(p);
    }

    @Override
    public synchronized void saveSlide(Slide s) throws DataAccessException {
        this.presentationDao.saveSlide(s);
    }

    @Override
    public void saveSlides(List<Slide> slides) throws DataAccessException {
        if (slides != null) {
            for (Slide s : slides) {
                this.saveSlide(s);
            }
        }
    }

    @Override
    public synchronized void saveSlideImages(Slide s) throws DataAccessException {
        this.presentationDao.saveSlideMedia(s);
    }

    @Override
    public synchronized void deleteSlide(Slide slide) throws DataAccessException {
        this.presentationDao.deleteSlide(slide);
    }

    @Override
    public synchronized void deleteSlideImage(Slide slide, SlideMedia sm) throws DataAccessException {
        this.presentationDao.deleteSlideImage(slide, sm);
    }

    @Override
    public synchronized void deleteAllSlideImages(Slide slide) throws DataAccessException {
        this.presentationDao.deleteAllSlideMedia(slide);
    }

    @Override
    public void saveMediaGroup(MediaGroup mediaGroup) throws DataAccessException {
        this.mediaGroupsDao.saveMediaGroup(mediaGroup);
    }

    private Integer getMediaCountFromCache(String cid) {
        Integer count;
        if (this.mediaCountCache == null) {
            this.initializeMediaCountCache();
        }
        if ((count = (Integer)this.mediaCountCache.getIfPresent((Object)cid)) == null) {
            count = (int)this.lunaMediaDAO.getCountByCollectionId(cid);
            this.addToMediaCountCache(cid, count);
        }
        return count;
    }

    @Override
    public int getMediaCount(List<MediaCollection> mcs) {
        if (this.isLuna7) {
            int totalCount = 0;
            for (MediaCollection mc : mcs) {
                totalCount += this.getMediaCountFromCache(mc.getId()).intValue();
            }
            return totalCount;
        }
        return this.facetsDao.getMediaCount(mcs);
    }

    private void addUsername(List<MediaGroup> mediaGroups) {
        for (MediaGroup mg : mediaGroups) {
            if (mg.getUsername() != null) continue;
            try {
                User user = this.authenticationDao.getUser(mg.getUserId());
                if (user == null) continue;
                mg.setUsername(user.getUsername());
            }
            catch (DataAccessException dataAccessException) {}
        }
    }

    @Override
    public List<MediaGroup> getMediaGroups(int sampleSize) {
        List<MediaGroup> publicMediaGroups = this.mediaGroupsDao.getMediaGroups(sampleSize);
        this.addUsername(publicMediaGroups);
        return publicMediaGroups;
    }

    @Override
    public List<MediaGroup> getAllMediaGroups() {
        return this.mediaGroupsDao.getAllMediaGroups();
    }

    @Override
    public List<Presentation> getAllPresentations() {
        return this.presentationDao.getAllPresentations();
    }

    @Override
    public List<MediaGroup> getMediaGroups(User user) {
        if (user != null && !user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        return this.mediaGroupsDao.getMediaGroups(user);
    }

    @Override
    public List<MediaGroup> getMediaGroups(SearchCriteria groupSearchCriteria, boolean includePublicGroups) {
        List<MediaGroup> searchResults = this.executeMediaGroupSearch(groupSearchCriteria, includePublicGroups);
        if (!groupSearchCriteria.getSearchText().trim().equals("")) {
            Collections.sort(searchResults, new DisplayableComparator(groupSearchCriteria.getSearchText()));
        }
        this.addUsername(searchResults);
        return searchResults;
    }

    @Override
    public MediaGroup getMediaGroup(int groupId, User user, String password) {
        MediaGroup toReturn = null;
        MediaGroup group = this.mediaGroupsDao.getMediaGroup(groupId);
        if (group != null) {
            if (user == null || user.getId() != group.getUserId()) {
                if (group.isPubliclyViewable()) {
                    if (StringUtils.isEmpty((String)group.getPassword())) {
                        toReturn = group;
                    } else if (group.getPassword().equals(password)) {
                        toReturn = group;
                    }
                }
            } else {
                toReturn = group;
            }
        }
        return toReturn;
    }

    @Override
    public MediaGroup getMediaGroup(int groupId, User user) {
        if (user != null && !user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        return this.getMediaGroup(groupId, user, null);
    }

    @Override
    public synchronized void addMediaToGroup(int groupId, Object mediaId, User user) throws DataAccessException {
        MediaGroup group = this.getMediaGroup(groupId, user);
        Media media = this.getMedia(user.getCredentials(), mediaId);
        if (user != null && user.isEnabled() && group.getUserId() == user.getId() && media != null) {
            this.addMediaToGroup(group, media);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addMediaToGroup(List mediaIds, int groupId, User user) throws DataAccessException {
        MediaGroup group = this.getMediaGroup(groupId, user, null);
        if (user != null && user.isEnabled() && group.getUserId() == user.getId()) {
            for (Object obj : mediaIds) {
                Media media = this.getMedia(user.getCredentials(), obj);
                if (media == null) continue;
                group.addMedia(media.getIdentity());
            }
            this.addToMediaGroupLock.lock();
            try {
                this.mediaGroupsDao.saveMediaGroup(group);
            }
            finally {
                this.addToMediaGroupLock.unlock();
            }
        }
    }

    @Override
    public synchronized void addMediaToGroup(List mediaIds, int groupId, User user, String libraryUrl) throws DataAccessException {
        MediaGroup group = this.getMediaGroup(groupId, user, null);
        if (user != null && user.isEnabled() && group.getUserId() == user.getId()) {
            List<ExternalMedia> myMediaList = this.getExternalMediaDetails(mediaIds, user.getId(), libraryUrl, false);
            for (Media media : myMediaList) {
                this.addMediaToGroup(group, media);
            }
        }
    }

    @Override
    public void addMediaToDefaultGroup(String mediaId, User user) throws DataAccessException {
        if (!user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        if (user.getDefaultGroupId() < 1) {
            throw new DataRetrievalFailureException("User has no default group defined.");
        }
        this.addMediaToGroup(user.getDefaultGroupId(), mediaId, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaToDefaultGroup(Media media, User user) throws DataAccessException {
        if (!user.isEnabled()) {
            throw new AuthenticationFailureException("User not enabled.");
        }
        if (user.getDefaultGroupId() < 1) {
            throw new DataRetrievalFailureException("User has no default group defined.");
        }
        this.addToMediaGroupLock.lock();
        try {
            MediaGroup group = this.getMediaGroup(user.getDefaultGroupId(), user);
            this.addMediaToGroup(group, media);
        }
        finally {
            this.addToMediaGroupLock.unlock();
        }
    }

    @Override
    public List<Media> getMediaForGroup(Authenticable authenticable, MediaGroup group) {
        return this.getMediaForGroup(authenticable, group, false);
    }

    @Override
    public List<Media> getMediaForGroup(Authenticable authenticable, MediaGroup group, boolean includeMediaFieldValues) {
        return this.getMediaForGroup(authenticable, group, 0, -1, includeMediaFieldValues);
    }

    @Override
    public List<Media> getMediaForGroup(Authenticable authenticable, MediaGroup group, int offset, int maxMedia) {
        return this.getMediaForGroup(authenticable, group, offset, maxMedia, false);
    }

    @Override
    public List<Media> getMediaForGroup(Authenticable authenticable, MediaGroup group, int offset, int maxMedia, boolean includeMediaFieldValues) {
        ArrayList<Media> toReturn = new ArrayList<Media>();
        if (authenticable != null && group != null) {
            if (maxMedia < 0) {
                maxMedia = group.getMediaIds().size();
            }
            List idList = group.getMediaIds().subList(offset, Math.min(maxMedia + offset, group.getMediaIds().size()));
            for (Object id : idList) {
                try {
                    Media media = this.getMedia(authenticable.getCredentials(), id, includeMediaFieldValues);
                    if (media == null) continue;
                    toReturn.add(media);
                }
                catch (DataAccessException e) {
                    log.error((Object)("error getting media for group: " + group), (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)("error getting media for group: " + group), (Throwable)e);
                }
            }
        }
        return toReturn;
    }

    @Override
    public List<MediaResult> findMediaByGroup(Authenticable authenticable, MediaGroup group) {
        ArrayList<MediaResult> toReturn = new ArrayList<MediaResult>();
        if (group != null && group.getMediaIds() != null) {
            toReturn.addAll(this.findMediaByGroup(authenticable, group, 0, group.getMediaIds().size()));
        }
        return toReturn;
    }

    @Override
    public MediaSearchResult mediaSearchResultByGroupAllCollections(Authenticable authenticable, MediaGroup group) {
        MediaSearchResult sr = null;
        if (group != null && group.getMediaIds() != null) {
            sr = this.mediaSearchByGroupAllCollections(authenticable, group, 0, group.getMediaIds().size());
        }
        return sr;
    }

    @Override
    public List<MediaResult> findMediaByGroupAllCollections(Authenticable authenticable, MediaGroup group) {
        ArrayList<MediaResult> toReturn = new ArrayList<MediaResult>();
        if (group != null && group.getMediaIds() != null) {
            toReturn.addAll(this.findMediaByGroupAllCollections(authenticable, group, 0, group.getMediaIds().size()));
        }
        return toReturn;
    }

    @Override
    public synchronized void deleteMediaGroup(MediaGroup mg) {
        this.mediaGroupsDao.deleteMediaGroup(mg);
    }

    @Override
    public synchronized void removeMediaFromGroup(MediaGroup mediaGroup, List selectedMediaIds, User user) {
        if (user != null && user.isEnabled() && mediaGroup.getUserId() == user.getId()) {
            mediaGroup.removeMedia(selectedMediaIds);
            this.mediaGroupsDao.saveMediaGroup(mediaGroup);
        }
    }

    @Override
    public Annotation getAnnotation(int anttId, User user) {
        Annotation toReturn = null;
        Annotation annotation = ((JdbcAnnotationDao)this.annotationDao).getAnnotation(anttId);
        if (annotation != null) {
            toReturn = annotation;
        }
        return toReturn;
    }

    @Override
    public List<Annotation> getAnnotations(List<Integer> anttIds, User user) {
        int BATCH_SIZE = 1000;
        ArrayList<Annotation> toReturn = new ArrayList<Annotation>();
        List idLists = ListUtils.partition(anttIds, (int)BATCH_SIZE);
        for (int i = 0; i < idLists.size(); ++i) {
            List<Annotation> annotations = ((JdbcAnnotationDao)this.annotationDao).getAnnotations((List)idLists.get(i));
            if (annotations == null) continue;
            toReturn.addAll(annotations);
        }
        for (Annotation anno : toReturn) {
            ((JdbcAnnotationDao)this.annotationDao).loadHistory(anno);
        }
        return toReturn;
    }

    public void addMapKuratorValuesToParentDoc(PublisherAnnotation pa, String mediaId) {
        List<String> pocOcrTextList;
        List<String> ocrTextList = ((JdbcAnnotationDao)this.annotationDao).getUniqueValuesByCreatorName(mediaId, "mapKurator:ocr");
        if (ocrTextList != null && ocrTextList.size() > 0) {
            for (String text : ocrTextList) {
                if (!StringUtils.isNotBlank((String)text)) continue;
                pa.addField(PublisherMedia.ANNOTATION_SEARCH_FIELD, (Object)text);
                pa.addField(PublisherMedia.ANNOTATION_OCR_TEXT, (Object)text);
            }
        }
        if ((pocOcrTextList = ((JdbcAnnotationDao)this.annotationDao).getUniqueValuesByCreatorName(mediaId, "mapKurator:post-ocr-correction")) != null && pocOcrTextList.size() > 0) {
            for (String text : pocOcrTextList) {
                if (!StringUtils.isNotBlank((String)text)) continue;
                pa.addField(PublisherMedia.ANNOTATION_SEARCH_FIELD, (Object)text);
                pa.addField(PublisherMedia.ANNOTATION_POST_OCR_TEXT, (Object)text);
            }
        }
    }

    public void addUserCorrectionTextToParentDoc(PublisherAnnotation pa, String mediaId) {
        List<String> userCorrectionTextList = ((JdbcAnnotationDao)this.annotationDao).getUniqueUserCorrectionValues(mediaId);
        if (userCorrectionTextList != null && userCorrectionTextList.size() > 0) {
            for (String text : userCorrectionTextList) {
                if (!StringUtils.isNotBlank((String)text)) continue;
                text = Jsoup.parse((String)text).text();
                pa.addField(PublisherMedia.ANNOTATION_SEARCH_FIELD, (Object)text);
                pa.addField(PublisherMedia.ANNOTATION_USER_CORRECTION_TEXT, (Object)text);
            }
        }
    }

    public void addLegacyTextToParentDoc(PublisherAnnotation pa, String mediaId) {
        List<String> legacyAnnoTextList = ((JdbcAnnotationDao)this.annotationDao).getUniqueLegacyValues(mediaId);
        if (legacyAnnoTextList != null && legacyAnnoTextList.size() > 0) {
            for (String text : legacyAnnoTextList) {
                if (!StringUtils.isNotBlank((String)text)) continue;
                text = Jsoup.parse((String)text).text();
                pa.addField(PublisherMedia.ANNOTATION_SEARCH_FIELD, (Object)text);
            }
        }
    }

    @Override
    public int getAnnotationCount(String mid, int mgid, User user) {
        Subject subject = SecurityUtils.getSubject();
        if (subject.hasRole(PermissionManager.getRoleSuperAdmin())) {
            return ((JdbcAnnotationDao)this.annotationDao).getAnnotationCount(mid);
        }
        if (user != null) {
            return ((JdbcAnnotationDao)this.annotationDao).getAnnotationCount(mid, mgid, user.getId());
        }
        return ((JdbcAnnotationDao)this.annotationDao).getAnnotationCount(mid, mgid);
    }

    @Override
    public List<Annotation> getAnnotations(String mid, int mgid, User user) {
        return this.getAnnotations(mid, mgid, user, null, null);
    }

    @Override
    public List<Annotation> getAnnotations(String mid, int mgid, User user, Integer offset, Integer limit) {
        ArrayList<Annotation> toReturn = new ArrayList<Annotation>();
        List<Annotation> annotations = null;
        Subject subject = SecurityUtils.getSubject();
        try {
            if (subject.hasRole(PermissionManager.getRoleSuperAdmin())) {
                annotations = ((JdbcAnnotationDao)this.annotationDao).getAnnotations(mid, offset, limit);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not determine if running as superadmin", (Throwable)e);
        }
        if (annotations == null) {
            annotations = user != null ? ((JdbcAnnotationDao)this.annotationDao).getAnnotations(mid, mgid, user.getId(), offset, limit) : ((JdbcAnnotationDao)this.annotationDao).getAnnotations(mid, mgid, -1, offset, limit);
        }
        if (!annotations.isEmpty()) {
            for (Annotation a : annotations) {
                if (user == null || user.getId() != a.getUserId()) {
                    toReturn.add(a);
                    continue;
                }
                toReturn.add(a);
            }
        }
        return toReturn;
    }

    @Override
    public List<Annotation> getLegacyAnnotations(String mid) {
        ArrayList<Annotation> toReturn = new ArrayList<Annotation>();
        List<Annotation> annotations = this.legacyAnnotationDao.getAnnotations(mid);
        if (!annotations.isEmpty()) {
            for (Annotation a : annotations) {
                toReturn.add(a);
            }
        }
        return toReturn;
    }

    @Override
    public synchronized int saveAnnotation(Annotation a, User user) throws DataAccessException {
        return this.saveAnnotation(a, user, true);
    }

    @Override
    public synchronized int saveAnnotation(Annotation a, User user, boolean updateParentDoc) throws DataAccessException {
        return this.saveAnnotation(a, user, updateParentDoc, true);
    }

    @Override
    public int saveAnnotation(Annotation a, User user, boolean updateParentDoc, boolean autoCreateHistory) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        String text = StringUtils.trim((String)a.getAnnotation());
        a.setAnnotation(text);
        if (autoCreateHistory) {
            SimpleDate now = new SimpleDate(new Date());
            AnnotationHistory history = new AnnotationHistory(a.getId(), user.getId(), a.getAnnotation(), now.toString(), "transcribing");
            a.addHistory(history);
        }
        int aId = ((JdbcAnnotationDao)this.annotationDao).saveAnnotation(a);
        long dbSaveTime = System.currentTimeMillis() - startTime;
        if (aId > 0) {
            if (a.getAnnotationUri() != null) {
                this.deleteAnnotationByUriFromSolr(a.getAnnotationUri());
            }
            startTime = System.currentTimeMillis();
            PublisherAnnotation pa = AnnotationMapper.createPublisherAnnotation(a);
            pa.setUserId((long)user.getId());
            long objConvTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            this.saveAnnotationToSolr(pa);
            long solrSaveTime = System.currentTimeMillis() - startTime;
            log.debug((Object)("@@@@@@  dbSaveTime: " + dbSaveTime + "ms objConvTime: " + objConvTime + " ms solrSaveTime: " + solrSaveTime + "ms"));
            if (updateParentDoc) {
                this.updateAnnotationParentDoc(a.getMediaId());
            }
        }
        return aId;
    }

    @Override
    public void saveAnnotations(List<Annotation> aList, User user, boolean updateParentDoc, boolean autoCreateHistory) throws DataAccessException {
        if (aList == null) {
            return;
        }
        ArrayList<PublisherAnnotation> addList = new ArrayList<PublisherAnnotation>();
        ArrayList<String> deleteList = new ArrayList<String>();
        ArrayList<String> parentDocsToUpdate = new ArrayList<String>();
        for (Annotation a : aList) {
            int aId;
            String text = StringUtils.trim((String)a.getAnnotation());
            a.setAnnotation(text);
            if (autoCreateHistory) {
                SimpleDate now = new SimpleDate(new Date());
                AnnotationHistory history = new AnnotationHistory(a.getId(), user.getId(), a.getAnnotation(), now.toString(), "transcribing");
                a.addHistory(history);
            }
            if ((aId = ((JdbcAnnotationDao)this.annotationDao).saveAnnotation(a)) > 0) {
                if (a.getAnnotationUri() != null) {
                    deleteList.add(a.getAnnotationUri());
                }
                PublisherAnnotation pa = AnnotationMapper.createPublisherAnnotation(a);
                pa.setUserId((long)user.getId());
                addList.add(pa);
            }
            if (parentDocsToUpdate.contains(a.getMediaId())) continue;
            parentDocsToUpdate.add(a.getMediaId());
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.deleteAnnotationsByUriFromSolr(deleteList);
        stopWatch.stop();
        log.info((Object)("Time to delete from Solr: " + stopWatch.getTime() + "ms"));
        stopWatch.reset();
        stopWatch.start();
        this.saveAnnotationsToSolr(addList);
        stopWatch.stop();
        log.info((Object)("Time to save to Solr: " + stopWatch.getTime() + "ms"));
        if (updateParentDoc && parentDocsToUpdate.size() > 0) {
            for (String mediaId : parentDocsToUpdate) {
                this.updateAnnotationParentDoc(mediaId);
            }
        }
    }

    @Override
    public void saveAnnotationBatch(List<Annotation> aList, String mediaId, User user, boolean updateParentDoc, String source) throws DataAccessException {
        if (aList == null || mediaId == null) {
            return;
        }
        ArrayList<PublisherAnnotation> addToSolrList = new ArrayList<PublisherAnnotation>();
        ArrayList<String> deleteFromSolrList = new ArrayList<String>();
        ArrayList<String> parentDocsToUpdate = new ArrayList<String>();
        List<Annotation> updatedAnnotList = null;
        Iterator<Annotation> aiter = aList.iterator();
        while (aiter.hasNext()) {
            Annotation a = aiter.next();
            String text = StringUtils.trim((String)a.getAnnotation());
            a.setAnnotation(text);
            if (StringUtils.equals((String)mediaId, (String)a.getMediaId())) continue;
            aiter.remove();
        }
        updatedAnnotList = ((JdbcAnnotationDao)this.annotationDao).saveAnnotationBatch(aList, mediaId, source);
        if (updatedAnnotList != null) {
            for (Annotation a : updatedAnnotList) {
                if (a.getId() > 0) {
                    if (a.getAnnotationUri() != null) {
                        deleteFromSolrList.add(a.getAnnotationUri());
                    }
                    PublisherAnnotation pa = AnnotationMapper.createPublisherAnnotation(a);
                    pa.setUserId((long)user.getId());
                    addToSolrList.add(pa);
                }
                if (parentDocsToUpdate.contains(a.getMediaId())) continue;
                parentDocsToUpdate.add(a.getMediaId());
            }
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.deleteAnnotationsByUriFromSolr(deleteFromSolrList);
        stopWatch.stop();
        log.info((Object)("Time to delete from Solr: " + stopWatch.getTime() + "ms"));
        stopWatch.reset();
        stopWatch.start();
        this.saveAnnotationsToSolr(addToSolrList);
        stopWatch.stop();
        log.info((Object)("Time to save to Solr: " + stopWatch.getTime() + "ms"));
        stopWatch.reset();
        stopWatch.start();
        if (updateParentDoc && parentDocsToUpdate.size() > 0) {
            for (String mid : parentDocsToUpdate) {
                this.updateAnnotationParentDoc(mid);
            }
            stopWatch.stop();
            log.info((Object)("Time to update parent doc: " + stopWatch.getTime() + "ms"));
        }
    }

    @Override
    public synchronized void deleteAnnotation(Annotation a) {
        ((JdbcAnnotationDao)this.annotationDao).deleteAnnotation(a);
        if (a.getAnnotationUri() != null) {
            this.deleteAnnotationByUriFromSolr(a.getAnnotationUri());
        }
    }

    @Override
    public synchronized void deleteAnnotationsBySource(String mediaId, String source) {
        if (StringUtils.isBlank((String)mediaId) || StringUtils.isBlank((String)source)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ((JdbcAnnotationDao)this.annotationDao).deleteAnnotationsBySource(mediaId, source);
        log.info((Object)("((JdbcAnnotationDao)annotationDao).deleteAnnotationsBySource(..): " + (System.currentTimeMillis() - startTime) + "ms"));
        startTime = System.currentTimeMillis();
        this.solrAnnotationDao.deleteByMediaIdAndSource(mediaId, source);
        log.info((Object)("solrAnnotationDao.deleteByMediaIdAndSource(.deleteAnnotationsBySource(..): " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    @Override
    public List<MediaFieldRelation> getMediaFieldRelations(List<MediaCollection> mediaCollections, String standardName) {
        return this.mediaFieldRelationDao.getAllMediaFieldRelations(mediaCollections, standardName);
    }

    @Override
    public List<String> getAnnotatedMediaByCollectionId(String collectionId) {
        List<String> mediaIds = this.annotationDao.getAnnotatedMediaByCollectionId(collectionId);
        return mediaIds;
    }

    @Override
    public Map<String, Map<String, List<String>>> getOrderedMediaFieldRelations(List<MediaCollection> mediaCollections, String dstStandardName) {
        List<MediaFieldRelation> mfrs = this.mediaFieldRelationDao.getAllMediaFieldRelations(mediaCollections, dstStandardName);
        if (mfrs == null) {
            return null;
        }
        HashMap standardFieldsMap = new HashMap();
        for (MediaFieldRelation mfr : mfrs) {
            List<String> fieldNames;
            Map standardFieldMap;
            if (!standardFieldsMap.containsKey(mfr.getSourceStandardId())) {
                standardFieldsMap.put(mfr.getSourceStandardId(), new LinkedHashMap());
            }
            if (!(standardFieldMap = (Map)standardFieldsMap.get(mfr.getSourceStandardId())).containsKey(mfr.getDestFieldName().toLowerCase())) {
                fieldNames = new ArrayList<String>();
            } else {
                String f = mfr.getDestFieldName().toLowerCase();
                fieldNames = (List)standardFieldMap.get(f);
            }
            fieldNames.add(mfr.getSourceFieldName());
            standardFieldMap.put(mfr.getDestFieldName().toLowerCase(), fieldNames);
        }
        Vector<String> oaiOrderedStandardNames = this.getApplicationConfiguration().getOaiOrderedStandardName();
        Vector<String> oaiOrderedDCFields = this.getApplicationConfiguration().getOaiOrderedDCField();
        Vector<String> oaiOrderedStandardFields = this.getApplicationConfiguration().getOaiOrderedStandardFields();
        HashMap<String, Map<String, List<String>>> standardOrderedFieldsMap = new HashMap<String, Map<String, List<String>>>();
        for (int i = 0; i < oaiOrderedStandardNames.size(); ++i) {
            Map dcFieldsMap;
            if (oaiOrderedDCFields.get(i) == null || oaiOrderedStandardFields.get(i) == null) continue;
            String collectionId = oaiOrderedStandardNames.get(i);
            String dcField = oaiOrderedDCFields.get(i);
            String[] orderedFields = StringUtils.split((String)oaiOrderedStandardFields.get(i), (char)',');
            for (int j = 0; j < orderedFields.length; ++j) {
                orderedFields[j] = StringUtils.trim((String)orderedFields[j]);
            }
            if (!standardOrderedFieldsMap.containsKey(oaiOrderedStandardNames.get(i))) {
                standardOrderedFieldsMap.put(collectionId, new LinkedHashMap());
            }
            if (!(dcFieldsMap = (Map)standardOrderedFieldsMap.get(collectionId)).containsKey(dcField.toLowerCase())) {
                dcFieldsMap.put(dcField.toLowerCase(), new ArrayList());
            }
            List orderedFieldList = (List)dcFieldsMap.get(dcField.toLowerCase());
            orderedFieldList.addAll(Arrays.asList(orderedFields));
        }
        for (String standard : standardFieldsMap.keySet()) {
            if (!standardOrderedFieldsMap.containsKey(standard)) {
                HashMap copy = new HashMap((Map)standardFieldsMap.get(standard));
                for (String c : copy.keySet()) {
                    copy.put(c, new ArrayList((Collection)copy.get(c)));
                }
                standardOrderedFieldsMap.put(standard, copy);
            }
            Map orderedFieldMap = (Map)standardOrderedFieldsMap.get(standard);
            Map relationMap = (Map)standardFieldsMap.get(standard);
            for (String dcField : orderedFieldMap.keySet()) {
                List orderedList = (List)orderedFieldMap.get(dcField.toLowerCase());
                List relationList = (List)relationMap.get(dcField.toLowerCase());
                ArrayList<String> orderedResult = new ArrayList<String>();
                block6: for (String orderedField : orderedList) {
                    if (relationList == null) continue;
                    Iterator relationIter = relationList.iterator();
                    while (relationIter.hasNext()) {
                        String relationField = (String)relationIter.next();
                        if (!relationField.equalsIgnoreCase(orderedField)) continue;
                        orderedResult.add(relationField);
                        relationIter.remove();
                        continue block6;
                    }
                }
                orderedResult.addAll(relationList);
                relationMap.remove(dcField.toLowerCase());
                orderedFieldMap.put(dcField.toLowerCase(), orderedResult);
            }
            for (String r : relationMap.keySet()) {
                orderedFieldMap.put(r.toLowerCase(), relationMap.get(r));
            }
        }
        return standardOrderedFieldsMap;
    }

    @Override
    public synchronized void saveExternalObjectData(ExternalMedia eod) throws DataAccessException {
        this.mediaDao.get("legacy").saveExternalObjectData(eod);
    }

    private void loadUserCollections(User user) {
        log.debug((Object)"loadUserCollections(..)");
        if (user == null) {
            return;
        }
        log.info((Object)user.toString());
        if (user.getCredentials() != null) {
            log.info((Object)user.getCredentials().toString());
        } else {
            log.error((Object)"null credentials");
        }
        if (user.getCredentials() != null) {
            log.debug((Object)"loadUserCollections(..): trying to set collections.");
            ArrayList<MediaCollection> collections = new ArrayList<MediaCollection>();
            collections.addAll(this.getMultipleMediaCollections(user.getCredentials().getAuthorizedCollectionIds()));
            log.debug((Object)("loadUserCollections(..): added multiple media collections. public content allowed = " + user.getCredentials().isPublicContentAllowed()));
            if (user.getCredentials().isPublicContentAllowed()) {
                collections.addAll(this.getPublicMediaCollections());
            }
            collections = ParsingUtils.removeDuplicateItems(collections);
            Collections.sort(collections, new MediaCollectionComparator());
            user.setMediaCollections(collections);
        }
        user.setDefaultMediaCollections(this.getMultipleMediaCollections(user.getDefaultCollectionIds()));
        user.setFolders(this.foldersDao.getFolders(user));
    }

    public void addMediaToGroup(MediaGroup mediaGroup, Media media) throws DataAccessException {
        mediaGroup.addMedia(String.valueOf(media.getIdentity()));
        this.mediaGroupsDao.saveMediaGroup(mediaGroup);
    }

    private List<MediaGroup> executeMediaGroupSearch(SearchCriteria searchCriteria, boolean includeNonPublicGroups) {
        if (searchCriteria.getUserSearchText() != null && !searchCriteria.getUserSearchText().trim().equals("")) {
            ArrayList<User> matchingLastAndFirst = new ArrayList<User>();
            ArrayList<User> matchingLast = new ArrayList<User>();
            ArrayList<User> matchingFirst = new ArrayList<User>();
            String userOrLastName = null;
            String lastName = null;
            String firstName = null;
            if (searchCriteria.getLastName().trim().equals("")) {
                userOrLastName = searchCriteria.getUserSearchText().trim();
            } else {
                firstName = searchCriteria.getFirstName().trim();
                lastName = searchCriteria.getLastName().trim();
            }
            Collection<User> allUsers = this.authenticationDao.getAllUsers();
            for (User u : allUsers) {
                if (userOrLastName != null) {
                    if (u.getUsername().equalsIgnoreCase(userOrLastName)) {
                        ArrayList<User> singleMatch = new ArrayList<User>();
                        singleMatch.add(u);
                        searchCriteria.setUsers(singleMatch);
                        return this.mediaGroupsDao.getMediaGroups(searchCriteria, includeNonPublicGroups);
                    }
                    if (u.getLastName() != null && u.getLastName().equalsIgnoreCase(userOrLastName)) {
                        matchingLast.add(u);
                        continue;
                    }
                    if (u.getFirstName() == null || !u.getFirstName().equalsIgnoreCase(userOrLastName)) continue;
                    matchingFirst.add(u);
                    continue;
                }
                if (firstName != null && u.getLastName() != null && u.getFirstName() != null && u.getLastName().equalsIgnoreCase(lastName) && u.getFirstName().equalsIgnoreCase(firstName)) {
                    matchingLastAndFirst.add(u);
                    continue;
                }
                if (u.getLastName() != null && u.getLastName().equalsIgnoreCase(lastName)) {
                    matchingLast.add(u);
                    continue;
                }
                if (firstName == null || u.getFirstName() == null || !u.getFirstName().equalsIgnoreCase(firstName)) continue;
                matchingFirst.add(u);
            }
            if (matchingLastAndFirst.size() > 0) {
                searchCriteria.setUsers(matchingLastAndFirst);
            } else if (matchingLast.size() > 0) {
                searchCriteria.setUsers(matchingLast);
            } else if (matchingFirst.size() > 0) {
                searchCriteria.setUsers(matchingFirst);
            } else {
                return new ArrayList<MediaGroup>();
            }
        }
        return this.mediaGroupsDao.getMediaGroups(searchCriteria, includeNonPublicGroups);
    }

    private List<Presentation> executePresentationSearch(SearchCriteria searchCriteria, User user) {
        if (!searchCriteria.getUserSearchText().trim().equals("")) {
            ArrayList<User> matchingLastAndFirst = new ArrayList<User>();
            ArrayList<User> matchingLast = new ArrayList<User>();
            ArrayList<User> matchingFirst = new ArrayList<User>();
            String userOrLastName = null;
            String lastName = null;
            String firstName = null;
            if (searchCriteria.getLastName().trim().equals("")) {
                userOrLastName = searchCriteria.getUserSearchText().trim();
            } else {
                firstName = searchCriteria.getFirstName().trim();
                lastName = searchCriteria.getLastName().trim();
            }
            Collection<User> allUsers = this.authenticationDao.getAllUsers();
            for (User u : allUsers) {
                if (userOrLastName != null) {
                    if (u.getUsername().equalsIgnoreCase(userOrLastName)) {
                        ArrayList<User> singleMatch = new ArrayList<User>();
                        singleMatch.add(u);
                        searchCriteria.setUsers(singleMatch);
                        return this.presentationDao.getPresentations(searchCriteria, user);
                    }
                    if (u.getLastName().equalsIgnoreCase(userOrLastName)) {
                        matchingLast.add(u);
                        continue;
                    }
                    if (!u.getFirstName().equalsIgnoreCase(userOrLastName)) continue;
                    matchingFirst.add(u);
                    continue;
                }
                if (u.getLastName().equalsIgnoreCase(lastName) && firstName != null && u.getFirstName().equalsIgnoreCase(firstName)) {
                    matchingLastAndFirst.add(u);
                    continue;
                }
                if (u.getLastName().equalsIgnoreCase(lastName)) {
                    matchingLast.add(u);
                    continue;
                }
                if (firstName == null || !u.getFirstName().equalsIgnoreCase(firstName)) continue;
                matchingFirst.add(u);
            }
            if (matchingLastAndFirst.size() > 0) {
                searchCriteria.setUsers(matchingLastAndFirst);
            } else if (matchingLast.size() > 0) {
                searchCriteria.setUsers(matchingLast);
            } else if (matchingFirst.size() > 0) {
                searchCriteria.setUsers(matchingFirst);
            } else {
                return new ArrayList<Presentation>();
            }
        }
        return this.presentationDao.getPresentations(searchCriteria, user);
    }

    private void addPresentationUsername(List<Presentation> presentations) {
        for (Presentation pres : presentations) {
            if (pres.getUsername() != null) continue;
            try {
                User user = this.authenticationDao.getUser(pres.getUserId());
                if (user == null) continue;
                pres.setUsername(user.getUsername());
            }
            catch (DataAccessException dataAccessException) {}
        }
    }

    private void sortMediaFields(List<MediaField> mediaFields) {
        if (mediaFields != null) {
            Collections.sort(mediaFields, new ReflectiveComparator("getDisplayName", 2));
        }
    }

    @Override
    public synchronized void saveFolder(Folder f, User user) {
        this.foldersDao.saveFolder(f);
        this.loadUserCollections(user);
    }

    @Override
    public synchronized void deleteFolder(Folder f, User user, boolean recursive) {
        this.foldersDao.deleteFolder(f);
        List<Folder> folderList = user.getFolders();
        List<MediaGroup> groupList = this.getMediaGroups(user);
        List<Presentation> presentationList = this.getPresentations(user);
        if (recursive) {
            for (MediaGroup mg : groupList) {
                if (mg.getFolderId() != f.getId()) continue;
                this.mediaGroupsDao.deleteMediaGroup(mg);
            }
            for (Presentation pres : presentationList) {
                if (pres.getFolderId() != f.getId()) continue;
                this.presentationDao.deletePresentation(pres);
            }
            for (Folder folderToRemove : folderList) {
                if (folderToRemove.getParentFolderId() != f.getId() || folderToRemove == f) continue;
                this.deleteFolder(folderToRemove, user, true);
            }
        } else {
            int parentFolderId = f.getParentFolderId();
            for (MediaGroup mg : groupList) {
                if (mg.getFolderId() != f.getId()) continue;
                mg.setFolderId(parentFolderId);
                this.mediaGroupsDao.saveMediaGroup(mg);
            }
            for (Presentation pres : presentationList) {
                if (pres.getFolderId() != f.getId()) continue;
                pres.setFolderId(parentFolderId);
                this.presentationDao.savePresentation(pres);
            }
            for (Folder folder : folderList) {
                if (folder.getParentFolderId() != f.getId()) continue;
                folder.setParentFolderId(parentFolderId);
                this.foldersDao.saveFolder(folder);
            }
        }
        this.loadUserCollections(user);
    }

    @Override
    public int getTotalMediaGroup() {
        return this.mediaGroupsDao.getTotalMediaGroup();
    }

    @Override
    public int getTotalPresentation() {
        return this.presentationDao.getTotalPresentation();
    }

    @Override
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfigurationDao.getApplicationConfiguration();
    }

    @Override
    public String getPathToPublicContent(String institutionId, String guid, String remoteAddress) throws DataAccessException {
        String path = null;
        ApplicationConfiguration appConfig = this.getApplicationConfiguration();
        if (appConfig.isKnowPublicContentRecipient(institutionId, guid)) {
            path = this.contentDistributionDao.getPathToPublicContent();
        }
        return path;
    }

    @Override
    public void fetchExternalPublicContent(String guid) throws DataAccessException {
        ApplicationConfiguration appConfig = this.getApplicationConfiguration();
        if (StringUtils.equals((String)appConfig.getFetchExternalPublicContentGuid(), (String)guid)) {
            String maintenanceGuid = appConfig.getMaintenanceGuid();
            this.requestMaintenance(maintenanceGuid);
            log.debug((Object)"Starting fetch of Public content");
            try {
                List<String> urls = appConfig.getContentDistributionUrls();
                this.contentDistributionDao.fetchExternalPublicContent(urls);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            log.debug((Object)"Finished fetch of Public content");
            this.requestEndMaintenance(maintenanceGuid);
        } else {
            log.info((Object)("Invalid guid for fetchExternalPublicContent: [" + guid + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishDistributedContent(String guid) throws DataAccessException {
        Date start = new Date();
        try {
            ApplicationConfiguration appConfig = this.getApplicationConfiguration();
            if (StringUtils.equals((String)appConfig.getPublishDistributedContentGuid(), (String)guid)) {
                if (appConfig.isPublicContentDistributor()) {
                    this.contentDistributionDao.publishConsolidatedExternalPublicContent(appConfig.getContentDistributionUrls());
                } else {
                    Authenticable authenticable = this.authenticate(null, this.contentDistributionLogin, this.contentDistributionPassword);
                    if (authenticable != null && CollectionUtils.isNotEmpty(authenticable.getMediaCollections())) {
                        this.contentDistributionDao.publishPublicContent(authenticable.getMediaCollections());
                    } else {
                        log.info((Object)("No Valid contentDistributionLogin given: [" + this.contentDistributionLogin + "]"));
                    }
                }
            }
        }
        finally {
            log.info((Object)("Content distribution finished. Time take: " + (new Date().getTime() - start.getTime()) + "ms"));
        }
    }

    @Override
    public void generateSiteMap(MessageSource messageSource) throws DataAccessException, SQLException, IOException {
        ArrayList credentialsIds = this.authenticationDao.getDefaultCredentials().getAuthorizedCollectionIds();
        ArrayList<MediaCollection> collections = new ArrayList<MediaCollection>();
        MediaSearchCriteria searchCriteria = new MediaSearchCriteria();
        MediaSearchResult sr = null;
        W4Facets facets = null;
        for (String cred : credentialsIds) {
            collections.add(this.getMediaCollection(cred));
        }
        try {
            searchCriteria.findAllMedia(collections);
            if (searchCriteria != null && !searchCriteria.isEmpty()) {
                searchCriteria.setMediaFields(this.getMediaFields(searchCriteria.getCollectionLimit()));
                sr = this.findMedia(searchCriteria, 0, this.searchLimit);
                if (sr != null && !sr.isEmpty()) {
                    facets = (W4Facets)this.getMediaFacets(sr, "count");
                }
            }
        }
        catch (InvalidSearchQuery e) {
            log.error((Object)e);
        }
        this.analyticsDao.generateSiteMap(collections, sr, facets, messageSource, this.getAllPresentations(), this.getAllMediaGroups());
    }

    @Override
    public boolean isMaintenanceInProgress() {
        return this.maintenanceInProgress;
    }

    @Override
    public boolean requestMaintenance(String guid) {
        if (!this.maintenanceInProgress && StringUtils.equals((String)guid, (String)this.getApplicationConfiguration().getMaintenanceGuid())) {
            try {
                for (Maintainable m : this.maintainableObjects) {
                    if (m == null) continue;
                    m.startMaintenance();
                }
                this.maintenanceInProgress = true;
                this.purgeCaches();
                return true;
            }
            catch (Exception e) {
                log.error((Object)"Unable to start maintenance!", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean requestEndMaintenance(String guid) {
        if (StringUtils.equals((String)guid, (String)this.getApplicationConfiguration().getMaintenanceGuid())) {
            try {
                for (Maintainable m : this.maintainableObjects) {
                    if (m == null) continue;
                    m.endMaintenance();
                }
                this.initialize();
                this.maintenanceInProgress = false;
                return true;
            }
            catch (Exception e) {
                log.error((Object)"Unable to end maintenance!", (Throwable)e);
            }
        }
        return false;
    }

    private void addMaintainable(Object o) {
        if (o instanceof Maintainable) {
            if (this.maintainableObjects == null) {
                throw new RuntimeException("Make sure id=\"maintainableObjects\" is set in the configuration.");
            }
            this.maintainableObjects.add((Maintainable)o);
        } else if (o instanceof LinkedHashMap) {
            Collection c = ((LinkedHashMap)o).values();
            for (Object obj : c) {
                if (!(obj instanceof Maintainable)) continue;
                if (this.maintainableObjects == null) {
                    this.maintainableObjects = new ArrayList<Maintainable>();
                }
                this.maintainableObjects.add((Maintainable)obj);
            }
        }
    }

    synchronized void initialize() {
        if (this.mediaFieldDao != null && this.mediaCollectionDao != null) {
            this.legacyAnnotationDao.setAllMediaCollections(this.mediaCollectionDao.getAllMediaCollections());
            for (String type : this.mediaDao.keySet()) {
                ArrayList<MediaCollection> collectionListByType = new ArrayList<MediaCollection>();
                for (MediaCollection mc : this.mediaCollectionDao.getAllMediaCollections()) {
                    if (!type.equals(mc.getCollectionType())) continue;
                    log.debug((Object)("mediaDao:   " + type + " => " + mc.getAbbreviatedName() + "(" + mc.getCollectionId() + ")"));
                    collectionListByType.add(mc);
                    mc.setMediaFields(this.getMediaFields(mc));
                }
                this.mediaDao.get(type).setAllMediaCollections(collectionListByType);
            }
            this.contentDistributionDao.setAllLocalMediaCollections(this.mediaCollectionDao.getLocalMediaCollections());
            log.info((Object)"LUNA field cache initialization. Please wait...");
            ArrayList<MediaField> allW4MediaFields = new ArrayList<MediaField>();
            for (MediaCollection mc : this.mediaCollectionDao.getAllMediaCollections()) {
                if (mc == null || mc.getCollectionType() == null || this.mediaFieldDao.get(mc.getCollectionType()) == null) continue;
                allW4MediaFields.addAll(this.mediaFieldDao.get(mc.getCollectionType()).getW4MediaFields(mc));
            }
            log.info((Object)"End of LUNA field cache initialization.");
        }
    }

    @Override
    public ArrayList<MediaResult> filterForMediaType(MediaSearchResult sr) {
        List<MediaResult> toReturn = sr.getResults();
        return this.filterForMediaType(toReturn);
    }

    @Override
    public ArrayList<MediaResult> filterForMediaType(List<MediaResult> results) {
        ArrayList<Media.MediaType> acceptableMediaTypeList = new ArrayList<Media.MediaType>();
        acceptableMediaTypeList.add(Media.MediaType.IMAGE);
        ArrayList<MediaResult> toReturn = new ArrayList<MediaResult>();
        block2: for (MediaResult r : results) {
            try {
                if (r.getIdentity() instanceof String && InsightCoreUtils.isValidLunaMediaIdFormat((String)r.getIdentity())) {
                    LuceneMediaResult newR = (LuceneMediaResult)r;
                    for (Media.MediaType mt : acceptableMediaTypeList) {
                        if (!newR.getAttributes().get("mediaType").toString().equalsIgnoreCase(mt.toString())) continue;
                        toReturn.add(r);
                        continue block2;
                    }
                    continue;
                }
                toReturn.add(r);
            }
            catch (DataAccessException dataAccessException) {}
        }
        return toReturn;
    }

    public String getMediaCollectionType(String mediaId) {
        String mediaCollectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(mediaId);
        MediaCollection mc = this.mediaCollectionDao.getMediaCollection(mediaCollectionId);
        if (mc == null) {
            return "legacy";
        }
        log.info((Object)("getCollectionType(" + mediaId + ") ->" + mediaCollectionId + " -> " + mc.getCollectionType()));
        return mc.getCollectionType();
    }

    @Override
    public List<MediaFieldValue> getMediaFieldValues(String mediaId) {
        Media media = null;
        log.info((Object)("Fetching media field values for media id = " + mediaId));
        if (mediaId == null) {
            return null;
        }
        if (!NumberUtils.isDigits((String)mediaId)) {
            String cType = this.getMediaCollectionType(mediaId);
            media = this.mediaDao.get(cType).getLunaMedia(mediaId, false);
            if (media != null && media.getCollection() != null) {
                return this.mediaFieldDao.get(cType).getMediaFieldValues(media);
            }
        } else {
            media = this.mediaDao.get("legacy").getExternalMedia(mediaId);
            return media.getFieldValues();
        }
        return null;
    }

    @Override
    public List<ExternalMedia> getExternalMediaByUser(int userId, String libraryUrl, int pageSize, int pageOffset) {
        return this.getExternalMedias(userId, null, libraryUrl, pageSize, pageOffset);
    }

    @Override
    public int getExternalMediaCountByUser(int userId, String libraryUrl) {
        try {
            StringBuilder streamSend = new StringBuilder("userId=" + userId);
            RestTemplate restTemplate = new RestTemplate();
            URI uri = new URI(libraryUrl + "/e/library/getMyMediaCount?" + streamSend);
            ResponseEntity result = restTemplate.getForEntity(uri, String.class);
            if (StringUtils.isNotBlank((String)((String)result.getBody()))) {
                JSONObject mediaCountJson = new JSONObject((String)result.getBody());
                return Integer.parseInt(mediaCountJson.getString("total"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in getExternalMediaCountByUser(..)", (Throwable)e);
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public ExternalMedia getExternalMediaDetails(String mediaId, int userId, String libraryUrl, boolean loadFullDetails) {
        ArrayList<String> mediaIdList = new ArrayList<String>();
        mediaIdList.add(mediaId);
        List<ExternalMedia> externalMediaList = this.getExternalMediaDetails(mediaIdList, userId, libraryUrl, loadFullDetails);
        if (externalMediaList != null && externalMediaList.size() > 0) {
            return externalMediaList.get(0);
        }
        return null;
    }

    @Override
    public List<ExternalMedia> getExternalMediaDetails(List<String> mediaIdList, int userId, String libraryUrl, boolean loadFullDetails) {
        ArrayList<ExternalMedia> externalMediaList = null;
        try {
            StringBuilder streamSend = new StringBuilder();
            if (userId > 0) {
                streamSend.append("userId=" + userId).append("&");
            }
            if (loadFullDetails) {
                streamSend.append("loadFully=" + URLEncoder.encode(Boolean.toString(loadFullDetails)));
            }
            for (String mediaId : mediaIdList) {
                if (mediaId.startsWith("DEFAULT~0~0")) {
                    mediaId = String.valueOf(InsightCoreUtils.getMediaIdFromLunaMediaId(mediaId));
                }
                streamSend.append("&mediaId=" + URLEncoder.encode(mediaId));
            }
            RestTemplate restTemplate = new RestTemplate();
            URI uri = new URI(libraryUrl + "/e/library/getMyMediaDetails?" + streamSend);
            ResponseEntity result = restTemplate.getForEntity(uri, String.class);
            if (StringUtils.isNotBlank((String)((String)result.getBody()))) {
                JSONArray mediaListJson = new JSONArray((String)result.getBody());
                externalMediaList = new ArrayList<ExternalMedia>();
                int n = mediaListJson.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject mediaJsonObject = mediaListJson.getJSONObject(i);
                    ExternalMedia externalMedia = this.constructExternalMedia(mediaJsonObject);
                    int mediaIndex = mediaIdList.indexOf(externalMedia.getObjectId().toString());
                    if (mediaIndex == -1) {
                        mediaIndex = mediaIdList.indexOf(String.valueOf(externalMedia.getMediaId()));
                    }
                    if (mediaIndex != -1 && mediaIndex < externalMediaList.size()) {
                        externalMediaList.add(mediaIndex, externalMedia);
                        continue;
                    }
                    externalMediaList.add(externalMedia);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in getExternalMediaDetails(....)", (Throwable)e);
            e.printStackTrace();
        }
        return externalMediaList;
    }

    private ExternalMedia constructExternalMedia(JSONObject mediaJsonObject) throws NumberFormatException, JSONException {
        ExternalMedia externalMedia = new ExternalMedia();
        externalMedia.setMediaId(Integer.parseInt(mediaJsonObject.getString("mediaId")));
        externalMedia.setObjectId(InsightCoreUtils.constructMediaId("DEFAULT~0~0", "", mediaJsonObject.getString("mediaId")));
        externalMedia.setMediaSource("Luna");
        externalMedia.setDisplayTitle(mediaJsonObject.getString("fileName"));
        if (mediaJsonObject.has("urlSize0")) {
            externalMedia.setUrlSize0(mediaJsonObject.getString("urlSize0"));
        }
        if (mediaJsonObject.has("urlSize1")) {
            externalMedia.setUrlSize1(mediaJsonObject.getString("urlSize1"));
        }
        if (mediaJsonObject.has("urlSize2")) {
            externalMedia.setUrlSize2(mediaJsonObject.getString("urlSize2"));
        }
        if (mediaJsonObject.has("urlSize3")) {
            externalMedia.setUrlSize3(mediaJsonObject.getString("urlSize3"));
        }
        if (mediaJsonObject.has("urlSize4")) {
            externalMedia.setUrlSize4(mediaJsonObject.getString("urlSize4"));
        }
        if (mediaJsonObject.has("urlSize5")) {
            externalMedia.setUrlSize5(mediaJsonObject.getString("urlSize5"));
        }
        if (mediaJsonObject.has("urlSize6")) {
            externalMedia.setUrlSize6(mediaJsonObject.getString("urlSize6"));
        }
        if (mediaJsonObject.has("urlSize7")) {
            externalMedia.setUrlSize7(mediaJsonObject.getString("urlSize7"));
        }
        if (mediaJsonObject.has("urlSize8")) {
            externalMedia.setUrlSize8(mediaJsonObject.getString("urlSize8"));
        }
        if (mediaJsonObject.has("urlSize9")) {
            externalMedia.setUrlSize9(mediaJsonObject.getString("urlSize9"));
        }
        if (mediaJsonObject.has("urlSize10")) {
            externalMedia.setUrlSize10(mediaJsonObject.getString("urlSize10"));
        }
        if (mediaJsonObject.has("urlSource")) {
            externalMedia.setUrlSource(mediaJsonObject.getString("urlSource"));
        }
        externalMedia.setStatus(Integer.parseInt(mediaJsonObject.getString("status")));
        externalMedia.setType(ImageFile.getMediaTypeToString((int)mediaJsonObject.getInt("type")));
        if (mediaJsonObject.has("title")) {
            externalMedia.setDisplayTitle(mediaJsonObject.getString("title"));
        }
        if (mediaJsonObject.has("description")) {
            externalMedia.setDescription(mediaJsonObject.getString("description"));
        }
        if (mediaJsonObject.has("copyright")) {
            externalMedia.setCopyright(mediaJsonObject.getString("copyright"));
        }
        if (mediaJsonObject.has("fields")) {
            MediaFieldValue mfv;
            MediaField field;
            String value;
            String name;
            Iterator fieldIterator;
            JSONObject fieldList;
            JSONObject fieldGroupObj = mediaJsonObject.getJSONObject("fields");
            ArrayList<MediaFieldValue> fieldValueList = new ArrayList<MediaFieldValue>();
            if (fieldGroupObj.has(MediaField.fieldGroupType.MEDIA_CUSTOM.toString())) {
                JSONObject fieldList2;
                Object jsonObj = fieldGroupObj.get(MediaField.fieldGroupType.MEDIA_CUSTOM.toString());
                if (jsonObj instanceof JSONObject) {
                    fieldList2 = fieldGroupObj.getJSONObject(MediaField.fieldGroupType.MEDIA_CUSTOM.toString());
                    Iterator fieldIterator2 = fieldList2.keys();
                    while (fieldIterator2.hasNext()) {
                        String name2 = (String)fieldIterator2.next();
                        Object json = fieldList2.get(name2);
                        if (json instanceof JSONArray) {
                            JSONArray arr = (JSONArray)json;
                            for (int j = 0; j < arr.length(); ++j) {
                                Object obj = arr.get(j);
                                if (!(obj instanceof String)) continue;
                                String value2 = (String)obj;
                                MediaField field2 = new MediaField(1, 1, name2, name2, 1, MediaField.fieldGroupType.MEDIA_CUSTOM.toString(), MediaField.fieldGroupType.MEDIA_CUSTOM);
                                MediaFieldValue mfv2 = new MediaFieldValue(field2, value2);
                                fieldValueList.add(mfv2);
                            }
                            continue;
                        }
                        String value3 = fieldList2.getString(name2);
                        MediaField field3 = new MediaField(1, 1, name2, name2, 1, MediaField.fieldGroupType.MEDIA_CUSTOM.toString(), MediaField.fieldGroupType.MEDIA_CUSTOM);
                        MediaFieldValue mfv3 = new MediaFieldValue(field3, value3);
                        fieldValueList.add(mfv3);
                    }
                } else if (jsonObj instanceof JSONArray) {
                    fieldList2 = fieldGroupObj.getJSONArray(MediaField.fieldGroupType.MEDIA_CUSTOM.toString());
                    for (int j = 0; j < fieldList2.length(); ++j) {
                        JSONObject obj = fieldList2.getJSONObject(j);
                        Iterator it = obj.keys();
                        while (it.hasNext()) {
                            String name3 = (String)it.next();
                            String value4 = (String)obj.get(name3);
                            MediaField field4 = new MediaField(1, 1, name3, name3, 1, MediaField.fieldGroupType.MEDIA_CUSTOM.toString(), MediaField.fieldGroupType.MEDIA_CUSTOM);
                            MediaFieldValue mfv4 = new MediaFieldValue(field4, value4);
                            fieldValueList.add(mfv4);
                        }
                    }
                }
            }
            if (fieldGroupObj.has(MediaField.fieldGroupType.MEDIA_IPTC.toString())) {
                fieldList = fieldGroupObj.getJSONObject(MediaField.fieldGroupType.MEDIA_IPTC.toString());
                fieldIterator = fieldList.keys();
                while (fieldIterator.hasNext()) {
                    name = (String)fieldIterator.next();
                    value = fieldList.getString(name);
                    field = new MediaField(1, 1, name, name, 1, MediaField.fieldGroupType.MEDIA_IPTC.toString(), MediaField.fieldGroupType.MEDIA_IPTC);
                    mfv = new MediaFieldValue(field, value);
                    fieldValueList.add(mfv);
                }
            }
            if (fieldGroupObj.has(MediaField.fieldGroupType.MEDIA_XMP.toString())) {
                fieldList = fieldGroupObj.getJSONObject(MediaField.fieldGroupType.MEDIA_XMP.toString());
                fieldIterator = fieldList.keys();
                while (fieldIterator.hasNext()) {
                    name = (String)fieldIterator.next();
                    value = fieldList.getString(name);
                    field = new MediaField(1, 1, name, name, 1, MediaField.fieldGroupType.MEDIA_XMP.toString(), MediaField.fieldGroupType.MEDIA_XMP);
                    mfv = new MediaFieldValue(field, value);
                    fieldValueList.add(mfv);
                }
            }
            if (fieldGroupObj.has(MediaField.fieldGroupType.MEDIA_EXIF.toString())) {
                fieldList = fieldGroupObj.getJSONObject(MediaField.fieldGroupType.MEDIA_EXIF.toString());
                fieldIterator = fieldList.keys();
                while (fieldIterator.hasNext()) {
                    name = (String)fieldIterator.next();
                    value = fieldList.getString(name);
                    field = new MediaField(1, 1, name, name, 1, MediaField.fieldGroupType.MEDIA_EXIF.toString(), MediaField.fieldGroupType.MEDIA_EXIF);
                    mfv = new MediaFieldValue(field, value);
                    fieldValueList.add(mfv);
                }
            }
            externalMedia.setFieldValues(fieldValueList);
        }
        return externalMedia;
    }

    private List<ExternalMedia> getExternalMedias(int userId, List<String> mediaIds, String libraryUrl, int pageSize, int pageOffset) {
        ArrayList<ExternalMedia> list = new ArrayList<ExternalMedia>();
        try {
            StringBuilder streamSend = new StringBuilder("userId=" + userId);
            if (mediaIds != null && !mediaIds.isEmpty()) {
                for (String mediaId : mediaIds) {
                    streamSend.append("&mediaId=" + URLEncoder.encode(mediaId));
                }
            } else {
                streamSend.append("&os=" + URLEncoder.encode(String.valueOf(pageOffset)));
                streamSend.append("&pageSize=" + URLEncoder.encode(String.valueOf(pageSize)));
            }
            RestTemplate restTemplate = new RestTemplate();
            URI uri = new URI(libraryUrl + "/e/library/getMyMedia?" + streamSend);
            ResponseEntity result = restTemplate.getForEntity(uri, String.class);
            if (StringUtils.isNotBlank((String)((String)result.getBody()))) {
                JSONArray mediaJsonArray = new JSONArray((String)result.getBody());
                int totalMedias = mediaJsonArray.length();
                for (int i = 0; i < totalMedias; ++i) {
                    JSONObject mediaJsonObject = mediaJsonArray.getJSONObject(i);
                    ExternalMedia externalMedia = this.constructExternalMedia(mediaJsonObject);
                    list.add(externalMedia);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in getExternalMedias(.....)", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<ExternalMedia> getExternalMedias(int userId, List<String> mediaIds) {
        ArrayList<ExternalMedia> list = new ArrayList<ExternalMedia>();
        StringBuffer query = new StringBuffer("SELECT * FROM EXTERNALMEDIA WHERE OBJECTOWNERID= " + userId + " AND MEDIAID IN (");
        int size = mediaIds.size();
        for (int i = 0; i < size; ++i) {
            query.append(mediaIds.get(i));
            if (i >= size - 1) continue;
            query.append(",");
        }
        query.append(") ");
        Collection<MediaDao> c = this.mediaDao.values();
        Iterator<MediaDao> it = c.iterator();
        try {
            while (it.hasNext()) {
                MediaDao md = it.next();
                List<ExternalMedia> sublist = md.getExternalMedias(query.toString());
                if (sublist == null || sublist.size() <= 0) continue;
                list.addAll(sublist);
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error while loading external media for user " + userId), (Throwable)e);
            list = null;
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public void removeExternalMedia(List<ExternalMedia> mediaList) {
        try {
            for (ExternalMedia media : mediaList) {
                this.mediaGroupsDao.deleteMediaGroupsMedia(String.valueOf(media.getMediaId()));
                this.presentationDao.deleteSlideImagesByMediaId(String.valueOf(media.getMediaId()));
            }
            Collection<MediaDao> c = this.mediaDao.values();
            for (MediaDao md : c) {
                if (md == null) continue;
                md.removeExternalMedia(mediaList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error while deleting the external media files", (Throwable)e);
        }
    }

    @Override
    public ChangeCollection getChangeCollection(String iiifBaseUrl, String collectionId, int pageSize) {
        ArrayList<String> cids = new ArrayList<String>();
        cids.add(collectionId);
        int lastPageNo = this.libraryHttpDao.getLastActivityPageNo(cids, pageSize);
        ChangeCollection c = new ChangeCollection(iiifBaseUrl, collectionId, new ChangeObject(iiifBaseUrl + "activitystream/collection/" + collectionId + "/page/" + lastPageNo, "OrderedCollectionPage"));
        c.setTotalItems(this.libraryHttpDao.getActivityTotal(cids));
        c.setFirst(new ChangeObject(iiifBaseUrl + "activitystream/collection/" + collectionId + "/page/" + 0, "OrderedCollectionPage"));
        ArrayList<ChangeResource> res = new ArrayList<ChangeResource>();
        ChangeResource dataset = new ChangeResource(iiifBaseUrl + "schema/" + collectionId + "?json=1", "Dataset");
        dataset.setFormat("application/json");
        dataset.setConformsTo("LunaCollectionSchema");
        res.add(dataset);
        ChangeResource collectionSchema = new ChangeResource(iiifBaseUrl + "schema/" + collectionId, "Dataset");
        collectionSchema.setFormat("application/xml");
        collectionSchema.setConformsTo("LunaCollectionSchema");
        res.add(collectionSchema);
        c.setSeeAlso(res);
        return c;
    }

    @Override
    public ChangePage getChangePage(String iiifBaseUrl, List<String> collectionIds, int pageNo, int pageSize) {
        ActivityResult ar = this.getPublishActivities(collectionIds, pageNo, pageSize);
        List<PublishEntity> entities = ar.getEntities();
        ArrayList<ChangeItem> items = new ArrayList<ChangeItem>();
        if (entities != null) {
            for (PublishEntity entity : entities) {
                ChangeItem thisItem = new ChangeItem(entity.getActionTypeString(), entity.getTimestamp(), new ChangeObject(iiifBaseUrl + "m/" + (String)entity.getIds().get(0) + "/manifest", "Manifest"));
                thisItem.setEndTime(entity.getTimestamp());
                items.add(thisItem);
            }
        }
        int lastPageNo = ar.getLastPageNumber();
        ChangePage page = new ChangePage(iiifBaseUrl, collectionIds.get(0), pageNo, pageNo > 0 ? new ChangeObject(iiifBaseUrl + "activitystream/collection/" + collectionIds.get(0) + "/page/" + (pageNo - 1), "OrderedCollectionPage") : null, items);
        if (pageNo < lastPageNo) {
            page.setNext(new ChangeObject(iiifBaseUrl + "activitystream/collection/" + collectionIds.get(0) + "/page/" + (pageNo + 1), "OrderedCollectionPage"));
        }
        ArrayList<ChangeObject> partOfs = new ArrayList<ChangeObject>();
        partOfs.add(new ChangeObject(iiifBaseUrl + "activitystreams/" + collectionIds.get(0), "OrderedCollectionPage"));
        page.setPartOf(partOfs);
        return page;
    }

    @Override
    public ActivityResult getPublishActivities(List<String> collectionIds, int pageNo, int pageSize) {
        return this.libraryHttpDao.getPublishEntities(collectionIds, pageNo, pageSize);
    }

    @Override
    public SharedSchema getSharedSchema(String iiifBaseUrl, String collectionId) {
        SharedSchema ss = this.libraryHttpDao.getSharedSchema(collectionId);
        System.out.println(ss.toXML());
        return ss;
    }

    @Override
    public Schema getSchema(String iiifBaseUrl, String collectionId) {
        Schema ss = this.libraryHttpDao.getSchema(collectionId);
        System.out.println(ss.toXML());
        return ss;
    }

    private List<PublisherAnnotation> findAnnotationsByMediaId(String mediaId) {
        return this.solrAnnotationDao.findByMediaId(mediaId);
    }

    private List<PublisherAnnotation> findAnnotationsByCanvas(String canvasUri) {
        return this.solrAnnotationDao.findByCanvasUri(canvasUri);
    }

    private List<PublisherAnnotation> findAnnotationsByManifest(String manifestUri) {
        return this.solrAnnotationDao.findByManifestUri(manifestUri);
    }

    private List<PublisherAnnotation> findAnnotationsByCollection(String colUri) {
        return this.solrAnnotationDao.findByCollectionUri(colUri);
    }

    @Override
    public List<Annotation> getAnnotationsByUri(String uri, User user) {
        List<PublisherAnnotation> manifestAnnots = this.findAnnotationsByManifest(uri);
        List<PublisherAnnotation> canvasAnnots = this.findAnnotationsByCanvas(uri);
        ArrayList<Annotation> toReturn = new ArrayList<Annotation>();
        if (manifestAnnots != null) {
            for (PublisherAnnotation pa : manifestAnnots) {
                toReturn.add(this.getAnnotation(pa.getId(), user));
            }
        }
        if (canvasAnnots != null) {
            for (PublisherAnnotation pa : canvasAnnots) {
                toReturn.add(this.getAnnotation(pa.getId(), user));
            }
        }
        return toReturn;
    }

    @Override
    public List<Annotation> getAnnotationsByCriteria(MediaSearchCriteria criteria, int offset, int pageSize) {
        this.initAnnotationIndex();
        List paList = this.solrAnnotationDao.find(criteria, offset, pageSize);
        List<SearchFieldValue> searchFieldValues = criteria.getSearchFieldValues();
        SearchFieldValue fv = searchFieldValues.get(0);
        ArrayList<String> terms = new ArrayList<String>();
        List<SearchValue> svs = fv.getSearchValues();
        for (SearchValue sv : svs) {
            terms.add(sv.getValue());
        }
        User user = null;
        if (criteria.getAuthenticable() instanceof User) {
            user = (User)criteria.getAuthenticable();
        }
        if (paList != null) {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            for (PublisherAnnotation pa : paList) {
                if (pa.getId() <= 0) continue;
                idList.add(pa.getId());
            }
            return this.getAnnotations(idList, user);
        }
        return null;
    }

    @Override
    public MediaSearchResult findMediaByAnnotation(MediaSearchCriteria criteria, int offset, int maximumNumberOfDocuments, boolean useParentDoc) {
        MediaSearchResult msr = null;
        if (useParentDoc) {
            LuceneSearchResult searchResult = this.solrAnnotationDao.findMediaIdsByAnnotationUsingParentDoc(criteria, offset, maximumNumberOfDocuments);
            ArrayList<String> mediaIdList = new ArrayList<String>();
            if (searchResult != null) {
                List<? extends Result> mediaResults = searchResult.getResults();
                for (LuceneMediaResult luceneMediaResult : mediaResults) {
                    mediaIdList.add((String)luceneMediaResult.getAttributes().get(PublisherAnnotation.MEDIA_ID));
                }
            }
            if (mediaIdList != null && mediaIdList.size() > 0) {
                msr = this.mediaSearchByIds(criteria.getAuthenticable(), mediaIdList);
                msr.setTotalNumberOfResults(searchResult.getTotalNumberOfResults());
            }
        } else {
            List mediaIdList = this.solrAnnotationDao.findMediaIdsByAnnotation(criteria);
            if (mediaIdList != null && mediaIdList.size() > 0) {
                List idsToSearch = mediaIdList.subList(offset, Math.min(offset + maximumNumberOfDocuments, mediaIdList.size()));
                msr = this.mediaSearchByIds(criteria.getAuthenticable(), idsToSearch);
                msr.setTotalNumberOfResults(mediaIdList.size());
            }
        }
        return msr;
    }

    @Override
    public AnnotationSearchResult findAnnotations(MediaSearchCriteria criteria, int offset, int pageSize) {
        AnnotationSearchResult asr = null;
        List<SearchFieldValue> searchFieldValues = criteria.getSearchFieldValues();
        SearchFieldValue fv = searchFieldValues.get(0);
        ArrayList<String> terms = new ArrayList<String>();
        List<SearchValue> svs = fv.getSearchValues();
        for (SearchValue sv : svs) {
            terms.addAll(Arrays.asList(StringUtils.split((String)sv.getValue())));
        }
        if (terms.size() > 1) {
            return this.findAnnotations(terms, offset, pageSize, criteria);
        }
        asr = this.solrAnnotationDao.findAnnotations(criteria, offset, pageSize);
        if (asr != null) {
            User user = null;
            if (criteria.getAuthenticable() instanceof User) {
                user = (User)criteria.getAuthenticable();
            }
            long startTime = System.currentTimeMillis();
            HashMap<Integer, LuceneAnnotationResult> idResultMap = new HashMap<Integer, LuceneAnnotationResult>();
            for (Result result : asr.getResults()) {
                if (!(result instanceof LuceneAnnotationResult)) continue;
                LuceneAnnotationResult lar = (LuceneAnnotationResult)result;
                idResultMap.put(Integer.parseInt((String)lar.getId()), lar);
            }
            List<Annotation> annos = this.getAnnotations(new ArrayList<Integer>(idResultMap.keySet()), user);
            for (Annotation anno : annos) {
                if (anno == null) continue;
                ((LuceneAnnotationResult)idResultMap.get(anno.getId())).setValues(anno);
            }
            System.out.println("[mrm] annotation query time: " + (System.currentTimeMillis() - startTime) + "ms count:" + asr.getResults().size());
        }
        return asr;
    }

    @Override
    public AnnotationSearchResult findAnnotations(List<String> terms, int offset, int pageSize, MediaSearchCriteria criteria) {
        return this.findAnnotationGroupInMedia(terms, null, offset, pageSize, criteria);
    }

    @Override
    public AnnotationSearchResult findAnnotationGroupInMedia(List<String> terms, List<String> mediaIds, int offset, int pageSize, MediaSearchCriteria criteria) {
        long startTime = System.currentTimeMillis();
        AnnotationSearcher searcher = new AnnotationSearcher(terms, this.solrAnnotationDao, this, criteria, offset, pageSize);
        if (this.searchDist > 0) {
            searcher.setD(this.searchDist);
        }
        if (this.maxCharDist > 0) {
            searcher.setMaxCharDist(this.maxCharDist);
        }
        AnnotationSearchResult foundAnnos = null;
        foundAnnos = mediaIds != null ? searcher.doSearch(mediaIds) : searcher.doSearch();
        if (foundAnnos != null && foundAnnos.getResults() != null) {
            log.debug((Object)("[mrm] annotation query time: " + (System.currentTimeMillis() - startTime) + "ms count:" + foundAnnos.getResults().size()));
        }
        return foundAnnos;
    }

    @Override
    public List<String> findMediaIdsByAnnotations(List<String> terms, int offset, int pageSize, MediaSearchCriteria criteria) {
        if (terms == null) {
            return null;
        }
        AnnotationSearcher searcher = new AnnotationSearcher(terms, this.solrAnnotationDao, this, criteria, offset, pageSize);
        if (this.searchDist > 0) {
            searcher.setD(this.searchDist);
        }
        return searcher.findMediaIds();
    }

    private void saveAnnotationToSolr(PublisherAnnotation pa) {
        try {
            this.solrAnnotationDao.save(pa);
        }
        catch (Exception e) {
            log.error((Object)("Could not save annotation to SOLR: " + pa.getId()), (Throwable)e);
        }
    }

    private void saveAnnotationsToSolr(List<PublisherAnnotation> pas) {
        try {
            this.solrAnnotationDao.save(pas);
        }
        catch (Exception e) {
            log.error((Object)("Could not save annotation to SOLR: # of annotations in this batch: " + pas.size()), (Throwable)e);
        }
    }

    private void deleteAnnotationByUriFromSolr(String annotationUri) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(annotationUri);
        this.solrAnnotationDao.deleteByUriList(list);
    }

    private void deleteAnnotationsByUriFromSolr(List<String> list) {
        if (list != null) {
            this.solrAnnotationDao.deleteByUriList(list);
        }
    }

    private void deleteAnnotationsByCanvasFromSolr(String canvasUri) {
        List<PublisherAnnotation> pas = this.findAnnotationsByCanvas(canvasUri);
        ArrayList<String> list = new ArrayList<String>();
        for (PublisherAnnotation pa : pas) {
            list.add(String.valueOf(pa.getAnnotationUri()));
        }
        this.solrAnnotationDao.deleteByUriList(list);
    }

    @Override
    public void deleteAnnotationsByMediaIdFromSolr(String mediaId) {
        this.solrAnnotationDao.deleteByMediaId(mediaId);
    }

    @Override
    public String getFieldValueByMedia(Media media, String displayName) {
        if (media == null) {
            return null;
        }
        List mfv = media.getFieldValues();
        Iterator it = mfv.iterator();
        if (displayName != null) {
            while (it.hasNext()) {
                MediaFieldValue m = (MediaFieldValue)it.next();
                if (!displayName.equals(m.getField().getDisplayName())) continue;
                return m.getValue().toString();
            }
            Vector<String> imageExportUrls = this.getExportUrls(media);
            if (displayName.startsWith("urlSize")) {
                int requestedResolution = NumberUtils.toInt((String)displayName.substring(7));
                return imageExportUrls.get(imageExportUrls.size() > requestedResolution ? requestedResolution : imageExportUrls.size() - 1);
            }
            if (displayName.equals("urlSource")) {
                return UrlUtils.stripAllParameters(((LunaMedia)media).getUrlSource());
            }
            if (displayName.equals("displayTitle")) {
                return media.getDisplayTitle();
            }
        }
        return "";
    }

    @Override
    public String getFieldValueByMedia(MediaResult mr, String displayName, Credentials cred) {
        if (mr == null) {
            return null;
        }
        List<MediaFieldValue> mfv = mr.getFieldValues();
        Iterator<MediaFieldValue> it = mfv.iterator();
        if (displayName != null) {
            while (it.hasNext()) {
                MediaFieldValue m = it.next();
                if (!displayName.equals(m.getField().getDisplayName())) continue;
                return m.getValue().toString();
            }
            Media media = null;
            String mediaId = String.valueOf(mr.getIdentity());
            media = this.getMedia(cred, mediaId, true);
            Vector<String> imageExportUrls = this.getExportUrls(media);
            if (displayName.startsWith("urlSize")) {
                int requestedResolution = NumberUtils.toInt((String)displayName.substring(7));
                return imageExportUrls.get(imageExportUrls.size() > requestedResolution ? requestedResolution : imageExportUrls.size() - 1);
            }
            if (displayName.equals("urlSource")) {
                return UrlUtils.stripAllParameters(((LunaMedia)mr).getUrlSource());
            }
            if (displayName.equals("displayTitle")) {
                return media.getDisplayTitle();
            }
        }
        return "";
    }

    @Override
    public Vector<String> getExportUrls(LuceneMediaResult lm) {
        if (lm.isPermitted()) {
            return this.getExportUrls(String.valueOf(lm.getIdentity()));
        }
        return new Vector<String>();
    }

    @Override
    public Vector<String> getExportUrls(Media media) {
        if (media instanceof LunaMedia) {
            LunaMedia lm = (LunaMedia)media;
            try {
                if (lm.isPermitted()) {
                    return this.getExportUrls(String.valueOf(media.getIdentity()));
                }
                return new Vector<String>();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.getExportUrls(String.valueOf(media.getIdentity()));
    }

    private Vector<String> getExportUrls(String mediaId) {
        Vector<String> imageExportUrls = new Vector();
        String cType = this.getMediaCollectionType(mediaId);
        if (mediaId.contains("~")) {
            if (this.isLuna7) {
                PublisherMedia pm = this.lunaMediaDAO.findByMediaId(mediaId);
                log.debug((Object)("getExportUrls(..): pm = " + pm));
                if (pm != null) {
                    imageExportUrls = this.mediaDao.get(cType).getImageExportUrls(pm);
                }
            } else {
                imageExportUrls = this.mediaDao.get(cType).getImageExportUrls(mediaId);
            }
        } else {
            imageExportUrls = this.mediaDao.get(cType).getExternalMediaExportUrls(mediaId);
        }
        return imageExportUrls;
    }

    @Override
    public Vector<String> getJpgExportUrlsFromLucene(LuceneMediaResult media) {
        Vector<String> imageExportUrls = new Vector<String>();
        if (media.getUrlSize0() != null) {
            imageExportUrls.add(media.getUrlSize0());
        }
        if (media.getUrlSize1() != null) {
            imageExportUrls.add(media.getUrlSize1());
        }
        if (media.getUrlSize2() != null) {
            imageExportUrls.add(media.getUrlSize2());
        }
        if (media.getUrlSize3() != null) {
            imageExportUrls.add(media.getUrlSize3());
        }
        if (media.getUrlSize4() != null) {
            imageExportUrls.add(media.getUrlSize4());
        }
        return imageExportUrls;
    }

    @Override
    public String getOaiRepositoryName() {
        return this.getApplicationConfiguration().getOaiRepositoryName() != null ? this.getApplicationConfiguration().getOaiRepositoryName() : "";
    }

    @Override
    public String getOaiRepositoryAdminEmail() {
        return this.getApplicationConfiguration().getOaiRepositoryAdminEmail() != null ? this.getApplicationConfiguration().getOaiRepositoryAdminEmail() : "";
    }

    @Override
    public String getOaiAdditionalIdentifiers() {
        return this.getApplicationConfiguration().getOaiAdditionalIdentifiers() != null ? this.getApplicationConfiguration().getOaiAdditionalIdentifiers() : "";
    }

    @Override
    public int getOaiResultPageSize() {
        return this.resumptionTokenDao.getResultPageSize();
    }

    @Override
    public TinyUrl getTinyUrl(String token) {
        TinyUrl tinyUrl = this.tinyUrlDao.getTinyUrl(token);
        return tinyUrl;
    }

    @Override
    public synchronized String saveTinyUrl(String url, String charToExclude) throws DataAccessException {
        Pattern p;
        Matcher m;
        TinyUrl existingUrl = this.tinyUrlDao.getToken(url);
        if (existingUrl != null) {
            return existingUrl.getToken();
        }
        TinyUrl tinyUrl = new TinyUrl();
        String token = "";
        do {
            token = InsightCoreUtils.constructRandomString(6, false, charToExclude);
        } while ((m = (p = Pattern.compile("^[,:{}\\[\\]0-9.\\-+Eaeflnr-u \\n\\r\\t]*$")).matcher(token)).find() || !this.tinyUrlDao.isTokenAvailable(token));
        tinyUrl.setToken(token);
        tinyUrl.setMappedUrl(url);
        tinyUrl.setCreatedTimeStamp(new SimpleDate().get());
        this.tinyUrlDao.saveTinyUrl(tinyUrl);
        return token;
    }

    @Override
    public synchronized void deleteTinyUrl(TinyUrl t) {
        this.tinyUrlDao.deleteTinyUrl(t);
    }

    @Override
    public ResumptionToken getResumptionToken(String token) {
        ResumptionToken rt = this.resumptionTokenDao.getResumptionToken(token);
        return rt;
    }

    @Override
    public synchronized String saveResumptionToken(String verb, String set, String metadataPrefix, String from, String until, int offset) throws DataAccessException {
        return this.saveResumptionToken(verb, set, metadataPrefix, from, until, offset, "");
    }

    @Override
    public synchronized String saveResumptionToken(String verb, String set, String metadataPrefix, String from, String until, int offset, String tokenToUse) throws DataAccessException {
        ResumptionToken resumptionToken = new ResumptionToken();
        String token = tokenToUse != null && !tokenToUse.equalsIgnoreCase("") ? tokenToUse : this.generateResumptionToken();
        String reservedNextToken = this.generateResumptionToken(token);
        resumptionToken.setResumptionToken(token);
        resumptionToken.setReservedNextToken(reservedNextToken);
        resumptionToken.setFrom(from);
        resumptionToken.setUntil(until);
        resumptionToken.setMetadataPrefix(metadataPrefix);
        resumptionToken.setSet(set);
        resumptionToken.setVerb(verb);
        resumptionToken.setOffset(offset);
        this.resumptionTokenDao.saveResumptionToken(resumptionToken);
        return token;
    }

    private String generateResumptionToken() {
        return this.generateResumptionToken("");
    }

    private String generateResumptionToken(String toExclude) {
        Pattern p;
        Matcher m;
        String token = "";
        do {
            token = InsightCoreUtils.constructRandomString(6, false, null);
        } while ((m = (p = Pattern.compile("^[,:{}\\[\\]0-9.\\-+Eaeflnr-u \\n\\r\\t]*$")).matcher(token)).find() || toExclude != null && token.equalsIgnoreCase(toExclude) || !this.resumptionTokenDao.isResumptionTokenAvailable(token));
        return token;
    }

    @Override
    public boolean isPublicCollection(String collectionId) {
        if (this.collectionIsPublicMap == null) {
            this.collectionIsPublicMap = new HashMap<String, Boolean>();
        }
        if (this.collectionIsPublicMap.containsKey(collectionId)) {
            return this.collectionIsPublicMap.get(collectionId);
        }
        List<MediaCollection> mcs = this.getPublicMediaCollections();
        for (MediaCollection mc : mcs) {
            if (!collectionId.equalsIgnoreCase(mc.getId())) continue;
            this.collectionIsPublicMap.put(collectionId, true);
            return true;
        }
        this.collectionIsPublicMap.put(collectionId, false);
        return false;
    }

    @Override
    public void sortFieldsInMediaResult(LuceneMediaResult lmr) {
        List<MediaFieldValue> mfvs = lmr.getFieldValues();
        String collectionId = InsightCoreUtils.getCollectionIdFromLunaMediaId(lmr.getId().toString());
        String cType = this.getMediaCollectionType(collectionId);
        List<MediaField> sortedMediaFields = this.mediaFieldDao.get(cType).getFieldOrderFromCache(collectionId);
        if (sortedMediaFields != null) {
            Collections.sort(mfvs, new MediaFieldCustomComparator(sortedMediaFields));
        }
    }

    @Override
    public UserActivity getUserActivity(int userId) {
        UserActivity ua = this.userActivityDao.getUserActivity(userId);
        return ua;
    }

    @Override
    public UserActivity getUserActivity(String ipAddress) {
        UserActivity ua = this.userActivityDao.getUserActivity(ipAddress);
        return ua;
    }

    @Override
    public synchronized void saveUserActivity(User user, int lastExportSize, long lastExportTimeMilli, String ipAddress) throws DataAccessException {
        UserActivity userActivity = new UserActivity();
        if (user != null) {
            userActivity.setUser(user);
        }
        if (ipAddress != null) {
            userActivity.setIpAddress(ipAddress);
        }
        userActivity.setLastExportSize(lastExportSize);
        userActivity.setLastExportTimeMilli(lastExportTimeMilli);
        this.userActivityDao.saveUserActivity(userActivity);
    }

    @Override
    public FailedLoginAttempt getFailedLoginAttempt(String userName) {
        FailedLoginAttempt fla = this.failedLoginAttemptDao.getFailedLoginAttempt(userName);
        return fla;
    }

    @Override
    public synchronized void saveFailedLoginAttempt(String userName) throws DataAccessException {
        FailedLoginAttempt fla;
        if (!this.failedLoginAttemptDao.isFailedLoginAttemptAvailable(userName)) {
            fla = this.failedLoginAttemptDao.getFailedLoginAttempt(userName);
            fla.setNumberOfFailedAttempt(fla.getNumberOfFailedAttempt() + 1);
        } else {
            fla = new FailedLoginAttempt();
            fla.setUserName(userName);
        }
        this.failedLoginAttemptDao.saveFailedLoginAttempt(fla);
    }

    @Override
    public synchronized void removeFailedLoginAttempt(String userName) throws DataAccessException {
        if (this.failedLoginAttemptDao != null) {
            this.failedLoginAttemptDao.removeFailedLoginAttempt(userName);
        }
    }

    @Override
    public MediaManifest saveManifest(String iiifBaseUrl, String sourceUrl, int userId, String query, String displayName) {
        Pattern p;
        Matcher m;
        MediaManifest existingManifest = this.manifestDao.getToken(sourceUrl);
        if (existingManifest != null) {
            return existingManifest;
        }
        String token = "";
        do {
            token = InsightCoreUtils.constructRandomString(6, false, null);
        } while ((m = (p = Pattern.compile("^[,:{}\\[\\]0-9.\\-+Eaeflnr-u \\n\\r\\t]*$")).matcher(token)).find() || !this.manifestDao.isTokenAvailable(token));
        String manifestUrl = iiifBaseUrl + "collection/s/" + token;
        MediaManifest manifest = new MediaManifest(-1, token, displayName == null ? "Manifest " + token : displayName, "Manifest for collection " + query, manifestUrl, null, sourceUrl, userId);
        manifest.setManifestData(query);
        manifest.setCreatedtimestamp(new SimpleDate().get());
        this.manifestDao.saveMediaManifest(manifest);
        return manifest;
    }

    @Override
    public MediaManifest getManifest(String token) {
        return this.manifestDao.getManifestByToken(token);
    }

    @Override
    public List<Category> getTopCategories() {
        return this.categoriesDao.getSubCategories(0);
    }

    @Override
    public List<MediaCollection> getOrderedCollectionsInCurrentCategory(Authenticable authenticable, int categoryId) {
        LinkedHashMap collOrderMap = new LinkedHashMap();
        Object[] collList = null;
        ArrayList<MediaCollection> toReturn = new ArrayList<MediaCollection>();
        Category cat = this.categoriesDao.getCategory(categoryId);
        ArrayList<String> cids = cat.getCollectionIds();
        ArrayList<Integer> cSeqs = cat.getCollectionSequences();
        if (cat != null && !cids.isEmpty()) {
            collList = new MediaCollection[cSeqs.size() + 1];
            for (int i = 0; i < cSeqs.size(); ++i) {
                collOrderMap.put(cids.get(i), cSeqs.get(i));
            }
            ArrayList<MediaCollection> mcs = authenticable.getMediaCollections();
            if (mcs != null) {
                for (MediaCollection mc : mcs) {
                    if (!collOrderMap.containsKey(mc.getId())) continue;
                    Integer order = (Integer)collOrderMap.get(mc.getId());
                    if (order >= collList.length) {
                        Object[] spacer = new MediaCollection[order + 1 - collList.length];
                        MediaCollection[] newArr = (MediaCollection[])ArrayUtils.addAll((Object[])collList, (Object[])spacer);
                        collList = newArr;
                    }
                    collList[order.intValue()] = mc;
                }
                for (int i = 0; i < collList.length; ++i) {
                    if (collList[i] == null) continue;
                    toReturn.add(collList[i]);
                }
            }
        }
        return toReturn;
    }

    @Override
    public Category getCategory(int categoryId) {
        return this.categoriesDao.getCategory(categoryId);
    }

    @Override
    public List<MediaCollection> getCollectionsByCategory(Authenticable authenticable, int categoryId) {
        List<MediaCollection> collList;
        if (this.categoryCollectionCache == null) {
            this.initializeCategoryCollectionCache();
        }
        if ((collList = (List<MediaCollection>)this.categoryCollectionCache.getIfPresent((Object)(authenticable.toString().trim() + ":" + categoryId))) == null) {
            Category cat = this.categoriesDao.getCategory(categoryId);
            collList = this.getOrderedCollectionsInCurrentCategory(authenticable, categoryId);
            if (cat != null && cat.getChildren() != null) {
                for (Category child : cat.getChildren()) {
                    List<MediaCollection> childColList = this.getOrderedCollectionsInCurrentCategory(authenticable, child.getId());
                    if (childColList == null) continue;
                    for (MediaCollection mc : childColList) {
                        if (collList.contains(mc)) continue;
                        collList.add(mc);
                    }
                }
            }
            if (collList != null) {
                this.addToCategoryCollectionCache(authenticable, categoryId, collList);
            }
        }
        return collList;
    }

    @Override
    public boolean resetLunaCaches() {
        if (!this.maintenanceInProgress) {
            try {
                ArrayList<Maintainable> ms = new ArrayList<Maintainable>();
                this.addMaintainableToList(this.mediaCollectionDao, ms);
                this.addMaintainableToList(this.mediaDao, ms);
                this.addMaintainableToList(this.mediaFieldDao, ms);
                this.addMaintainableToList(this.mediaFieldRelationDao, ms);
                this.addMaintainableToList(this.mediaFieldStandardDao, ms);
                this.addMaintainableToList(this.mediaStandardFieldDao, ms);
                this.addMaintainableToList(this.authenticationDao, ms);
                for (Maintainable m : ms) {
                    m.startMaintenance();
                }
                this.maintenanceInProgress = true;
                for (Maintainable m : ms) {
                    m.endMaintenance();
                }
                this.initialize();
                this.maintenanceInProgress = false;
                return true;
            }
            catch (Exception e) {
                log.error((Object)"Unable to reset caches!", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public int rebuildAnnotationIndex(boolean rebuildAll) {
        List solrAnnots = this.solrAnnotationDao.findAll(0, ((JdbcAnnotationDao)this.annotationDao).getMaximumAnnotationCache());
        HashSet<Integer> solrAnnotIds = new HashSet<Integer>();
        if (solrAnnots != null) {
            for (PublisherAnnotation pa : solrAnnots) {
                solrAnnotIds.add(pa.getId());
            }
        }
        int count = 0;
        List<Annotation> dbAnnots = ((JdbcAnnotationDao)this.annotationDao).getAllAnnotations();
        if (dbAnnots != null) {
            for (Annotation a : dbAnnots) {
                if (!rebuildAll && solrAnnotIds.contains(a.getId())) continue;
                PublisherAnnotation pa = AnnotationMapper.createPublisherAnnotation(a);
                log.info((Object)("Saving annotation id: " + a.getId() + " to Solr."));
                this.saveAnnotationToSolr(pa);
                ++count;
            }
        }
        this.solrAnnotationDao.setInitialized(true);
        return count;
    }

    @Override
    public int initAnnotationIndex() {
        int count = 0;
        if (!this.solrAnnotationDao.isInitialized()) {
            log.info((Object)"Initializing solr index");
            List solrAnnots = this.solrAnnotationDao.findAll(0, ((JdbcAnnotationDao)this.annotationDao).getMaximumAnnotationCache());
            count = solrAnnots == null || solrAnnots.size() == 0 ? this.rebuildAnnotationIndex(true) : 0;
            this.solrAnnotationDao.setInitialized(true);
        }
        log.info((Object)("Initialized solr index. # processed:  " + count));
        return count;
    }

    @Override
    public int rebuildAnnotationIndex(String collectionId, boolean rebuildAll) {
        int count = 0;
        List<String> mediaIdList = this.annotationDao.getAnnotatedMediaByCollectionId(collectionId);
        if (mediaIdList != null) {
            for (String mediaId : mediaIdList) {
                List<Annotation> dbAnnots;
                List solrAnnots = this.solrAnnotationDao.findByMediaId(mediaId);
                HashSet<Integer> solrAnnotIds = new HashSet<Integer>();
                if (solrAnnots != null) {
                    for (PublisherAnnotation pa : solrAnnots) {
                        solrAnnotIds.add(pa.getId());
                    }
                }
                if ((dbAnnots = ((JdbcAnnotationDao)this.annotationDao).getAnnotations(mediaId, null, null)) != null) {
                    for (Annotation a : dbAnnots) {
                        if (!rebuildAll && solrAnnotIds.contains(a.getId())) continue;
                        PublisherAnnotation pa = AnnotationMapper.createPublisherAnnotation(a);
                        log.info((Object)("Saving annotation id: " + a.getId() + " to Solr."));
                        this.saveAnnotationToSolr(pa);
                        ++count;
                    }
                }
                this.updateAnnotationParentDoc(mediaId);
            }
        }
        return count;
    }

    @Override
    public int replaceSourceValuesInAnnotationIndex(String collectionId, String valueToFind, String valueReplaceWith) {
        int count = 0;
        List<String> mediaIdList = this.annotationDao.getAnnotatedMediaByCollectionId(collectionId);
        if (mediaIdList != null) {
            for (String mediaId : mediaIdList) {
                log.info((Object)("Updating: " + mediaId));
                int annotCount = 0;
                List solrAnnots = this.solrAnnotationDao.findByMediaIdAndSource(mediaId, valueToFind);
                HashSet<String> solrAnnotIds = new HashSet<String>();
                if (solrAnnots != null) {
                    for (PublisherAnnotation pa : solrAnnots) {
                        solrAnnotIds.add(String.valueOf(pa.getId()));
                        ++annotCount;
                    }
                    count += annotCount;
                }
                log.info((Object)("Count: " + annotCount));
                this.solrAnnotationDao.atomicUpdate(new ArrayList(solrAnnotIds), PublisherAnnotation.SOURCE, valueReplaceWith);
            }
        }
        return count;
    }

    @Override
    public void updateAnnotationParentDoc(String mediaId) {
        try {
            long startTime = System.currentTimeMillis();
            List<Annotation> annoList = this.getAnnotations(mediaId, -1, null);
            log.warn((Object)("=============================getAnnotations() in updateAnnotationParentDoc(...) took: " + (System.currentTimeMillis() - startTime) + "ms"));
            if (annoList != null) {
                PublisherAnnotation pm = AnnotationMapper.createPublisherAnnotationParentDoc(mediaId, annoList);
                try {
                    this.addLegacyTextToParentDoc(pm, mediaId);
                    long startTime2 = System.currentTimeMillis();
                    this.addMapKuratorValuesToParentDoc(pm, mediaId);
                    log.debug((Object)("===========================addMapKuratorValuesToParentDoc took: " + (System.currentTimeMillis() - startTime2) + "ms"));
                    startTime2 = System.currentTimeMillis();
                    this.addUserCorrectionTextToParentDoc(pm, mediaId);
                    log.debug((Object)("===========================addUserCorrectionTextToParentDoc took: " + (System.currentTimeMillis() - startTime2) + "ms"));
                }
                catch (Exception e) {
                    log.error((Object)"Could not add OCR or user correction values to solr doc", (Throwable)e);
                }
                this.solrAnnotationDao.delete(pm);
                this.solrAnnotationDao.save(pm);
            }
            log.warn((Object)("=============================updateAnnotationParentDoc(...) complete took: " + (System.currentTimeMillis() - startTime) + "ms"));
        }
        catch (Exception e) {
            log.error((Object)"Could not update annotation parent media doc!", (Throwable)e);
        }
    }

    private void addMaintainableToList(Object o, List<Maintainable> m) {
        if (o instanceof Maintainable) {
            if (m == null) {
                throw new RuntimeException("Make sure id=\"maintainableObjects\" is set in the configuration.");
            }
            m.add((Maintainable)o);
        } else if (o instanceof LinkedHashMap) {
            Collection c = ((LinkedHashMap)o).values();
            for (Object obj : c) {
                if (!(obj instanceof Maintainable)) continue;
                if (m == null) {
                    m = new ArrayList<Maintainable>();
                }
                m.add((Maintainable)obj);
            }
        }
    }

    public void setSearchDist(int searchDist) {
        this.searchDist = searchDist;
    }

    public void setMaxCharDist(int maxCharDist) {
        this.maxCharDist = maxCharDist;
    }

    public void setCachesEnabled(boolean cacheEnabled) {
        this.cachesEnabled = cacheEnabled;
    }
}

