/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.cache;

import com.lunaimaging.insight.core.domain.cache.ObjectCache;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnboundCache
implements ObjectCache {
    Map cache = Collections.synchronizedMap(new HashMap());

    public synchronized boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public synchronized void put(Object key, Object value) throws InvalidParameterException {
        if (value == null) {
            throw new InvalidParameterException("Can not ObjectCache null object!");
        }
        if (key == null) {
            throw new InvalidParameterException("CachingKey is null!");
        }
        this.cache.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) throws InvalidParameterException {
        Object value = this.cache.get(key);
        this.cache.remove(key);
        return value;
    }

    @Override
    public synchronized Object get(Object key) {
        Object value = null;
        if (key != null && this.cache.containsKey(key)) {
            value = this.cache.get(key);
        }
        return value;
    }

    @Override
    public synchronized List getAll() {
        return new ArrayList(this.cache.values());
    }

    @Override
    public void purge() {
        this.cache.clear();
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public int getMaximumSize() {
        return 0;
    }

    @Override
    public void setMaximumSize(int maximumSize) {
    }
}

