/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.domain.cache;

import com.lunaimaging.insight.core.domain.cache.ObjectCache;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache
implements ObjectCache {
    public static final int DEFAULT_MAX_SIZE = 1000;
    public static final int DRAIN_CACHE_BY = 1;
    private int maximumSize;
    private LinkedHashMap<Object, Object> cache;

    public LRUCache(int maxSize) {
        this.setMaximumSize(maxSize);
        this.cache = this.constructCachingMap();
    }

    public LRUCache() {
        this(1000);
    }

    public int size() {
        return this.cache.size();
    }

    public synchronized boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public synchronized void put(Object key, Object value) throws InvalidParameterException {
        if (value == null) {
            throw new InvalidParameterException("Can not ObjectCache null object!");
        }
        if (key == null) {
            throw new InvalidParameterException("key is null!");
        }
        this.cache.put(key, value);
    }

    @Override
    public synchronized Object get(Object key) {
        Object value = null;
        if (key != null && this.cache.containsKey(key)) {
            value = this.cache.get(key);
            this.cache.remove(key);
            this.cache.put(key, value);
        }
        return value;
    }

    @Override
    public synchronized Collection getAll() {
        return new ArrayList<Object>(this.cache.values());
    }

    public synchronized Collection getKeys() {
        return new ArrayList<Object>(this.cache.keySet());
    }

    public synchronized Collection getSome(int sampleSize) {
        ArrayList<Object> cacheValues = new ArrayList<Object>(this.cache.values());
        if (sampleSize < cacheValues.size()) {
            return cacheValues.subList(cacheValues.size() - sampleSize, cacheValues.size());
        }
        return cacheValues;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object prevValue = this.get(key);
        this.cache.remove(key);
        return prevValue;
    }

    @Override
    public synchronized void purge() {
        this.cache.clear();
    }

    @Override
    public synchronized boolean isFull() {
        return this.cache.size() == this.maximumSize;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public int getMaximumSize() {
        return this.maximumSize;
    }

    @Override
    public synchronized void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
        LinkedHashMap<Object, Object> newMap = this.constructCachingMap();
        if (this.cache != null && !this.cache.isEmpty()) {
            for (Object key : this.cache.keySet()) {
                newMap.put(key, this.cache.get(key));
            }
        }
        this.cache = newMap;
    }

    private LinkedHashMap<Object, Object> constructCachingMap() {
        final int size = this.maximumSize;
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() >= size;
            }
        };
        return map;
    }
}

